/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddManagedDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String versionPattern;
    @Nullable
    private final String scope;
    @Nullable
    private final Boolean releasesOnly;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;
    @Nullable
    private VersionComparator versionComparator;
    @Nullable
    private String resolvedVersion;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document doc = super.visitDocument(document, ctx);
        Validated versionValidation = Semver.validate((String)this.version, (String)this.versionPattern);
        if (versionValidation.isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (this.documentHasManagedDependency(doc, ctx)) {
            return document;
        }
        String versionToUse = this.findVersionToUse(ctx);
        if (versionToUse.equals(this.existingManagedDependencyVersion())) {
            return document;
        }
        Xml.Tag root = document.getRoot();
        List rootContent = root.getContent() != null ? root.getContent() : Collections.emptyList();
        Xml.Tag dependencyManagementTag = root.getChild("dependencyManagement").orElse(null);
        if (dependencyManagementTag == null) {
            doc = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencyManagement>\n<dependencies/>\n</dependencyManagement>"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        } else if (!dependencyManagementTag.getChild("dependencies").isPresent()) {
            doc = (Xml.Document)new AddToTagVisitor(dependencyManagementTag, Xml.Tag.build((String)"\n<dependencies/>\n"), (Comparator)new MavenTagInsertionComparator(rootContent)).visitNonNull((Tree)doc, (Object)ctx);
        }
        doc = (Xml.Document)new InsertDependencyInOrder(this.groupId, this.artifactId, versionToUse, this.type, this.scope, this.classifier).visitNonNull((Tree)doc, ctx);
        return doc;
    }

    private boolean documentHasManagedDependency(Xml.Document doc, ExecutionContext ctx) {
        final AtomicBoolean managedDepExists = new AtomicBoolean(false);
        new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
                Xml.Tag tg = super.visitTag(tag, executionContext);
                if (this.isManagedDependencyTag(AddManagedDependencyVisitor.this.groupId, AddManagedDependencyVisitor.this.artifactId)) {
                    managedDepExists.set(true);
                }
                return tg;
            }
        }.visitNonNull((Tree)doc, ctx);
        return managedDepExists.get();
    }

    @Nullable
    private String existingManagedDependencyVersion() {
        return this.getResolutionResult().getPom().getDependencyManagement().stream().map(resolvedManagedDep -> {
            if (resolvedManagedDep.matches(this.groupId, this.artifactId, this.type, this.classifier)) {
                return resolvedManagedDep.getGav().getVersion();
            }
            if (resolvedManagedDep.getRequestedBom() != null && resolvedManagedDep.getRequestedBom().getGroupId().equals(this.groupId) && resolvedManagedDep.getRequestedBom().getArtifactId().equals(this.artifactId)) {
                return resolvedManagedDep.getRequestedBom().getVersion();
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private String findVersionToUse(ExecutionContext ctx) {
        if (this.resolvedVersion == null) {
            if (this.versionComparator == null) {
                this.resolvedVersion = this.version;
            } else {
                MavenMetadata mavenMetadata = this.downloadMetadata(this.groupId, this.artifactId, ctx);
                LatestRelease latest = new LatestRelease(this.versionPattern);
                this.resolvedVersion = mavenMetadata.getVersioning().getVersions().stream().filter(v -> this.versionComparator.isValid(null, v)).filter(v -> !Boolean.TRUE.equals(this.releasesOnly) || latest.isValid(null, v)).max((v1, v2) -> this.versionComparator.compare(null, v1, v2)).orElse(this.version);
            }
        }
        return this.resolvedVersion;
    }

    public AddManagedDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.classifier = classifier;
    }

    private static class InsertDependencyInOrder
    extends MavenIsoVisitor<ExecutionContext> {
        private final String groupId;
        private final String artifactId;
        private final String version;
        @Nullable
        private final String type;
        @Nullable
        private final String scope;
        @Nullable
        private final String classifier;

        @Override
        public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
            return super.visitDocument(document, ctx);
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (MANAGED_DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + this.groupId + "</groupId>\n<artifactId>" + this.artifactId + "</artifactId>\n<version>" + this.version + "</version>\n" + (this.classifier == null ? "" : "<classifier>" + this.classifier + "</classifier>\n") + (this.type == null || this.type.equals("jar") ? "" : "<type>" + this.type + "</type>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
                this.maybeUpdateModel();
            }
            return super.visitTag(tag, ctx);
        }

        public InsertDependencyInOrder(String groupId, String artifactId, String version, @Nullable String type, @Nullable String scope, @Nullable String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.type = type;
            this.scope = scope;
            this.classifier = classifier;
        }
    }
}

