/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeManagedDependencyGroupIdAndArtifactId
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a managed dependency coordinate 'com.google.guava:guava:VERSION'.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a managed dependency coordinate 'com.google.guava:guava:VERSION'.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use.", example="rewrite-testing-frameworks")
    private final String newArtifactId;
    @Option(displayName="New version", description="The new version to use.", example="2.0.0", required=false)
    @Nullable
    private final String newVersion;

    public String getDisplayName() {
        return "Change Maven managed dependency groupId, artifactId and optionally the version";
    }

    public String getDescription() {
        return "Change the groupId, artifactId and optionally the version of a specified Maven managed dependency.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isManagedDependencyTag(ChangeManagedDependencyGroupIdAndArtifactId.this.oldGroupId, ChangeManagedDependencyGroupIdAndArtifactId.this.oldArtifactId)) {
                    Optional versionTag;
                    Optional artifactIdTag;
                    Optional groupIdTag = tag.getChild("groupId");
                    boolean changed = false;
                    if (groupIdTag.isPresent() && !ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId.equals(((Xml.Tag)groupIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)groupIdTag.get(), ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId));
                        changed = true;
                    }
                    if ((artifactIdTag = tag.getChild("artifactId")).isPresent() && !ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId.equals(((Xml.Tag)artifactIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)artifactIdTag.get(), ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId));
                        changed = true;
                    }
                    if (ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion != null && (versionTag = tag.getChild("version")).isPresent() && !ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion.equals(((Xml.Tag)versionTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion));
                        changed = true;
                    }
                    if (changed) {
                        this.maybeUpdateModel();
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    public ChangeManagedDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @NonNull
    public String toString() {
        return "ChangeManagedDependencyGroupIdAndArtifactId(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeManagedDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeManagedDependencyGroupIdAndArtifactId other = (ChangeManagedDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeManagedDependencyGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

