/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.List;
import java.util.Objects;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;

public final class ResolvedManagedDependency {
    private final GroupArtifactVersion gav;
    private final Scope scope;
    @Nullable
    private final String type;
    @Nullable
    private final String classifier;
    private final List<GroupArtifact> exclusions;
    private final ManagedDependency requested;
    @Nullable
    private final ManagedDependency requestedBom;
    @Nullable
    private final ResolvedGroupArtifactVersion bomGav;

    public String getType() {
        return this.type == null ? "jar" : this.type;
    }

    public String getGroupId() {
        assert (this.gav.getGroupId() != null);
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    @Nullable
    public String getVersion() {
        return this.gav.getVersion();
    }

    boolean matches(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        return groupId.equals(this.gav.getGroupId()) && artifactId.equals(this.gav.getArtifactId()) && (type == null ? "jar" : type).equals(this.type == null ? "jar" : this.type) && Objects.equals(classifier, this.classifier);
    }

    public ResolvedManagedDependency(GroupArtifactVersion gav, Scope scope, @Nullable String type, @Nullable String classifier, List<GroupArtifact> exclusions, ManagedDependency requested, @Nullable ManagedDependency requestedBom, @Nullable ResolvedGroupArtifactVersion bomGav) {
        this.gav = gav;
        this.scope = scope;
        this.type = type;
        this.classifier = classifier;
        this.exclusions = exclusions;
        this.requested = requested;
        this.requestedBom = requestedBom;
        this.bomGav = bomGav;
    }

    public GroupArtifactVersion getGav() {
        return this.gav;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public List<GroupArtifact> getExclusions() {
        return this.exclusions;
    }

    public ManagedDependency getRequested() {
        return this.requested;
    }

    @Nullable
    public ManagedDependency getRequestedBom() {
        return this.requestedBom;
    }

    @Nullable
    public ResolvedGroupArtifactVersion getBomGav() {
        return this.bomGav;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResolvedManagedDependency)) {
            return false;
        }
        ResolvedManagedDependency other = (ResolvedManagedDependency)o;
        GroupArtifactVersion this$gav = this.getGav();
        GroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        List<GroupArtifact> this$exclusions = this.getExclusions();
        List<GroupArtifact> other$exclusions = other.getExclusions();
        if (this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions)) {
            return false;
        }
        ManagedDependency this$requested = this.getRequested();
        ManagedDependency other$requested = other.getRequested();
        if (this$requested == null ? other$requested != null : !this$requested.equals(other$requested)) {
            return false;
        }
        ManagedDependency this$requestedBom = this.getRequestedBom();
        ManagedDependency other$requestedBom = other.getRequestedBom();
        if (this$requestedBom == null ? other$requestedBom != null : !this$requestedBom.equals(other$requestedBom)) {
            return false;
        }
        ResolvedGroupArtifactVersion this$bomGav = this.getBomGav();
        ResolvedGroupArtifactVersion other$bomGav = other.getBomGav();
        return !(this$bomGav == null ? other$bomGav != null : !((Object)this$bomGav).equals(other$bomGav));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        List<GroupArtifact> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        ManagedDependency $requested = this.getRequested();
        result = result * 59 + ($requested == null ? 43 : $requested.hashCode());
        ManagedDependency $requestedBom = this.getRequestedBom();
        result = result * 59 + ($requestedBom == null ? 43 : $requestedBom.hashCode());
        ResolvedGroupArtifactVersion $bomGav = this.getBomGav();
        result = result * 59 + ($bomGav == null ? 43 : ((Object)$bomGav).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "ResolvedManagedDependency(gav=" + this.getGav() + ", scope=" + (Object)((Object)this.getScope()) + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", exclusions=" + this.getExclusions() + ", requested=" + this.getRequested() + ", requestedBom=" + this.getRequestedBom() + ", bomGav=" + this.getBomGav() + ")";
    }

    @NonNull
    public ResolvedManagedDependency withGav(GroupArtifactVersion gav) {
        return this.gav == gav ? this : new ResolvedManagedDependency(gav, this.scope, this.type, this.classifier, this.exclusions, this.requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withScope(Scope scope) {
        return this.scope == scope ? this : new ResolvedManagedDependency(this.gav, scope, this.type, this.classifier, this.exclusions, this.requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withType(@Nullable String type) {
        return this.type == type ? this : new ResolvedManagedDependency(this.gav, this.scope, type, this.classifier, this.exclusions, this.requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withClassifier(@Nullable String classifier) {
        return this.classifier == classifier ? this : new ResolvedManagedDependency(this.gav, this.scope, this.type, classifier, this.exclusions, this.requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withExclusions(List<GroupArtifact> exclusions) {
        return this.exclusions == exclusions ? this : new ResolvedManagedDependency(this.gav, this.scope, this.type, this.classifier, exclusions, this.requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withRequested(ManagedDependency requested) {
        return this.requested == requested ? this : new ResolvedManagedDependency(this.gav, this.scope, this.type, this.classifier, this.exclusions, requested, this.requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withRequestedBom(@Nullable ManagedDependency requestedBom) {
        return this.requestedBom == requestedBom ? this : new ResolvedManagedDependency(this.gav, this.scope, this.type, this.classifier, this.exclusions, this.requested, requestedBom, this.bomGav);
    }

    @NonNull
    public ResolvedManagedDependency withBomGav(@Nullable ResolvedGroupArtifactVersion bomGav) {
        return this.bomGav == bomGav ? this : new ResolvedManagedDependency(this.gav, this.scope, this.type, this.classifier, this.exclusions, this.requested, this.requestedBom, bomGav);
    }
}

