/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class InsertDependencyComparator
implements Comparator<Content> {
    private final Map<Content, Float> positions = new HashMap<Content, Float>();
    private static final Comparator<Content> dependencyComparator = (d1, d2) -> {
        String artifactId2;
        String groupId2;
        Scope scope2;
        if (!(d1 instanceof Xml.Tag) || !(d2 instanceof Xml.Tag)) {
            return 1;
        }
        Xml.Tag t1 = (Xml.Tag)d1;
        Xml.Tag t2 = (Xml.Tag)d2;
        Scope scope1 = Scope.fromName(t1.getChildValue("scope").orElse(null));
        if (!scope1.equals((Object)(scope2 = Scope.fromName(t2.getChildValue("scope").orElse(null))))) {
            return scope1.compareTo(scope2);
        }
        String groupId1 = t1.getChildValue("groupId").orElse("");
        if (!groupId1.equals(groupId2 = t2.getChildValue("groupId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = t1.getChildValue("artifactId").orElse("");
        if (!artifactId1.equals(artifactId2 = t2.getChildValue("artifactId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = t1.getChildValue("classifier").orElse(null);
        String classifier2 = t2.getChildValue("classifier").orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return t1.getChildValue("version").orElse("").compareTo(t2.getChildValue("version").orElse(""));
    };

    public InsertDependencyComparator(List<? extends Content> existingDependencies, Xml.Tag dependencyTag) {
        int existingDependenciesSize = existingDependencies.size();
        for (int i = 0; i < existingDependenciesSize; ++i) {
            this.positions.put(existingDependencies.get(i), Float.valueOf(i));
        }
        ArrayList<? extends Content> ideallySortedDependencies = new ArrayList<Content>(existingDependencies);
        ideallySortedDependencies.add((Content)dependencyTag);
        ideallySortedDependencies.sort(dependencyComparator);
        Content afterDependency = null;
        for (int i = 0; i < ideallySortedDependencies.size(); ++i) {
            Content d = (Content)ideallySortedDependencies.get(i);
            if (dependencyTag != d) continue;
            if (i <= 0) break;
            afterDependency = (Content)ideallySortedDependencies.get(i - 1);
            break;
        }
        this.positions.put((Content)dependencyTag, Float.valueOf(afterDependency == null ? -0.5f : this.positions.get(afterDependency).floatValue() + 0.5f));
    }

    @Override
    public int compare(Content o1, Content o2) {
        return this.positions.get(o1).compareTo(this.positions.get(o2));
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }
}

