/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangeProperty;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;
    @Option(displayName="Trust parent POM", description="Even if the parent suggests a version that is older than what we are trying to upgrade to, trust it anyway. Useful when you want to wait for the parent to catch up before upgrading. The parent is not trusted by default.", example="false", required=false)
    @Nullable
    private final Boolean trustParent;

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public String getDisplayName() {
        return "Upgrade Maven dependency version";
    }

    public String getDescription() {
        return "Upgrade the version of a dependency by specifying a group or group and artifact using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return new MavenIsoVisitor<ExecutionContext>(){
            @Nullable
            Collection<String> availableVersions;

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document m = super.visitDocument(document, ctx);
                for (MavenResolutionResult module : this.getResolutionResult().getModules()) {
                    Object resolved;
                    String newerVersion = null;
                    String requestedVersion = null;
                    for (Dependency dependency : module.getPom().getRequestedDependencies()) {
                        resolved = module.getResolvedDependency(dependency);
                        if (resolved == null || !StringUtils.matchesGlob((String)((ResolvedDependency)resolved).getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)((ResolvedDependency)resolved).getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) continue;
                        newerVersion = this.findNewerVersion(((ResolvedDependency)resolved).getGroupId(), ((ResolvedDependency)resolved).getArtifactId(), ((ResolvedDependency)resolved).getVersion(), ctx);
                        requestedVersion = dependency.getVersion();
                    }
                    for (ManagedDependency managedDependency : module.getPom().getRequested().getDependencyManagement()) {
                        ResolvedGroupArtifactVersion bom;
                        resolved = module.getResolvedManagedDependency(managedDependency);
                        if (resolved == null) continue;
                        if (StringUtils.matchesGlob((String)((ResolvedManagedDependency)resolved).getGroupId(), (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)((ResolvedManagedDependency)resolved).getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) {
                            newerVersion = this.findNewerVersion(((ResolvedManagedDependency)resolved).getGroupId(), ((ResolvedManagedDependency)resolved).getArtifactId(), ((ResolvedManagedDependency)resolved).getVersion(), ctx);
                            requestedVersion = managedDependency.getVersion();
                            continue;
                        }
                        if (((ResolvedManagedDependency)resolved).getBomGav() == null || !StringUtils.matchesGlob((String)(bom = ((ResolvedManagedDependency)resolved).getBomGav()).getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)bom.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) continue;
                        newerVersion = this.findNewerVersion(bom.getGroupId(), bom.getArtifactId(), bom.getVersion(), ctx);
                        requestedVersion = managedDependency.getVersion();
                    }
                    if (newerVersion == null) {
                        for (ResolvedManagedDependency resolvedManagedDependency : module.getPom().getDependencyManagement()) {
                            if (!StringUtils.matchesGlob((String)resolvedManagedDependency.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)resolvedManagedDependency.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) continue;
                            newerVersion = this.findNewerVersion(resolvedManagedDependency.getGroupId(), resolvedManagedDependency.getArtifactId(), module.getPom().getValue(resolvedManagedDependency.getVersion()), ctx);
                            requestedVersion = resolvedManagedDependency.getVersion();
                        }
                    }
                    if (newerVersion == null || requestedVersion == null || !requestedVersion.contains("${")) continue;
                    m = (Xml.Document)new ChangePropertyValue(requestedVersion, newerVersion, false).getVisitor().visitNonNull((Tree)m, (Object)ctx, this.getCursor());
                    break;
                }
                if (m != document) {
                    Pom requestedPom = this.getResolutionResult().getPom().getRequested();
                    this.maybeUpdateModel();
                    this.doAfterVisit(new RemoveRedundantDependencyVersions());
                }
                return m;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t;
                block7: {
                    block6: {
                        String newerVersion;
                        t = super.visitTag(tag, ctx);
                        if (!this.isDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) break block6;
                        ResolvedDependency d = this.findDependency(tag);
                        if (d == null || (newerVersion = this.findNewerVersion(d.getGroupId(), d.getArtifactId(), d.getVersion(), ctx)) == null) break block7;
                        for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
                            String requestedVersion;
                            if (!StringUtils.matchesGlob((String)dm.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)dm.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId) || !(requestedVersion = dm.getRequested().getVersion()).startsWith("${")) continue;
                            this.doAfterVisit((TreeVisitor)new ChangeProperty(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion));
                            return t;
                        }
                        Optional version = t.getChild("version");
                        if (!version.isPresent()) break block7;
                        String requestedVersion = d.getRequested().getVersion();
                        if (requestedVersion != null && requestedVersion.startsWith("${")) {
                            this.doAfterVisit((TreeVisitor)new ChangeProperty(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion));
                            return t;
                        }
                        t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)version.get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                        break block7;
                    }
                    if (this.isManagedDependencyTag(UpgradeDependencyVersion.this.groupId, UpgradeDependencyVersion.this.artifactId)) {
                        for (ResolvedManagedDependency dm : this.getResolutionResult().getPom().getDependencyManagement()) {
                            ResolvedGroupArtifactVersion bom;
                            if (StringUtils.matchesGlob((String)dm.getGroupId(), (String)UpgradeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)dm.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) {
                                String requestedVersion = dm.getRequested().getVersion();
                                String newerVersion = this.findNewerVersion(dm.getGroupId(), dm.getArtifactId(), dm.getVersion(), ctx);
                                if (!requestedVersion.startsWith("${")) continue;
                                this.doAfterVisit((TreeVisitor)new ChangeProperty(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion));
                                return t;
                            }
                            if (dm.getBomGav() == null || !StringUtils.matchesGlob((String)(bom = dm.getBomGav()).getGroupId(), (String)UpgradeDependencyVersion.this.groupId) || !StringUtils.matchesGlob((String)bom.getArtifactId(), (String)UpgradeDependencyVersion.this.artifactId)) continue;
                            String requestedVersion = dm.getRequestedBom().getVersion();
                            String newerVersion = this.findNewerVersion(bom.getGroupId(), bom.getArtifactId(), bom.getVersion(), ctx);
                            if (newerVersion == null) continue;
                            if (requestedVersion.startsWith("${")) {
                                this.doAfterVisit((TreeVisitor)new ChangeProperty(requestedVersion.substring(2, requestedVersion.length() - 1), newerVersion));
                                return t;
                            }
                            t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)t.getChild("version").get(), newerVersion).visitNonNull((Tree)t, (Object)0, this.getCursor());
                        }
                    }
                }
                return t;
            }

            @Nullable
            private String findNewerVersion(String groupId, String artifactId, String version, ExecutionContext ctx) {
                if (this.availableVersions == null) {
                    MavenMetadata mavenMetadata = this.downloadMetadata(groupId, artifactId, ctx);
                    this.availableVersions = new ArrayList<String>();
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!versionComparator.isValid(version, v)) continue;
                        this.availableVersions.add(v);
                    }
                }
                return versionComparator.upgrade(version, this.availableVersions).orElse(null);
            }
        };
    }

    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean trustParent) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.trustParent = trustParent;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @Nullable
    public Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    public String toString() {
        return "UpgradeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ", trustParent=" + this.getTrustParent() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

