/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.utilities;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.CheckedFunction1;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.MavenArtifactCache;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ResolvedDependency;

public class MavenArtifactDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryExceptions(new Class[]{SocketTimeoutException.class, TimeoutException.class}).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    private final MavenArtifactCache mavenArtifactCache;
    private final Map<String, MavenSettings.Server> serverIdToServer;
    private final Consumer<Throwable> onError;

    public MavenArtifactDownloader(MavenArtifactCache mavenArtifactCache, @Nullable MavenSettings settings, Consumer<Throwable> onError) {
        this.mavenArtifactCache = mavenArtifactCache;
        this.onError = onError;
        this.serverIdToServer = settings == null || settings.getServers() == null ? new HashMap<String, MavenSettings.Server>() : settings.getServers().getServers().stream().collect(Collectors.toMap(MavenSettings.Server::getId, Function.identity()));
    }

    @Nullable
    public Path downloadArtifact(ResolvedDependency dependency) {
        if (dependency.getRequested().getType() != null && !"jar".equals(dependency.getRequested().getType())) {
            return null;
        }
        return this.mavenArtifactCache.computeArtifact(dependency, () -> {
            try {
                InputStream bodyStream;
                String uri = dependency.getRepository().getUri() + "/" + dependency.getGroupId().replace('.', '/') + '/' + dependency.getArtifactId() + '/' + dependency.getVersion() + '/' + dependency.getArtifactId() + '-' + (dependency.getDatedSnapshotVersion() == null ? dependency.getVersion() : dependency.getDatedSnapshotVersion()) + ".jar";
                final AtomicReference<Response> response = new AtomicReference<Response>();
                if (uri.startsWith("~/")) {
                    bodyStream = new FileInputStream(System.getProperty("user.home") + uri.substring(1));
                } else {
                    Request.Builder request = this.applyAuthentication(dependency.getRepository(), new Request.Builder().url(uri).get());
                    response.set((Response)sendRequest.apply((Object)request.build()));
                    ResponseBody body = ((Response)response.get()).body();
                    if (!((Response)response.get()).isSuccessful() || body == null) {
                        this.onError.accept(new MavenDownloadingException("Unable to download dependency %s:%s:%s. Response was %s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), Integer.toString(((Response)response.get()).code())));
                        ((Response)response.get()).close();
                        return null;
                    }
                    bodyStream = body.byteStream();
                }
                return new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return bodyStream.read();
                    }

                    @Override
                    public void close() throws IOException {
                        bodyStream.close();
                        if (response.get() != null) {
                            ((Response)response.get()).close();
                        }
                    }
                };
            }
            catch (Throwable t) {
                this.onError.accept(t);
                return null;
            }
        }, this.onError);
    }

    private Request.Builder applyAuthentication(MavenRepository repository, Request.Builder request) {
        MavenSettings.Server authInfo = this.serverIdToServer.get(repository.getId());
        if (authInfo != null) {
            String credentials = Credentials.basic((String)authInfo.getUsername(), (String)authInfo.getPassword());
            request.header("Authorization", credentials);
        } else if (repository.getUsername() != null && repository.getPassword() != null) {
            String credentials = Credentials.basic((String)repository.getUsername(), (String)repository.getPassword());
            request.header("Authorization", credentials);
        }
        return request;
    }
}

