/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.util.List;
import java.util.Map;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ProfileActivation;

public final class Profile {
    @Nullable
    private final String id;
    @Nullable
    private final ProfileActivation activation;
    private final Map<String, String> properties;
    private final List<Dependency> dependencies;
    private final List<ManagedDependency> dependencyManagement;
    private final List<MavenRepository> repositories;

    public boolean isActive(Iterable<String> activeProfiles) {
        return ProfileActivation.isActive(this.id, activeProfiles, this.activation);
    }

    public Profile(@Nullable String id, @Nullable ProfileActivation activation, Map<String, String> properties, List<Dependency> dependencies, List<ManagedDependency> dependencyManagement, List<MavenRepository> repositories) {
        this.id = id;
        this.activation = activation;
        this.properties = properties;
        this.dependencies = dependencies;
        this.dependencyManagement = dependencyManagement;
        this.repositories = repositories;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public ProfileActivation getActivation() {
        return this.activation;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<ManagedDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Profile)) {
            return false;
        }
        Profile other = (Profile)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ProfileActivation this$activation = this.getActivation();
        ProfileActivation other$activation = other.getActivation();
        if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<ManagedDependency> this$dependencyManagement = this.getDependencyManagement();
        List<ManagedDependency> other$dependencyManagement = other.getDependencyManagement();
        if (this$dependencyManagement == null ? other$dependencyManagement != null : !((Object)this$dependencyManagement).equals(other$dependencyManagement)) {
            return false;
        }
        List<MavenRepository> this$repositories = this.getRepositories();
        List<MavenRepository> other$repositories = other.getRepositories();
        return !(this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ProfileActivation $activation = this.getActivation();
        result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<ManagedDependency> $dependencyManagement = this.getDependencyManagement();
        result = result * 59 + ($dependencyManagement == null ? 43 : ((Object)$dependencyManagement).hashCode());
        List<MavenRepository> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", properties=" + this.getProperties() + ", dependencies=" + this.getDependencies() + ", dependencyManagement=" + this.getDependencyManagement() + ", repositories=" + this.getRepositories() + ")";
    }

    @NonNull
    public Profile withId(@Nullable String id) {
        return this.id == id ? this : new Profile(id, this.activation, this.properties, this.dependencies, this.dependencyManagement, this.repositories);
    }

    @NonNull
    public Profile withActivation(@Nullable ProfileActivation activation) {
        return this.activation == activation ? this : new Profile(this.id, activation, this.properties, this.dependencies, this.dependencyManagement, this.repositories);
    }

    @NonNull
    public Profile withProperties(Map<String, String> properties) {
        return this.properties == properties ? this : new Profile(this.id, this.activation, properties, this.dependencies, this.dependencyManagement, this.repositories);
    }

    @NonNull
    public Profile withDependencies(List<Dependency> dependencies) {
        return this.dependencies == dependencies ? this : new Profile(this.id, this.activation, this.properties, dependencies, this.dependencyManagement, this.repositories);
    }

    @NonNull
    public Profile withDependencyManagement(List<ManagedDependency> dependencyManagement) {
        return this.dependencyManagement == dependencyManagement ? this : new Profile(this.id, this.activation, this.properties, this.dependencies, dependencyManagement, this.repositories);
    }

    @NonNull
    public Profile withRepositories(List<MavenRepository> repositories) {
        return this.repositories == repositories ? this : new Profile(this.id, this.activation, this.properties, this.dependencies, this.dependencyManagement, repositories);
    }
}

