/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.vavr.CheckedFunction1;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenDownloadingException;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public class MavenPomDownloader {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry mavenDownloaderRetry = retryRegistry.retry("MavenDownloader");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)mavenDownloaderRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    private final MavenPomCache mavenCache;
    private final Map<Path, Pom> projectPoms;
    private final MavenExecutionContextView ctx;

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx) {
        this.projectPoms = projectPoms;
        this.ctx = MavenExecutionContextView.view(ctx);
        this.mavenCache = this.ctx.getPomCache();
    }

    public MavenMetadata downloadMetadata(GroupArtifact groupArtifact, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        return this.downloadMetadata(new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), null), containingPom, repositories);
    }

    public MavenMetadata downloadMetadata(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) {
        if (gav.getGroupId() == null) {
            throw new MavenDownloadingException("Unable to download maven metadata because of a missing groupId.");
        }
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "metadata");
        MavenMetadata mavenMetadata = null;
        for (MavenRepository repo : this.distinctNormalizedRepositories(repositories, containingPom, null)) {
            String version = gav.getVersion();
            if (version != null && (version.endsWith("-SNAPSHOT") && !repo.isSnapshots() || version.equals("RELEASE") && !repo.isReleases())) continue;
            try {
                Optional<MavenMetadata> result = this.mavenCache.getMavenMetadata(URI.create(repo.getUri()), gav);
                if (result == null && !URI.create(repo.getUri()).getScheme().equals("file")) {
                    String uri = repo.getUri() + "/" + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + (gav.getVersion() == null ? "" : gav.getVersion() + '/') + "maven-metadata.xml";
                    Request.Builder request = this.applyAuthenticationToRequest(repo, new Request.Builder().url(uri).get());
                    try (Response response = (Response)sendRequest.apply((Object)request.build());){
                        if (response.isSuccessful() && response.body() != null) {
                            byte[] responseBody = response.body().bytes();
                            result = Optional.of(MavenMetadata.parse(responseBody));
                            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, result.get());
                        } else if (response.code() >= 400 && response.code() <= 404) {
                            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (result == null || !result.isPresent()) continue;
                if (mavenMetadata == null) {
                    mavenMetadata = result.get();
                    continue;
                }
                mavenMetadata = this.mergeMetadata(mavenMetadata, result.get());
            }
            catch (Exception exception) {}
        }
        if (mavenMetadata == null) {
            sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
            throw new MavenDownloadingException("Unable to download metadata " + gav);
        }
        sample.stop(timer.tags(new String[]{"outcome", "success"}).register((MeterRegistry)Metrics.globalRegistry));
        return mavenMetadata;
    }

    @NonNull
    private MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(Stream.concat(m1.getVersioning().getVersions().stream(), m2.getVersioning().getVersions().stream()).collect(Collectors.toList()), Stream.concat(m1.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m1.getVersioning().getSnapshotVersions().stream(), m2.getVersioning().getSnapshotVersions() == null ? Stream.empty() : m2.getVersioning().getSnapshotVersions().stream()).collect(Collectors.toList()), null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pom download(GroupArtifactVersion gav, @Nullable String relativePath, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        Optional<Pom> result;
        Pom maybeLocalPom;
        Path folderContainingPom;
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            String errorText = "Unable to download dependency " + gav;
            if (containingPom == null) throw new MavenDownloadingException(errorText);
            this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
            throw new MavenDownloadingException(errorText);
        }
        for (Pom projectPom : this.projectPoms.values()) {
            if (!gav.getGroupId().equals(projectPom.getGroupId()) || !gav.getArtifactId().equals(projectPom.getArtifactId())) continue;
            if (!gav.getVersion().equals(projectPom.getVersion())) return projectPom;
            return projectPom;
        }
        if (containingPom != null && containingPom.getRequested().getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && (folderContainingPom = containingPom.getRequested().getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && gav.getGroupId().equals(maybeLocalPom.getGroupId()) && gav.getArtifactId().equals(maybeLocalPom.getArtifactId()) && gav.getVersion().equals(maybeLocalPom.getVersion())) {
            return maybeLocalPom;
        }
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("group.id", gav.getGroupId()).tag("artifact.id", gav.getArtifactId()).tag("type", "pom");
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(gav, containingPom, repositories, (ExecutionContext)this.ctx);
        Iterator<MavenRepository> iterator = normalizedRepos.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
                if (containingPom == null) throw new MavenDownloadingException("Unable to download dependency " + gav);
                this.ctx.getResolutionListener().downloadError(gav, containingPom.getRequested());
                throw new MavenDownloadingException("Unable to download dependency " + gav);
            }
            MavenRepository repo = iterator.next();
            ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(repo.getUri(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), versionMaybeDatedSnapshot);
            result = this.mavenCache.getPom(resolvedGav);
            if (result == null) {
                URI uri = URI.create(repo.getUri() + "/" + gav.getGroupId().replace('.', '/') + '/' + gav.getArtifactId() + '/' + gav.getVersion() + '/' + gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".pom");
                if (uri.getScheme().equals("file")) {
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    try {
                        File f = new File(uri);
                        if (!f.exists() || !new File(f.getParentFile(), gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".jar").exists()) continue;
                        try (FileInputStream fis = new FileInputStream(f);){
                            RawPom rawPom = RawPom.parse(fis, Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                            Pom pom3 = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                            pom3 = pom3.withRepository(MavenRepository.MAVEN_LOCAL_USER_NEUTRAL);
                            if (!Objects.equals(versionMaybeDatedSnapshot, pom3.getVersion())) {
                                pom3 = pom3.withGav(pom3.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                            }
                            this.mavenCache.putPom(resolvedGav, pom3);
                            sample.stop(timer.tags(new String[]{"outcome", "from maven local"}).register((MeterRegistry)Metrics.globalRegistry));
                            Pom pom2 = pom3;
                            return pom2;
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                Request.Builder request = this.applyAuthenticationToRequest(repo, new Request.Builder().url(uri.toString()).get());
                try {
                    Response response = (Response)sendRequest.apply((Object)request.build());
                    try {
                        if (response.isSuccessful() && response.body() != null) {
                            byte[] responseBody = response.body().bytes();
                            Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                            RawPom rawPom = RawPom.parse(new ByteArrayInputStream(responseBody), Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                            Pom pom4 = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                            if (!Objects.equals(versionMaybeDatedSnapshot, pom4.getVersion())) {
                                pom4 = pom4.withGav(pom4.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                            }
                            this.mavenCache.putPom(resolvedGav, pom4);
                            sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
                            Pom pom = pom4;
                            return pom;
                        }
                        this.mavenCache.putPom(resolvedGav, null);
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (result.isPresent()) break;
        }
        sample.stop(timer.tags(new String[]{"outcome", "cached"}).register((MeterRegistry)Metrics.globalRegistry));
        return result.get();
    }

    @Nullable
    private String datedSnapshotVersion(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories, ExecutionContext ctx) {
        if (gav.getVersion() != null && gav.getVersion().endsWith("-SNAPSHOT")) {
            for (ResolvedGroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(gav.getGroupId()) || !pinnedSnapshotVersion.getArtifactId().equals(gav.getArtifactId()) || !pinnedSnapshotVersion.getVersion().equals(gav.getVersion())) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
            MavenMetadata mavenMetadata = this.downloadMetadata(gav, containingPom, repositories);
            MavenMetadata.Snapshot snapshot = mavenMetadata.getVersioning().getSnapshot();
            if (snapshot != null) {
                return gav.getVersion().replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return gav.getVersion();
    }

    private Collection<MavenRepository> distinctNormalizedRepositories(List<MavenRepository> repositories, @Nullable ResolvedPom containingPom, @Nullable String acceptsVersion) {
        MavenRepository normalizedRepo;
        LinkedHashSet<MavenRepository> normalizedRepositories = new LinkedHashSet<MavenRepository>();
        normalizedRepositories.add(MavenRepository.MAVEN_LOCAL);
        for (MavenRepository repo : repositories) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        for (MavenRepository repo : this.ctx.getRepositories()) {
            normalizedRepo = this.normalizeRepository(repo, containingPom);
            if (normalizedRepo == null || acceptsVersion != null && !normalizedRepo.acceptsVersion(acceptsVersion)) continue;
            normalizedRepositories.add(normalizedRepo);
        }
        normalizedRepositories.add(this.normalizeRepository(MavenRepository.MAVEN_CENTRAL, containingPom));
        return normalizedRepositories;
    }

    @Nullable
    protected MavenRepository normalizeRepository(MavenRepository originalRepository, @Nullable ResolvedPom containingPom) {
        Optional<MavenRepository> result;
        block21: {
            result = null;
            MavenRepository repository = this.applyAuthenticationToRepository(this.applyMirrors(originalRepository));
            if (containingPom != null) {
                repository = repository.withUri(containingPom.getValue(repository.getUri()));
            }
            try {
                MavenRepository normalized;
                block22: {
                    if (repository.isKnownToExist()) {
                        return repository;
                    }
                    String originalUrl = repository.getUri();
                    result = this.mavenCache.getNormalizedRepository(repository);
                    if (result != null) break block21;
                    if (!repository.getUri().toLowerCase().startsWith("http")) {
                        return null;
                    }
                    String httpsUri = repository.getUri().toLowerCase().startsWith("http:") ? repository.getUri().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri();
                    Request.Builder request = this.applyAuthenticationToRequest(repository, new Request.Builder().url(httpsUri).get());
                    normalized = null;
                    try (Response ignored = (Response)sendRequest.apply((Object)request.build());){
                        normalized = repository.withUri(httpsUri);
                    }
                    catch (Throwable t) {
                        if (httpsUri.equals(originalUrl)) break block22;
                        try (Response ignored2 = (Response)sendRequest.apply((Object)request.url(originalUrl).build());){
                            normalized = new MavenRepository(repository.getId(), originalUrl, repository.isReleases(), repository.isSnapshots(), repository.getUsername(), repository.getPassword());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                this.mavenCache.putNormalizedRepository(repository, normalized);
                result = Optional.ofNullable(normalized);
            }
            catch (Exception e) {
                this.ctx.getOnError().accept(e);
                this.mavenCache.putNormalizedRepository(repository, null);
            }
        }
        return result == null || !result.isPresent() ? null : this.applyAuthenticationToRepository(result.get());
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(), repository);
    }

    private Request.Builder applyAuthenticationToRequest(MavenRepository repository, Request.Builder request) {
        if (repository.getUsername() != null && repository.getPassword() != null) {
            String credentials = Credentials.basic((String)repository.getUsername(), (String)repository.getPassword());
            request.header("Authorization", credentials);
        }
        return request;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.ctx.getMirrors(), repository);
    }
}

