/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeProperty<P>
extends XmlVisitor<P> {
    private final String key;
    private final String value;

    public Xml visitDocument(Xml.Document document, P p) {
        Optional props = document.getRoot().getChild("properties");
        if (!props.isPresent()) {
            Xml.Tag prop = ((Xml.Document)new XmlParser().parse(new String[]{"<properties>\n  <" + this.key + ">" + this.value + "</" + this.key + ">\n</properties>"}).get(0)).getRoot();
            document = (Xml.Document)new AddToTagVisitor(document.getRoot(), prop, (Comparator)new MavenTagInsertionComparator(document.getRoot().getChildren())).visitNonNull((Tree)document, p);
        } else if (!((Xml.Tag)props.get()).getChild(this.key).isPresent()) {
            Xml.Tag prop = ((Xml.Document)new XmlParser().parse(new String[]{"<" + this.key + ">" + this.value + "</" + this.key + ">"}).get(0)).getRoot();
            document = (Xml.Document)new AddToTagVisitor((Xml.Tag)props.get(), prop, Comparator.comparing(Xml.Tag::getName)).visitNonNull((Tree)document, p);
        } else {
            document = (Xml.Document)new ChangeTagValueVisitor((Xml.Tag)((Xml.Tag)props.get()).getChild(this.key).get(), this.value).visitNonNull((Tree)document, p);
        }
        return document;
    }

    public ChangeProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @NonNull
    public String toString() {
        return "ChangeProperty(key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeProperty)) {
            return false;
        }
        ChangeProperty other = (ChangeProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

