/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeDependencyGroupIdAndArtifactId
extends Recipe {
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use.", example="rewrite-testing-frameworks")
    private final String newArtifactId;

    public String getDisplayName() {
        return "Change Maven dependency groupId and artifactId";
    }

    public String getDescription() {
        return "Change the groupId and artifactId of a specified Maven dependency.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isDependencyTag(ChangeDependencyGroupIdAndArtifactId.this.oldGroupId, ChangeDependencyGroupIdAndArtifactId.this.oldArtifactId)) {
                    Optional artifactIdTag;
                    Optional groupIdTag = tag.getChild("groupId");
                    if (groupIdTag.isPresent() && !ChangeDependencyGroupIdAndArtifactId.this.newGroupId.equals(((Xml.Tag)groupIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)groupIdTag.get(), ChangeDependencyGroupIdAndArtifactId.this.newGroupId));
                    }
                    if ((artifactIdTag = tag.getChild("artifactId")).isPresent() && !ChangeDependencyGroupIdAndArtifactId.this.newArtifactId.equals(((Xml.Tag)artifactIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)artifactIdTag.get(), ChangeDependencyGroupIdAndArtifactId.this.newArtifactId));
                    }
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    public ChangeDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyGroupIdAndArtifactId(oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeDependencyGroupIdAndArtifactId other = (ChangeDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        return !(this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        return result;
    }
}

