/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public class MavenVisitor
extends XmlVisitor<ExecutionContext> {
    private static final XPathMatcher DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencies/dependency");
    private static final XPathMatcher MANAGED_DEPENDENCY_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies/dependency");
    private static final XPathMatcher PROPERTY_MATCHER = new XPathMatcher("/project/properties/*");
    private static final XPathMatcher PLUGIN_MATCHER = new XPathMatcher("/project/*/plugins/plugin");
    private static final XPathMatcher PARENT_MATCHER = new XPathMatcher("/project/parent");
    protected Pom model;
    protected Collection<Pom> modules;

    public String getLanguage() {
        return "maven";
    }

    public Maven visitMaven(Maven maven, ExecutionContext ctx) {
        this.model = maven.getModel();
        if (this.model == null) {
            return maven;
        }
        this.modules = maven.getModules();
        return (Maven)this.visitDocument((Xml.Document)maven, ctx);
    }

    public final Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document refactored = (Xml.Document)super.visitDocument(document, (Object)ctx);
        if (refactored != document) {
            return new Maven(refactored);
        }
        return refactored;
    }

    public boolean isPropertyTag() {
        return PROPERTY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag() {
        return DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isDependencyTag(String groupId, @Nullable String artifactId) {
        return this.isDependencyTag() && this.hasGroupAndArtifact(groupId, artifactId);
    }

    public boolean isManagedDependencyTag() {
        return MANAGED_DEPENDENCY_MATCHER.matches(this.getCursor());
    }

    public boolean isManagedDependencyTag(String groupId, @Nullable String artifactId) {
        return this.isManagedDependencyTag() && this.hasGroupAndArtifact(groupId, artifactId);
    }

    public boolean isPluginTag() {
        return PLUGIN_MATCHER.matches(this.getCursor());
    }

    public boolean isPluginTag(String groupId, @Nullable String artifactId) {
        return this.isPluginTag() && this.hasGroupAndArtifact(groupId, artifactId);
    }

    public boolean isParentTag() {
        return PARENT_MATCHER.matches(this.getCursor());
    }

    private boolean hasGroupAndArtifact(String groupId, @Nullable String artifactId) {
        return this.hasGroupId(groupId) && this.hasArtifactId(artifactId);
    }

    private boolean hasGroupId(String groupId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isGroupIdFound = groupId.equals(tag.getChildValue("groupId").orElse(this.model.getGroupId()));
        if (!isGroupIdFound && this.model.getProperties() != null && tag.getChildValue("groupId").isPresent() && ((String)tag.getChildValue("groupId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("groupId").get()).trim();
            String value = this.model.getValue(propertyKey);
            isGroupIdFound = value != null && StringUtils.matchesGlob((String)value, (String)groupId);
        }
        return isGroupIdFound;
    }

    private boolean hasArtifactId(@Nullable String artifactId) {
        Xml.Tag tag = (Xml.Tag)this.getCursor().getValue();
        boolean isArtifactIdFound = tag.getChildValue("artifactId").map(a -> a.equals(artifactId)).orElse(artifactId == null);
        if (!isArtifactIdFound && artifactId != null && this.model.getProperties() != null && tag.getChildValue("artifactId").isPresent() && ((String)tag.getChildValue("artifactId").get()).trim().startsWith("${")) {
            String propertyKey = ((String)tag.getChildValue("artifactId").get()).trim();
            String value = this.model.getValue(propertyKey);
            isArtifactIdFound = value != null && StringUtils.matchesGlob((String)value, (String)artifactId);
        }
        return isArtifactIdFound;
    }

    @Nullable
    public Pom.Dependency findDependency(Xml.Tag tag) {
        return this.model.getDependencies().stream().filter(d -> tag.getChildValue("groupId").orElse(this.model.getGroupId()).equals(d.getGroupId()) && tag.getChildValue("artifactId").orElse(this.model.getArtifactId()).equals(d.getArtifactId())).findAny().orElse(null);
    }

    public Collection<Pom.Dependency> findDependencies(String groupId, String artifactId) {
        return this.findDependencies(d -> StringUtils.matchesGlob((String)d.getGroupId(), (String)groupId) && StringUtils.matchesGlob((String)d.getArtifactId(), (String)artifactId));
    }

    public Collection<Pom.Dependency> findDependencies(Predicate<Pom.Dependency> matcher) {
        return Stream.concat(this.model.getDependencies().stream().filter(matcher), this.model.getDependencies().stream().flatMap(d -> d.findDependencies(matcher).stream())).collect(Collectors.toList());
    }
}

