/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.Version;
import org.openrewrite.maven.search.FindDependency;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddDependencyVisitor
extends MavenVisitor {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    @Nullable
    private final String metadataPattern;
    private final boolean releasesOnly;
    @Nullable
    private final String classifier;
    @Nullable
    private final String scope;
    @Nullable
    private final String type;
    @Nullable
    private final Pattern familyPattern;
    @Nullable
    private final List<String> onlyIfUsing;
    @Nullable
    private VersionComparator versionComparator;

    @Override
    public Maven visitMaven(Maven maven, ExecutionContext ctx) {
        if (this.onlyIfUsing != null) {
            Set found = (Set)ctx.getMessage("org.openrewrite.java.FoundType", Collections.emptySet());
            if (this.onlyIfUsing.stream().noneMatch(t -> found.contains(JavaType.Class.build((String)t)))) {
                return maven;
            }
        }
        this.model = maven.getModel();
        Validated versionValidation = Semver.validate((String)this.version, (String)this.metadataPattern);
        if (versionValidation.isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (!FindDependency.find(maven, this.groupId, this.artifactId).isEmpty()) {
            return maven;
        }
        for (Pom ancestor = this.model.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.getDependencies().stream().anyMatch(d -> this.groupId.equals(d.getGroupId()) && this.artifactId.equals(d.getArtifactId()))) continue;
            return maven;
        }
        Xml.Tag root = maven.getRoot();
        if (!root.getChild("dependencies").isPresent()) {
            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencies/>"), (Comparator)new MavenTagInsertionComparator(root.getChildren())));
        }
        this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder());
        ArrayList<Pom.Dependency> dependencies = new ArrayList<Pom.Dependency>(this.model.getDependencies());
        String packaging = this.type == null ? "jar" : this.type;
        dependencies.add(new Pom.Dependency(null, Scope.fromName(this.scope), this.classifier, this.type, false, new Pom(this.groupId, this.artifactId, this.version, null, null, null, packaging, this.classifier, null, Collections.emptyList(), new Pom.DependencyManagement(Collections.emptyList()), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap()), this.version, null, Collections.emptySet()));
        return maven.withModel(maven.getModel().withDependencies(dependencies));
    }

    private String findVersionToUse(String groupId, String artifactId, ExecutionContext ctx) {
        if (this.versionComparator == null) {
            return this.version;
        }
        MavenMetadata mavenMetadata = new MavenPomDownloader(MavenPomCache.NOOP, Collections.emptyMap(), ctx).downloadMetadata(groupId, artifactId, Collections.emptyList());
        LatestRelease latest = new LatestRelease(this.metadataPattern);
        return mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).filter(v -> !this.releasesOnly || latest.isValid(v)).max((Comparator<String>)this.versionComparator).orElse(this.version);
    }

    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String metadataPattern, boolean releasesOnly, @Nullable String classifier, @Nullable String scope, @Nullable String type, @Nullable Pattern familyPattern, @Nullable List<String> onlyIfUsing) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.metadataPattern = metadataPattern;
        this.releasesOnly = releasesOnly;
        this.classifier = classifier;
        this.scope = scope;
        this.type = type;
        this.familyPattern = familyPattern;
        this.onlyIfUsing = onlyIfUsing;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependencyVisitor)) {
            return false;
        }
        AddDependencyVisitor other = (AddDependencyVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.releasesOnly != other.releasesOnly) {
            return false;
        }
        String this$groupId = this.groupId;
        String other$groupId = other.groupId;
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.artifactId;
        String other$artifactId = other.artifactId;
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$metadataPattern = this.metadataPattern;
        String other$metadataPattern = other.metadataPattern;
        if (this$metadataPattern == null ? other$metadataPattern != null : !this$metadataPattern.equals(other$metadataPattern)) {
            return false;
        }
        String this$classifier = this.classifier;
        String other$classifier = other.classifier;
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$scope = this.scope;
        String other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$type = this.type;
        String other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Pattern this$familyPattern = this.familyPattern;
        Pattern other$familyPattern = other.familyPattern;
        if (this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern)) {
            return false;
        }
        List<String> this$onlyIfUsing = this.onlyIfUsing;
        List<String> other$onlyIfUsing = other.onlyIfUsing;
        if (this$onlyIfUsing == null ? other$onlyIfUsing != null : !((Object)this$onlyIfUsing).equals(other$onlyIfUsing)) {
            return false;
        }
        VersionComparator this$versionComparator = this.versionComparator;
        VersionComparator other$versionComparator = other.versionComparator;
        return !(this$versionComparator == null ? other$versionComparator != null : !this$versionComparator.equals(other$versionComparator));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddDependencyVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.releasesOnly ? 79 : 97);
        String $groupId = this.groupId;
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.artifactId;
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $metadataPattern = this.metadataPattern;
        result = result * 59 + ($metadataPattern == null ? 43 : $metadataPattern.hashCode());
        String $classifier = this.classifier;
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Pattern $familyPattern = this.familyPattern;
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        List<String> $onlyIfUsing = this.onlyIfUsing;
        result = result * 59 + ($onlyIfUsing == null ? 43 : ((Object)$onlyIfUsing).hashCode());
        VersionComparator $versionComparator = this.versionComparator;
        result = result * 59 + ($versionComparator == null ? 43 : $versionComparator.hashCode());
        return result;
    }

    private class InsertDependencyInOrder
    extends MavenVisitor {
        private InsertDependencyInOrder() {
        }

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                String versionToUse = null;
                if (this.model.getManagedVersion(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId) == null) {
                    if (AddDependencyVisitor.this.familyPattern != null) {
                        versionToUse = this.findDependencies(d -> AddDependencyVisitor.this.familyPattern.matcher(d.getGroupId()).matches()).stream().max(Comparator.comparing(d -> new Version(d.getVersion()))).map(Pom.Dependency::getRequestedVersion).orElse(null);
                    }
                    if (versionToUse == null) {
                        versionToUse = AddDependencyVisitor.this.findVersionToUse(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, ctx);
                    }
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + AddDependencyVisitor.this.groupId + "</groupId>\n<artifactId>" + AddDependencyVisitor.this.artifactId + "</artifactId>\n" + (versionToUse == null ? "" : "<version>" + versionToUse + "</version>\n") + (AddDependencyVisitor.this.classifier == null ? "" : "<classifier>" + AddDependencyVisitor.this.classifier + "</classifier>\n") + (AddDependencyVisitor.this.scope == null ? "" : "<scope>" + AddDependencyVisitor.this.scope + "</scope>\n") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getChildren(), dependencyTag)));
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }
    }
}

