/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ChangePropertyValue;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.tree.Xml;

public class ChangeDependencyVersion
extends MavenRefactorVisitor {
    private String groupId;
    @Nullable
    private String artifactId;
    private String toVersion;

    public ChangeDependencyVersion() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(@Nullable String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"toVersion", (Object)this.toVersion));
    }

    public Xml visitTag(Xml.Tag tag) {
        block4: {
            block3: {
                String version;
                Optional versionTag;
                block5: {
                    if (!this.isDependencyTag(this.groupId, this.artifactId) && !this.isManagedDependencyTag(this.groupId, this.artifactId)) break block3;
                    versionTag = tag.getChild("version");
                    if (!versionTag.isPresent() || (version = (String)((Xml.Tag)versionTag.get()).getValue().orElse(null)) == null) break block4;
                    if (!version.trim().startsWith("${") || this.toVersion.equals(this.model.getProperty(version.trim()))) break block5;
                    ChangePropertyValue changePropertyValue = new ChangePropertyValue();
                    changePropertyValue.setKey(version);
                    changePropertyValue.setToValue(this.toVersion);
                    this.andThen((RefactorVisitor)changePropertyValue);
                    break block4;
                }
                if (this.toVersion.equals(version)) break block4;
                this.andThen((RefactorVisitor)new ChangeTagValue.Scoped((Xml.Tag)versionTag.get(), this.toVersion));
                break block4;
            }
            if (!this.modules.isEmpty() && this.isPropertyTag()) {
                String propertyKeyRef = "${" + tag.getName() + "}";
                block0: for (Pom module : this.modules) {
                    for (Pom.Dependency dependency : module.getDependencies()) {
                        if (!propertyKeyRef.equals(dependency.getRequestedVersion())) continue;
                        this.andThen((RefactorVisitor)new ChangeTagValue.Scoped(tag, this.toVersion));
                        break block0;
                    }
                }
            }
        }
        return super.visitTag(tag);
    }
}

