/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.xml.AddToTag;
import org.openrewrite.xml.ChangeTagValue;
import org.openrewrite.xml.RemoveContent;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class ChangeDependencyScope
extends MavenRefactorVisitor {
    private String groupId;
    private String artifactId;
    @Nullable
    private String toScope;

    public ChangeDependencyScope() {
        this.setCursoringOn();
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setToScope(@Nullable String toScope) {
        this.toScope = toScope;
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId));
    }

    public Xml visitTag(Xml.Tag tag) {
        if (this.isDependencyTag() && this.groupId.equals(tag.getChildValue("groupId").orElse(this.model.getGroupId())) && this.artifactId.equals(tag.getChildValue("artifactId").orElse(null))) {
            Optional scope = tag.getChild("scope");
            if (scope.isPresent()) {
                if (this.toScope == null) {
                    this.andThen((RefactorVisitor)new RemoveContent.Scoped((Content)scope.get(), false));
                } else if (!this.toScope.equals(((Xml.Tag)scope.get()).getValue().orElse(null))) {
                    this.andThen((RefactorVisitor)new ChangeTagValue.Scoped((Xml.Tag)scope.get(), this.toScope));
                }
            } else {
                this.andThen((RefactorVisitor)new AddToTag.Scoped(tag, Xml.Tag.build((String)("<scope>" + this.toScope + "</scope>"))));
            }
        }
        return super.visitTag(tag);
    }
}

