/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenRefactorVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.cache.NoopCache;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.internal.MavenDownloader;
import org.openrewrite.maven.internal.MavenMetadata;
import org.openrewrite.maven.internal.Version;
import org.openrewrite.maven.tree.Maven;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTag;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddDependency
extends MavenRefactorVisitor {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    private String groupId;
    private String artifactId;
    private String version;
    @Nullable
    private String metadataPattern;
    private boolean releasesOnly = true;
    @Nullable
    private VersionComparator versionComparator;
    @Nullable
    private String classifier;
    @Nullable
    private String scope;
    private boolean skipIfPresent = true;
    @Nullable
    private Pattern familyPattern;

    public void setMetadataPattern(@Nullable String metadataPattern) {
        this.metadataPattern = metadataPattern;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    public void setClassifier(@Nullable String classifier) {
        this.classifier = classifier;
    }

    public void setScope(@Nullable String scope) {
        this.scope = scope;
    }

    public void setSkipIfPresent(boolean skipIfPresent) {
        this.skipIfPresent = skipIfPresent;
    }

    public void setReleasesOnly(boolean releasesOnly) {
        this.releasesOnly = releasesOnly;
    }

    public void setFamilyPattern(@Nullable String familyPattern) {
        this.familyPattern = familyPattern == null ? null : Pattern.compile(familyPattern.replace("*", ".*"));
    }

    public Validated validate() {
        return Validated.required((String)"groupId", (Object)this.groupId).and(Validated.required((String)"artifactId", (Object)this.artifactId)).and(Validated.required((String)"version", (Object)this.version).or(Semver.validate((String)this.version, (String)this.metadataPattern)));
    }

    public boolean isIdempotent() {
        return false;
    }

    @Override
    public Maven visitMaven(Maven maven) {
        this.model = maven.getModel();
        Validated versionValidation = Semver.validate((String)this.version, (String)this.metadataPattern);
        if (versionValidation.isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        if (this.skipIfPresent && this.findDependencies(this.groupId, this.artifactId).stream().anyMatch(d -> !(this.version != null && !this.version.equals(d.getVersion()) || this.classifier != null && !this.classifier.equals(d.getClassifier()) || !d.getScope().isInClasspathOf(Scope.fromName(this.scope))))) {
            return maven;
        }
        Xml.Tag root = maven.getRoot();
        if (!root.getChild("dependencies").isPresent()) {
            this.andThen((RefactorVisitor)new AddToTag.Scoped(root, Xml.Tag.build((String)"<dependencies/>"), (Comparator)new MavenTagInsertionComparator(root.getChildren())));
        }
        this.andThen((RefactorVisitor)new InsertDependencyInOrder());
        ArrayList<Pom.Dependency> dependencies = new ArrayList<Pom.Dependency>(this.model.getDependencies());
        dependencies.add(new Pom.Dependency(Scope.fromName(this.scope), this.classifier, false, new Pom(null, this.groupId, this.artifactId, this.version, null, "jar", this.classifier, null, Collections.emptyList(), new Pom.DependencyManagement(Collections.emptyList()), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap()), this.version, Collections.emptySet()));
        return maven.withModel(maven.getModel().withDependencies(dependencies));
    }

    private String findVersionToUse(String groupId, String artifactId) {
        if (this.versionComparator == null) {
            return this.version;
        }
        MavenMetadata mavenMetadata = new MavenDownloader(new NoopCache()).downloadMetadata(groupId, artifactId, Collections.emptyList());
        LatestRelease latest = new LatestRelease(this.metadataPattern);
        return mavenMetadata.getVersioning().getVersions().stream().filter(arg_0 -> ((VersionComparator)this.versionComparator).isValid(arg_0)).filter(v -> !this.releasesOnly || latest.isValid(v)).max((Comparator<String>)this.versionComparator).orElse(this.version);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddDependency)) {
            return false;
        }
        AddDependency other = (AddDependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.releasesOnly != other.releasesOnly) {
            return false;
        }
        if (this.skipIfPresent != other.skipIfPresent) {
            return false;
        }
        String this$groupId = this.groupId;
        String other$groupId = other.groupId;
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.artifactId;
        String other$artifactId = other.artifactId;
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$metadataPattern = this.metadataPattern;
        String other$metadataPattern = other.metadataPattern;
        if (this$metadataPattern == null ? other$metadataPattern != null : !this$metadataPattern.equals(other$metadataPattern)) {
            return false;
        }
        VersionComparator this$versionComparator = this.versionComparator;
        VersionComparator other$versionComparator = other.versionComparator;
        if (this$versionComparator == null ? other$versionComparator != null : !this$versionComparator.equals(other$versionComparator)) {
            return false;
        }
        String this$classifier = this.classifier;
        String other$classifier = other.classifier;
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$scope = this.scope;
        String other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        Pattern this$familyPattern = this.familyPattern;
        Pattern other$familyPattern = other.familyPattern;
        return !(this$familyPattern == null ? other$familyPattern != null : !this$familyPattern.equals(other$familyPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.releasesOnly ? 79 : 97);
        result = result * 59 + (this.skipIfPresent ? 79 : 97);
        String $groupId = this.groupId;
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.artifactId;
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $metadataPattern = this.metadataPattern;
        result = result * 59 + ($metadataPattern == null ? 43 : $metadataPattern.hashCode());
        VersionComparator $versionComparator = this.versionComparator;
        result = result * 59 + ($versionComparator == null ? 43 : $versionComparator.hashCode());
        String $classifier = this.classifier;
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        Pattern $familyPattern = this.familyPattern;
        result = result * 59 + ($familyPattern == null ? 43 : $familyPattern.hashCode());
        return result;
    }

    private class InsertDependencyInOrder
    extends MavenRefactorVisitor {
        public InsertDependencyInOrder() {
            this.setCursoringOn();
        }

        public Xml visitTag(Xml.Tag tag) {
            if (DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                String versionToUse = null;
                if (this.model.getManagedVersion(AddDependency.this.groupId, AddDependency.this.artifactId) == null) {
                    if (AddDependency.this.familyPattern != null) {
                        versionToUse = this.findDependencies(d -> AddDependency.this.familyPattern.matcher(d.getGroupId()).matches()).stream().max(Comparator.comparing(d -> new Version(d.getVersion()))).map(Pom.Dependency::getRequestedVersion).orElse(versionToUse);
                    }
                    if (versionToUse == null) {
                        versionToUse = AddDependency.this.findVersionToUse(AddDependency.this.groupId, AddDependency.this.artifactId);
                    }
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + AddDependency.this.groupId + "</groupId>\n<artifactId>" + AddDependency.this.artifactId + "</artifactId>\n" + (versionToUse == null ? "" : "<version>" + versionToUse + "</version>\n") + (AddDependency.this.classifier == null ? "" : "<classifier>" + AddDependency.this.classifier + "</classifier>\n") + (AddDependency.this.scope == null ? "" : "<scope>" + AddDependency.this.scope + "</scope>\n") + "</dependency>"));
                this.andThen((RefactorVisitor)new AddToTag.Scoped(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getChildren(), dependencyTag)));
                return tag;
            }
            return super.visitTag(tag);
        }
    }
}

