/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal.template;

import java.util.Collection;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.java.internal.template.BlockStatementTemplateGenerator;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;

public class KotlinBlockStatementTemplateGenerator
extends BlockStatementTemplateGenerator {
    public KotlinBlockStatementTemplateGenerator(Set<String> imports, boolean contextSensitive) {
        super(imports, contextSensitive);
    }

    protected void contextFreeTemplate(Cursor cursor, J j, Collection<JavaType.GenericTypeVariable> typeVariables, StringBuilder before, StringBuilder after) {
        if (j instanceof J.MethodInvocation) {
            before.insert(0, "class Template {\n");
            JavaType.Method methodType = ((J.MethodInvocation)j).getMethodType();
            if (methodType == null || methodType.getReturnType() != JavaType.Primitive.Void) {
                before.append("var o : Any = ");
            }
            after.append(";\n}");
        } else if (j instanceof Expression && !(j instanceof J.Assignment)) {
            before.insert(0, "class Template {\n");
            before.append("var o : Any = ");
            after.append(";\n}");
        } else {
            if (j instanceof J.ClassDeclaration || j instanceof K.ClassDeclaration) {
                throw new IllegalArgumentException("Templating a class declaration requires context from which package declaration and imports may be reached. Mark this template as context-sensitive by calling KotlinTemplate.Builder#contextSensitive().");
            }
            if (j instanceof Statement && !(j instanceof J.Import) && !(j instanceof J.Package)) {
                before.insert(0, "class Template {\ninit {\n");
                after.append("\n}\n}");
            } else {
                throw new IllegalArgumentException("Kotlin templating is currently only implemented for context-free expressions and statements and not for `" + j.getClass() + "` instances.");
            }
        }
        before.insert(0, "import org.openrewrite.java.internal.template.__M__;\nimport org.openrewrite.java.internal.template.__P__;\n");
        for (String anImport : this.imports) {
            before.insert(0, anImport);
        }
    }
}

