/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.Quoted;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.internal.KotlinSource;
import org.openrewrite.kotlin.internal.PsiElementAssociations;
import org.openrewrite.kotlin.internal.PsiTreePrinter;
import org.openrewrite.kotlin.marker.AnnotationConstructor;
import org.openrewrite.kotlin.marker.AnnotationUseSite;
import org.openrewrite.kotlin.marker.By;
import org.openrewrite.kotlin.marker.Extension;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.IndexedAccess;
import org.openrewrite.kotlin.marker.Infix;
import org.openrewrite.kotlin.marker.IsNullSafe;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.NotIs;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.OmitEquals;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class KotlinTreeParserVisitor
extends KtVisitor<J, ExecutionContext> {
    private final KotlinSource kotlinSource;
    private final PsiElementAssociations psiElementAssociations;
    private final List<NamedStyles> styles;
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final Charset charset;
    private final Boolean charsetBomMarked;
    private final Stack<KtElement> ownerStack = new Stack();
    private final ExecutionContext executionContext;
    private final List<Integer> cRLFLocations;

    public KotlinTreeParserVisitor(KotlinSource kotlinSource, PsiElementAssociations psiElementAssociations, List<NamedStyles> styles, @Nullable Path relativeTo, ExecutionContext ctx) {
        this.kotlinSource = kotlinSource;
        this.psiElementAssociations = psiElementAssociations;
        this.styles = styles;
        this.sourcePath = kotlinSource.getInput().getRelativePath(relativeTo);
        this.fileAttributes = kotlinSource.getInput().getFileAttributes();
        EncodingDetectingInputStream stream = kotlinSource.getInput().getSource(ctx);
        this.charset = stream.getCharset();
        this.charsetBomMarked = stream.isCharsetBomMarked();
        this.ownerStack.push((KtElement)kotlinSource.getKtFile());
        this.executionContext = ctx;
        this.cRLFLocations = kotlinSource.getCRLFLocations();
    }

    public K.CompilationUnit parse() {
        return (K.CompilationUnit)this.visitKtFile(this.kotlinSource.getKtFile(), this.executionContext);
    }

    public J visitParenthesizedExpression(KtParenthesizedExpression expression, ExecutionContext data) {
        assert (expression.getExpression() != null);
        PsiElement rPar = expression.getLastChild();
        if (rPar == null || !")".equals(rPar.getText())) {
            throw new UnsupportedOperationException("TODO");
        }
        return new J.Parentheses(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padRight((J)expression.getExpression().accept((KtVisitor)this, (Object)data), this.prefix(rPar)));
    }

    public J visitForExpression(KtForExpression expression, ExecutionContext data) {
        return new J.ForEachLoop(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, new J.ForEachLoop.Control(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight((J.VariableDeclarations)Objects.requireNonNull(expression.getLoopParameter()).accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)expression.getLoopParameter())), this.padRight((Expression)((J)Objects.requireNonNull(expression.getLoopRange()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getLoopRange().getParent())), this.suffix(expression.getLoopRange().getParent()))), this.padRight((Statement)((J)Objects.requireNonNull(expression.getBody()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent())), this.suffix((PsiElement)expression.getBody())));
    }

    public J visitAnnotatedExpression(KtAnnotatedExpression expression, ExecutionContext data) {
        List ktAnnotations = expression.getAnnotationEntries();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(ktAnnotations.size());
        for (int i = 0; i < ktAnnotations.size(); ++i) {
            KtAnnotationEntry ktAnnotation = (KtAnnotationEntry)ktAnnotations.get(i);
            J.Annotation anno = (J.Annotation)ktAnnotation.accept((KtVisitor)this, (Object)data);
            if (i == 0) {
                anno = anno.withPrefix(KotlinTreeParserVisitor.merge(this.prefix((PsiElement)expression), anno.getPrefix()));
            }
            annotations.add(anno);
        }
        return new K.AnnotatedExpression(Tree.randomId(), Markers.EMPTY, annotations, (Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getBaseExpression()).accept((KtVisitor)this, (Object)data)));
    }

    public J visitAnnotationUseSiteTarget(KtAnnotationUseSiteTarget annotationTarget, ExecutionContext data) {
        return this.createIdentifier((PsiElement)annotationTarget, this.type((KtElement)annotationTarget));
    }

    public J visitAnonymousInitializer(KtAnonymousInitializer initializer, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitArrayAccessExpression(KtArrayAccessExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        Expression selectExpr = (Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getArrayExpression()).accept((KtVisitor)this, (Object)data));
        JRightPadded<Expression> select = this.padRight(selectExpr, this.suffix((PsiElement)expression.getArrayExpression()));
        J.Identifier name = this.createIdentifier("<get>", Space.EMPTY, (JavaType)this.methodInvocationType((PsiElement)expression));
        markers = markers.addIfAbsent((Marker)new IndexedAccess(Tree.randomId()));
        List indexExpressions = expression.getIndexExpressions();
        ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>();
        for (int i = 0; i < indexExpressions.size(); ++i) {
            KtExpression indexExp = (KtExpression)indexExpressions.get(i);
            JRightPadded<Expression> rp = this.padRight((Expression)this.convertToExpression((J)indexExp.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)indexExp));
            expressions.add(this.maybeTrailingComma((KtElement)indexExp, rp, i == indexExpressions.size() - 1));
        }
        JContainer args = JContainer.build((Space)Space.EMPTY, expressions, (Markers)markers);
        return new J.MethodInvocation(Tree.randomId(), this.prefix((PsiElement)expression), markers, select, null, name, args, this.methodInvocationType((PsiElement)expression));
    }

    public J visitBackingField(KtBackingField accessor, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitBinaryWithTypeRHSExpression(KtBinaryExpressionWithTypeRHS expression, ExecutionContext data) {
        IElementType type = expression.getOperationReference().getReferencedNameElementType();
        if (type == KtTokens.AS_KEYWORD || type == KtTokens.AS_SAFE) {
            TypeTree clazz = (TypeTree)Objects.requireNonNull(expression.getRight()).accept((KtVisitor)this, (Object)data);
            Markers markers = Markers.EMPTY;
            if (type == KtTokens.AS_SAFE) {
                markers = markers.addIfAbsent((Marker)new IsNullSafe(Tree.randomId(), Space.EMPTY));
            }
            return new J.TypeCast(Tree.randomId(), this.deepPrefix((PsiElement)expression), markers, new J.ControlParentheses(Tree.randomId(), this.suffix((PsiElement)expression.getLeft()), Markers.EMPTY, JRightPadded.build((Object)clazz)), (Expression)this.convertToExpression((J)expression.getLeft().accept((KtVisitor)this, (Object)data)));
        }
        throw new UnsupportedOperationException("TODO");
    }

    public J visitBlockStringTemplateEntry(KtBlockStringTemplateEntry entry, ExecutionContext data) {
        J tree = (J)Objects.requireNonNull(entry.getExpression()).accept((KtVisitor)this, (Object)data);
        boolean inBraces = true;
        return new K.KString.Value(Tree.randomId(), Space.EMPTY, Markers.EMPTY, tree, this.suffix((PsiElement)entry.getExpression()), inBraces);
    }

    public J visitBreakExpression(KtBreakExpression expression, ExecutionContext data) {
        return new J.Break(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(Objects.requireNonNull(expression.getTargetLabel().getIdentifier()), null) : null);
    }

    public J visitCallableReferenceExpression(KtCallableReferenceExpression expression, ExecutionContext data) {
        JRightPadded<J.Empty> receiver;
        FirElement firElement = this.psiElementAssociations.primary((PsiElement)expression.getCallableReference());
        if (!(firElement instanceof FirResolvedCallableReference)) {
            throw new UnsupportedOperationException(String.format("Unsupported callable reference: fir: %s, psi : %s with code: %s | sub-psi : %s | sub-fir : %s", firElement == null ? "null" : firElement.getClass().getName(), expression.getClass().getName(), expression.getText(), PsiTreePrinter.print((PsiElement)expression), PsiTreePrinter.print(this.psiElementAssociations.primary((PsiElement)expression))));
        }
        FirResolvedCallableReference reference = (FirResolvedCallableReference)this.psiElementAssociations.primary((PsiElement)expression.getCallableReference());
        JavaType.Method methodReferenceType = null;
        if (reference != null && reference.getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            methodReferenceType = this.psiElementAssociations.getTypeMapping().methodDeclarationType((FirFunction)((FirNamedFunctionSymbol)reference.getResolvedSymbol()).getFir(), expression.getReceiverExpression());
        }
        JavaType.Variable fieldReferenceType = null;
        if (reference != null && reference.getResolvedSymbol() instanceof FirPropertySymbol) {
            fieldReferenceType = this.psiElementAssociations.getTypeMapping().variableType((FirVariable)((FirPropertySymbol)reference.getResolvedSymbol()).getFir(), expression.getReceiverExpression());
        }
        if (expression.getReceiverExpression() == null) {
            receiver = this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.prefix(expression.findColonColon()));
        } else {
            Expression receiverExp = (Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data));
            if (expression.getHasQuestionMarks()) {
                PsiElement questionMark = PsiTreeUtil.findSiblingForward((PsiElement)expression.getFirstChild(), (IElementType)KtTokens.QUEST, null);
                receiverExp = (Expression)receiverExp.withMarkers(receiverExp.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), this.prefix(questionMark))));
            }
            receiver = this.padRight(receiverExp, this.prefix(expression.findColonColon()));
        }
        return new J.MemberReference(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, receiver, null, this.padLeft(this.prefix(expression.getLastChild()), (J.Identifier)((J)expression.getCallableReference().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY)), this.type((KtElement)expression.getCallableReference()), methodReferenceType, fieldReferenceType);
    }

    public J visitCatchSection(KtCatchClause catchClause, ExecutionContext data) {
        J.VariableDeclarations paramDecl = (J.VariableDeclarations)Objects.requireNonNull(catchClause.getCatchParameter()).accept((KtVisitor)this, (Object)data);
        J.Block body = (J.Block)Objects.requireNonNull(catchClause.getCatchBody()).accept((KtVisitor)this, (Object)data);
        return new J.Try.Catch(Tree.randomId(), this.deepPrefix((PsiElement)catchClause), Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), this.prefix((PsiElement)catchClause.getParameterList()), Markers.EMPTY, this.padRight(paramDecl, this.endFixAndSuffix((PsiElement)catchClause.getCatchParameter()))), body);
    }

    public J visitClassInitializer(KtClassInitializer initializer, ExecutionContext data) {
        J.Block staticInit = (J.Block)((J)Objects.requireNonNull(initializer.getBody()).accept((KtVisitor)this, (Object)data)).withPrefix(this.deepPrefix((PsiElement)initializer));
        staticInit = staticInit.getPadding().withStatic(this.padRight(true, this.prefix((PsiElement)initializer.getBody())));
        return staticInit;
    }

    public J visitClassLiteralExpression(KtClassLiteralExpression expression, ExecutionContext data) {
        return new J.MemberReference(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getReceiverExpression()).accept((KtVisitor)this, (Object)data)), this.prefix(expression.findColonColon())), null, this.padLeft(this.prefix(expression.getLastChild()), this.createIdentifier("class", Space.EMPTY, null)), this.type((KtElement)expression), null, null);
    }

    public J visitClassOrObject(KtClassOrObject classOrObject, ExecutionContext data) {
        throw new IllegalArgumentException("Unsupported declaration: " + classOrObject.getText());
    }

    public J visitCollectionLiteralExpression(KtCollectionLiteralExpression expression, ExecutionContext data) {
        JContainer elements;
        if (expression.getInnerExpressions().isEmpty()) {
            elements = JContainer.build(Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.prefix(expression.getRightBracket()))));
        } else {
            List<Object> rps = new ArrayList<JRightPadded<Expression>>(expression.getInnerExpressions().size());
            for (KtExpression ktExpression : expression.getInnerExpressions()) {
                rps.add(this.padRight((Expression)this.convertToExpression((J)ktExpression.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktExpression)));
            }
            if (expression.getTrailingComma() != null) {
                rps = ListUtils.mapLast(rps, rp -> rp.withMarkers(rp.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(expression.getTrailingComma())))));
            }
            elements = JContainer.build((Space)Space.EMPTY, rps, (Markers)Markers.EMPTY);
        }
        return new K.ListLiteral(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, (JContainer<Expression>)elements, this.type((KtElement)expression));
    }

    public J visitConstructorCalleeExpression(KtConstructorCalleeExpression constructorCalleeExpression, ExecutionContext data) {
        J j = (J)Objects.requireNonNull(constructorCalleeExpression.getTypeReference()).accept((KtVisitor)this, (Object)data);
        return j.withPrefix(KotlinTreeParserVisitor.merge(j.getPrefix(), this.deepPrefix((PsiElement)constructorCalleeExpression)));
    }

    public J visitConstructorDelegationCall(KtConstructorDelegationCall call, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitContextReceiverList(KtContextReceiverList contextReceiverList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitContinueExpression(KtContinueExpression expression, ExecutionContext data) {
        return new J.Continue(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(Objects.requireNonNull(expression.getTargetLabel().getIdentifier()), null) : null);
    }

    public J visitDeclaration(KtDeclaration dcl, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitDelegatedSuperTypeEntry(KtDelegatedSuperTypeEntry specifier, ExecutionContext data) {
        TypeTree element = (TypeTree)Objects.requireNonNull(specifier.getTypeReference()).accept((KtVisitor)this, (Object)data);
        Expression expr = (Expression)this.convertToExpression((J)Objects.requireNonNull(specifier.getDelegateExpression()).accept((KtVisitor)this, (Object)data));
        return new K.DelegatedSuperType(Tree.randomId(), Markers.EMPTY, element, this.suffix((PsiElement)specifier.getTypeReference()), expr).withPrefix(this.prefix((PsiElement)specifier));
    }

    public J visitDestructuringDeclarationEntry(KtDestructuringDeclarationEntry multiDeclarationEntry, ExecutionContext data) {
        return this.createIdentifier((PsiElement)multiDeclarationEntry, this.type((KtElement)multiDeclarationEntry)).withPrefix(this.prefix((PsiElement)multiDeclarationEntry));
    }

    public J visitDoubleColonExpression(KtDoubleColonExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitDoWhileExpression(KtDoWhileExpression expression, ExecutionContext data) {
        JRightPadded<J.Block> body;
        if (expression.getBody() != null) {
            body = JRightPadded.build((Object)((Statement)((J)Objects.requireNonNull(expression.getBody()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent()))));
        } else {
            J.Block emptyBlock = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY.add((Marker)new OmitBraces(Tree.randomId())), new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.EMPTY);
            body = this.padRight(emptyBlock, Space.EMPTY);
        }
        return new J.DoWhileLoop(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, body, this.padLeft(this.prefix(expression.getWhileKeyword()), this.mapControlParentheses(Objects.requireNonNull(expression.getCondition()), data).withPrefix(this.prefix(expression.getLeftParenthesis()))));
    }

    private J.ControlParentheses<Expression> mapControlParentheses(KtExpression expression, ExecutionContext data) {
        return new J.ControlParentheses(Tree.randomId(), this.deepPrefix(expression.getParent()), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)expression.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getParent())), this.suffix(expression.getParent())));
    }

    public J visitDynamicType(KtDynamicType type, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitEnumEntry(KtEnumEntry enumEntry, ExecutionContext data) {
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        if (!enumEntry.getAnnotationEntries().isEmpty()) {
            this.mapModifiers(enumEntry.getModifierList(), annotations, Collections.emptyList(), data);
        }
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)enumEntry);
        J.Identifier name = this.createIdentifier(Objects.requireNonNull(enumEntry.getNameIdentifier()), this.type((KtElement)enumEntry), consumedSpaces);
        J.NewClass initializer = null;
        if (enumEntry.getInitializerList() != null) {
            initializer = (J.NewClass)enumEntry.getInitializerList().accept((KtVisitor)this, (Object)data);
        }
        if (enumEntry.getBody() != null) {
            J.Block body = (J.Block)enumEntry.getBody().accept((KtVisitor)this, (Object)data);
            if (initializer != null) {
                initializer = initializer.withBody(body);
            } else {
                Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId()));
                JContainer args = JContainer.empty();
                args = args.withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
                initializer = new J.NewClass(Tree.randomId(), Space.EMPTY, markers, null, Space.EMPTY, null, args, body, null);
            }
        }
        return new J.EnumValue(Tree.randomId(), this.deepPrefix((PsiElement)enumEntry), Markers.EMPTY, annotations, name, initializer);
    }

    public J visitEscapeStringTemplateEntry(KtEscapeStringTemplateEntry entry, ExecutionContext data) {
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)entry.getText(), entry.getText(), null, JavaType.Primitive.String).withPrefix(this.deepPrefix((PsiElement)entry));
    }

    public J visitExpression(KtExpression expression, ExecutionContext data) {
        if (expression instanceof KtFunctionLiteral) {
            KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)expression;
            Markers markers = Markers.EMPTY;
            ktFunctionLiteral.getLBrace();
            List valueParameters = ktFunctionLiteral.getValueParameters();
            ArrayList<Object> valueParams = new ArrayList<Object>(valueParameters.size());
            if (!valueParameters.isEmpty()) {
                for (int i = 0; i < valueParameters.size(); ++i) {
                    KtParameter ktParameter = (KtParameter)valueParameters.get(i);
                    J expr = ((J)ktParameter.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)ktParameter));
                    valueParams.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight(expr, this.suffix((PsiElement)ktParameter)), i == valueParameters.size() - 1));
                }
            } else if (ktFunctionLiteral.getArrow() != null) {
                valueParams.add(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), Space.EMPTY));
            }
            J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), this.prefix((PsiElement)ktFunctionLiteral.getValueParameterList()), Markers.EMPTY, false, valueParams);
            J.Block body = (J.Block)Objects.requireNonNull(ktFunctionLiteral.getBodyExpression()).accept((KtVisitor)this, (Object)data);
            body = body.withEnd(this.endFixAndSuffix((PsiElement)ktFunctionLiteral.getBodyExpression()));
            return new J.Lambda(Tree.randomId(), this.deepPrefix((PsiElement)expression), markers, params, this.prefix(ktFunctionLiteral.getArrow()), (J)body, null);
        }
        throw new UnsupportedOperationException("TODO");
    }

    public J visitExpressionWithLabel(KtExpressionWithLabel expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitFileAnnotationList(KtFileAnnotationList fileAnnotationList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitFinallySection(KtFinallySection finallySection, ExecutionContext data) {
        return (J)finallySection.getFinalExpression().accept((KtVisitor)this, (Object)data);
    }

    public J visitFunctionType(KtFunctionType type, ExecutionContext data) {
        List parameters;
        List<Object> params;
        HashSet<PsiElement> consumedSpaces = new HashSet<PsiElement>();
        if (type.getParameters().isEmpty()) {
            params = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), this.prefix(Objects.requireNonNull(Objects.requireNonNull(type.getParameterList()).getNode().findChildByType((IElementType)KtTokens.RPAR)).getPsi()), Markers.EMPTY)).withAfter(Space.EMPTY));
        } else {
            params = new ArrayList();
            parameters = type.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                KtParameter ktParameter = (KtParameter)parameters.get(i);
                TypeTree typeTree = ktParameter.getNameIdentifier() != null ? new K.FunctionType.Parameter(Tree.randomId(), Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(ktParameter.getColon()))), this.createIdentifier(ktParameter.getNameIdentifier(), null), (TypeTree)Objects.requireNonNull(ktParameter.getTypeReference()).accept((KtVisitor)this, (Object)data)) : (TypeTree)Objects.requireNonNull(ktParameter.getTypeReference()).accept((KtVisitor)this, (Object)data);
                params.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight((TypeTree)typeTree.withPrefix(this.prefix((PsiElement)ktParameter)), this.endFixAndSuffix((PsiElement)ktParameter)), i == parameters.size() - 1));
            }
        }
        parameters = JContainer.build((Space)this.prefix((PsiElement)type.getParameterList()), params, (Markers)Markers.EMPTY);
        if (type.getFirstChild() == type.getParameterList()) {
            parameters = parameters.withBefore(this.prefix((PsiElement)type));
            consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)type));
        }
        return new K.FunctionType(Tree.randomId(), this.prefix((PsiElement)type, consumedSpaces), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), type.getReceiver() != null ? this.padRight((NameTree)Objects.requireNonNull(type.getReceiverTypeReference()).accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)type.getReceiver())) : null, (JContainer<TypeTree>)parameters, this.suffix((PsiElement)type.getParameterList()), this.padRight((TypedTree)Objects.requireNonNull(type.getReturnTypeReference()).accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)type)));
    }

    public J visitImportAlias(KtImportAlias importAlias, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitImportList(KtImportList importList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitInitializerList(KtInitializerList list, ExecutionContext data) {
        JContainer args;
        List entries = list.getInitializers();
        if (entries.size() > 1) {
            throw new UnsupportedOperationException("TODO");
        }
        if (!(entries.get(0) instanceof KtSuperTypeCallEntry)) {
            throw new UnsupportedOperationException("TODO");
        }
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId()));
        KtSuperTypeCallEntry superTypeCallEntry = (KtSuperTypeCallEntry)entries.get(0);
        if (!superTypeCallEntry.getValueArguments().isEmpty()) {
            args = this.mapValueArguments(superTypeCallEntry.getValueArgumentList(), data);
        } else {
            KtValueArgumentList ktArgList = superTypeCallEntry.getValueArgumentList();
            args = JContainer.build((Space)this.prefix((PsiElement)ktArgList), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), ktArgList != null ? this.prefix(ktArgList.getRightParenthesis()) : Space.EMPTY, Markers.EMPTY), Space.EMPTY)), (Markers)markers);
        }
        return new J.NewClass(Tree.randomId(), this.deepPrefix((PsiElement)list), markers, null, Space.EMPTY, null, args, null, null);
    }

    public J visitIntersectionType(KtIntersectionType definitelyNotNullType, ExecutionContext data) {
        ArrayList<JRightPadded<TypeTree>> rps = new ArrayList<JRightPadded<TypeTree>>(2);
        TypeTree left = (TypeTree)Objects.requireNonNull(definitelyNotNullType.getLeftTypeRef()).accept((KtVisitor)this, (Object)data);
        TypeTree right = (TypeTree)Objects.requireNonNull(definitelyNotNullType.getRightTypeRef()).accept((KtVisitor)this, (Object)data);
        rps.add(this.padRight(left, this.suffix((PsiElement)definitelyNotNullType.getLeftTypeRef())));
        rps.add(this.padRight(right, Space.EMPTY));
        JContainer bounds = JContainer.build((Space)Space.EMPTY, rps, (Markers)Markers.EMPTY);
        return new J.IntersectionType(Tree.randomId(), this.prefix((PsiElement)definitelyNotNullType), Markers.EMPTY, bounds);
    }

    public J visitIsExpression(KtIsExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        Expression element = (Expression)this.convertToExpression((J)expression.getLeftHandSide().accept((KtVisitor)this, (Object)data));
        if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IS) {
            markers = markers.addIfAbsent((Marker)new NotIs(Tree.randomId()));
        }
        J clazz = (J)Objects.requireNonNull(expression.getTypeReference()).accept((KtVisitor)this, (Object)data);
        return new J.InstanceOf(Tree.randomId(), this.deepPrefix((PsiElement)expression), markers, this.padRight(element, this.prefix((PsiElement)expression.getOperationReference())), clazz, null, this.type((KtElement)expression));
    }

    public J visitLabeledExpression(KtLabeledExpression expression, ExecutionContext data) {
        J j = (J)Objects.requireNonNull(expression.getBaseExpression()).accept((KtVisitor)this, (Object)data);
        return new J.Label(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padRight(this.createIdentifier(Objects.requireNonNull(expression.getNameIdentifier()), null), this.suffix(expression.getNameIdentifier())), this.convertToStatement(j));
    }

    public J visitLambdaExpression(KtLambdaExpression expression, ExecutionContext data) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        return ((J)functionLiteral.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression));
    }

    public J visitLiteralStringTemplateEntry(KtLiteralStringTemplateEntry entry, ExecutionContext data) {
        if (!(entry.getFirstChild() instanceof LeafPsiElement)) {
            throw new UnsupportedOperationException("Unsupported KtStringTemplateEntry child");
        }
        String value = this.maybeAdjustCRLF((PsiElement)entry);
        boolean quoted = entry.getPrevSibling().getNode().getElementType() == KtTokens.OPEN_QUOTE && entry.getNextSibling().getNode().getElementType() == KtTokens.CLOSING_QUOTE;
        String valueSource = quoted ? "\"" + value + "\"" : value;
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)value, valueSource, null, JavaType.Primitive.String);
    }

    public J visitLoopExpression(KtLoopExpression loopExpression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitModifierList(KtModifierList list, ExecutionContext data) {
        throw new UnsupportedOperationException("Use mapModifiers instead");
    }

    public J visitNamedDeclaration(KtNamedDeclaration declaration, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitNullableType(KtNullableType nullableType, ExecutionContext data) {
        TypeTree typeTree = (TypeTree)Objects.requireNonNull(nullableType.getInnerType()).accept((KtVisitor)this, (Object)data);
        if (typeTree instanceof K.FunctionType && nullableType.getModifierList() != null) {
            List<Object> leadingAnnotations = new ArrayList<J.Annotation>();
            List modifiers = this.mapModifiers(nullableType.getModifierList(), leadingAnnotations, Collections.emptyList(), data);
            if (!leadingAnnotations.isEmpty()) {
                leadingAnnotations = ListUtils.mapFirst(leadingAnnotations, anno -> anno.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)nullableType.getModifierList()), anno.getPrefix())));
            } else if (!modifiers.isEmpty()) {
                modifiers = ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)nullableType.getModifierList()), mod.getPrefix())));
            }
            typeTree = ((K.FunctionType)typeTree).withModifiers(modifiers).withLeadingAnnotations(leadingAnnotations);
        }
        return (J)typeTree.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)nullableType), typeTree.getPrefix())).withMarkers(typeTree.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), this.prefix((PsiElement)nullableType.getQuestionMarkNode()))));
    }

    public J visitParameter(KtParameter parameter, ExecutionContext data) {
        int modifierOffset;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        TypeTree typeExpression = null;
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)parameter);
        if (!parameter.getAnnotations().isEmpty()) {
            throw new UnsupportedOperationException("TODO");
        }
        int valOrVarOffset = parameter.getValOrVarKeyword() != null ? parameter.getValOrVarKeyword().getTextOffset() : -1;
        int n = modifierOffset = parameter.getModifierList() != null ? parameter.getModifierList().getTextOffset() : -1;
        if (valOrVarOffset < modifierOffset) {
            if (parameter.getValOrVarKeyword() != null) {
                modifiers.add(this.mapModifier(parameter.getValOrVarKeyword(), Collections.emptyList(), consumedSpaces));
            }
            if (parameter.getModifierList() != null) {
                modifiers.addAll(this.mapModifiers(parameter.getModifierList(), leadingAnnotations, lastAnnotations, data));
            }
        } else {
            if (parameter.getModifierList() != null) {
                modifiers.addAll(this.mapModifiers(parameter.getModifierList(), leadingAnnotations, lastAnnotations, data));
            }
            if (parameter.getValOrVarKeyword() != null) {
                modifiers.add(this.mapModifier(parameter.getValOrVarKeyword(), Collections.emptyList(), consumedSpaces));
            }
        }
        if (parameter.getDestructuringDeclaration() != null) {
            return this.mapDestructuringDeclaration(parameter.getDestructuringDeclaration(), data).withPrefix(this.prefix((PsiElement)parameter));
        }
        JavaType.Variable vt = this.variableType((PsiElement)parameter, this.owner((PsiElement)parameter));
        J.Identifier name = this.createIdentifier(Objects.requireNonNull(parameter.getNameIdentifier()), (JavaType)vt, consumedSpaces);
        if (parameter.getTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(parameter.getColon())));
            typeExpression = (TypeTree)parameter.getTypeReference().accept((KtVisitor)this, (Object)data);
        }
        JLeftPadded<Expression> initializer = parameter.getDefaultValue() != null ? this.padLeft(this.prefix(parameter.getEqualsToken()), (Expression)this.convertToExpression((J)parameter.getDefaultValue().accept((KtVisitor)this, (Object)data))) : null;
        J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), initializer, vt);
        vars.add(this.padRight(namedVariable, Space.EMPTY));
        return new J.VariableDeclarations(Tree.randomId(), this.deepPrefix((PsiElement)parameter), markers, leadingAnnotations, modifiers, typeExpression, null, Collections.emptyList(), vars);
    }

    public J visitParameterList(KtParameterList list, ExecutionContext data) {
        throw new UnsupportedOperationException("Unsupported, use mapParameters() instead");
    }

    public J visitPrimaryConstructor(KtPrimaryConstructor constructor, ExecutionContext data) {
        if (constructor.getBodyExpression() != null) {
            throw new UnsupportedOperationException("TODO");
        }
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)constructor);
        if (constructor.getModifierList() != null) {
            KtModifierList ktModifierList = constructor.getModifierList();
            modifiers.addAll(this.mapModifiers(ktModifierList, leadingAnnotations, Collections.emptyList(), data));
        }
        if (constructor.getConstructorKeyword() != null) {
            modifiers.add(this.mapModifier(constructor.getConstructorKeyword(), Collections.emptyList(), consumedSpaces));
        }
        JavaType.Method type = this.methodDeclarationType((PsiElement)constructor);
        J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "<constructor>", (JavaType)type, null);
        if (constructor.getValueParameterList() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        JContainer params = JContainer.build((Space)this.prefix((PsiElement)constructor.getValueParameterList(), KotlinTreeParserVisitor.preConsumedInfix((PsiElement)constructor)), this.mapParameters(constructor.getValueParameterList(), data), (Markers)Markers.EMPTY);
        return new J.MethodDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)constructor), Markers.build(Collections.singletonList(new PrimaryConstructor(Tree.randomId()))), leadingAnnotations, modifiers, null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name.withMarkers(name.getMarkers().addIfAbsent((Marker)new Implicit(Tree.randomId()))), Collections.emptyList()), params, null, null, null, type);
    }

    public J visitPropertyAccessor(KtPropertyAccessor accessor, ExecutionContext data) {
        JContainer params;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(accessor.getModifierList(), leadingAnnotations, Collections.emptyList(), data);
        TypeTree returnTypeExpression = null;
        ArrayList lastAnnotations = new ArrayList();
        J.Block body = null;
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)accessor);
        JavaType.Method type = this.methodDeclarationType((PsiElement)accessor);
        J.Identifier name = this.createIdentifier(accessor.getNamePlaceholder().getText(), this.prefix(accessor.getNamePlaceholder(), consumedSpaces), (JavaType)type);
        List ktParameters = accessor.getValueParameters();
        if (!ktParameters.isEmpty()) {
            if (ktParameters.size() != 1) {
                throw new UnsupportedOperationException("TODO");
            }
            ArrayList<JRightPadded<Statement>> parameters = new ArrayList<JRightPadded<Statement>>();
            for (KtParameter ktParameter : ktParameters) {
                Statement stmt = this.convertToStatement(((J)ktParameter.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(ktParameter.getParent())));
                parameters.add(this.padRight(stmt, this.prefix(accessor.getRightParenthesis())));
            }
            params = JContainer.build((Space)this.prefix(accessor.getLeftParenthesis()), parameters, (Markers)Markers.EMPTY);
        } else {
            params = JContainer.build((Space)this.prefix(accessor.getLeftParenthesis()), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(accessor.getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        }
        if (accessor.getReturnTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.suffix(accessor.getRightParenthesis())));
            returnTypeExpression = (TypeTree)((J)accessor.getReturnTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)accessor.getReturnTypeReference()));
        }
        if (accessor.getBodyBlockExpression() != null) {
            body = (J.Block)((J)accessor.getBodyBlockExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)accessor.getBodyBlockExpression()));
        } else if (accessor.getBodyExpression() != null) {
            body = this.convertToBlock(accessor.getBodyExpression(), data).withPrefix(this.prefix(accessor.getEqualsToken()));
        } else {
            params = JContainer.empty();
            params = params.withBefore(Space.EMPTY).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
        }
        return new J.MethodDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)accessor), markers, leadingAnnotations, modifiers, null, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, lastAnnotations), params, null, body, null, type);
    }

    public J visitQualifiedExpression(KtQualifiedExpression expression, ExecutionContext data) {
        Expression receiver = (Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data));
        Expression selector = (Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getSelectorExpression()).accept((KtVisitor)this, (Object)data));
        if (selector instanceof J.MethodInvocation) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)selector;
            return methodInvocation.getPadding().withSelect(this.padRight(receiver, this.suffix((PsiElement)expression.getReceiverExpression()))).withName(methodInvocation.getName().withPrefix(this.prefix((PsiElement)expression.getSelectorExpression()))).withPrefix(this.endFixPrefixAndInfix((PsiElement)expression));
        }
        J.Identifier identifier = (J.Identifier)selector;
        return new J.FieldAccess(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, receiver, this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), identifier), this.type((KtElement)expression));
    }

    public J visitReferenceExpression(KtReferenceExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitReturnExpression(KtReturnExpression expression, ExecutionContext data) {
        KtExpression returnedExpression = expression.getReturnedExpression();
        Expression returnExpr = returnedExpression != null ? (Expression)this.convertToExpression(((J)returnedExpression.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)returnedExpression))) : null;
        return new K.KReturn(Tree.randomId(), new J.Return(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, returnExpr), expression.getTargetLabel() != null ? this.createIdentifier(Objects.requireNonNull(expression.getTargetLabel().getIdentifier()), null) : null);
    }

    public J visitSafeQualifiedExpression(KtSafeQualifiedExpression expression, ExecutionContext data) {
        J j = this.visitQualifiedExpression((KtQualifiedExpression)expression, data);
        return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new IsNullSafe(Tree.randomId(), Space.EMPTY)));
    }

    public J visitScript(KtScript script, ExecutionContext data) {
        return (J)script.getBlockExpression().accept((KtVisitor)this, (Object)data);
    }

    public J visitScriptInitializer(KtScriptInitializer initializer, ExecutionContext data) {
        J j = (J)Objects.requireNonNull(initializer.getBody()).accept((KtVisitor)this, (Object)data);
        return j.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)initializer), j.getPrefix()));
    }

    public J visitSecondaryConstructor(KtSecondaryConstructor constructor, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(constructor.getModifierList(), leadingAnnotations, lastAnnotations, data);
        modifiers.add(this.mapModifier(constructor.getConstructorKeyword(), Collections.emptyList(), KotlinTreeParserVisitor.preConsumedInfix((PsiElement)constructor)));
        JavaType.Method type = this.methodDeclarationType((PsiElement)constructor);
        J.Identifier name = this.createIdentifier(Objects.requireNonNull(constructor.getName()), this.prefix(constructor.getConstructorKeyword()), (JavaType)type).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
        List<JRightPadded<Statement>> statements = this.mapParameters(constructor.getValueParameterList(), data);
        JContainer params = JContainer.build((Space)this.prefix((PsiElement)constructor.getValueParameterList()), statements, (Markers)Markers.EMPTY);
        K.ConstructorInvocation delegationCall = constructor.getDelegationCall().isImplicit() ? null : new K.ConstructorInvocation(Tree.randomId(), this.prefix((PsiElement)constructor.getDelegationCall()), Markers.EMPTY, (TypeTree)this.createIdentifier((PsiElement)Objects.requireNonNull(constructor.getDelegationCall().getCalleeExpression()), this.type((KtElement)constructor.getDelegationCall().getCalleeExpression())), this.mapValueArguments(constructor.getDelegationCall().getValueArgumentList(), data));
        J.Block body = null;
        if (constructor.getBodyExpression() != null) {
            body = (J.Block)constructor.getBodyExpression().accept((KtVisitor)this, (Object)data);
        }
        J.MethodDeclaration methodDeclaration = new J.MethodDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)constructor), markers, leadingAnnotations, modifiers, null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, type);
        return delegationCall != null ? new K.Constructor(Tree.randomId(), Markers.EMPTY, methodDeclaration, this.prefix(constructor.getColon()), delegationCall) : methodDeclaration;
    }

    public J visitSelfType(KtSelfType type, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitSimpleNameStringTemplateEntry(KtSimpleNameStringTemplateEntry entry, ExecutionContext data) {
        return new K.KString.Value(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (J)Objects.requireNonNull(entry.getExpression()).accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)entry.getExpression()), false);
    }

    public J visitStringTemplateEntryWithExpression(KtStringTemplateEntryWithExpression entry, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitSuperExpression(KtSuperExpression expression, ExecutionContext data) {
        return this.createIdentifier((PsiElement)expression, this.type((KtElement)expression)).withPrefix(this.prefix((PsiElement)expression));
    }

    public J visitSuperTypeEntry(KtSuperTypeEntry specifier, ExecutionContext data) {
        J j = (J)Objects.requireNonNull(specifier.getTypeReference()).accept((KtVisitor)this, (Object)data);
        return j.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)specifier), j.getPrefix()));
    }

    public J visitSuperTypeListEntry(KtSuperTypeListEntry specifier, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitThisExpression(KtThisExpression expression, ExecutionContext data) {
        return new K.KThis(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(Objects.requireNonNull(expression.getTargetLabel().getIdentifier()), null) : null, this.type((KtElement)expression));
    }

    public J visitThrowExpression(KtThrowExpression expression, ExecutionContext data) {
        return new J.Throw(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getThrownExpression()).accept((KtVisitor)this, (Object)data)));
    }

    public J visitTryExpression(KtTryExpression expression, ExecutionContext data) {
        List ktCatchClauses = expression.getCatchClauses();
        J.Block block = (J.Block)expression.getTryBlock().accept((KtVisitor)this, (Object)data);
        ArrayList<J.Try.Catch> catches = new ArrayList<J.Try.Catch>(ktCatchClauses.size());
        JLeftPadded<J.Block> finallyBlock = null;
        for (KtCatchClause catchClause : ktCatchClauses) {
            catches.add((J.Try.Catch)catchClause.accept((KtVisitor)this, (Object)data));
        }
        if (expression.getFinallyBlock() != null) {
            finallyBlock = this.padLeft(this.prefix((PsiElement)expression.getFinallyBlock()), (J.Block)expression.getFinallyBlock().accept((KtVisitor)this, (Object)data));
        }
        return new J.Try(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, null, block, catches, finallyBlock);
    }

    public J visitTypeAlias(KtTypeAlias typeAlias, ExecutionContext data) {
        J.Identifier name;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)typeAlias);
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>(this.mapModifiers(typeAlias.getModifierList(), leadingAnnotations, lastAnnotations, data));
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(typeAlias.getTypeAliasKeyword(), consumedSpaces), markers, "typealias", J.Modifier.Type.LanguageExtension, Collections.emptyList()));
        if (typeAlias.getIdentifyingElement() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        J.Identifier typeExpression = name = this.createIdentifier(typeAlias.getIdentifyingElement(), this.type((KtElement)typeAlias.getTypeReference()));
        if (typeAlias.getTypeParameterList() != null && (typeExpression = (TypeTree)typeAlias.getTypeParameterList().accept((KtVisitor)this, (Object)data)) instanceof J.ParameterizedType) {
            Space prefix = name.getPrefix();
            typeExpression = ((J.ParameterizedType)typeExpression).withClazz((NameTree)name.withPrefix(Space.EMPTY).withPrefix(prefix));
        }
        Expression expr = (Expression)this.convertToExpression((J)typeAlias.getTypeReference().accept((KtVisitor)this, (Object)data));
        ASTNode node = typeAlias.getNode().findChildByType((IElementType)KtTokens.EQ);
        Space prefix = node != null ? this.prefix(node.getPsi()) : Space.EMPTY;
        JRightPadded<J.VariableDeclarations.NamedVariable> namedVariable = this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.createIdentifier("", Space.EMPTY, null, null), Collections.emptyList(), this.padLeft(prefix, expr), null), Space.EMPTY);
        List<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = Collections.singletonList(namedVariable);
        return new J.VariableDeclarations(Tree.randomId(), this.deepPrefix((PsiElement)typeAlias), markers, leadingAnnotations, modifiers, (TypeTree)typeExpression, null, Collections.emptyList(), vars);
    }

    public J visitTypeArgumentList(KtTypeArgumentList typeArgumentList, ExecutionContext data) {
        throw new UnsupportedOperationException("use mapTypeArguments instead");
    }

    public J visitTypeConstraint(KtTypeConstraint constraint, ExecutionContext data) {
        ArrayList annotations = new ArrayList();
        J.Identifier typeParamName = (J.Identifier)Objects.requireNonNull(constraint.getSubjectTypeParameterName()).accept((KtVisitor)this, (Object)data);
        PsiElement ref = PsiTreeUtil.getChildOfType((PsiElement)constraint, KtTypeReference.class);
        typeParamName = typeParamName.withType(this.psiElementAssociations.type(ref, this.owner((PsiElement)constraint)));
        TypeTree typeTree = (TypeTree)Objects.requireNonNull(constraint.getBoundTypeReference()).accept((KtVisitor)this, (Object)data);
        return new J.TypeParameter(Tree.randomId(), this.deepPrefix((PsiElement)constraint), Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.suffix((PsiElement)constraint.getSubjectTypeParameterName()))), annotations, Collections.emptyList(), (Expression)typeParamName, JContainer.build((Space)Space.EMPTY, Collections.singletonList(this.padRight(typeTree, null)), (Markers)Markers.EMPTY));
    }

    public J visitTypeConstraintList(KtTypeConstraintList list, ExecutionContext data) {
        List ktTypeConstraints = list.getConstraints();
        ArrayList<JRightPadded<J.TypeParameter>> params = new ArrayList<JRightPadded<J.TypeParameter>>(ktTypeConstraints.size());
        for (KtTypeConstraint ktTypeConstraint : ktTypeConstraints) {
            params.add(this.padRight((J.TypeParameter)ktTypeConstraint.accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)ktTypeConstraint)));
        }
        return new K.TypeConstraints(Tree.randomId(), Markers.EMPTY, (JContainer<J.TypeParameter>)JContainer.build((Space)this.deepPrefix((PsiElement)list), params, (Markers)Markers.EMPTY));
    }

    public J visitTypeParameter(KtTypeParameter parameter, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        JContainer bounds = null;
        if (parameter.getNameIdentifier() == null) {
            throw new UnsupportedOperationException("This should never happen");
        }
        if (parameter.getExtendsBound() != null) {
            bounds = JContainer.build((Space)this.suffix(parameter.getNameIdentifier()), Collections.singletonList(this.padRight((TypeTree)parameter.getExtendsBound().accept((KtVisitor)this, (Object)data), Space.EMPTY)), (Markers)Markers.EMPTY);
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), Space.EMPTY));
        }
        return new J.TypeParameter(Tree.randomId(), this.deepPrefix((PsiElement)parameter), markers, annotations, this.mapModifiers(parameter.getModifierList(), annotations, Collections.emptyList(), data), (Expression)this.createIdentifier(parameter.getNameIdentifier(), this.type((KtElement)parameter)), bounds);
    }

    public J visitTypeParameterList(KtTypeParameterList list, ExecutionContext data) {
        List ktTypeParameters = list.getParameters();
        ArrayList<JRightPadded<J.Identifier>> expressions = new ArrayList<JRightPadded<J.Identifier>>(ktTypeParameters.size());
        for (KtTypeParameter ktTypeParameter : ktTypeParameters) {
            J.Identifier name = this.createIdentifier((PsiElement)ktTypeParameter, this.type((KtElement)ktTypeParameter));
            expressions.add(this.padRight(name, this.suffix((PsiElement)ktTypeParameter)));
        }
        JContainer typeParameters = JContainer.build((Space)this.deepPrefix((PsiElement)list), expressions, (Markers)Markers.EMPTY);
        return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, typeParameters, null);
    }

    public J visitTypeProjection(KtTypeProjection typeProjection, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        JContainer bounds = null;
        Object name = null;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(typeProjection.getModifierList(), leadingAnnotations, Collections.emptyList(), data);
        switch (typeProjection.getProjectionKind()) {
            case IN: 
            case OUT: {
                bounds = JContainer.build((Space)this.prefix(typeProjection.getProjectionToken()), Collections.singletonList(this.padRight((TypeTree)((J)Objects.requireNonNull(typeProjection.getTypeReference()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)typeProjection.getTypeReference())), Space.EMPTY)), (Markers)Markers.EMPTY);
                break;
            }
            case STAR: {
                return new J.Wildcard(Tree.randomId(), this.prefix((PsiElement)typeProjection), Markers.EMPTY, null, null);
            }
            default: {
                name = (Expression)this.convertToExpression((J)Objects.requireNonNull(typeProjection.getTypeReference()).accept((KtVisitor)this, (Object)data));
                Space prefix = this.deepPrefix((PsiElement)typeProjection);
                name = name instanceof J.Identifier ? KotlinTreeParserVisitor.addPrefixInFront((J.Identifier)name, prefix) : (Expression)name.withPrefix(KotlinTreeParserVisitor.merge(prefix, name.getPrefix()));
            }
        }
        if (name != null) {
            return name;
        }
        return new K.TypeParameterExpression(Tree.randomId(), new J.TypeParameter(Tree.randomId(), this.deepPrefix((PsiElement)typeProjection), markers, leadingAnnotations, modifiers, (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(new Implicit(Tree.randomId()))), Collections.emptyList(), "Any", null, null), bounds));
    }

    public J visitUnaryExpression(KtUnaryExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitWhenConditionInRange(KtWhenConditionInRange condition, ExecutionContext data) {
        K.Binary.Type operator = condition.isNegated() ? K.Binary.Type.NotContains : K.Binary.Type.Contains;
        J.Empty left = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        return new K.Binary(Tree.randomId(), this.deepPrefix((PsiElement)condition), Markers.EMPTY, (Expression)left, this.padLeft(Space.EMPTY, operator), (Expression)this.convertToExpression((J)Objects.requireNonNull(condition.getRangeExpression()).accept((KtVisitor)this, (Object)data)), Space.EMPTY, this.type((KtElement)condition));
    }

    public J visitWhenConditionIsPattern(KtWhenConditionIsPattern condition, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        if (condition.isNegated()) {
            markers = markers.addIfAbsent((Marker)new NotIs(Tree.randomId()));
        }
        J.Empty element = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        JRightPadded<J.Empty> expr = this.padRight(element, Space.EMPTY);
        J clazz = (J)Objects.requireNonNull(condition.getTypeReference()).accept((KtVisitor)this, (Object)data);
        return new J.InstanceOf(Tree.randomId(), this.deepPrefix((PsiElement)condition), markers, expr, clazz, null, this.type((KtElement)condition));
    }

    public J visitWhenConditionWithExpression(KtWhenConditionWithExpression condition, ExecutionContext data) {
        return ((J)Objects.requireNonNull(condition.getExpression()).accept((KtVisitor)this, (Object)data)).withPrefix(this.deepPrefix((PsiElement)condition));
    }

    public J visitWhenEntry(KtWhenEntry ktWhenEntry, ExecutionContext data) {
        ArrayList<Object> expressions = new ArrayList<Object>(1);
        if (ktWhenEntry.getElseKeyword() != null) {
            expressions.add(this.padRight(this.createIdentifier("else", Space.EMPTY, null, null), this.prefix(ktWhenEntry.getArrow())));
        } else {
            KtWhenCondition[] ktWhenConditions = ktWhenEntry.getConditions();
            for (int i = 0; i < ktWhenConditions.length; ++i) {
                KtWhenCondition ktWhenCondition = ktWhenConditions[i];
                Expression expr = (Expression)this.convertToExpression((J)ktWhenCondition.accept((KtVisitor)this, (Object)data));
                expressions.add(this.maybeTrailingComma((KtElement)ktWhenCondition, this.padRight(expr, this.suffix((PsiElement)ktWhenCondition)), i == ktWhenConditions.length - 1));
            }
        }
        JContainer expressionContainer = JContainer.build((Space)Space.EMPTY, expressions, (Markers)Markers.EMPTY);
        J body = (J)Objects.requireNonNull(ktWhenEntry.getExpression()).accept((KtVisitor)this, (Object)data);
        return new K.WhenBranch(Tree.randomId(), this.deepPrefix((PsiElement)ktWhenEntry), Markers.EMPTY, (JContainer<Expression>)expressionContainer, this.padRight(body, Space.EMPTY));
    }

    @NotNull
    private <T> JRightPadded<T> maybeTrailingComma(KtElement element, JRightPadded<T> padded, boolean last) {
        if (!last) {
            return padded;
        }
        PsiElement maybeComma = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)KtTokens.COMMA, null);
        if (maybeComma != null && maybeComma.getNode().getElementType() == KtTokens.COMMA) {
            padded = padded.withMarkers(padded.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(maybeComma))));
        }
        return padded;
    }

    public J visitWhenExpression(KtWhenExpression expression, ExecutionContext data) {
        J.ControlParentheses controlParentheses = null;
        if (expression.getSubjectExpression() != null) {
            J subject = (J)expression.getSubjectExpression().accept((KtVisitor)this, (Object)data);
            controlParentheses = new J.ControlParentheses(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight(subject, this.prefix(expression.getRightParenthesis())));
        }
        List whenEntries = expression.getEntries();
        ArrayList<JRightPadded<K.WhenBranch>> statements = new ArrayList<JRightPadded<K.WhenBranch>>(whenEntries.size());
        for (KtWhenEntry whenEntry : whenEntries) {
            K.WhenBranch whenBranch = (K.WhenBranch)whenEntry.accept((KtVisitor)this, (Object)data);
            statements.add(this.maybeTrailingSemicolon(whenBranch, (KtElement)whenEntry));
        }
        J.Block body = new J.Block(Tree.randomId(), this.prefix(expression.getOpenBrace()), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), statements, this.prefix(expression.getCloseBrace()));
        return new K.When(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, (J.ControlParentheses<J>)controlParentheses, body, this.type((KtElement)expression));
    }

    public J visitWhileExpression(KtWhileExpression expression, ExecutionContext data) {
        return new J.WhileLoop(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.mapControlParentheses(Objects.requireNonNull(expression.getCondition()), data).withPrefix(this.prefix(expression.getLeftParenthesis())), JRightPadded.build((Object)((Statement)((J)Objects.requireNonNull(expression.getBody()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent())))));
    }

    public void visitBinaryFile(PsiBinaryFile file) {
        throw new UnsupportedOperationException("TODO");
    }

    public void visitComment(PsiComment comment) {
        throw new UnsupportedOperationException("TODO");
    }

    public void visitDirectory(PsiDirectory dir) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitKtElement(KtElement element, ExecutionContext data) {
        throw new UnsupportedOperationException("Should never call this, if this is called, means something wrong");
    }

    public J visitKtFile(KtFile file, ExecutionContext data) {
        List<J.Annotation> annotations = file.getFileAnnotationList() != null ? this.mapAnnotations(file.getAnnotationEntries(), data) : Collections.emptyList();
        HashSet<PsiElement> consumedSpaces = new HashSet<PsiElement>();
        Space eof = this.endFixAndSuffix((PsiElement)file);
        JRightPadded<J.Package> pkg = null;
        if (!file.getPackageFqName().isRoot()) {
            pkg = this.maybeTrailingSemicolon((J.Package)Objects.requireNonNull(file.getPackageDirective()).accept((KtVisitor)this, (Object)data), (KtElement)file.getPackageDirective());
            consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)file.getPackageDirective()));
        }
        ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(file.getImportDirectives().size());
        if (!file.getImportDirectives().isEmpty()) {
            List importDirectives = file.getImportDirectives();
            for (int i = 0; i < importDirectives.size(); ++i) {
                KtImportDirective importDirective = (KtImportDirective)importDirectives.get(i);
                J.Import anImport = (J.Import)importDirective.accept((KtVisitor)this, (Object)data);
                if (i == 0) {
                    anImport = anImport.withPrefix(KotlinTreeParserVisitor.merge(this.prefix((PsiElement)file.getImportList()), anImport.getPrefix()));
                }
                imports.add(this.maybeTrailingSemicolon(anImport, (KtElement)importDirective));
            }
        }
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(file.getDeclarations().size());
        List declarations = file.getDeclarations();
        for (KtDeclaration declaration : declarations) {
            Statement statement;
            try {
                statement = this.convertToStatement((J)declaration.accept((KtVisitor)this, (Object)data));
            }
            catch (Exception e) {
                statement = new J.Unknown(Tree.randomId(), this.deepPrefix((PsiElement)declaration), Markers.EMPTY, new J.Unknown.Source(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(ParseExceptionResult.build((Parser)KotlinParser.builder().build(), (Throwable)e).withTreeType(declaration.getClass().getName()))), file.getText().substring(PsiUtilsKt.getStartOffsetSkippingComments((PsiElement)declaration), declaration.getTextRange().getEndOffset())));
            }
            if (declaration instanceof KtProperty) {
                statements.add(this.maybeFollowingSemicolon(statement, (KtElement)declaration));
                continue;
            }
            statements.add(this.maybeTrailingSemicolon(statement, (KtElement)declaration));
        }
        return new K.CompilationUnit(Tree.randomId(), this.prefixAndInfix((PsiElement)file, consumedSpaces), Markers.build(this.styles), this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, annotations, pkg, imports, statements, eof);
    }

    public J visitAnnotation(KtAnnotation annotation, ExecutionContext data) {
        Space beforeLBracket;
        if (annotation.getUseSiteTarget() == null) {
            throw new UnsupportedOperationException("TODO, Some cases we don't know");
        }
        List annotationEntries = annotation.getEntries();
        List<Object> rpAnnotations = new ArrayList<JRightPadded<J.Annotation>>(annotationEntries.size());
        for (KtAnnotationEntry ktAnnotationEntry : annotationEntries) {
            J.Annotation anno2 = (J.Annotation)ktAnnotationEntry.accept((KtVisitor)this, (Object)data);
            anno2 = anno2.withMarkers(anno2.getMarkers().addIfAbsent((Marker)new AnnotationConstructor(Tree.randomId())));
            rpAnnotations.add(this.padRight(anno2, Space.EMPTY));
        }
        PsiElement maybeLBracket = KotlinTreeParserVisitor.findFirstChild((PsiElement)annotation, anno -> anno.getNode().getElementType() == KtTokens.LBRACKET);
        boolean isImplicitBracket = maybeLBracket == null;
        Space space = beforeLBracket = isImplicitBracket ? Space.EMPTY : this.prefix(maybeLBracket);
        if (!isImplicitBracket) {
            rpAnnotations = ListUtils.mapLast(rpAnnotations, rp -> rp.withAfter(this.prefix(KotlinTreeParserVisitor.findFirstChild((PsiElement)annotation, anno -> anno.getNode().getElementType() == KtTokens.RBRACKET))));
        }
        return new J.Annotation(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new AnnotationUseSite(Tree.randomId(), this.suffix((PsiElement)annotation.getUseSiteTarget()), isImplicitBracket)), (NameTree)annotation.getUseSiteTarget().accept((KtVisitor)this, (Object)data), JContainer.build((Space)beforeLBracket, rpAnnotations, (Markers)Markers.EMPTY));
    }

    public J visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, ExecutionContext data) {
        NameTree nameTree;
        boolean isUseSite;
        Markers markers = Markers.EMPTY;
        JContainer args = null;
        boolean bl = isUseSite = annotationEntry.getUseSiteTarget() != null;
        if (isUseSite) {
            boolean bl2 = isUseSite = KotlinTreeParserVisitor.findFirstChild((PsiElement)annotationEntry, c -> c == annotationEntry.getUseSiteTarget()) != null;
        }
        if (isUseSite) {
            nameTree = (NameTree)annotationEntry.getUseSiteTarget().accept((KtVisitor)this, (Object)data);
            markers = markers.addIfAbsent((Marker)new AnnotationUseSite(Tree.randomId(), this.prefix(KotlinTreeParserVisitor.findFirstChild((PsiElement)annotationEntry, p -> p.getNode().getElementType() == KtTokens.COLON)), true));
            J.Annotation argAnno = new J.Annotation(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new AnnotationConstructor(Tree.randomId())), (NameTree)Objects.requireNonNull(annotationEntry.getCalleeExpression()).accept((KtVisitor)this, (Object)data), annotationEntry.getValueArgumentList() != null ? this.mapValueArguments(annotationEntry.getValueArgumentList(), data) : null);
            args = JContainer.build((Space)Space.EMPTY, Collections.singletonList(this.padRight(argAnno, Space.EMPTY)), (Markers)Markers.EMPTY);
        } else {
            nameTree = (NameTree)Objects.requireNonNull(annotationEntry.getCalleeExpression()).accept((KtVisitor)this, (Object)data);
            if (annotationEntry.getValueArgumentList() != null) {
                args = this.mapValueArguments(annotationEntry.getValueArgumentList(), data);
            }
        }
        return this.mapType(new J.Annotation(Tree.randomId(), this.deepPrefix((PsiElement)annotationEntry), markers, nameTree, args));
    }

    public J visitArgument(KtValueArgument argument, ExecutionContext data) {
        if (argument.getArgumentExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        if (argument.isNamed()) {
            J.Identifier name = this.createIdentifier((PsiElement)Objects.requireNonNull(argument.getArgumentName()), this.type((KtElement)argument.getArgumentName()));
            Expression expr = (Expression)this.convertToExpression((J)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data));
            if (argument.isSpread()) {
                expr = new K.SpreadArgument(Tree.randomId(), this.prefix(KotlinTreeParserVisitor.findFirstChild((PsiElement)argument, c -> c.getNode().getElementType() == KtTokens.MUL)), Markers.EMPTY, expr);
            }
            return new J.Assignment(Tree.randomId(), this.deepPrefix((PsiElement)argument), Markers.EMPTY, (Expression)name, this.padLeft(this.suffix((PsiElement)argument.getArgumentName()), expr), this.type((KtElement)argument.getArgumentExpression()));
        }
        if (argument.isSpread()) {
            Expression j = (Expression)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data);
            return new K.SpreadArgument(Tree.randomId(), this.deepPrefix((PsiElement)argument), Markers.EMPTY, j);
        }
        J j = ((J)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.deepPrefix((PsiElement)argument));
        return argument instanceof KtLambdaArgument ? (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new TrailingLambdaArgument(Tree.randomId()))) : j;
    }

    public J visitBinaryExpression(KtBinaryExpression expression, ExecutionContext data) {
        assert (expression.getLeft() != null);
        assert (expression.getRight() != null);
        KtOperationReferenceExpression operationReference = expression.getOperationReference();
        J.Binary.Type javaBinaryType = this.mapJBinaryType(operationReference);
        J.AssignmentOperation.Type assignmentOperationType = javaBinaryType == null ? this.mapAssignmentOperationType(operationReference) : null;
        K.Binary.Type kotlinBinaryType = javaBinaryType == null && assignmentOperationType == null ? this.mapKBinaryType(operationReference) : null;
        Expression left = (Expression)this.convertToExpression((J)expression.getLeft().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
        Expression right = (Expression)this.convertToExpression((J)expression.getRight().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getRight()));
        JavaType type = this.type((KtElement)expression);
        if (javaBinaryType != null) {
            return new J.Binary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), javaBinaryType), right, type);
        }
        if (operationReference.getOperationSignTokenType() == KtTokens.EQ) {
            return new J.Assignment(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.suffix((PsiElement)expression.getLeft()), right), type);
        }
        if (assignmentOperationType != null) {
            return new J.AssignmentOperation(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), assignmentOperationType), right, type);
        }
        if (kotlinBinaryType != null) {
            return new K.Binary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), kotlinBinaryType), right, Space.EMPTY, type);
        }
        return this.mapFunctionCall(expression, data);
    }

    @Nullable
    private J.AssignmentOperation.Type mapAssignmentOperationType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == KtTokens.PLUSEQ) {
            return J.AssignmentOperation.Type.Addition;
        }
        if (elementType == KtTokens.MINUSEQ) {
            return J.AssignmentOperation.Type.Subtraction;
        }
        if (elementType == KtTokens.MULTEQ) {
            return J.AssignmentOperation.Type.Multiplication;
        }
        if (elementType == KtTokens.DIVEQ) {
            return J.AssignmentOperation.Type.Division;
        }
        return null;
    }

    public J visitBlockExpression(KtBlockExpression expression, ExecutionContext data) {
        Space prefix;
        List<Object> statements = new ArrayList<JRightPadded<Statement>>();
        for (KtExpression stmt : expression.getStatements()) {
            J exp = (J)stmt.accept((KtVisitor)this, (Object)data);
            Statement statement = (Statement)this.convertToStatement(exp).withPrefix(this.endFixPrefixAndInfix((PsiElement)stmt));
            JRightPadded<Statement> build = this.maybeTrailingSemicolon(statement, (KtElement)stmt);
            statements.add(build);
        }
        boolean hasBraces = expression.getLBrace() != null;
        Space end = hasBraces ? this.deepPrefix(expression.getRBrace()) : Space.EMPTY;
        Space blockPrefix = prefix = this.prefix((PsiElement)expression);
        if (!hasBraces && !statements.isEmpty()) {
            statements = ListUtils.mapFirst(statements, s -> s.withElement((Object)((Statement)((Statement)s.getElement()).withPrefix(KotlinTreeParserVisitor.merge(prefix, ((Statement)s.getElement()).getPrefix())))));
            blockPrefix = Space.EMPTY;
        }
        return new J.Block(Tree.randomId(), blockPrefix, hasBraces ? Markers.EMPTY : Markers.EMPTY.addIfAbsent((Marker)new OmitBraces(Tree.randomId())), JRightPadded.build((Object)false), statements, end);
    }

    public J visitCallExpression(KtCallExpression expression, ExecutionContext data) {
        if (expression.getCalleeExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        PsiElementAssociations.ExpressionType type = this.psiElementAssociations.getCallType((KtExpression)expression);
        if (type == PsiElementAssociations.ExpressionType.CONSTRUCTOR) {
            JavaType.Method mt = this.methodInvocationType((PsiElement)expression);
            J.Identifier name = (J.Identifier)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            name = (TypeTree)name.withType((JavaType)(mt != null ? mt.getReturnType() : JavaType.Unknown.getInstance()));
            if (!expression.getTypeArguments().isEmpty()) {
                ArrayList<JRightPadded<Expression>> parameters = new ArrayList<JRightPadded<Expression>>(expression.getTypeArguments().size());
                for (KtTypeProjection ktTypeProjection : expression.getTypeArguments()) {
                    parameters.add(this.padRight((Expression)this.convertToExpression((J)ktTypeProjection.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktTypeProjection)));
                }
                JavaType javaType = this.type((KtElement)expression);
                JavaType.Unknown nameType = JavaType.Unknown.getInstance();
                JavaType.Unknown pt = JavaType.Unknown.getInstance();
                if (javaType instanceof JavaType.Method) {
                    pt = ((JavaType.Method)javaType).getReturnType();
                } else if (javaType instanceof JavaType.Variable) {
                    pt = ((JavaType.Variable)javaType).getType();
                } else if (javaType instanceof JavaType.Parameterized) {
                    pt = javaType;
                }
                if (pt instanceof JavaType.Parameterized) {
                    nameType = ((JavaType.Parameterized)pt).getType();
                }
                name = new J.ParameterizedType(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (NameTree)name.withType((JavaType)nameType).withPrefix(Space.EMPTY), JContainer.build((Space)this.prefix((PsiElement)expression.getTypeArgumentList()), parameters, (Markers)Markers.EMPTY), (JavaType)pt);
            }
            return this.isAnnotationConstructor((JavaType)mt) ? new J.Annotation(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY.addIfAbsent((Marker)new AnnotationConstructor(Tree.randomId())), (NameTree)name, this.mapValueArgumentsMaybeWithTrailingLambda(expression.getValueArgumentList(), expression.getValueArguments(), data)) : new J.NewClass(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, null, Space.EMPTY, (TypeTree)name, this.mapValueArgumentsMaybeWithTrailingLambda(expression.getValueArgumentList(), expression.getValueArguments(), data), null, mt);
        }
        if (type == null || type == PsiElementAssociations.ExpressionType.METHOD_INVOCATION) {
            J.Identifier name;
            J j = (J)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            JRightPadded<Expression> select = null;
            if (j instanceof J.Identifier) {
                name = (J.Identifier)j;
            } else {
                select = this.padRight((Expression)this.convertToExpression(j), Space.EMPTY);
                name = this.createIdentifier("<empty>", Space.EMPTY, null, null).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
            }
            JContainer<Expression> typeParams = this.mapTypeArguments(expression.getTypeArgumentList(), data);
            JContainer args = this.mapValueArgumentsMaybeWithTrailingLambda(expression.getValueArgumentList(), expression.getValueArguments(), data);
            if (expression.getValueArgumentList() == null) {
                args = args.withMarkers(args.getMarkers().addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
            }
            JavaType.Method methodType = this.methodInvocationType((PsiElement)expression);
            return new J.MethodInvocation(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, select, typeParams, name.withType((JavaType)methodType), args, methodType);
        }
        if (type == PsiElementAssociations.ExpressionType.QUALIFIER) {
            TypeTree typeTree = (TypeTree)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            JContainer<Expression> typeParams = this.mapTypeArguments(expression.getTypeArgumentList(), data);
            return new J.ParameterizedType(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, (NameTree)typeTree, typeParams, this.type((KtElement)expression));
        }
        throw new UnsupportedOperationException("ExpressionType not found: " + expression.getCalleeExpression().getText());
    }

    private boolean isAnnotationConstructor(@Nullable JavaType type) {
        if (type instanceof JavaType.Method && !(((JavaType.Method)type).getDeclaringType() instanceof JavaType.Unknown)) {
            return this.isAnnotationConstructor((JavaType)((JavaType.Method)type).getDeclaringType());
        }
        if (type instanceof JavaType.Parameterized) {
            return this.isAnnotationConstructor((JavaType)((JavaType.Parameterized)type).getType());
        }
        if (type instanceof JavaType.Class) {
            return ((JavaType.Class)type).getKind() == JavaType.FullyQualified.Kind.Annotation;
        }
        return false;
    }

    @Nullable
    JContainer<Expression> mapTypeArguments(@Nullable KtTypeArgumentList ktTypeArgumentList, ExecutionContext data) {
        if (ktTypeArgumentList == null) {
            return null;
        }
        List ktTypeProjections = ktTypeArgumentList.getArguments();
        ArrayList<JRightPadded<Expression>> parameters = new ArrayList<JRightPadded<Expression>>(ktTypeProjections.size());
        for (int i = 0; i < ktTypeProjections.size(); ++i) {
            KtTypeProjection ktTypeProjection = (KtTypeProjection)ktTypeProjections.get(i);
            parameters.add(this.maybeTrailingComma((KtElement)ktTypeProjection, this.padRight((Expression)this.convertToExpression((J)ktTypeProjection.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktTypeProjection)), i == ktTypeProjections.size() - 1));
        }
        return JContainer.build((Space)this.deepPrefix((PsiElement)ktTypeArgumentList), parameters, (Markers)Markers.EMPTY);
    }

    public J visitConstantExpression(KtConstantExpression expression, ExecutionContext data) {
        Serializable value;
        IStubElementType elementType = expression.getElementType();
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            value = ParseUtilsKt.parseNumericLiteral((String)expression.getText(), (IElementType)elementType);
        } else if (elementType == KtNodeTypes.BOOLEAN_CONSTANT) {
            value = Boolean.valueOf(ParseUtilsKt.parseBoolean((String)expression.getText()));
        } else if (elementType == KtNodeTypes.CHARACTER_CONSTANT) {
            value = Character.valueOf(expression.getText().charAt(0));
        } else if (elementType == KtNodeTypes.NULL) {
            value = null;
        } else {
            throw new UnsupportedOperationException("Unsupported constant expression elementType : " + elementType);
        }
        return new J.Literal(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, (Object)value, expression.getText(), null, this.primitiveType((PsiElement)expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J visitClass(KtClass klass, ExecutionContext data) {
        this.ownerStack.push((KtElement)klass);
        try {
            J j = this.visitClass0(klass, data);
            return j;
        }
        finally {
            this.ownerStack.pop();
        }
    }

    @NotNull
    private J visitClass0(KtClass klass, ExecutionContext data) {
        J.ClassDeclaration.Kind kind;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        JContainer typeParams = null;
        JContainer<TypeTree> implementings = null;
        Markers markers = Markers.EMPTY;
        Set<PsiElement> prefixConsumedSet = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)klass);
        List<J.Modifier> modifiers = this.mapModifiers(klass.getModifierList(), leadingAnnotations, lastAnnotations, data);
        if (!klass.hasModifier(KtTokens.OPEN_KEYWORD)) {
            modifiers.add(this.buildFinalModifier());
        }
        if (klass.getClassKeyword() != null) {
            J.ClassDeclaration.Kind.Type classType = J.ClassDeclaration.Kind.Type.Class;
            for (J.Modifier mod : modifiers) {
                if ("annotation".equals(mod.getKeyword())) {
                    classType = J.ClassDeclaration.Kind.Type.Annotation;
                    break;
                }
                if (!"enum".equals(mod.getKeyword())) continue;
                classType = J.ClassDeclaration.Kind.Type.Enum;
                break;
            }
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(klass.getClassKeyword(), prefixConsumedSet), Markers.EMPTY, lastAnnotations, classType);
        } else if (klass.getClassOrInterfaceKeyword() != null) {
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(klass.getClassOrInterfaceKeyword(), prefixConsumedSet), Markers.EMPTY, Collections.emptyList(), J.ClassDeclaration.Kind.Type.Interface);
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        J.Identifier name = this.createIdentifier(Objects.requireNonNull(klass.getIdentifyingElement()), this.type((KtElement)klass));
        J.Block body = klass.getBody() != null ? (J.Block)klass.getBody().accept((KtVisitor)this, (Object)data) : new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY.add((Marker)new OmitBraces(Tree.randomId())), this.padRight(false, Space.EMPTY), Collections.emptyList(), Space.EMPTY);
        if (klass.getPrimaryConstructor() != null) {
            J.MethodDeclaration primaryConstructor = (J.MethodDeclaration)klass.getPrimaryConstructor().accept((KtVisitor)this, (Object)data);
            body = body.withStatements(ListUtils.concat((Object)primaryConstructor, (List)body.getStatements()));
            markers = markers.addIfAbsent((Marker)new PrimaryConstructor(Tree.randomId()));
        }
        if (klass.getSuperTypeList() != null) {
            implementings = this.mapSuperTypeList(klass.getSuperTypeList(), data);
            JContainer<TypeTree> jContainer = implementings = implementings != null ? implementings.withBefore(this.prefix(klass.getColon())) : null;
        }
        if (klass.getTypeParameterList() != null) {
            typeParams = JContainer.build((Space)this.prefix((PsiElement)klass.getTypeParameterList()), this.mapTypeParameters(klass.getTypeParameterList(), data), (Markers)Markers.EMPTY);
        }
        K.TypeConstraints typeConstraints = null;
        if (klass.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)klass.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = Objects.requireNonNull(klass.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD)).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        J.ClassDeclaration classDeclaration = new J.ClassDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)klass), markers, leadingAnnotations, modifiers, kind, name, typeParams, null, null, implementings, null, body, (JavaType.FullyQualified)this.type((KtElement)klass));
        return typeConstraints != null ? new K.ClassDeclaration(Tree.randomId(), Markers.EMPTY, classDeclaration, typeConstraints) : classDeclaration;
    }

    public J visitClassBody(KtClassBody classBody, ExecutionContext data) {
        ArrayList<Object> list = new ArrayList<Object>();
        Space after = this.endFixPrefixAndInfix(classBody.getRBrace());
        if (!classBody.getEnumEntries().isEmpty()) {
            ArrayList<JRightPadded> enumValues = new ArrayList<JRightPadded>(classBody.getEnumEntries().size());
            boolean terminatedWithSemicolon = false;
            for (int i = 0; i < classBody.getEnumEntries().size(); ++i) {
                KtEnumEntry ktEnumEntry = (KtEnumEntry)classBody.getEnumEntries().get(i);
                PsiElement comma = PsiTreeUtil.findSiblingForward((PsiElement)Objects.requireNonNull(ktEnumEntry.getIdentifyingElement()), (IElementType)KtTokens.COMMA, null);
                PsiElement semicolon = PsiTreeUtil.findSiblingForward((PsiElement)ktEnumEntry.getIdentifyingElement(), (IElementType)KtTokens.SEMICOLON, null);
                JRightPadded rp = this.padRight((J.EnumValue)ktEnumEntry.accept((KtVisitor)this, (Object)data), Space.EMPTY);
                if (i == classBody.getEnumEntries().size() - 1) {
                    if (semicolon != null) {
                        terminatedWithSemicolon = true;
                    }
                    if (comma != null) {
                        rp = rp.withAfter(this.prefix(comma));
                        Space afterComma = Space.EMPTY;
                        if (semicolon != null) {
                            afterComma = this.suffix(comma);
                        }
                        rp = rp.withMarkers(rp.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), afterComma)));
                    } else if (semicolon != null) {
                        rp = rp.withAfter(this.prefix(semicolon));
                    }
                } else {
                    rp = rp.withAfter(this.prefix(comma));
                }
                enumValues.add(rp);
            }
            JRightPadded<J.EnumValueSet> enumSet = this.padRight(new J.EnumValueSet(Tree.randomId(), Space.EMPTY, Markers.EMPTY, enumValues, terminatedWithSemicolon), Space.EMPTY);
            list.add(enumSet);
        }
        for (KtDeclaration d : classBody.getDeclarations()) {
            if (d instanceof KtEnumEntry) continue;
            Statement statement = this.convertToStatement((J)d.accept((KtVisitor)this, (Object)data));
            list.add(this.maybeFollowingSemicolon(statement, (KtElement)d));
        }
        return new J.Block(Tree.randomId(), this.deepPrefix((PsiElement)classBody), Markers.EMPTY, this.padRight(false, Space.EMPTY), list, after);
    }

    public J visitDestructuringDeclaration(KtDestructuringDeclaration multiDeclaration, ExecutionContext data) {
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList leadingAnnotations = new ArrayList();
        ArrayList<JRightPadded<J.VariableDeclarations>> destructVars = new ArrayList<JRightPadded<J.VariableDeclarations>>();
        JLeftPadded<Expression> paddedInitializer = null;
        J.Modifier modifier = new J.Modifier(Tree.randomId(), this.prefix(multiDeclaration.getValOrVarKeyword(), KotlinTreeParserVisitor.preConsumedInfix((PsiElement)multiDeclaration)), Markers.EMPTY, multiDeclaration.isVar() ? "var" : null, multiDeclaration.isVar() ? J.Modifier.Type.LanguageExtension : J.Modifier.Type.Final, Collections.emptyList());
        modifiers.add(modifier);
        if (multiDeclaration.getInitializer() != null) {
            paddedInitializer = this.padLeft(this.suffix(multiDeclaration.getRPar()), (Expression)this.convertToExpression((J)multiDeclaration.getInitializer().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)multiDeclaration.getInitializer())));
        }
        List entries = multiDeclaration.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)entries.get(i);
            Space beforeEntry = this.prefix((PsiElement)entry);
            List<Object> annotations = new ArrayList<J.Annotation>();
            if (entry.getModifierList() != null) {
                this.mapModifiers(entry.getModifierList(), annotations, Collections.emptyList(), data);
                if (!annotations.isEmpty()) {
                    annotations = ListUtils.mapFirst(annotations, anno -> anno.withPrefix(beforeEntry));
                }
            }
            JavaType.Variable vt = this.variableType((PsiElement)entry, this.owner((PsiElement)entry));
            if (entry.getName() == null) {
                throw new UnsupportedOperationException("KtDestructuringDeclarationEntry has empty name, this should never happen");
            }
            J.Identifier nameVar = this.createIdentifier(Objects.requireNonNull(entry.getNameIdentifier()), (JavaType)vt);
            nameVar = !annotations.isEmpty() ? nameVar.withAnnotations(annotations) : nameVar.withPrefix(beforeEntry);
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, nameVar, Collections.emptyList(), null, vt);
            TypeTree typeExpression = null;
            if (entry.getTypeReference() != null) {
                typeExpression = (TypeTree)entry.getTypeReference().accept((KtVisitor)this, (Object)data);
            }
            J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(entry.getColon()))), Collections.emptyList(), Collections.emptyList(), typeExpression, null, Collections.emptyList(), Collections.singletonList(this.padRight(namedVariable, Space.EMPTY)));
            destructVars.add(this.maybeTrailingComma((KtElement)entry, this.padRight(variableDeclarations, this.suffix((PsiElement)entry)), i == entries.size() - 1));
        }
        JavaType.Variable vt = this.variableType((PsiElement)multiDeclaration, this.owner((PsiElement)multiDeclaration));
        J.VariableDeclarations.NamedVariable emptyWithInitializer = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.createIdentifier("<destruct>", Space.SINGLE_SPACE, (JavaType)vt), Collections.emptyList(), paddedInitializer, vt);
        J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, leadingAnnotations, modifiers, null, null, Collections.emptyList(), Collections.singletonList(this.padRight(emptyWithInitializer, Space.EMPTY)));
        return new K.DestructuringDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)multiDeclaration), Markers.EMPTY, variableDeclarations, (JContainer<Statement>)JContainer.build((Space)this.prefix(multiDeclaration.getLPar()), destructVars, (Markers)Markers.EMPTY));
    }

    public J visitDotQualifiedExpression(KtDotQualifiedExpression expression, ExecutionContext data) {
        assert (expression.getSelectorExpression() != null);
        Space prefix = this.deepPrefix((PsiElement)expression);
        if (expression.getSelectorExpression() instanceof KtCallExpression) {
            KtCallExpression callExpression = (KtCallExpression)expression.getSelectorExpression();
            Space callExpressionPrefix = this.prefix((PsiElement)callExpression);
            Expression receiver = (Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data));
            J j = (J)callExpression.accept((KtVisitor)this, (Object)data);
            if (j instanceof J.Annotation) {
                J.Annotation a = (J.Annotation)j;
                a = a.withAnnotationType((NameTree)a.getAnnotationType().withPrefix(callExpressionPrefix));
                J.FieldAccess newName = new J.FieldAccess(Tree.randomId(), receiver.getPrefix(), Markers.EMPTY, (Expression)receiver.withPrefix(Space.EMPTY), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), (J.Identifier)a.getAnnotationType()), a.getType());
                return a.withAnnotationType((NameTree)newName).withPrefix(prefix);
            }
            if (j instanceof J.ParameterizedType) {
                J.ParameterizedType pt = (J.ParameterizedType)j;
                pt = pt.withClazz((NameTree)pt.getClazz().withPrefix(callExpressionPrefix));
                J.FieldAccess newName = new J.FieldAccess(Tree.randomId(), receiver.getPrefix(), Markers.EMPTY, (Expression)receiver.withPrefix(Space.EMPTY), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), (J.Identifier)pt.getClazz()), pt.getType());
                return pt.withClazz((NameTree)newName).withPrefix(prefix);
            }
            if (j instanceof J.MethodInvocation) {
                J.MethodInvocation m = (J.MethodInvocation)j;
                return m.getPadding().withSelect(this.padRight(receiver, this.suffix((PsiElement)expression.getReceiverExpression()))).withName(m.getName().withPrefix(callExpressionPrefix)).withPrefix(prefix);
            }
            if (j instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)j;
                if (receiver instanceof J.FieldAccess || receiver instanceof J.Identifier) {
                    if ((n = n.withPrefix(prefix)).getClazz() instanceof J.ParameterizedType) {
                        J.ParameterizedType pt = (J.ParameterizedType)n.getClazz();
                        if (pt != null) {
                            pt = pt.withClazz((NameTree)pt.getClazz().withPrefix(callExpressionPrefix));
                            J.FieldAccess newName = new J.FieldAccess(Tree.randomId(), receiver.getPrefix(), Markers.EMPTY, (Expression)receiver.withPrefix(Space.EMPTY), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), (J.Identifier)pt.getClazz()), pt.getType());
                            pt = pt.withClazz((NameTree)newName);
                            n = n.withClazz((TypeTree)pt);
                        }
                    } else {
                        J.Identifier id = (J.Identifier)n.getClazz();
                        if (id != null) {
                            id = id.withPrefix(callExpressionPrefix);
                            J.FieldAccess newName = new J.FieldAccess(Tree.randomId(), receiver.getPrefix(), Markers.EMPTY, (Expression)receiver.withPrefix(Space.EMPTY), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), id), id.getType());
                            n = n.withClazz((TypeTree)newName).withPrefix(prefix);
                        }
                    }
                }
                return n;
            }
            throw new UnsupportedOperationException("Unsupported call expression " + j.getClass().getName());
        }
        if (expression.getSelectorExpression() instanceof KtNameReferenceExpression) {
            return new J.FieldAccess(Tree.randomId(), prefix, Markers.EMPTY, (Expression)this.convertToExpression(((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY)), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), (J.Identifier)expression.getSelectorExpression().accept((KtVisitor)this, (Object)data)), this.type((KtElement)expression.getSelectorExpression()));
        }
        throw new UnsupportedOperationException("Unsupported dot qualified selector: " + expression.getSelectorExpression().getClass());
    }

    public J visitIfExpression(KtIfExpression expression, ExecutionContext data) {
        return new J.If(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.buildIfCondition(expression), this.buildIfThenPart(expression), this.buildIfElsePart(expression));
    }

    public J visitImportDirective(KtImportDirective importDirective, ExecutionContext data) {
        FirResolvedImport resolvedImport = this.getResolvedImport(importDirective);
        boolean isStaticImport = resolvedImport != null && resolvedImport.getResolvedParentClassId() != null;
        JLeftPadded<Boolean> rpStatic = this.padLeft(Space.EMPTY, isStaticImport);
        KtImportAlias alias = importDirective.getAlias();
        ASTNode node = importDirective.getNode().findChildByType((IElementType)KtTokens.IMPORT_KEYWORD);
        LeafPsiElement importPsi = (LeafPsiElement)node;
        PsiElement first = this.findFirstNonSpaceNextSibling((PsiElement)importPsi);
        PsiElement last = KotlinTreeParserVisitor.findLastChild((PsiElement)importDirective, psi -> !(psi instanceof KtImportAlias) && !KotlinTreeParserVisitor.isSpace(psi.getNode()) && psi.getNode().getElementType() != KtTokens.SEMICOLON);
        String text = this.nodeRangeText(KotlinTreeParserVisitor.getNodeOrNull(first), KotlinTreeParserVisitor.getNodeOrNull(last));
        TypeTree reference = TypeTree.build((String)text);
        if ((reference = reference.withPrefix(this.suffix((PsiElement)importPsi))) instanceof J.Identifier) {
            reference = new J.FieldAccess(Tree.randomId(), this.suffix((PsiElement)importPsi), Markers.EMPTY, (Expression)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.padLeft(Space.EMPTY, (J.Identifier)reference), this.type((KtElement)importDirective));
        }
        return new J.Import(Tree.randomId(), this.deepPrefix((PsiElement)importDirective), Markers.EMPTY, rpStatic, (J.FieldAccess)reference, alias != null ? this.padLeft(this.prefix((PsiElement)alias), this.createIdentifier(Objects.requireNonNull(alias.getNameIdentifier()), this.type((KtElement)importDirective))) : null);
    }

    @Nullable
    private FirResolvedImport getResolvedImport(KtImportDirective importDirective) {
        FirElement primary2 = this.psiElementAssociations.primary((PsiElement)importDirective);
        if (primary2 instanceof FirResolvedImport) {
            return (FirResolvedImport)primary2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J visitNamedFunction(KtNamedFunction function, ExecutionContext data) {
        this.ownerStack.push((KtElement)function);
        try {
            J j = this.visitNamedFunction0(function, data);
            return j;
        }
        finally {
            this.ownerStack.pop();
        }
    }

    @NotNull
    private J visitNamedFunction0(KtNamedFunction function, ExecutionContext data) {
        boolean isOpen;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(function.getModifierList(), leadingAnnotations, lastAnnotations, data);
        J.TypeParameters typeParameters = null;
        TypeTree returnTypeExpression = null;
        Set<PsiElement> prefixConsumedSet = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)function);
        if (function.getTypeParameterList() != null) {
            typeParameters = new J.TypeParameters(Tree.randomId(), this.prefix((PsiElement)function.getTypeParameterList()), Markers.EMPTY, Collections.emptyList(), this.mapTypeParameters(function.getTypeParameterList(), data));
        }
        if (!(isOpen = function.hasModifier(KtTokens.OPEN_KEYWORD))) {
            modifiers.add(this.buildFinalModifier().withPrefix(Space.EMPTY));
        }
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(function.getFunKeyword(), prefixConsumedSet), Markers.EMPTY, "fun", J.Modifier.Type.LanguageExtension, Collections.emptyList()));
        JavaType.Method type = this.methodDeclarationType((PsiElement)function);
        J.Identifier name = function.getNameIdentifier() == null ? this.createIdentifier("", Space.EMPTY, (JavaType)type) : this.createIdentifier(function.getNameIdentifier(), (JavaType)type);
        List ktParameters = function.getValueParameters();
        if (function.getValueParameterList() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        JContainer params = ktParameters.isEmpty() ? JContainer.build((Space)this.prefix((PsiElement)function.getValueParameterList()), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(function.getValueParameterList().getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY) : JContainer.build((Space)this.prefix((PsiElement)function.getValueParameterList()), this.mapParameters(function.getValueParameterList(), data), (Markers)Markers.EMPTY);
        if (function.getReceiverTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new Extension(Tree.randomId()));
            Expression receiver = (Expression)this.convertToExpression((J)function.getReceiverTypeReference().accept((KtVisitor)this, (Object)data));
            JRightPadded infixReceiver = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new Extension(Tree.randomId())), this.createIdentifier("<receiverType>", Space.EMPTY, null, null), Collections.emptyList(), this.padLeft(Space.EMPTY, receiver), null)).withAfter(this.suffix((PsiElement)function.getReceiverTypeReference()));
            J.VariableDeclarations implicitParam = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new Extension(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(infixReceiver));
            implicitParam = implicitParam.withMarkers(implicitParam.getMarkers().addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), Space.EMPTY)));
            ArrayList<JRightPadded> newStatements = new ArrayList<JRightPadded>(params.getElements().size() + 1);
            newStatements.add(JRightPadded.build((Object)implicitParam));
            newStatements.addAll(params.getPadding().getElements());
            params = params.getPadding().withElements(newStatements);
        }
        if (function.getTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(function.getColon())));
            returnTypeExpression = (TypeTree)function.getTypeReference().accept((KtVisitor)this, (Object)data);
        }
        K.TypeConstraints typeConstraints = null;
        if (function.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)function.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = Objects.requireNonNull(function.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD)).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        J.Block body = function.getBodyBlockExpression() != null ? (J.Block)((J)function.getBodyBlockExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)function.getBodyBlockExpression())) : (function.getBodyExpression() != null ? this.convertToBlock(function.getBodyExpression(), data).withPrefix(this.prefix(function.getEqualsToken())) : null);
        J.MethodDeclaration methodDeclaration = new J.MethodDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)function), markers, leadingAnnotations, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, type);
        return typeConstraints == null ? methodDeclaration : new K.MethodDeclaration(Tree.randomId(), Markers.EMPTY, methodDeclaration, typeConstraints);
    }

    @NotNull
    private List<JRightPadded<J.TypeParameter>> mapTypeParameters(KtTypeParameterList list, ExecutionContext data) {
        List ktTypeParameters = list.getParameters();
        ArrayList<JRightPadded<J.TypeParameter>> params = new ArrayList<JRightPadded<J.TypeParameter>>(ktTypeParameters.size());
        for (int i = 0; i < ktTypeParameters.size(); ++i) {
            KtTypeParameter ktTypeParameter = (KtTypeParameter)ktTypeParameters.get(i);
            J.TypeParameter typeParameter = (J.TypeParameter)ktTypeParameter.accept((KtVisitor)this, (Object)data);
            params.add(this.maybeTrailingComma((KtElement)ktTypeParameter, this.padRight(typeParameter, this.suffix((PsiElement)ktTypeParameter)), i == ktTypeParameters.size() - 1));
        }
        return params;
    }

    public J visitObjectLiteralExpression(KtObjectLiteralExpression expression, ExecutionContext data) {
        J j = (J)expression.getObjectDeclaration().accept((KtVisitor)this, (Object)data);
        return j.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)expression), j.getPrefix()));
    }

    public J visitObjectDeclaration(KtObjectDeclaration declaration, ExecutionContext data) {
        J.Block body;
        JContainer typeParameters;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        JContainer implementings = null;
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)declaration);
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        if (declaration.getModifierList() != null) {
            modifiers.addAll(this.mapModifiers(declaration.getModifierList(), leadingAnnotations, lastAnnotations, data));
        }
        modifiers.add(this.buildFinalModifier());
        JContainer jContainer = typeParameters = declaration.getTypeParameterList() == null ? null : JContainer.build((Space)this.prefix((PsiElement)declaration.getTypeParameterList()), this.mapTypeParameters(declaration.getTypeParameterList(), data), (Markers)Markers.EMPTY);
        if (declaration.getSuperTypeList() != null) {
            implementings = this.mapSuperTypeList(declaration.getSuperTypeList(), data);
            implementings = Objects.requireNonNull(implementings).withBefore(this.prefix(declaration.getColon()));
        }
        if (declaration.getBody() == null) {
            body = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.padRight(false, Space.EMPTY), Collections.emptyList(), Space.EMPTY);
            body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)new OmitBraces(Tree.randomId())));
        } else {
            body = (J.Block)declaration.getBody().accept((KtVisitor)this, (Object)data);
        }
        if (declaration.getObjectKeyword() != null) {
            markers = markers.add((Marker)new KObject(Tree.randomId(), Space.EMPTY));
            markers = markers.add((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(declaration.getColon())));
        }
        J.Identifier name = declaration.getNameIdentifier() != null ? this.createIdentifier(declaration.getNameIdentifier(), this.type((KtElement)declaration)) : this.createIdentifier(declaration.isCompanion() ? "<companion>" : "", Space.EMPTY, this.type((KtElement)declaration)).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
        return new J.ClassDeclaration(Tree.randomId(), this.deepPrefix((PsiElement)declaration), markers, leadingAnnotations, modifiers, new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(declaration.getObjectKeyword(), consumedSpaces), Markers.EMPTY, lastAnnotations, J.ClassDeclaration.Kind.Type.Class), name, typeParameters, null, null, implementings, null, body, (JavaType.FullyQualified)this.type((KtElement)declaration));
    }

    @Nullable
    public J visitPackageDirective(KtPackageDirective directive, ExecutionContext data) {
        if (directive.getPackageNameExpression() == null) {
            return null;
        }
        return new J.Package(Tree.randomId(), this.deepPrefix((PsiElement)directive), Markers.EMPTY, (Expression)directive.getPackageNameExpression().accept((KtVisitor)this, (Object)data), Collections.emptyList());
    }

    public J visitPrefixExpression(KtPrefixExpression expression, ExecutionContext data) {
        assert (expression.getBaseExpression() != null);
        J.Unary.Type type = this.mapJUnaryType(expression.getOperationReference());
        if (type == null) {
            throw new UnsupportedOperationException("TODO");
        }
        JavaType javaType = this.type((KtElement)expression);
        if (javaType instanceof JavaType.Method) {
            javaType = ((JavaType.Method)javaType).getReturnType();
        } else if (javaType instanceof JavaType.Variable) {
            javaType = ((JavaType.Variable)javaType).getType();
        }
        return new J.Unary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), type), (Expression)((J)expression.getBaseExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.suffix((PsiElement)expression.getOperationReference())), javaType);
    }

    public J visitPostfixExpression(KtPostfixExpression expression, ExecutionContext data) {
        JavaType type = this.type((KtElement)expression);
        if (type instanceof JavaType.Method) {
            type = ((JavaType.Method)type).getReturnType();
        } else if (type instanceof JavaType.Variable) {
            type = ((JavaType.Variable)type).getType();
        }
        Object j = this.convertToExpression((J)Objects.requireNonNull(expression.getBaseExpression()).accept((KtVisitor)this, (Object)data));
        IElementType referencedNameElementType = expression.getOperationReference().getReferencedNameElementType();
        if (referencedNameElementType == KtTokens.EXCLEXCL) {
            j = new K.Unary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), K.Unary.Type.NotNull), (Expression)j, type);
        } else if (referencedNameElementType == KtTokens.PLUSPLUS) {
            j = new J.Unary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), J.Unary.Type.PostIncrement), (Expression)j, type);
        } else if (referencedNameElementType == KtTokens.MINUSMINUS) {
            j = new J.Unary(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), J.Unary.Type.PostDecrement), (Expression)j, type);
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        return j;
    }

    public J visitProperty(KtProperty property, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(property.getModifierList(), leadingAnnotations, lastAnnotations, data);
        TypeTree typeExpression = null;
        ArrayList<JRightPadded> variables = new ArrayList<JRightPadded>();
        J.MethodDeclaration getter = null;
        J.MethodDeclaration setter = null;
        JRightPadded<Expression> receiver = null;
        JContainer typeParameters = property.getTypeParameterList() != null ? JContainer.build((Space)this.prefix((PsiElement)property.getTypeParameterList()), this.mapTypeParameters(property.getTypeParameterList(), data), (Markers)Markers.EMPTY) : null;
        K.TypeConstraints typeConstraints = null;
        boolean isSetterFirst = false;
        Set<PsiElement> prefixConsumedSet = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)property);
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(property.getValOrVarKeyword(), prefixConsumedSet), Markers.EMPTY, property.isVar() ? "var" : null, property.isVar() ? J.Modifier.Type.LanguageExtension : J.Modifier.Type.Final, lastAnnotations));
        if (property.getReceiverTypeReference() != null) {
            Expression receiverExp = (Expression)this.convertToExpression(((J)property.getReceiverTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)property.getReceiverTypeReference())));
            receiver = this.padRight(receiverExp, this.suffix((PsiElement)property.getReceiverTypeReference()));
            markers = markers.addIfAbsent((Marker)new Extension(Tree.randomId()));
        }
        JLeftPadded<Expression> initializer = null;
        if (property.getInitializer() != null) {
            initializer = this.padLeft(this.prefix(property.getEqualsToken()), (Expression)this.convertToExpression(((J)property.getInitializer().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)property.getInitializer()))));
        } else if (property.getDelegate() != null) {
            Space afterByKeyword = this.prefix((PsiElement)property.getDelegate().getExpression());
            Expression initializerExp = (Expression)this.convertToExpression((J)property.getDelegate().accept((KtVisitor)this, (Object)data)).withPrefix(afterByKeyword);
            initializer = this.padLeft(this.prefix((PsiElement)property.getDelegate()), initializerExp);
            markers = markers.addIfAbsent((Marker)new By(Tree.randomId()));
        }
        Markers rpMarker = Markers.EMPTY;
        Space maybeBeforeSemicolon = Space.EMPTY;
        PsiElement lastChild = this.findLastNotSpaceChild((PsiElement)property);
        if (lastChild != null && lastChild.getNode().getElementType() == KtTokens.SEMICOLON) {
            rpMarker = rpMarker.addIfAbsent((Marker)new Semicolon(Tree.randomId()));
            maybeBeforeSemicolon = this.prefix(lastChild);
        }
        JavaType.Variable vt = this.variableType((PsiElement)property, this.owner((PsiElement)property));
        J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), this.prefix(property.getNameIdentifier()), Markers.EMPTY, this.createIdentifier(Objects.requireNonNull(property.getNameIdentifier()), (JavaType)vt).withPrefix(Space.EMPTY), Collections.emptyList(), initializer, vt);
        variables.add(this.padRight(namedVariable, maybeBeforeSemicolon).withMarkers(rpMarker));
        if (property.getColon() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(property.getColon())));
            typeExpression = (TypeTree)Objects.requireNonNull(property.getTypeReference()).accept((KtVisitor)this, (Object)data);
        }
        if (property.getGetter() != null) {
            getter = (J.MethodDeclaration)property.getGetter().accept((KtVisitor)this, (Object)data);
        }
        if (property.getSetter() != null) {
            setter = (J.MethodDeclaration)property.getSetter().accept((KtVisitor)this, (Object)data);
        }
        if (getter != null && setter != null) {
            isSetterFirst = property.getSetter().getTextRange().getStartOffset() < property.getGetter().getTextRange().getStartOffset();
        }
        J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), this.endFixPrefixAndInfix((PsiElement)property), markers, leadingAnnotations, modifiers, typeExpression, null, Collections.emptyList(), variables);
        if (property.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)property.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = Objects.requireNonNull(property.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD)).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        if (getter != null || setter != null || receiver != null || typeConstraints != null) {
            return new K.Property(Tree.randomId(), this.deepPrefix((PsiElement)property), markers, (JContainer<J.TypeParameter>)typeParameters, variableDeclarations.withPrefix(Space.EMPTY), typeConstraints, getter, setter, isSetterFirst, receiver);
        }
        return variableDeclarations;
    }

    private List<J.Modifier> mapModifiers(@Nullable KtModifierList modifierList, @NonNull List<J.Annotation> leadingAnnotations, @NonNull List<J.Annotation> lastAnnotations, ExecutionContext data) {
        boolean isLeadingAnnotation = true;
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        if (modifierList == null) {
            return modifiers;
        }
        for (PsiElement child : PsiUtilsKt.getAllChildren((PsiElement)modifierList)) {
            J.Annotation annotation;
            boolean isKeyword;
            if (KotlinTreeParserVisitor.isSpace(child.getNode())) continue;
            boolean isAnnotationEntry = child instanceof KtAnnotationEntry;
            boolean isAnnotation = child instanceof KtAnnotation;
            boolean bl = isKeyword = child instanceof LeafPsiElement && child.getNode().getElementType() instanceof KtModifierKeywordToken;
            if (isAnnotationEntry) {
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)child;
                annotation = (J.Annotation)ktAnnotationEntry.accept((KtVisitor)this, (Object)data);
                if (isLeadingAnnotation) {
                    leadingAnnotations.add(annotation);
                    continue;
                }
                annotations.add(annotation);
                continue;
            }
            if (isAnnotation) {
                KtAnnotation ktAnnotation = (KtAnnotation)child;
                annotation = (J.Annotation)ktAnnotation.accept((KtVisitor)this, (Object)data);
                if (isLeadingAnnotation) {
                    leadingAnnotations.add(annotation);
                    continue;
                }
                annotations.add(annotation);
                continue;
            }
            if (!isKeyword) continue;
            isLeadingAnnotation = false;
            modifiers.add(this.mapModifier(child, new ArrayList<J.Annotation>(annotations), null));
            annotations.clear();
        }
        if (!annotations.isEmpty()) {
            lastAnnotations.addAll(annotations);
        }
        return modifiers;
    }

    public J visitPropertyDelegate(KtPropertyDelegate delegate, ExecutionContext data) {
        if (delegate.getExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        return ((J)delegate.getExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.deepPrefix((PsiElement)delegate));
    }

    public J visitSimpleNameExpression(KtSimpleNameExpression expression, ExecutionContext data) {
        return this.createIdentifier((PsiElement)expression, this.type((KtElement)expression));
    }

    public J visitStringTemplateExpression(KtStringTemplateExpression expression, ExecutionContext data) {
        KtStringTemplateEntry[] entries = expression.getEntries();
        boolean hasStringTemplateEntry = Arrays.stream(entries).anyMatch(x -> x instanceof KtBlockStringTemplateEntry || x instanceof KtSimpleNameStringTemplateEntry);
        if (hasStringTemplateEntry) {
            String delimiter = expression.getFirstChild().getText();
            ArrayList<J> values = new ArrayList<J>(entries.length);
            for (KtStringTemplateEntry entry2 : entries) {
                values.add((J)entry2.accept((KtVisitor)this, (Object)data));
            }
            return new K.KString(Tree.randomId(), this.deepPrefix((PsiElement)expression), Markers.EMPTY, delimiter, values, this.type((KtElement)expression));
        }
        StringBuilder valueSb = new StringBuilder();
        Arrays.stream(entries).forEach(entry -> valueSb.append(this.maybeAdjustCRLF((PsiElement)entry)));
        String valueSource = KotlinTreeParserVisitor.getString(expression, valueSb);
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)valueSb.toString(), valueSource, null, JavaType.Primitive.String).withPrefix(this.deepPrefix((PsiElement)expression));
    }

    @NotNull
    private static String getString(KtStringTemplateExpression expression, StringBuilder valueSb) {
        PsiElement openQuote = expression.getFirstChild();
        PsiElement closingQuota = expression.getLastChild();
        if (openQuote == null || closingQuota == null || openQuote.getNode().getElementType() != KtTokens.OPEN_QUOTE || closingQuota.getNode().getElementType() != KtTokens.CLOSING_QUOTE) {
            throw new UnsupportedOperationException("This should never happen");
        }
        return openQuote.getText() + valueSb + closingQuota.getText();
    }

    public J visitStringTemplateEntry(KtStringTemplateEntry entry, ExecutionContext data) {
        PsiElement leaf = entry.getFirstChild();
        if (!(leaf instanceof LeafPsiElement)) {
            throw new UnsupportedOperationException("Unsupported KtStringTemplateEntry child");
        }
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)leaf.getText(), "\"" + leaf.getText() + "\"", null, this.primitiveType((PsiElement)entry));
    }

    public J visitSuperTypeList(KtSuperTypeList list, ExecutionContext data) {
        throw new UnsupportedOperationException("Unsupported, call mapSuperTypeList instead");
    }

    public J visitSuperTypeCallEntry(KtSuperTypeCallEntry call, ExecutionContext data) {
        return (J)Objects.requireNonNull(call.getTypeReference()).accept((KtVisitor)this, (Object)data);
    }

    public J visitTypeReference(KtTypeReference typeReference, ExecutionContext data) {
        PsiElement first;
        List<Object> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        Set<PsiElement> consumedSpaces = KotlinTreeParserVisitor.preConsumedInfix((PsiElement)typeReference);
        List modifiers = this.mapModifiers(typeReference.getModifierList(), leadingAnnotations, lastAnnotations, data);
        if (!leadingAnnotations.isEmpty()) {
            leadingAnnotations = ListUtils.mapFirst(leadingAnnotations, anno -> anno.withPrefix(this.prefix((PsiElement)typeReference)));
            consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)typeReference));
        } else if (!modifiers.isEmpty() && (first = KotlinTreeParserVisitor.findFirstNonSpaceChild((PsiElement)typeReference)) != null) {
            if (first.getNode().getElementType() != KtTokens.LPAR) {
                modifiers = ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(this.prefix((PsiElement)typeReference)));
                consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)typeReference));
            } else {
                modifiers = ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(KotlinTreeParserVisitor.merge(this.prefix((PsiElement)typeReference.getModifierList()), mod.getPrefix())));
            }
        }
        J j = (J)Objects.requireNonNull(typeReference.getTypeElement()).accept((KtVisitor)this, (Object)data);
        consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)typeReference.getTypeElement()));
        if (j instanceof K.FunctionType && typeReference.getModifierList() != null) {
            K.FunctionType functionType2 = (K.FunctionType)j;
            if ((functionType2 = functionType2.withModifiers(modifiers).withLeadingAnnotations(leadingAnnotations)).getReceiver() != null) {
                functionType2 = functionType2.withReceiver((JRightPadded<NameTree>)functionType2.getReceiver().withElement((Object)((NameTree)((NameTree)functionType2.getReceiver().getElement()).withPrefix(functionType2.getPrefix()))));
                functionType2 = functionType2.withPrefix(Space.EMPTY);
            }
            j = functionType2;
        } else if (j instanceof J.Identifier) {
            j = ((J.Identifier)j).withAnnotations(leadingAnnotations);
        } else if ((j instanceof J.ParameterizedType || j instanceof J.IntersectionType) && !leadingAnnotations.isEmpty()) {
            j = new J.AnnotatedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, leadingAnnotations, (TypeTree)j);
        }
        Stack<Pair> parenPairs = new Stack<Pair>();
        List<PsiElement> allChildren = KotlinTreeParserVisitor.getAllChildren((PsiElement)typeReference);
        int l = 0;
        int r = allChildren.size() - 1;
        while (l < r) {
            if ((l = KotlinTreeParserVisitor.findFirstLPAR(allChildren, l)) * (r = KotlinTreeParserVisitor.findLastRPAR(allChildren, r)) < 0) {
                throw new UnsupportedOperationException("Unpaired parentheses!");
            }
            if (l < 0 || r < 0) break;
            parenPairs.add(new Pair((Object)l++, (Object)r--));
        }
        while (!parenPairs.empty()) {
            Pair parenPair = (Pair)parenPairs.pop();
            PsiElement lPAR = allChildren.get((Integer)parenPair.getFirst());
            PsiElement rPAR = allChildren.get((Integer)parenPair.getSecond());
            TypeTree typeTree = j instanceof K.FunctionType ? ((K.FunctionType)j).withReturnType((JRightPadded<TypedTree>)((K.FunctionType)j).getReturnType().withAfter(Space.EMPTY)) : (TypeTree)j;
            j = new J.ParenthesizedTypeTree(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), new J.Parentheses(Tree.randomId(), this.prefix(lPAR), Markers.EMPTY, this.padRight(typeTree, this.prefix(rPAR))));
        }
        return j.withPrefix(KotlinTreeParserVisitor.merge(this.prefix((PsiElement)typeReference, consumedSpaces), j.getPrefix()));
    }

    public J visitUserType(KtUserType type, ExecutionContext data) {
        J.Identifier name = (J.Identifier)Objects.requireNonNull(type.getReferenceExpression()).accept((KtVisitor)this, (Object)data);
        if (type.getFirstChild() == type.getReferenceExpression()) {
            name = name.withPrefix(KotlinTreeParserVisitor.merge(this.deepPrefix((PsiElement)type), name.getPrefix()));
        }
        J.Identifier nameTree = name;
        if (type.getQualifier() != null) {
            Expression select = (Expression)this.convertToExpression((J)type.getQualifier().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)type.getQualifier()));
            nameTree = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, select, this.padLeft(this.suffix((PsiElement)type.getQualifier()), name), null);
        }
        if (type.getTypeArgumentList() != null) {
            JContainer<Expression> args = this.mapTypeArguments(type.getTypeArgumentList(), data);
            JavaType javaType = this.type((KtElement)type);
            if (javaType instanceof JavaType.Unknown) {
                javaType = new JavaType.Parameterized(null, (JavaType.FullyQualified)JavaType.Unknown.getInstance(), null);
            } else if (!(javaType instanceof JavaType.Parameterized)) {
                throw new UnsupportedOperationException("java type is not a Parameterized: " + type.getText());
            }
            JavaType.Parameterized pt = (JavaType.Parameterized)javaType;
            return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, pt == null ? (NameTree)nameTree.withType((JavaType)JavaType.Unknown.getInstance()) : (NameTree)nameTree.withType((JavaType)pt.getType()), args, (JavaType)(pt == null ? JavaType.Unknown.getInstance() : pt));
        }
        return nameTree;
    }

    public J visitValueArgumentList(KtValueArgumentList list, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    @Nullable
    private K.Binary.Type mapKBinaryType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == null) {
            return null;
        }
        if (elementType == KtTokens.NOT_IN) {
            return K.Binary.Type.NotContains;
        }
        if (elementType == KtTokens.RANGE) {
            return K.Binary.Type.RangeTo;
        }
        if (elementType == KtTokens.RANGE_UNTIL) {
            return K.Binary.Type.RangeUntil;
        }
        if (elementType == KtTokens.IN_KEYWORD) {
            return K.Binary.Type.Contains;
        }
        if (elementType == KtTokens.EQEQEQ) {
            return K.Binary.Type.IdentityEquals;
        }
        if (elementType == KtTokens.EXCLEQEQEQ) {
            return K.Binary.Type.IdentityNotEquals;
        }
        if (elementType == KtTokens.ELVIS) {
            return K.Binary.Type.Elvis;
        }
        if (elementType == KtTokens.EQ) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported OPERATION_REFERENCE type: " + elementType);
    }

    @Nullable
    private J.Binary.Type mapJBinaryType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == null) {
            String operator = operationReference.getText();
            if ("and".equals(operator)) {
                return J.Binary.Type.BitAnd;
            }
            if ("or".equals(operator)) {
                return J.Binary.Type.BitOr;
            }
            if ("xor".equals(operator)) {
                return J.Binary.Type.BitXor;
            }
            if ("shl".equals(operator)) {
                return J.Binary.Type.LeftShift;
            }
            if ("shr".equals(operator)) {
                return J.Binary.Type.RightShift;
            }
            if ("ushr".equals(operator)) {
                return J.Binary.Type.UnsignedRightShift;
            }
        }
        if (elementType == KtTokens.PLUS) {
            return J.Binary.Type.Addition;
        }
        if (elementType == KtTokens.MINUS) {
            return J.Binary.Type.Subtraction;
        }
        if (elementType == KtTokens.MUL) {
            return J.Binary.Type.Multiplication;
        }
        if (elementType == KtTokens.DIV) {
            return J.Binary.Type.Division;
        }
        if (elementType == KtTokens.EQEQ) {
            return J.Binary.Type.Equal;
        }
        if (elementType == KtTokens.EXCLEQ) {
            return J.Binary.Type.NotEqual;
        }
        if (elementType == KtTokens.GT) {
            return J.Binary.Type.GreaterThan;
        }
        if (elementType == KtTokens.GTEQ) {
            return J.Binary.Type.GreaterThanOrEqual;
        }
        if (elementType == KtTokens.LT) {
            return J.Binary.Type.LessThan;
        }
        if (elementType == KtTokens.LTEQ) {
            return J.Binary.Type.LessThanOrEqual;
        }
        if (elementType == KtTokens.PERC) {
            return J.Binary.Type.Modulo;
        }
        if (elementType == KtTokens.ANDAND) {
            return J.Binary.Type.And;
        }
        if (elementType == KtTokens.OROR) {
            return J.Binary.Type.Or;
        }
        return null;
    }

    @Nullable
    private J.Unary.Type mapJUnaryType(KtSimpleNameExpression operationReference) {
        IElementType elementType = operationReference.getReferencedNameElementType();
        if (elementType == KtTokens.EXCL) {
            return J.Unary.Type.Not;
        }
        if (elementType == KtTokens.MINUSMINUS) {
            return J.Unary.Type.PreDecrement;
        }
        if (elementType == KtTokens.PLUSPLUS) {
            return J.Unary.Type.PreIncrement;
        }
        if (elementType == KtTokens.MINUS) {
            return J.Unary.Type.Negative;
        }
        if (elementType == KtTokens.PLUSEQ) {
            return J.Unary.Type.Positive;
        }
        if (elementType == KtTokens.PLUS) {
            return J.Unary.Type.Positive;
        }
        return null;
    }

    private J.MethodInvocation mapFunctionCall(KtBinaryExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Infix(Tree.randomId())).addIfAbsent((Marker)new Extension(Tree.randomId()));
        Expression selectExp = (Expression)this.convertToExpression(((J)Objects.requireNonNull(expression.getLeft()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getLeft())));
        JRightPadded<Expression> select = this.padRight(selectExp, Space.EMPTY);
        J.Identifier name = (J.Identifier)expression.getOperationReference().accept((KtVisitor)this, (Object)data);
        ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(1);
        Markers paramMarkers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
        Expression rightExp = (Expression)this.convertToExpression(((J)Objects.requireNonNull(expression.getRight()).accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getRight())));
        JRightPadded<Expression> padded = this.padRight(rightExp, this.suffix((PsiElement)expression.getRight()));
        expressions.add(padded);
        JContainer args = JContainer.build((Space)Space.EMPTY, expressions, (Markers)paramMarkers);
        JavaType.Method methodType = this.methodInvocationType((PsiElement)expression);
        return new J.MethodInvocation(Tree.randomId(), this.prefix((PsiElement)expression), markers, select, null, name, args, methodType);
    }

    private J.ControlParentheses<Expression> buildIfCondition(KtIfExpression expression) {
        return new J.ControlParentheses(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)Objects.requireNonNull(expression.getCondition()).accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.suffix(expression.getLeftParenthesis())), this.prefix(expression.getRightParenthesis())));
    }

    private JRightPadded<Statement> buildIfThenPart(KtIfExpression expression) {
        return this.padRight((Statement)this.convertToStatement((J)Objects.requireNonNull(expression.getThen()).accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.prefix(expression.getThen().getParent())), Space.EMPTY);
    }

    @Nullable
    private J.If.Else buildIfElsePart(KtIfExpression expression) {
        if (expression.getElse() == null) {
            return null;
        }
        return new J.If.Else(Tree.randomId(), this.prefix(expression.getElseKeyword()), Markers.EMPTY, this.padRight((Statement)this.convertToStatement((J)expression.getElse().accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.suffix(expression.getElseKeyword())), Space.EMPTY));
    }

    private <T extends J> T mapType(T tree) {
        return this.mapType(tree, null);
    }

    private <T extends J> T mapType(T tree, @Nullable JavaType type) {
        Object updated = tree;
        if (updated instanceof J.Annotation) {
            J.Annotation a = (J.Annotation)updated;
            if (a.getAnnotationType() instanceof J.Identifier && a.getAnnotationType().getType() instanceof JavaType.Method) {
                a = a.withAnnotationType((NameTree)((J.Identifier)a.getAnnotationType()).withType(((JavaType.Method)a.getAnnotationType().getType()).getReturnType()));
            }
            updated = a;
        }
        return updated;
    }

    @Nullable
    private JavaType type(@Nullable KtElement psi) {
        if (psi == null) {
            return JavaType.Unknown.getInstance();
        }
        return this.psiElementAssociations.type((PsiElement)psi, this.owner((PsiElement)psi));
    }

    private JavaType.Primitive primitiveType(PsiElement psi) {
        return this.psiElementAssociations.primitiveType(psi);
    }

    @Nullable
    private JavaType.Variable variableType(PsiElement psi, @Nullable FirElement parent) {
        return this.psiElementAssociations.variableType(psi, parent);
    }

    @Nullable
    private JavaType.Method methodDeclarationType(PsiElement psi) {
        return this.psiElementAssociations.methodDeclarationType(psi);
    }

    @Nullable
    private JavaType.Method methodInvocationType(PsiElement psi) {
        return this.psiElementAssociations.methodInvocationType(psi);
    }

    private J.Identifier createIdentifier(PsiElement name, @Nullable JavaType type) {
        return this.createIdentifier(name, type, null);
    }

    private J.Identifier createIdentifier(PsiElement name, @Nullable JavaType type, @Nullable Set<PsiElement> consumedSpaces) {
        return this.createIdentifier(name.getNode().getText(), this.prefix(name, consumedSpaces), type);
    }

    private J.Identifier createIdentifier(String name, Space prefix, @Nullable JavaType type) {
        return this.createIdentifier(name, prefix, type instanceof JavaType.Variable ? ((JavaType.Variable)type).getType() : type, type instanceof JavaType.Variable ? (JavaType.Variable)type : null);
    }

    private J.Identifier createIdentifier(String name, Space prefix, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        Markers markers = Markers.EMPTY;
        String updated = name;
        if (name.startsWith("`")) {
            updated = updated.substring(1, updated.length() - 1);
            markers = markers.addIfAbsent((Marker)new Quoted(Tree.randomId()));
        }
        return new J.Identifier(Tree.randomId(), prefix, markers, Collections.emptyList(), updated, type instanceof JavaType.Unknown ? null : type, fieldType);
    }

    private static J.Identifier addPrefixInFront(J.Identifier id, Space prefix) {
        id = !id.getAnnotations().isEmpty() ? id.withAnnotations(ListUtils.mapFirst((List)id.getAnnotations(), anno -> anno.withPrefix(KotlinTreeParserVisitor.merge(prefix, anno.getPrefix())))) : id.withPrefix(KotlinTreeParserVisitor.merge(prefix, id.getPrefix()));
        return id;
    }

    @Nullable
    private FirElement owner(PsiElement element) {
        KtElement owner;
        KtElement ktElement = owner = this.ownerStack.peek() == element ? (KtElement)this.ownerStack.get(this.ownerStack.size() - 2) : this.ownerStack.peek();
        if (owner instanceof KtDeclaration) {
            return this.psiElementAssociations.primary((PsiElement)owner);
        }
        if (owner instanceof KtFile) {
            return this.psiElementAssociations.primary((PsiElement)owner);
        }
        return null;
    }

    private J.Block convertToBlock(KtExpression ktExpression, ExecutionContext data) {
        Expression returnExpr = (Expression)this.convertToExpression((J)ktExpression.accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
        K.KReturn kreturn = new K.KReturn(Tree.randomId(), new J.Return(Tree.randomId(), this.prefix((PsiElement)ktExpression), Markers.EMPTY.addIfAbsent((Marker)new ImplicitReturn(Tree.randomId())), returnExpr), null);
        return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new OmitBraces(Tree.randomId())).addIfAbsent((Marker)new SingleExpressionBlock(Tree.randomId())), JRightPadded.build((Object)false), Collections.singletonList(JRightPadded.build((Object)kreturn)), Space.EMPTY);
    }

    private <J2 extends J> JRightPadded<J2> maybeTrailingSemicolon(J2 j, KtElement element) {
        boolean hasSemicolon;
        PsiElement maybeSemicolon = this.findLastNotSpaceChild((PsiElement)element);
        boolean bl = hasSemicolon = maybeSemicolon instanceof LeafPsiElement && ((LeafPsiElement)maybeSemicolon).getElementType() == KtTokens.SEMICOLON;
        if (hasSemicolon) {
            return new JRightPadded(j, this.prefix(maybeSemicolon), Markers.EMPTY.add((Marker)new Semicolon(Tree.randomId())));
        }
        maybeSemicolon = this.findFirstNonSpaceNextSibling((PsiElement)element);
        if (maybeSemicolon instanceof LeafPsiElement && ((LeafPsiElement)maybeSemicolon).getElementType() == KtTokens.SEMICOLON) {
            return new JRightPadded(j, this.deepPrefix(maybeSemicolon), Markers.EMPTY.add((Marker)new Semicolon(Tree.randomId())));
        }
        return this.padRight(j, Space.EMPTY);
    }

    private <J2 extends J> JRightPadded<J2> maybeFollowingSemicolon(J2 j, KtElement element) {
        PsiElement maybeSemicolon = this.findFirstNonSpaceNextSibling((PsiElement)element);
        if (maybeSemicolon instanceof LeafPsiElement && ((LeafPsiElement)maybeSemicolon).getElementType() == KtTokens.SEMICOLON) {
            return new JRightPadded(j, this.deepPrefix(maybeSemicolon), Markers.EMPTY.add((Marker)new Semicolon(Tree.randomId())));
        }
        return this.padRight(j, Space.EMPTY);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return this.padRight(tree, right, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right, Markers markers) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, markers);
    }

    private <J2 extends J> J2 convertToExpression(J j) {
        if (j instanceof Statement && !(j instanceof Expression)) {
            j = new K.StatementExpression(Tree.randomId(), (Statement)j);
        }
        return (J2)j;
    }

    private Statement convertToStatement(J j) {
        if (!(j instanceof Statement) && j instanceof Expression) {
            j = new K.ExpressionStatement(Tree.randomId(), (Expression)j);
        }
        if (!(j instanceof Statement)) {
            throw new UnsupportedOperationException("TODO");
        }
        return (Statement)j;
    }

    private Space prefix(@Nullable PsiElement element) {
        return this.prefix(element, null);
    }

    @NotNull
    private Space prefix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement first = this.findFirstPrefixSpace(element);
        if (first == null) {
            return Space.EMPTY;
        }
        if (consumedSpaces != null && consumedSpaces.contains(first)) {
            return Space.EMPTY;
        }
        return this.space(first);
    }

    private static List<PsiElement> getAllChildren(PsiElement psiElement) {
        ArrayList<PsiElement> allChildren = new ArrayList<PsiElement>();
        for (PsiElement it : PsiUtilsKt.getAllChildren((PsiElement)psiElement)) {
            allChildren.add(it);
        }
        return allChildren;
    }

    @Nullable
    private PsiElement findFirstPrefixSpace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement pre = element.getPrevSibling();
        if (pre == null || !KotlinTreeParserVisitor.isSpace(pre.getNode())) {
            return null;
        }
        while (pre.getPrevSibling() != null && KotlinTreeParserVisitor.isSpace(pre.getPrevSibling().getNode())) {
            pre = pre.getPrevSibling();
        }
        return pre;
    }

    @Nullable
    private static PsiElement getFirstSpaceChildOrNull(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Iterator iterator = PsiUtilsKt.getAllChildren((PsiElement)element).iterator();
        PsiElement first = (PsiElement)iterator.next();
        if (first != null) {
            return KotlinTreeParserVisitor.isSpace(first.getNode()) ? first : null;
        }
        return null;
    }

    @Nullable
    private PsiElement findFirstNonSpacePrevSibling(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiElement pre = element.getPrevSibling(); pre != null; pre = pre.getPrevSibling()) {
            if (KotlinTreeParserVisitor.isSpace(pre.getNode())) continue;
            return pre;
        }
        return null;
    }

    @Nullable
    private PsiElement findFirstNonSpaceNextSibling(@Nullable PsiElement element) {
        PsiElement next;
        if (element == null) {
            return null;
        }
        for (next = element.getNextSibling(); next != null && KotlinTreeParserVisitor.isSpace(next.getNode()); next = next.getNextSibling()) {
        }
        return next;
    }

    private Space suffix(@Nullable PsiElement element) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement whitespace = element.getNextSibling();
        if (whitespace == null || !KotlinTreeParserVisitor.isSpace(whitespace.getNode())) {
            return Space.EMPTY;
        }
        return this.space(whitespace);
    }

    private Space infix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement first = element.getFirstChild();
        if (first == null || !KotlinTreeParserVisitor.isSpace(first.getNode())) {
            return Space.EMPTY;
        }
        if (consumedSpaces != null && consumedSpaces.contains(first)) {
            return Space.EMPTY;
        }
        return this.space(element.getFirstChild());
    }

    private Space endFix(@Nullable PsiElement element) {
        if (element == null) {
            return Space.EMPTY;
        }
        Space end = this.endFix(this.findLastNotSpaceChild(element));
        PsiElement lastSpace = this.findLastSpaceChild(element);
        return KotlinTreeParserVisitor.merge(end, this.space(lastSpace));
    }

    private Space endFixPrefixAndInfix(@Nullable PsiElement element) {
        return KotlinTreeParserVisitor.merge(this.endFix(this.findFirstNonSpacePrevSibling(element)), this.prefixAndInfix(element, null));
    }

    private Space deepPrefix(@Nullable PsiElement element) {
        return this.endFixPrefixAndInfix(element);
    }

    private Space endFixAndSuffix(@Nullable PsiElement element) {
        return KotlinTreeParserVisitor.merge(this.endFix(element), this.suffix(element));
    }

    private Space prefixAndInfix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        return KotlinTreeParserVisitor.merge(this.prefix(element, consumedSpaces), this.infix(element, consumedSpaces));
    }

    private static boolean isSpace(ASTNode node) {
        IElementType elementType = node.getElementType();
        return elementType == KtTokens.WHITE_SPACE || elementType == KtTokens.BLOCK_COMMENT || elementType == KtTokens.EOL_COMMENT || elementType == KtTokens.DOC_COMMENT || KotlinTreeParserVisitor.isCRLF(node);
    }

    private static boolean isLPAR(PsiElement element) {
        return element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == KtTokens.LPAR;
    }

    private static boolean isRPAR(PsiElement element) {
        return element instanceof LeafPsiElement && ((LeafPsiElement)element).getElementType() == KtTokens.RPAR;
    }

    private static int findFirstLPAR(List<PsiElement> elements, int start) {
        int ret = -1;
        for (int i = start; i < elements.size(); ++i) {
            if (!KotlinTreeParserVisitor.isLPAR(elements.get(i))) continue;
            return i;
        }
        return ret;
    }

    private static int findLastRPAR(List<PsiElement> elements, int end) {
        int ret = -1;
        for (int i = end; i >= 0; --i) {
            if (!KotlinTreeParserVisitor.isRPAR(elements.get(i))) continue;
            return i;
        }
        return ret;
    }

    private static boolean isCRLF(ASTNode node) {
        return node instanceof PsiErrorElementImpl && node.getText().equals("\r");
    }

    private String nodeRangeText(@Nullable ASTNode first, @Nullable ASTNode last) {
        StringBuilder builder = new StringBuilder();
        while (first != null) {
            builder.append(first.getText());
            if (first == last) break;
            first = first.getTreeNext();
        }
        return builder.toString();
    }

    private List<J.Annotation> mapAnnotations(List<KtAnnotationEntry> ktAnnotationEntries, ExecutionContext data) {
        return ktAnnotationEntries.stream().map(annotation -> (J.Annotation)annotation.accept((KtVisitor)this, (Object)data)).collect(Collectors.toList());
    }

    private J mapDestructuringDeclaration(KtDestructuringDeclaration ktDestructuringDeclaration, ExecutionContext data) {
        List entries = ktDestructuringDeclaration.getEntries();
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(entries.size());
        for (KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry : entries) {
            J.Identifier name = (J.Identifier)ktDestructuringDeclarationEntry.accept((KtVisitor)this, (Object)data);
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), null, this.variableType((PsiElement)ktDestructuringDeclarationEntry, this.owner((PsiElement)ktDestructuringDeclarationEntry)));
            variables.add(this.padRight(namedVariable, this.suffix((PsiElement)ktDestructuringDeclarationEntry)));
        }
        J.VariableDeclarations j = new J.VariableDeclarations(Tree.randomId(), this.prefix((PsiElement)ktDestructuringDeclaration), Markers.EMPTY.addIfAbsent((Marker)new OmitEquals(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), variables);
        if (entries.size() == 1) {
            List<PsiElement> allChildren = KotlinTreeParserVisitor.getAllChildren((PsiElement)ktDestructuringDeclaration);
            int l = KotlinTreeParserVisitor.findFirstLPAR(allChildren, 0);
            int r = KotlinTreeParserVisitor.findLastRPAR(allChildren, allChildren.size() - 1);
            if (l >= 0 && l < r) {
                j = new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.padRight(j, Space.EMPTY));
            }
        }
        return j;
    }

    private J.Modifier mapModifier(PsiElement modifier, List<J.Annotation> annotations, @Nullable Set<PsiElement> consumedSpaces) {
        J.Modifier.Type type;
        Space prefix = this.prefix(modifier, consumedSpaces);
        String keyword = null;
        switch (modifier.getText()) {
            case "public": {
                type = J.Modifier.Type.Public;
                break;
            }
            case "protected": {
                type = J.Modifier.Type.Protected;
                break;
            }
            case "private": {
                type = J.Modifier.Type.Private;
                break;
            }
            case "abstract": {
                type = J.Modifier.Type.Abstract;
                break;
            }
            case "val": {
                type = J.Modifier.Type.Final;
                break;
            }
            default: {
                type = J.Modifier.Type.LanguageExtension;
                keyword = modifier.getText();
            }
        }
        return new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, keyword, type, annotations);
    }

    private List<JRightPadded<Statement>> mapParameters(@Nullable KtParameterList list, ExecutionContext data) {
        if (list == null) {
            return Collections.emptyList();
        }
        List ktParameters = list.getParameters();
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(ktParameters.size());
        for (int i = 0; i < ktParameters.size(); ++i) {
            KtParameter ktParameter = (KtParameter)ktParameters.get(i);
            Statement statement = this.convertToStatement((J)ktParameter.accept((KtVisitor)this, (Object)data));
            statements.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight(statement, this.endFixAndSuffix((PsiElement)ktParameter)), i == ktParameters.size() - 1));
        }
        if (ktParameters.isEmpty()) {
            J.Empty param = new J.Empty(Tree.randomId(), this.prefix(list.getRightParenthesis()), Markers.EMPTY);
            statements.add(this.padRight(param, Space.EMPTY));
        }
        return statements;
    }

    @Nullable
    private JContainer<TypeTree> mapSuperTypeList(@Nullable KtSuperTypeList ktSuperTypeList, ExecutionContext data) {
        if (ktSuperTypeList == null) {
            return null;
        }
        List ktSuperTypeListEntries = ktSuperTypeList.getEntries();
        List<JRightPadded<K.ConstructorInvocation>> superTypes = new ArrayList(ktSuperTypeListEntries.size());
        Markers markers = Markers.EMPTY;
        for (int i = 0; i < ktSuperTypeListEntries.size(); ++i) {
            KtSuperTypeListEntry superTypeListEntry = (KtSuperTypeListEntry)ktSuperTypeListEntries.get(i);
            if (superTypeListEntry instanceof KtSuperTypeCallEntry) {
                JContainer args;
                KtSuperTypeCallEntry superTypeCallEntry = (KtSuperTypeCallEntry)superTypeListEntry;
                TypeTree typeTree = (TypeTree)superTypeCallEntry.getCalleeExpression().accept((KtVisitor)this, (Object)data);
                if (!superTypeCallEntry.getValueArguments().isEmpty()) {
                    args = this.mapValueArguments(superTypeCallEntry.getValueArgumentList(), data);
                } else {
                    KtValueArgumentList ktArgList = superTypeCallEntry.getValueArgumentList();
                    args = JContainer.build((Space)this.prefix((PsiElement)ktArgList), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(Objects.requireNonNull(ktArgList).getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)markers);
                }
                K.ConstructorInvocation delegationCall = new K.ConstructorInvocation(Tree.randomId(), this.prefix((PsiElement)superTypeListEntry), Markers.EMPTY, typeTree, args);
                superTypes.add(this.padRight(delegationCall, this.suffix((PsiElement)superTypeCallEntry)));
                continue;
            }
            if (superTypeListEntry instanceof KtSuperTypeEntry || superTypeListEntry instanceof KtDelegatedSuperTypeEntry) {
                TypeTree typeTree = (TypeTree)superTypeListEntry.accept((KtVisitor)this, (Object)data);
                if (i == 0) {
                    typeTree = (TypeTree)typeTree.withPrefix(this.prefix((PsiElement)superTypeListEntry));
                }
                superTypes.add(this.padRight(typeTree, this.suffix((PsiElement)superTypeListEntry)));
                continue;
            }
            throw new UnsupportedOperationException("TODO");
        }
        superTypes = ListUtils.mapFirst(superTypes, rp -> rp.withElement((Object)((TypeTree)((TypeTree)rp.getElement()).withPrefix(KotlinTreeParserVisitor.merge(this.prefix((PsiElement)ktSuperTypeList), ((TypeTree)rp.getElement()).getPrefix())))));
        return JContainer.build((Space)Space.EMPTY, superTypes, (Markers)Markers.EMPTY);
    }

    private JContainer<Expression> mapValueArgumentsMaybeWithTrailingLambda(@Nullable KtValueArgumentList valueArgumentList, List<KtValueArgument> ktValueArguments, ExecutionContext data) {
        ArrayList<Object> expressions = new ArrayList<Object>(ktValueArguments.size());
        Markers markers = Markers.EMPTY;
        if (valueArgumentList != null && valueArgumentList.getArguments().isEmpty()) {
            J.Empty arg = new J.Empty(Tree.randomId(), this.prefix(valueArgumentList.getRightParenthesis()), Markers.EMPTY);
            expressions.add(this.padRight(arg, Space.EMPTY));
        }
        for (int i = 0; i < ktValueArguments.size(); ++i) {
            PsiElement maybeTrailingComma;
            KtValueArgument ktValueArgument = ktValueArguments.get(i);
            Expression expr = (Expression)this.convertToExpression((J)ktValueArgument.accept((KtVisitor)this, (Object)data));
            Markers rpMarkers = Markers.EMPTY;
            if (valueArgumentList != null && i == valueArgumentList.getArguments().size() - 1 && (maybeTrailingComma = this.findTrailingComma((PsiElement)ktValueArgument)) != null) {
                rpMarkers = rpMarkers.addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(maybeTrailingComma)));
            }
            expressions.add(this.padRight(expr, this.suffix((PsiElement)ktValueArgument), rpMarkers));
        }
        if (valueArgumentList == null) {
            markers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
        }
        Space prefix = valueArgumentList != null ? this.prefix((PsiElement)valueArgumentList) : Space.EMPTY;
        return JContainer.build((Space)prefix, expressions, (Markers)markers);
    }

    private JContainer<Expression> mapValueArguments(@Nullable KtValueArgumentList argumentList, ExecutionContext data) {
        if (argumentList == null) {
            return JContainer.empty();
        }
        List ktValueArguments = argumentList.getArguments();
        ArrayList<Object> expressions = new ArrayList<Object>(ktValueArguments.size());
        if (ktValueArguments.isEmpty()) {
            J.Empty arg = new J.Empty(Tree.randomId(), this.prefix(argumentList.getRightParenthesis()), Markers.EMPTY);
            expressions.add(this.padRight(arg, Space.EMPTY));
        } else {
            for (int i = 0; i < ktValueArguments.size(); ++i) {
                KtValueArgument ktValueArgument = (KtValueArgument)ktValueArguments.get(i);
                Expression expr = (Expression)this.convertToExpression((J)ktValueArgument.accept((KtVisitor)this, (Object)data));
                expressions.add(this.maybeTrailingComma((KtElement)ktValueArgument, this.padRight(expr, this.suffix((PsiElement)ktValueArgument)), i == ktValueArguments.size() - 1));
            }
        }
        return JContainer.build((Space)this.prefix((PsiElement)argumentList), expressions, (Markers)Markers.EMPTY);
    }

    private Space toSpace(@Nullable PsiElement element) {
        if (element == null || !KotlinTreeParserVisitor.isSpace(element.getNode())) {
            return Space.EMPTY;
        }
        IElementType elementType = element.getNode().getElementType();
        if (elementType == KtTokens.WHITE_SPACE) {
            return Space.build((String)this.maybeAdjustCRLF(element), Collections.emptyList());
        }
        if (elementType == KtTokens.EOL_COMMENT || elementType == KtTokens.BLOCK_COMMENT) {
            String nodeText = this.maybeAdjustCRLF(element);
            boolean isBlockComment = ((PsiComment)element).getTokenType() == KtTokens.BLOCK_COMMENT;
            String comment = isBlockComment ? nodeText.substring(2, nodeText.length() - 2) : nodeText.substring(2);
            ArrayList<TextComment> comments = new ArrayList<TextComment>(1);
            comments.add(new TextComment(isBlockComment, comment, "", Markers.EMPTY));
            return Space.build((String)"", comments);
        }
        if (elementType == KtTokens.DOC_COMMENT) {
            return this.kdocToSpace((KDoc)element);
        }
        return Space.EMPTY;
    }

    private String maybeAdjustCRLF(PsiElement element) {
        boolean hasCRLF;
        String text = element.getText();
        boolean isStringTemplateEntry = element instanceof KtLiteralStringTemplateEntry;
        if (!KotlinTreeParserVisitor.isSpace(element.getNode()) && !isStringTemplateEntry) {
            return text;
        }
        TextRange range = element.getTextRange();
        int left = this.findFirstGreaterOrEqual(this.cRLFLocations, range.getStartOffset());
        int right = left != -1 ? this.findFirstLessOrEqual(this.cRLFLocations, range.getEndOffset(), left) : -1;
        boolean bl = hasCRLF = left != -1 && left <= right;
        if (hasCRLF) {
            for (int i = right; i >= left; --i) {
                text = this.replaceNewLineWithCRLF(text, this.cRLFLocations.get(i) - range.getStartOffset());
            }
        }
        return text;
    }

    private Space kdocToSpace(KDoc kDoc) {
        StringBuilder sb = new StringBuilder();
        for (PsiElement it : PsiUtilsKt.getAllChildren((PsiElement)kDoc)) {
            String text = it.getText();
            if (it instanceof PsiWhiteSpace) {
                boolean hasCRLF;
                TextRange range = it.getTextRange();
                int left = this.findFirstGreaterOrEqual(this.cRLFLocations, range.getStartOffset());
                int right = left != -1 ? this.findFirstLessOrEqual(this.cRLFLocations, range.getEndOffset(), left) : -1;
                boolean bl = hasCRLF = left != -1 && left <= right;
                if (hasCRLF) {
                    for (int i = right; i >= left; --i) {
                        text = this.replaceNewLineWithCRLF(text, this.cRLFLocations.get(i) - range.getStartOffset());
                    }
                }
            }
            sb.append(text);
        }
        String source = sb.toString();
        String comment = source.substring(2, source.length() - 2);
        ArrayList<TextComment> comments = new ArrayList<TextComment>(1);
        comments.add(new TextComment(true, comment, "", Markers.EMPTY));
        return Space.build((String)"", comments);
    }

    private Space space(@Nullable PsiElement node) {
        Space space = Space.EMPTY;
        while (node != null && KotlinTreeParserVisitor.isSpace(node.getNode())) {
            space = KotlinTreeParserVisitor.merge(space, this.toSpace(node));
            node = node.getNextSibling();
        }
        return space;
    }

    private static Space merge(@Nullable Space s1, @Nullable Space s2) {
        if (s1 == null || s1.isEmpty()) {
            return s2 != null ? s2 : Space.EMPTY;
        }
        if (s2 == null || s2.isEmpty()) {
            return s1;
        }
        if (s1.getComments().isEmpty()) {
            return Space.build((String)(s1.getWhitespace() + s2.getWhitespace()), (List)s2.getComments());
        }
        List newComments = ListUtils.mapLast((List)s1.getComments(), c -> c.withSuffix(c.getSuffix() + s2.getWhitespace()));
        newComments.addAll(s2.getComments());
        return Space.build((String)s1.getWhitespace(), (List)newComments);
    }

    private J.Modifier buildFinalModifier() {
        return new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList());
    }

    @Nullable
    private PsiElement findLastNotSpaceChild(@Nullable PsiElement parent) {
        return KotlinTreeParserVisitor.findLastChild(parent, psi -> !KotlinTreeParserVisitor.isSpace(psi.getNode()));
    }

    @Nullable
    private static PsiElement findFirstChild(@Nullable PsiElement parent, Predicate<PsiElement> condition) {
        if (parent == null) {
            return null;
        }
        for (PsiElement child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!condition.test(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private static PsiElement findFirstNonSpaceChild(@Nullable PsiElement parent) {
        return KotlinTreeParserVisitor.findFirstChild(parent, child -> !KotlinTreeParserVisitor.isSpace(child.getNode()));
    }

    @Nullable
    private static PsiElement findLastChild(@Nullable PsiElement parent, Predicate<PsiElement> condition) {
        if (parent == null) {
            return null;
        }
        for (PsiElement child = parent.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!condition.test(child)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    private PsiElement findLastSpaceChild(@Nullable PsiElement parent) {
        if (parent == null) {
            return null;
        }
        PsiElement ret = null;
        for (PsiElement child = parent.getLastChild(); child != null && KotlinTreeParserVisitor.isSpace(child.getNode()); child = child.getPrevSibling()) {
            ret = child;
        }
        return ret;
    }

    private static <E> void addIfNotNull(Set<E> set, @Nullable E element) {
        if (element != null) {
            set.add(element);
        }
    }

    private static Set<PsiElement> preConsumedInfix(PsiElement element) {
        HashSet<PsiElement> consumed = new HashSet<PsiElement>();
        KotlinTreeParserVisitor.addIfNotNull(consumed, KotlinTreeParserVisitor.getFirstSpaceChildOrNull(element));
        return consumed;
    }

    @Nullable
    private PsiElement findTrailingComma(PsiElement element) {
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getNode().getElementType() != KtTokens.COMMA) continue;
            return nextSibling;
        }
        return null;
    }

    private int findFirstGreaterOrEqual(List<Integer> sequence, int target) {
        int left = 0;
        int right = sequence.size() - 1;
        int resultIndex = -1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int midValue = sequence.get(mid);
            if (midValue >= target) {
                resultIndex = mid;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return resultIndex;
    }

    private int findFirstLessOrEqual(List<Integer> sequence, int target, int left) {
        int right = sequence.size() - 1;
        int resultIndex = -1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            int midValue = sequence.get(mid);
            if (midValue <= target) {
                resultIndex = mid;
                left = mid + 1;
                continue;
            }
            right = mid - 1;
        }
        return resultIndex;
    }

    private String replaceNewLineWithCRLF(String source, int index) {
        if (index < 0 || index >= source.length()) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source);
        char charAtIndex = source.charAt(index);
        if (charAtIndex != '\n') {
            return source;
        }
        sb.setCharAt(index, '\r');
        sb.insert(index + 1, '\n');
        return sb.toString();
    }

    @Nullable
    private static ASTNode getNodeOrNull(@Nullable PsiElement psiElement) {
        return psiElement != null ? psiElement.getNode() : null;
    }
}

