/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.internal;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBackingField;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtIntersectionType;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSelfType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.types.Variance;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.ImplicitReturn;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.kotlin.internal.KotlinSource;
import org.openrewrite.kotlin.internal.PsiElementAssociations;
import org.openrewrite.kotlin.marker.AnnotationCallSite;
import org.openrewrite.kotlin.marker.By;
import org.openrewrite.kotlin.marker.CheckNotNull;
import org.openrewrite.kotlin.marker.Extension;
import org.openrewrite.kotlin.marker.GenericType;
import org.openrewrite.kotlin.marker.Implicit;
import org.openrewrite.kotlin.marker.IndexedAccess;
import org.openrewrite.kotlin.marker.Infix;
import org.openrewrite.kotlin.marker.IsNullSafe;
import org.openrewrite.kotlin.marker.IsNullable;
import org.openrewrite.kotlin.marker.KObject;
import org.openrewrite.kotlin.marker.Modifier;
import org.openrewrite.kotlin.marker.NotIs;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.OmitEquals;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.marker.TrailingLambdaArgument;
import org.openrewrite.kotlin.marker.TypeReferencePrefix;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;

public class KotlinTreeParserVisitor
extends KtVisitor<J, ExecutionContext> {
    private final KotlinSource kotlinSource;
    private final PsiElementAssociations psiElementAssociations;
    private final List<NamedStyles> styles;
    private final Path sourcePath;
    @Nullable
    private final FileAttributes fileAttributes;
    private final Charset charset;
    private final Boolean charsetBomMarked;
    private final Stack<KtElement> ownerStack = new Stack();
    private final ExecutionContext executionContext;

    public KotlinTreeParserVisitor(KotlinSource kotlinSource, PsiElementAssociations psiElementAssociations, List<NamedStyles> styles, @Nullable Path relativeTo, ExecutionContext ctx) {
        this.kotlinSource = kotlinSource;
        this.psiElementAssociations = psiElementAssociations;
        this.styles = styles;
        this.sourcePath = kotlinSource.getInput().getRelativePath(relativeTo);
        this.fileAttributes = kotlinSource.getInput().getFileAttributes();
        EncodingDetectingInputStream stream = kotlinSource.getInput().getSource(ctx);
        this.charset = stream.getCharset();
        this.charsetBomMarked = stream.isCharsetBomMarked();
        this.ownerStack.push((KtElement)kotlinSource.getKtFile());
        this.executionContext = ctx;
    }

    public K.CompilationUnit parse() {
        return (K.CompilationUnit)this.visitKtFile(this.kotlinSource.getKtFile(), this.executionContext);
    }

    public J visitParenthesizedExpression(KtParenthesizedExpression expression, ExecutionContext data) {
        assert (expression.getExpression() != null);
        PsiElement rPar = expression.getLastChild();
        if (rPar == null || !")".equals(rPar.getText())) {
            throw new UnsupportedOperationException("TODO");
        }
        return new J.Parentheses(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padRight((J)expression.getExpression().accept((KtVisitor)this, (Object)data), this.prefix(rPar)));
    }

    public J visitForExpression(KtForExpression expression, ExecutionContext data) {
        return new J.ForEachLoop(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, new J.ForEachLoop.Control(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight((J.VariableDeclarations)expression.getLoopParameter().accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)expression.getLoopParameter())), this.padRight((Expression)((J)expression.getLoopRange().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getLoopRange().getParent())), this.suffix(expression.getLoopRange().getParent()))), this.padRight((Statement)((J)expression.getBody().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent())), this.suffix((PsiElement)expression.getBody())));
    }

    public J visitAnnotatedExpression(KtAnnotatedExpression expression, ExecutionContext data) {
        List ktAnnotations = expression.getAnnotationEntries();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(ktAnnotations.size());
        for (int i = 0; i < ktAnnotations.size(); ++i) {
            KtAnnotationEntry ktAnnotation = (KtAnnotationEntry)ktAnnotations.get(i);
            J.Annotation anno = (J.Annotation)ktAnnotation.accept((KtVisitor)this, (Object)data);
            if (i == 0) {
                anno = anno.withPrefix(this.merge(this.prefix((PsiElement)expression), anno.getPrefix()));
            }
            annotations.add(anno);
        }
        return new K.AnnotatedExpression(Tree.randomId(), Markers.EMPTY, annotations, (Expression)this.convertToExpression((J)expression.getBaseExpression().accept((KtVisitor)this, (Object)data)));
    }

    public J visitAnnotationUseSiteTarget(KtAnnotationUseSiteTarget annotationTarget, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitAnonymousInitializer(KtAnonymousInitializer initializer, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitArrayAccessExpression(KtArrayAccessExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        boolean hasExplicitReceiver = false;
        boolean implicitExtensionFunction = false;
        Expression selectExpr = (Expression)this.convertToExpression((J)expression.getArrayExpression().accept((KtVisitor)this, (Object)data));
        JRightPadded<Expression> select = this.padRight(selectExpr, this.suffix((PsiElement)expression.getArrayExpression()));
        JContainer typeParams = null;
        J.Identifier name = this.createIdentifier("get", Space.EMPTY, (JavaType)this.methodInvocationType((PsiElement)expression));
        markers = markers.addIfAbsent((Marker)new IndexedAccess(Tree.randomId()));
        List indexExpressions = expression.getIndexExpressions();
        ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>();
        for (KtExpression indexExp : indexExpressions) {
            expressions.add(this.padRight((Expression)this.convertToExpression((J)indexExp.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)indexExp)));
        }
        JContainer args = JContainer.build((Space)Space.EMPTY, expressions, (Markers)markers);
        return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, markers, select, typeParams, name, args, this.methodInvocationType((PsiElement)expression));
    }

    public J visitBackingField(KtBackingField accessor, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitBinaryWithTypeRHSExpression(KtBinaryExpressionWithTypeRHS expression, ExecutionContext data) {
        IElementType type = expression.getOperationReference().getReferencedNameElementType();
        if (type == KtTokens.AS_KEYWORD || type == KtTokens.AS_SAFE) {
            J clazz = ((J)expression.getRight().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getRight()));
            Markers markers = Markers.EMPTY;
            if (type == KtTokens.AS_SAFE) {
                markers = markers.addIfAbsent((Marker)new IsNullSafe(Tree.randomId(), Space.EMPTY));
            }
            return new J.TypeCast(Tree.randomId(), this.prefix((PsiElement)expression), markers, new J.ControlParentheses(Tree.randomId(), this.suffix((PsiElement)expression.getLeft()), Markers.EMPTY, JRightPadded.build((Object)clazz)), (Expression)this.convertToExpression((J)expression.getLeft().accept((KtVisitor)this, (Object)data)));
        }
        throw new UnsupportedOperationException("TODO");
    }

    public J visitBlockStringTemplateEntry(KtBlockStringTemplateEntry entry, ExecutionContext data) {
        J tree = (J)entry.getExpression().accept((KtVisitor)this, (Object)data);
        boolean inBraces = true;
        return new K.KString.Value(Tree.randomId(), Space.EMPTY, Markers.EMPTY, tree, this.suffix((PsiElement)entry.getExpression()), inBraces);
    }

    public J visitBreakExpression(KtBreakExpression expression, ExecutionContext data) {
        return new J.Break(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(expression.getTargetLabel().getIdentifier(), null) : null);
    }

    public J visitCallableReferenceExpression(KtCallableReferenceExpression expression, ExecutionContext data) {
        FirResolvedCallableReference reference = (FirResolvedCallableReference)this.psiElementAssociations.primary((PsiElement)expression.getCallableReference());
        JavaType.Method methodReferenceType = null;
        if (reference.getResolvedSymbol() instanceof FirNamedFunctionSymbol) {
            methodReferenceType = this.psiElementAssociations.getTypeMapping().methodDeclarationType((FirFunction)((FirNamedFunctionSymbol)reference.getResolvedSymbol()).getFir(), TypeUtils.asFullyQualified((JavaType)this.type((KtElement)expression.getReceiverExpression())), this.owner((PsiElement)expression));
        }
        JavaType.Variable fieldReferenceType = null;
        if (reference.getResolvedSymbol() instanceof FirPropertySymbol) {
            fieldReferenceType = this.psiElementAssociations.getTypeMapping().variableType((FirVariableSymbol<? extends FirVariable>)((FirVariableSymbol)reference.getResolvedSymbol()), (JavaType)TypeUtils.asFullyQualified((JavaType)this.type((KtElement)expression.getReceiverExpression())), this.owner((PsiElement)expression));
        }
        Object receiver = expression.getReceiverExpression() == null ? this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.prefix(expression.findColonColon())) : this.padRight((Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data)), this.prefix(expression.findColonColon()));
        return new J.MemberReference(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, receiver, null, this.padLeft(this.prefix(expression.getLastChild()), (J.Identifier)((J)expression.getCallableReference().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY)), this.type((KtElement)expression.getCallableReference()), methodReferenceType, fieldReferenceType);
    }

    public J visitCatchSection(KtCatchClause catchClause, ExecutionContext data) {
        J.VariableDeclarations paramDecl = (J.VariableDeclarations)catchClause.getCatchParameter().accept((KtVisitor)this, (Object)data);
        J.ControlParentheses param = new J.ControlParentheses(Tree.randomId(), this.prefix((PsiElement)catchClause.getParameterList()), Markers.EMPTY, this.padRight(paramDecl, this.prefix(catchClause.getParameterList().getRightParenthesis())));
        J.Block body = (J.Block)catchClause.getCatchBody().accept((KtVisitor)this, (Object)data);
        return new J.Try.Catch(Tree.randomId(), this.prefix((PsiElement)catchClause), Markers.EMPTY, param, body);
    }

    public J visitClassInitializer(KtClassInitializer initializer, ExecutionContext data) {
        J.Block staticInit = (J.Block)((J)initializer.getBody().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)initializer));
        staticInit = staticInit.getPadding().withStatic(this.padRight(true, this.prefix((PsiElement)initializer.getBody())));
        return staticInit;
    }

    public J visitClassLiteralExpression(KtClassLiteralExpression expression, ExecutionContext data) {
        return new J.MemberReference(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data)), this.prefix(expression.findColonColon())), null, this.padLeft(this.prefix(expression.getLastChild()), this.createIdentifier("class", Space.EMPTY, null)), this.type((KtElement)expression), null, null);
    }

    public J visitClassOrObject(KtClassOrObject classOrObject, ExecutionContext data) {
        throw new IllegalArgumentException("Unsupported declaration: " + classOrObject.getText());
    }

    public J visitCollectionLiteralExpression(KtCollectionLiteralExpression expression, ExecutionContext data) {
        JContainer elements;
        if (expression.getInnerExpressions().isEmpty()) {
            elements = JContainer.build(Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.prefix(expression.getRightBracket()))));
        } else {
            List<Object> rps = new ArrayList<JRightPadded<Expression>>(expression.getInnerExpressions().size());
            for (KtExpression ktExpression : expression.getInnerExpressions()) {
                rps.add(this.padRight((Expression)this.convertToExpression((J)ktExpression.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktExpression)));
            }
            if (expression.getTrailingComma() != null) {
                rps = ListUtils.mapLast(rps, rp -> rp.withMarkers(rp.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(expression.getTrailingComma())))));
            }
            elements = JContainer.build((Space)Space.EMPTY, rps, (Markers)Markers.EMPTY);
        }
        return new K.ListLiteral(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (JContainer<Expression>)elements, this.type((KtElement)expression));
    }

    public J visitConstructorCalleeExpression(KtConstructorCalleeExpression constructorCalleeExpression, ExecutionContext data) {
        J j = (J)constructorCalleeExpression.getTypeReference().accept((KtVisitor)this, (Object)data);
        return j.withPrefix(this.merge(j.getPrefix(), this.prefix((PsiElement)constructorCalleeExpression)));
    }

    public J visitConstructorDelegationCall(KtConstructorDelegationCall call, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitContextReceiverList(KtContextReceiverList contextReceiverList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitContinueExpression(KtContinueExpression expression, ExecutionContext data) {
        return new J.Continue(Tree.randomId(), this.prefix(expression.getParent()), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(expression.getTargetLabel().getIdentifier(), null) : null);
    }

    public J visitDeclaration(KtDeclaration dcl, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitDelegatedSuperTypeEntry(KtDelegatedSuperTypeEntry specifier, ExecutionContext data) {
        TypeTree element = (TypeTree)specifier.getTypeReference().accept((KtVisitor)this, (Object)data);
        Expression expr = (Expression)this.convertToExpression((J)specifier.getDelegateExpression().accept((KtVisitor)this, (Object)data));
        return new K.DelegatedSuperType(Tree.randomId(), Markers.EMPTY, element, this.suffix((PsiElement)specifier.getTypeReference()), expr).withPrefix(this.prefix((PsiElement)specifier));
    }

    public J visitDestructuringDeclarationEntry(KtDestructuringDeclarationEntry multiDeclarationEntry, ExecutionContext data) {
        return this.createIdentifier((PsiElement)multiDeclarationEntry, this.type((KtElement)multiDeclarationEntry)).withPrefix(this.prefix((PsiElement)multiDeclarationEntry));
    }

    public J visitDoubleColonExpression(KtDoubleColonExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitDoWhileExpression(KtDoWhileExpression expression, ExecutionContext data) {
        return new J.DoWhileLoop(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, JRightPadded.build((Object)((Statement)((J)expression.getBody().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent())))), this.padLeft(this.prefix(expression.getWhileKeyword()), this.mapControlParentheses(expression.getCondition(), data).withPrefix(this.prefix(expression.getLeftParenthesis()))));
    }

    private J.ControlParentheses<Expression> mapControlParentheses(KtExpression expression, ExecutionContext data) {
        return new J.ControlParentheses(Tree.randomId(), this.prefix(expression.getParent()), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)expression.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getParent())), this.suffix(expression.getParent())));
    }

    public J visitDynamicType(KtDynamicType type, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitEnumEntry(KtEnumEntry enumEntry, ExecutionContext data) {
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        if (!enumEntry.getAnnotationEntries().isEmpty()) {
            this.mapModifiers(enumEntry.getModifierList(), annotations, Collections.emptyList(), data);
        }
        J.Identifier name = this.createIdentifier(enumEntry.getNameIdentifier(), this.type((KtElement)enumEntry));
        J.NewClass initializer = null;
        if (enumEntry.getInitializerList() != null) {
            initializer = (J.NewClass)enumEntry.getInitializerList().accept((KtVisitor)this, (Object)data);
        }
        if (enumEntry.getBody() != null) {
            Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId()));
            JContainer args = JContainer.empty();
            args = args.withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
            J.Block body = (J.Block)((J)enumEntry.getBody().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
            initializer = new J.NewClass(Tree.randomId(), this.prefix((PsiElement)enumEntry.getBody()), markers, null, Space.EMPTY, null, args, body, null);
        }
        return new J.EnumValue(Tree.randomId(), this.prefix((PsiElement)enumEntry), Markers.EMPTY, annotations, name, initializer);
    }

    public J visitEscapeStringTemplateEntry(KtEscapeStringTemplateEntry entry, ExecutionContext data) {
        throw new UnsupportedOperationException("Not required");
    }

    public J visitExpression(KtExpression expression, ExecutionContext data) {
        if (expression instanceof KtFunctionLiteral) {
            KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)expression;
            Markers markers = Markers.EMPTY;
            ktFunctionLiteral.getLBrace();
            boolean hasBraces = true;
            boolean omitDestruct = false;
            List valueParameters = ktFunctionLiteral.getValueParameters();
            ArrayList<Object> valueParams = new ArrayList<Object>(valueParameters.size());
            if (!valueParameters.isEmpty()) {
                for (int i = 0; i < valueParameters.size(); ++i) {
                    KtParameter ktParameter = (KtParameter)valueParameters.get(i);
                    J expr = ((J)ktParameter.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)ktParameter));
                    valueParams.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight(expr, this.suffix((PsiElement)ktParameter)), i == valueParameters.size() - 1));
                }
            } else if (ktFunctionLiteral.getArrow() != null) {
                valueParams.add(this.padRight(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), Space.EMPTY));
            }
            J.Lambda.Parameters params = new J.Lambda.Parameters(Tree.randomId(), this.prefix((PsiElement)ktFunctionLiteral.getValueParameterList()), Markers.EMPTY, false, valueParams);
            J.Block body = (J.Block)((J)ktFunctionLiteral.getBodyExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)ktFunctionLiteral.getBodyExpression()));
            body = body.withEnd(this.prefix(ktFunctionLiteral.getRBrace()));
            return new J.Lambda(Tree.randomId(), this.prefix((PsiElement)expression), markers, params, this.prefix(ktFunctionLiteral.getArrow()), (J)body, null);
        }
        throw new UnsupportedOperationException("TODO");
    }

    public J visitExpressionWithLabel(KtExpressionWithLabel expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitFileAnnotationList(KtFileAnnotationList fileAnnotationList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitFinallySection(KtFinallySection finallySection, ExecutionContext data) {
        return (J)finallySection.getFinalExpression().accept((KtVisitor)this, (Object)data);
    }

    public J visitFunctionType(KtFunctionType type, ExecutionContext data) {
        List parameters;
        List<Object> params;
        if (type.getParameters().isEmpty()) {
            params = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), this.prefix(type.getParameterList().getNode().findChildByType((IElementType)KtTokens.RPAR).getPsi()), Markers.EMPTY)).withAfter(Space.EMPTY));
        } else {
            params = new ArrayList();
            parameters = type.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                KtParameter ktParameter = (KtParameter)parameters.get(i);
                TypeTree typeTree = ktParameter.getNameIdentifier() != null ? new K.FunctionType.Parameter(Tree.randomId(), Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(ktParameter.getColon()))), this.createIdentifier(ktParameter.getNameIdentifier(), null), (TypeTree)ktParameter.getTypeReference().accept((KtVisitor)this, (Object)data)) : (TypeTree)ktParameter.getTypeReference().accept((KtVisitor)this, (Object)data);
                params.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight((TypeTree)typeTree.withPrefix(this.prefix((PsiElement)ktParameter)), this.suffix((PsiElement)ktParameter)), i == parameters.size() - 1));
            }
        }
        parameters = JContainer.build((Space)this.prefix((PsiElement)type.getParameterList()), params, (Markers)Markers.EMPTY);
        if (type.getFirstChild() == type.getParameterList()) {
            parameters = parameters.withBefore(this.prefix((PsiElement)type));
        }
        return new K.FunctionType(Tree.randomId(), this.prefix((PsiElement)type), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), type.getReceiver() != null ? this.padRight((NameTree)type.getReceiverTypeReference().accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)type.getReceiver())) : null, (JContainer<TypeTree>)parameters, this.suffix((PsiElement)type.getParameterList()), (TypedTree)((J)type.getReturnTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)type.getReturnTypeReference())));
    }

    public J visitImportAlias(KtImportAlias importAlias, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitImportList(KtImportList importList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitInitializerList(KtInitializerList list, ExecutionContext data) {
        JContainer args;
        List entries = list.getInitializers();
        if (entries.size() > 1) {
            throw new UnsupportedOperationException("TODO");
        }
        if (!(entries.get(0) instanceof KtSuperTypeCallEntry)) {
            throw new UnsupportedOperationException("TODO");
        }
        TypeTree clazz = null;
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId()));
        KtSuperTypeCallEntry superTypeCallEntry = (KtSuperTypeCallEntry)entries.get(0);
        J.Identifier typeTree = (J.Identifier)superTypeCallEntry.getCalleeExpression().accept((KtVisitor)this, (Object)data);
        if (!superTypeCallEntry.getValueArguments().isEmpty()) {
            ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(superTypeCallEntry.getValueArguments().size());
            for (ValueArgument valueArgument : superTypeCallEntry.getValueArguments()) {
                if (!(valueArgument instanceof KtValueArgument)) {
                    throw new UnsupportedOperationException("TODO");
                }
                KtValueArgument ktValueArgument = (KtValueArgument)valueArgument;
                expressions.add(this.padRight((Expression)this.convertToExpression((J)ktValueArgument.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktValueArgument)));
            }
            args = JContainer.build((Space)this.prefix((PsiElement)superTypeCallEntry.getValueArgumentList()), expressions, (Markers)Markers.EMPTY);
        } else {
            KtValueArgumentList ktArgList = superTypeCallEntry.getValueArgumentList();
            args = JContainer.build((Space)this.prefix((PsiElement)ktArgList), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(ktArgList.getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)markers);
        }
        return new J.NewClass(Tree.randomId(), this.prefix((PsiElement)list), markers, null, Space.EMPTY, clazz, args, null, null);
    }

    public J visitIntersectionType(KtIntersectionType definitelyNotNullType, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitIsExpression(KtIsExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        Expression element = (Expression)this.convertToExpression((J)expression.getLeftHandSide().accept((KtVisitor)this, (Object)data));
        if (expression.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IS) {
            markers = markers.addIfAbsent((Marker)new NotIs(Tree.randomId()));
        }
        J clazz = (J)expression.getTypeReference().accept((KtVisitor)this, (Object)data);
        return new J.InstanceOf(Tree.randomId(), this.prefix((PsiElement)expression), markers, this.padRight(element, this.prefix((PsiElement)expression.getOperationReference())), clazz, null, this.type((KtElement)expression));
    }

    public J visitLabeledExpression(KtLabeledExpression expression, ExecutionContext data) {
        J j = (J)expression.getBaseExpression().accept((KtVisitor)this, (Object)data);
        return new J.Label(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padRight(this.createIdentifier(expression.getNameIdentifier(), null), this.suffix(expression.getNameIdentifier())), this.convertToStatement(j));
    }

    public J visitLambdaExpression(KtLambdaExpression expression, ExecutionContext data) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        return ((J)functionLiteral.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression));
    }

    public J visitLiteralStringTemplateEntry(KtLiteralStringTemplateEntry entry, ExecutionContext data) {
        PsiElement leaf = entry.getFirstChild();
        if (!(leaf instanceof LeafPsiElement)) {
            throw new UnsupportedOperationException("Unsupported KtStringTemplateEntry child");
        }
        boolean quoted = entry.getPrevSibling().getNode().getElementType() == KtTokens.OPEN_QUOTE && entry.getNextSibling().getNode().getElementType() == KtTokens.CLOSING_QUOTE;
        String valueSource = quoted ? "\"" + leaf.getText() + "\"" : leaf.getText();
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)leaf.getText(), valueSource, null, JavaType.Primitive.String);
    }

    public J visitLoopExpression(KtLoopExpression loopExpression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitModifierList(KtModifierList list, ExecutionContext data) {
        throw new UnsupportedOperationException("Use mapModifiers instead");
    }

    public J visitNamedDeclaration(KtNamedDeclaration declaration, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitNullableType(KtNullableType nullableType, ExecutionContext data) {
        J j = (J)nullableType.getInnerType().accept((KtVisitor)this, (Object)data);
        return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new IsNullable(Tree.randomId(), this.suffix((PsiElement)nullableType.getInnerType()))));
    }

    public J visitParameter(KtParameter parameter, ExecutionContext data) {
        int modifierOffset;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        TypeTree typeExpression = null;
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(1);
        if (!parameter.getAnnotations().isEmpty()) {
            throw new UnsupportedOperationException("TODO");
        }
        int valOrVarOffset = parameter.getValOrVarKeyword() != null ? parameter.getValOrVarKeyword().getTextOffset() : -1;
        int n = modifierOffset = parameter.getModifierList() != null ? parameter.getModifierList().getTextOffset() : -1;
        if (valOrVarOffset < modifierOffset) {
            if (parameter.getValOrVarKeyword() != null) {
                modifiers.add(this.mapModifier(parameter.getValOrVarKeyword(), Collections.emptyList()));
            }
            if (parameter.getModifierList() != null) {
                modifiers.addAll(this.mapModifiers(parameter.getModifierList(), leadingAnnotations, lastAnnotations, data));
            }
        } else {
            if (parameter.getModifierList() != null) {
                modifiers.addAll(this.mapModifiers(parameter.getModifierList(), leadingAnnotations, lastAnnotations, data));
            }
            if (parameter.getValOrVarKeyword() != null) {
                modifiers.add(this.mapModifier(parameter.getValOrVarKeyword(), Collections.emptyList()));
            }
        }
        if (parameter.getDestructuringDeclaration() != null) {
            return this.mapDestructuringDeclaration(parameter.getDestructuringDeclaration(), data).withPrefix(this.prefix((PsiElement)parameter));
        }
        J.Identifier name = this.createIdentifier(parameter.getNameIdentifier(), this.type((KtElement)parameter));
        if (parameter.getTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(parameter.getColon())));
            typeExpression = (TypeTree)((J)parameter.getTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)parameter.getTypeReference()));
        }
        JLeftPadded<Expression> initializer = parameter.getDefaultValue() != null ? this.padLeft(this.prefix(parameter.getEqualsToken()), (Expression)parameter.getDefaultValue().accept((KtVisitor)this, (Object)data)) : null;
        J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), initializer, name.getFieldType());
        vars.add(this.padRight(namedVariable, Space.EMPTY));
        return new J.VariableDeclarations(Tree.randomId(), this.prefix((PsiElement)parameter), markers, leadingAnnotations, modifiers, typeExpression, null, Collections.emptyList(), vars);
    }

    public J visitParameterList(KtParameterList list, ExecutionContext data) {
        throw new UnsupportedOperationException("Unsupport, use mapParameters() instead");
    }

    public J visitPrimaryConstructor(KtPrimaryConstructor constructor, ExecutionContext data) {
        ArrayList<Object> statements;
        if (constructor.getBodyExpression() != null) {
            throw new UnsupportedOperationException("TODO");
        }
        ArrayList leadingAnnotations = new ArrayList();
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        if (constructor.getModifierList() != null) {
            KtModifierList ktModifierList = constructor.getModifierList();
            modifiers.addAll(this.mapModifiers(ktModifierList, Collections.emptyList(), Collections.emptyList(), data));
        }
        if (constructor.getConstructorKeyword() != null) {
            modifiers.add(this.mapModifier(constructor.getConstructorKeyword(), Collections.emptyList()));
        }
        JavaType.Method type = this.methodDeclarationType((PsiElement)constructor);
        J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "<constructor>", (JavaType)type, null);
        if (constructor.getValueParameterList() != null) {
            List ktParameters = constructor.getValueParameters();
            statements = new ArrayList<Object>(ktParameters.size());
            for (int i = 0; i < ktParameters.size(); ++i) {
                KtParameter ktParameter = (KtParameter)ktParameters.get(i);
                Statement statement = this.convertToStatement((J)ktParameter.accept((KtVisitor)this, (Object)data));
                statements.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight(statement, this.suffix((PsiElement)ktParameter)), i == ktParameters.size() - 1));
            }
            if (ktParameters.isEmpty()) {
                J.Empty param = new J.Empty(Tree.randomId(), this.prefix(constructor.getValueParameterList().getRightParenthesis()), Markers.EMPTY);
                statements.add(this.padRight(param, Space.EMPTY));
            }
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        JContainer params = JContainer.build((Space)this.prefix((PsiElement)constructor.getValueParameterList()), statements, (Markers)Markers.EMPTY);
        return new J.MethodDeclaration(Tree.randomId(), this.prefix((PsiElement)constructor), Markers.build(Collections.singletonList(new PrimaryConstructor(Tree.randomId()))), leadingAnnotations, modifiers, null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name.withMarkers(name.getMarkers().addIfAbsent((Marker)new Implicit(Tree.randomId()))), Collections.emptyList()), params, null, null, null, type);
    }

    public J visitPropertyAccessor(KtPropertyAccessor accessor, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(accessor.getModifierList(), leadingAnnotations, Collections.emptyList(), data);
        J.TypeParameters typeParameters = null;
        TypeTree returnTypeExpression = null;
        ArrayList lastAnnotations = new ArrayList();
        J.Identifier name = null;
        JContainer params = null;
        J.Block body = null;
        JavaType.Method type = this.methodDeclarationType((PsiElement)accessor);
        name = this.createIdentifier(accessor.getNamePlaceholder().getText(), this.prefix(accessor.getNamePlaceholder()), (JavaType)type);
        List ktParameters = accessor.getValueParameters();
        if (!ktParameters.isEmpty()) {
            if (ktParameters.size() != 1) {
                throw new UnsupportedOperationException("TODO");
            }
            ArrayList<JRightPadded<Statement>> parameters = new ArrayList<JRightPadded<Statement>>();
            for (KtParameter ktParameter : ktParameters) {
                Statement stmt = this.convertToStatement(((J)ktParameter.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(ktParameter.getParent())));
                parameters.add(this.padRight(stmt, this.prefix(accessor.getRightParenthesis())));
            }
            params = JContainer.build((Space)this.prefix(accessor.getLeftParenthesis()), parameters, (Markers)Markers.EMPTY);
        } else {
            params = JContainer.build((Space)this.prefix(accessor.getLeftParenthesis()), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(accessor.getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        }
        if (accessor.getReturnTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.suffix(accessor.getRightParenthesis())));
            returnTypeExpression = (TypeTree)((J)accessor.getReturnTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)accessor.getReturnTypeReference()));
        }
        if (accessor.getBodyBlockExpression() != null) {
            body = (J.Block)((J)accessor.getBodyBlockExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)accessor.getBodyBlockExpression()));
        } else if (accessor.getBodyExpression() != null) {
            body = this.convertToBlock(accessor.getBodyExpression(), data).withPrefix(this.prefix(accessor.getEqualsToken()));
        } else {
            params = JContainer.empty();
            params = params.withBefore(Space.EMPTY).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
        }
        return new J.MethodDeclaration(Tree.randomId(), this.prefix((PsiElement)accessor), markers, leadingAnnotations, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, lastAnnotations), params, null, body, null, type);
    }

    public J visitQualifiedExpression(KtQualifiedExpression expression, ExecutionContext data) {
        Expression receiver = (Expression)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data);
        Expression selector = (Expression)expression.getSelectorExpression().accept((KtVisitor)this, (Object)data);
        if (selector instanceof J.MethodInvocation) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)selector;
            return methodInvocation.getPadding().withSelect(this.padRight(receiver, this.suffix((PsiElement)expression.getReceiverExpression()))).withName(methodInvocation.getName().withPrefix(this.prefix((PsiElement)expression.getSelectorExpression())));
        }
        J.Identifier identifier = (J.Identifier)selector;
        return new J.FieldAccess(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, receiver, this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), identifier), this.type((KtElement)expression));
    }

    public J visitReferenceExpression(KtReferenceExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitReturnExpression(KtReturnExpression expression, ExecutionContext data) {
        KtExpression returnedExpression = expression.getReturnedExpression();
        Expression returnExpr = returnedExpression != null ? (Expression)this.convertToExpression(((J)returnedExpression.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)returnedExpression))) : null;
        return new K.KReturn(Tree.randomId(), new J.Return(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, returnExpr), expression.getTargetLabel() != null ? this.createIdentifier(expression.getTargetLabel().getIdentifier(), null) : null);
    }

    public J visitSafeQualifiedExpression(KtSafeQualifiedExpression expression, ExecutionContext data) {
        J j = this.visitQualifiedExpression((KtQualifiedExpression)expression, data);
        ASTNode safeAccess = expression.getNode().findChildByType((IElementType)KtTokens.SAFE_ACCESS);
        return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new IsNullSafe(Tree.randomId(), this.prefix(safeAccess.getPsi()))));
    }

    public J visitScript(KtScript script, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitScriptInitializer(KtScriptInitializer initializer, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitSecondaryConstructor(KtSecondaryConstructor constructor, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(constructor.getModifierList(), leadingAnnotations, lastAnnotations, data);
        modifiers.add(this.mapModifier(constructor.getConstructorKeyword(), Collections.emptyList()));
        JavaType.Method type = this.methodDeclarationType((PsiElement)constructor);
        J.Identifier name = this.createIdentifier(constructor.getName(), Space.EMPTY, (JavaType)type);
        List<JRightPadded<Statement>> statements = this.mapParameters(constructor.getValueParameterList(), data);
        JContainer params = JContainer.build((Space)this.prefix((PsiElement)constructor.getValueParameterList()), statements, (Markers)Markers.EMPTY);
        J.Identifier delegateName = this.createIdentifier((PsiElement)constructor.getDelegationCall().getCalleeExpression(), this.type((KtElement)constructor.getDelegationCall().getCalleeExpression()));
        JContainer<Expression> args = this.mapFunctionCallArguments(constructor.getDelegationCall().getValueArgumentList(), data);
        K.ConstructorInvocation delegationCall = new K.ConstructorInvocation(Tree.randomId(), this.prefix((PsiElement)constructor.getDelegationCall()), Markers.EMPTY, (TypeTree)delegateName, args);
        J.Block body = null;
        if (constructor.getBodyExpression() != null) {
            body = (J.Block)constructor.getBodyExpression().accept((KtVisitor)this, (Object)data);
        }
        J.MethodDeclaration methodDeclaration = new J.MethodDeclaration(Tree.randomId(), this.prefix((PsiElement)constructor), markers, leadingAnnotations, modifiers, null, null, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, type);
        return new K.Constructor(Tree.randomId(), Markers.EMPTY, methodDeclaration, this.prefix(constructor.getColon()), delegationCall);
    }

    public J visitSelfType(KtSelfType type, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitSimpleNameStringTemplateEntry(KtSimpleNameStringTemplateEntry entry, ExecutionContext data) {
        return new K.KString.Value(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (J)entry.getExpression().accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)entry.getExpression()), false);
    }

    public J visitStringTemplateEntryWithExpression(KtStringTemplateEntryWithExpression entry, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitSuperExpression(KtSuperExpression expression, ExecutionContext data) {
        return this.createIdentifier((PsiElement)expression, this.type((KtElement)expression)).withPrefix(this.prefix((PsiElement)expression));
    }

    public J visitSuperTypeEntry(KtSuperTypeEntry specifier, ExecutionContext data) {
        J j = (J)specifier.getTypeReference().accept((KtVisitor)this, (Object)data);
        return j.withPrefix(this.merge(this.prefix((PsiElement)specifier), j.getPrefix()));
    }

    public J visitSuperTypeListEntry(KtSuperTypeListEntry specifier, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitThisExpression(KtThisExpression expression, ExecutionContext data) {
        return new K.KThis(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, expression.getTargetLabel() != null ? this.createIdentifier(expression.getTargetLabel().getIdentifier(), null) : null, this.type((KtElement)expression));
    }

    public J visitThrowExpression(KtThrowExpression expression, ExecutionContext data) {
        return new J.Throw(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (Expression)this.convertToExpression((J)expression.getThrownExpression().accept((KtVisitor)this, (Object)data)));
    }

    public J visitTryExpression(KtTryExpression expression, ExecutionContext data) {
        List ktCatchClauses = expression.getCatchClauses();
        J.Block block = (J.Block)expression.getTryBlock().accept((KtVisitor)this, (Object)data);
        ArrayList<J.Try.Catch> catches = new ArrayList<J.Try.Catch>(ktCatchClauses.size());
        JLeftPadded<J.Block> finallyBlock = null;
        for (KtCatchClause catchClause : ktCatchClauses) {
            catches.add((J.Try.Catch)catchClause.accept((KtVisitor)this, (Object)data));
        }
        if (expression.getFinallyBlock() != null) {
            finallyBlock = this.padLeft(this.prefix((PsiElement)expression.getFinallyBlock()), (J.Block)expression.getFinallyBlock().accept((KtVisitor)this, (Object)data));
        }
        return new J.Try(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, null, block, catches, finallyBlock);
    }

    public J visitTypeAlias(KtTypeAlias typeAlias, ExecutionContext data) {
        J.Identifier name;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(typeAlias.getTypeAliasKeyword()), markers, "typealias", J.Modifier.Type.LanguageExtension, Collections.emptyList()));
        this.mapModifiers(typeAlias.getModifierList(), leadingAnnotations, lastAnnotations, data);
        if (typeAlias.getIdentifyingElement() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        J.Identifier typeExpression = name = this.createIdentifier(typeAlias.getIdentifyingElement(), this.type((KtElement)typeAlias.getTypeReference()));
        if (typeAlias.getTypeParameterList() != null && (typeExpression = (TypeTree)typeAlias.getTypeParameterList().accept((KtVisitor)this, (Object)data)) instanceof J.ParameterizedType) {
            Space prefix = name.getPrefix();
            typeExpression = ((J.ParameterizedType)typeExpression).withClazz((NameTree)name.withPrefix(Space.EMPTY).withPrefix(prefix));
        }
        Expression expr = (Expression)this.convertToExpression((J)typeAlias.getTypeReference().accept((KtVisitor)this, (Object)data));
        JRightPadded<J.VariableDeclarations.NamedVariable> namedVariable = this.padRight(new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.createIdentifier("", Space.EMPTY, null, null), Collections.emptyList(), this.padLeft(this.prefix(typeAlias.getNode().findChildByType((IElementType)KtTokens.EQ).getPsi()), expr), null), Space.EMPTY);
        List<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = Collections.singletonList(namedVariable);
        return new J.VariableDeclarations(Tree.randomId(), this.prefix((PsiElement)typeAlias), markers, leadingAnnotations, modifiers, (TypeTree)typeExpression, null, Collections.emptyList(), vars);
    }

    public J visitTypeArgumentList(KtTypeArgumentList typeArgumentList, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitTypeConstraint(KtTypeConstraint constraint, ExecutionContext data) {
        ArrayList annotations = new ArrayList();
        J.Identifier typeParamName = (J.Identifier)constraint.getSubjectTypeParameterName().accept((KtVisitor)this, (Object)data);
        TypeTree typeTree = (TypeTree)constraint.getBoundTypeReference().accept((KtVisitor)this, (Object)data);
        return new J.TypeParameter(Tree.randomId(), this.prefix((PsiElement)constraint), Markers.EMPTY.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.suffix((PsiElement)constraint.getSubjectTypeParameterName()))), annotations, (Expression)typeParamName, JContainer.build((Space)Space.EMPTY, Collections.singletonList(this.padRight(typeTree, null)), (Markers)Markers.EMPTY));
    }

    public J visitTypeConstraintList(KtTypeConstraintList list, ExecutionContext data) {
        List ktTypeConstraints = list.getConstraints();
        ArrayList<JRightPadded<J.TypeParameter>> params = new ArrayList<JRightPadded<J.TypeParameter>>(ktTypeConstraints.size());
        for (KtTypeConstraint ktTypeConstraint : ktTypeConstraints) {
            params.add(this.padRight((J.TypeParameter)ktTypeConstraint.accept((KtVisitor)this, (Object)data), this.suffix((PsiElement)ktTypeConstraint)));
        }
        return new K.TypeConstraints(Tree.randomId(), Markers.EMPTY, (JContainer<J.TypeParameter>)JContainer.build((Space)this.prefix((PsiElement)list), params, (Markers)Markers.EMPTY));
    }

    public J visitTypeParameter(KtTypeParameter parameter, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        J.Identifier name = null;
        JContainer bounds = null;
        if (parameter.getNameIdentifier() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        this.mapModifiers(parameter.getModifierList(), annotations, Collections.emptyList(), data);
        if (parameter.getVariance() == Variance.INVARIANT) {
            if (parameter.getModifierList() != null && parameter.getModifierList().hasModifier(KtTokens.REIFIED_KEYWORD)) {
                PsiElement reifiedKeyword = parameter.getModifierList().getModifier(KtTokens.REIFIED_KEYWORD);
                J.Annotation reified = new J.Annotation(Tree.randomId(), this.prefix(reifiedKeyword), Markers.EMPTY.addIfAbsent((Marker)new Modifier(Tree.randomId())), (NameTree)this.createIdentifier("reified", Space.EMPTY, null, null), JContainer.empty());
                annotations.add(reified);
            }
            name = this.createIdentifier(parameter.getNameIdentifier(), this.type((KtElement)parameter));
            if (parameter.getExtendsBound() != null) {
                bounds = JContainer.build((Space)this.suffix(parameter.getNameIdentifier()), Collections.singletonList(this.padRight((TypeTree)((J)parameter.getExtendsBound().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)parameter.getExtendsBound())), Space.EMPTY)), (Markers)Markers.EMPTY);
            }
        } else if (parameter.getVariance() == Variance.IN_VARIANCE || parameter.getVariance() == Variance.OUT_VARIANCE) {
            GenericType.Variance variance = parameter.getVariance() == Variance.IN_VARIANCE ? GenericType.Variance.CONTRAVARIANT : GenericType.Variance.COVARIANT;
            markers = markers.addIfAbsent((Marker)new GenericType(Tree.randomId(), variance));
            name = this.createIdentifier("<Any>", Space.EMPTY, null).withMarkers(Markers.build(Collections.singletonList(new Implicit(Tree.randomId()))));
            KtModifierKeywordToken varianceKeyword = parameter.getVariance() == Variance.IN_VARIANCE ? KtTokens.IN_KEYWORD : KtTokens.OUT_KEYWORD;
            PsiElement varianceKeywordPsi = parameter.getModifierList().getModifier(varianceKeyword);
            bounds = JContainer.build((Space)this.prefix(varianceKeywordPsi), Collections.singletonList(this.padRight(this.createIdentifier(parameter.getNameIdentifier(), this.type((KtElement)parameter)), Space.EMPTY)), (Markers)Markers.EMPTY);
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        return new J.TypeParameter(Tree.randomId(), this.prefix((PsiElement)parameter), markers, annotations, (Expression)name, bounds);
    }

    public J visitTypeParameterList(KtTypeParameterList list, ExecutionContext data) {
        List ktTypeParameters = list.getParameters();
        ArrayList<JRightPadded<J.Identifier>> expressions = new ArrayList<JRightPadded<J.Identifier>>(ktTypeParameters.size());
        for (KtTypeParameter ktTypeParameter : ktTypeParameters) {
            J.Identifier name = this.createIdentifier((PsiElement)ktTypeParameter, this.type((KtElement)ktTypeParameter));
            expressions.add(this.padRight(name, this.suffix((PsiElement)ktTypeParameter)));
        }
        JContainer typeParameters = JContainer.build((Space)this.prefix((PsiElement)list), expressions, (Markers)Markers.EMPTY);
        return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, typeParameters, null);
    }

    public J visitTypeProjection(KtTypeProjection typeProjection, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        JContainer bounds = null;
        Expression name = null;
        switch (typeProjection.getProjectionKind()) {
            case IN: {
                markers = markers.addIfAbsent((Marker)new GenericType(Tree.randomId(), GenericType.Variance.CONTRAVARIANT));
                bounds = JContainer.build((Space)this.prefix(typeProjection.getProjectionToken()), Collections.singletonList(this.padRight((TypeTree)((J)typeProjection.getTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)typeProjection.getTypeReference())), Space.EMPTY)), (Markers)Markers.EMPTY);
                break;
            }
            case OUT: {
                markers = markers.addIfAbsent((Marker)new GenericType(Tree.randomId(), GenericType.Variance.COVARIANT));
                bounds = JContainer.build((Space)this.prefix(typeProjection.getProjectionToken()), Collections.singletonList(this.padRight((TypeTree)((J)typeProjection.getTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)typeProjection.getTypeReference())), Space.EMPTY)), (Markers)Markers.EMPTY);
                break;
            }
            case STAR: {
                return new J.Wildcard(Tree.randomId(), this.prefix((PsiElement)typeProjection), Markers.EMPTY, null, null);
            }
            default: {
                name = (Expression)((J)typeProjection.getTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)typeProjection));
            }
        }
        return name != null ? name : new K.TypeParameterExpression(Tree.randomId(), new J.TypeParameter(Tree.randomId(), this.prefix((PsiElement)typeProjection), markers, Collections.emptyList(), (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(new Implicit(Tree.randomId()))), Collections.emptyList(), "Any", null, null), bounds));
    }

    public J visitUnaryExpression(KtUnaryExpression expression, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitWhenConditionInRange(KtWhenConditionInRange condition, ExecutionContext data) {
        K.Binary.Type operator = condition.isNegated() ? K.Binary.Type.NotContains : K.Binary.Type.Contains;
        J.Empty left = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        return new K.Binary(Tree.randomId(), this.prefix((PsiElement)condition), Markers.EMPTY, (Expression)left, this.padLeft(Space.EMPTY, operator), (Expression)this.convertToExpression((J)condition.getRangeExpression().accept((KtVisitor)this, (Object)data)), Space.EMPTY, this.type((KtElement)condition));
    }

    public J visitWhenConditionIsPattern(KtWhenConditionIsPattern condition, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        if (condition.isNegated()) {
            markers = markers.addIfAbsent((Marker)new NotIs(Tree.randomId()));
        }
        J.Empty element = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        JRightPadded<J.Empty> expr = this.padRight(element, Space.EMPTY);
        J clazz = (J)condition.getTypeReference().accept((KtVisitor)this, (Object)data);
        return new J.InstanceOf(Tree.randomId(), this.prefix((PsiElement)condition), markers, expr, clazz, null, this.type((KtElement)condition));
    }

    public J visitWhenConditionWithExpression(KtWhenConditionWithExpression condition, ExecutionContext data) {
        return ((J)condition.getExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)condition));
    }

    public J visitWhenEntry(KtWhenEntry ktWhenEntry, ExecutionContext data) {
        ArrayList<Object> expressions = new ArrayList<Object>(1);
        if (ktWhenEntry.getElseKeyword() != null) {
            expressions.add(this.padRight(this.createIdentifier("else", Space.EMPTY, null, null), this.prefix(ktWhenEntry.getArrow())));
        } else {
            KtWhenCondition[] ktWhenConditions = ktWhenEntry.getConditions();
            for (int i = 0; i < ktWhenConditions.length; ++i) {
                KtWhenCondition ktWhenCondition = ktWhenConditions[i];
                Expression expr = (Expression)this.convertToExpression((J)ktWhenCondition.accept((KtVisitor)this, (Object)data));
                expressions.add(this.maybeTrailingComma((KtElement)ktWhenCondition, this.padRight(expr, this.suffix((PsiElement)ktWhenCondition)), i == ktWhenConditions.length - 1));
            }
        }
        JContainer expressionContainer = JContainer.build((Space)Space.EMPTY, expressions, (Markers)Markers.EMPTY);
        J body = (J)ktWhenEntry.getExpression().accept((KtVisitor)this, (Object)data);
        return new K.WhenBranch(Tree.randomId(), this.prefix((PsiElement)ktWhenEntry), Markers.EMPTY, (JContainer<Expression>)expressionContainer, this.padRight(body, Space.EMPTY));
    }

    @NotNull
    private <T> JRightPadded<T> maybeTrailingComma(KtElement element, JRightPadded<T> padded, boolean last) {
        if (!last) {
            return padded;
        }
        PsiElement maybeComma = PsiTreeUtil.findSiblingForward((PsiElement)element, (IElementType)KtTokens.COMMA, null);
        if (maybeComma != null && maybeComma.getNode().getElementType() == KtTokens.COMMA) {
            padded = padded.withMarkers(padded.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(maybeComma))));
        }
        return padded;
    }

    public J visitWhenExpression(KtWhenExpression expression, ExecutionContext data) {
        J.ControlParentheses controlParentheses = null;
        if (expression.getSubjectExpression() != null) {
            J subject = (J)expression.getSubjectExpression().accept((KtVisitor)this, (Object)data);
            controlParentheses = new J.ControlParentheses(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight(subject, this.prefix(expression.getRightParenthesis())));
        }
        List whenEntries = expression.getEntries();
        ArrayList<JRightPadded<K.WhenBranch>> statements = new ArrayList<JRightPadded<K.WhenBranch>>(whenEntries.size());
        for (KtWhenEntry whenEntry : whenEntries) {
            K.WhenBranch whenBranch = (K.WhenBranch)whenEntry.accept((KtVisitor)this, (Object)data);
            statements.add(this.padRight(whenBranch, Space.EMPTY));
        }
        J.Block body = new J.Block(Tree.randomId(), this.prefix(expression.getOpenBrace()), Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), statements, this.prefix(expression.getCloseBrace()));
        return new K.When(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (J.ControlParentheses<J>)controlParentheses, body, this.type((KtElement)expression));
    }

    public J visitWhileExpression(KtWhileExpression expression, ExecutionContext data) {
        return new J.WhileLoop(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.mapControlParentheses(expression.getCondition(), data).withPrefix(this.prefix(expression.getLeftParenthesis())), JRightPadded.build((Object)((Statement)((J)expression.getBody().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix(expression.getBody().getParent())))));
    }

    public void visitBinaryFile(PsiBinaryFile file) {
        throw new UnsupportedOperationException("TODO");
    }

    public void visitComment(PsiComment comment) {
        throw new UnsupportedOperationException("TODO");
    }

    public void visitDirectory(PsiDirectory dir) {
        throw new UnsupportedOperationException("TODO");
    }

    public J visitKtElement(KtElement element, ExecutionContext data) {
        throw new UnsupportedOperationException("Should never call this, if this is called, means something wrong");
    }

    public J visitKtFile(KtFile file, ExecutionContext data) {
        ArrayList<JRightPadded<J.Import>> imports;
        List<J.Annotation> annotations = file.getFileAnnotationList() != null ? this.mapAnnotations(file.getAnnotationEntries(), data) : Collections.emptyList();
        HashSet<PsiElement> consumedSpaces = new HashSet<PsiElement>();
        JRightPadded<J.Package> pkg = null;
        if (!file.getPackageFqName().isRoot()) {
            pkg = this.maybeSemicolon((J.Package)file.getPackageDirective().accept((KtVisitor)this, (Object)data), (KtElement)file.getPackageDirective());
            consumedSpaces.add(this.findFirstPrefixSpace((PsiElement)file.getPackageDirective()));
        }
        ArrayList<JRightPadded<J.Import>> arrayList = imports = file.getImportDirectives().isEmpty() ? Collections.emptyList() : new ArrayList<JRightPadded<J.Import>>(file.getImportDirectives().size());
        if (!file.getImportDirectives().isEmpty()) {
            List importDirectives = file.getImportDirectives();
            for (int i = 0; i < importDirectives.size(); ++i) {
                KtImportDirective importDirective = (KtImportDirective)importDirectives.get(i);
                J.Import anImport = (J.Import)importDirective.accept((KtVisitor)this, (Object)data);
                if (i == 0) {
                    anImport = anImport.withPrefix(this.prefix((PsiElement)file.getImportList()));
                }
                imports.add(this.maybeSemicolon(anImport, (KtElement)importDirective));
            }
        }
        ArrayList<JRightPadded<Statement>> statements = file.getDeclarations().isEmpty() ? Collections.emptyList() : new ArrayList<JRightPadded<Statement>>(file.getDeclarations().size());
        List declarations = file.getDeclarations();
        for (int i = 0; i < declarations.size(); ++i) {
            boolean last = i == declarations.size() - 1;
            KtDeclaration declaration = (KtDeclaration)declarations.get(i);
            Statement statement = this.convertToStatement((J)declaration.accept((KtVisitor)this, (Object)data));
            statements.add(this.padRight(statement, last ? this.suffix((PsiElement)declaration) : Space.EMPTY));
        }
        return new K.CompilationUnit(Tree.randomId(), this.prefixAndInfix((PsiElement)file, consumedSpaces), Markers.build(this.styles), this.sourcePath, this.fileAttributes, this.charset.name(), this.charsetBomMarked, null, annotations, pkg, imports, statements, Space.EMPTY);
    }

    public J visitAnnotation(KtAnnotation annotation, ExecutionContext data) {
        throw new UnsupportedOperationException("KtAnnotation");
    }

    public J visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        JContainer args = null;
        if (annotationEntry.getUseSiteTarget() != null) {
            markers = markers.addIfAbsent((Marker)new AnnotationCallSite(Tree.randomId(), annotationEntry.getUseSiteTarget().getText(), this.suffix((PsiElement)annotationEntry.getUseSiteTarget())));
        }
        if (annotationEntry.getValueArgumentList() != null) {
            if (annotationEntry.getValueArguments().isEmpty()) {
                args = JContainer.build((Space)this.prefix((PsiElement)annotationEntry.getValueArgumentList()), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(annotationEntry.getValueArgumentList().getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
            } else {
                ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(annotationEntry.getValueArguments().size());
                for (ValueArgument valueArgument : annotationEntry.getValueArguments()) {
                    KtValueArgument ktValueArgument = (KtValueArgument)valueArgument;
                    expressions.add(this.padRight((Expression)this.convertToExpression(((J)ktValueArgument.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)ktValueArgument))), this.suffix((PsiElement)ktValueArgument)));
                }
                args = JContainer.build((Space)this.prefix((PsiElement)annotationEntry.getValueArgumentList()), expressions, (Markers)Markers.EMPTY);
            }
        }
        return new J.Annotation(Tree.randomId(), this.prefix((PsiElement)annotationEntry), markers, (NameTree)annotationEntry.getCalleeExpression().accept((KtVisitor)this, (Object)data), args);
    }

    public J visitArgument(KtValueArgument argument, ExecutionContext data) {
        if (argument.getArgumentExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        if (argument.isNamed()) {
            J.Identifier name = this.createIdentifier((PsiElement)argument.getArgumentName(), this.type((KtElement)argument.getArgumentName()));
            Expression expr = (Expression)this.convertToExpression((J)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data));
            return new J.Assignment(Tree.randomId(), this.prefix((PsiElement)argument), Markers.EMPTY, (Expression)name, this.padLeft(this.suffix((PsiElement)argument.getArgumentName()), expr), this.type((KtElement)argument.getArgumentExpression()));
        }
        if (argument.isSpread()) {
            Expression j = (Expression)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data);
            return new K.SpreadArgument(Tree.randomId(), this.prefix((PsiElement)argument), Markers.EMPTY, j);
        }
        J j = ((J)argument.getArgumentExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)argument));
        return argument instanceof KtLambdaArgument ? (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new TrailingLambdaArgument(Tree.randomId()))) : j;
    }

    public J visitBinaryExpression(KtBinaryExpression expression, ExecutionContext data) {
        assert (expression.getLeft() != null);
        assert (expression.getRight() != null);
        KtOperationReferenceExpression operationReference = expression.getOperationReference();
        J.Binary.Type javaBinaryType = this.mapJBinaryType(operationReference);
        J.AssignmentOperation.Type assignmentOperationType = javaBinaryType == null ? this.mapAssignmentOperationType(operationReference) : null;
        K.Binary.Type kotlinBinaryType = javaBinaryType == null && assignmentOperationType == null ? this.mapKBinaryType(operationReference) : null;
        Expression left = (Expression)this.convertToExpression((J)expression.getLeft().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
        Expression right = (Expression)this.convertToExpression((J)expression.getRight().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getRight()));
        JavaType type = this.type((KtElement)expression);
        if (javaBinaryType != null) {
            return new J.Binary(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), javaBinaryType), right, type);
        }
        if (operationReference.getOperationSignTokenType() == KtTokens.EQ) {
            return new J.Assignment(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.suffix((PsiElement)expression.getLeft()), right), type);
        }
        if (assignmentOperationType != null) {
            return new J.AssignmentOperation(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), assignmentOperationType), right, type);
        }
        if (kotlinBinaryType != null) {
            return new K.Binary(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, left, this.padLeft(this.prefix((PsiElement)operationReference), kotlinBinaryType), right, Space.EMPTY, type);
        }
        return this.mapFunctionCall(expression, data);
    }

    @Nullable
    private J.AssignmentOperation.Type mapAssignmentOperationType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == KtTokens.PLUSEQ) {
            return J.AssignmentOperation.Type.Addition;
        }
        if (elementType == KtTokens.MINUSEQ) {
            return J.AssignmentOperation.Type.Subtraction;
        }
        if (elementType == KtTokens.MULTEQ) {
            return J.AssignmentOperation.Type.Multiplication;
        }
        if (elementType == KtTokens.DIVEQ) {
            return J.AssignmentOperation.Type.Division;
        }
        return null;
    }

    public J visitBlockExpression(KtBlockExpression expression, ExecutionContext data) {
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>();
        for (KtExpression stmt : expression.getStatements()) {
            J exp = (J)stmt.accept((KtVisitor)this, (Object)data);
            Statement statement = this.convertToStatement(exp);
            JRightPadded<Statement> build = this.maybeSemicolon(statement, (KtElement)stmt);
            statements.add(build);
        }
        boolean hasBraces = expression.getLBrace() != null;
        Space end = expression.getLBrace() != null ? this.prefix(expression.getRBrace()) : this.suffix((PsiElement)expression);
        return new J.Block(Tree.randomId(), this.prefix((PsiElement)expression), hasBraces ? Markers.EMPTY : Markers.EMPTY.addIfAbsent((Marker)new OmitBraces(Tree.randomId())), JRightPadded.build((Object)false), statements, end);
    }

    public J visitCallExpression(KtCallExpression expression, ExecutionContext data) {
        if (expression.getCalleeExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        PsiElementAssociations.ExpressionType type = this.psiElementAssociations.getCallType((KtExpression)expression);
        if (type == PsiElementAssociations.ExpressionType.CONSTRUCTOR) {
            JContainer args;
            List arguments;
            J.Identifier name = (J.Identifier)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            if (!expression.getTypeArguments().isEmpty()) {
                ArrayList<JRightPadded<Expression>> parameters = new ArrayList<JRightPadded<Expression>>(expression.getTypeArguments().size());
                for (KtTypeProjection ktTypeProjection : expression.getTypeArguments()) {
                    parameters.add(this.padRight((Expression)this.convertToExpression((J)ktTypeProjection.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktTypeProjection)));
                }
                name = new J.ParameterizedType(Tree.randomId(), name.getPrefix(), Markers.EMPTY, (NameTree)name.withPrefix(Space.EMPTY), JContainer.build((Space)this.prefix((PsiElement)expression.getTypeArgumentList()), parameters, (Markers)Markers.EMPTY), this.type((KtElement)expression));
            }
            if ((arguments = expression.getValueArguments()).isEmpty()) {
                args = JContainer.build(Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(expression.getValueArgumentList().getRightParenthesis()), Markers.EMPTY), Space.EMPTY)));
                args = args.withBefore(this.prefix((PsiElement)expression.getValueArgumentList()));
            } else {
                args = this.mapFunctionCallArguments(expression.getValueArgumentList(), arguments, data);
            }
            return new J.NewClass(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, null, Space.EMPTY, (TypeTree)name, args, null, this.methodInvocationType((PsiElement)expression));
        }
        if (type == null || type == PsiElementAssociations.ExpressionType.METHOD_INVOCATION) {
            J.Identifier name = (J.Identifier)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            JContainer<Expression> typeParams = this.mapTypeArguments(expression.getTypeArgumentList(), data);
            JContainer args = this.mapFunctionCallArguments(expression.getValueArgumentList(), expression.getValueArguments(), data);
            if (expression.getValueArgumentList() == null) {
                args = args.withMarkers(args.getMarkers().addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
            }
            JavaType.Method methodType = this.methodInvocationType((PsiElement)expression);
            return new J.MethodInvocation(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, null, typeParams, name.withType((JavaType)methodType), args, methodType);
        }
        if (type == PsiElementAssociations.ExpressionType.QUALIFIER) {
            TypeTree typeTree = (TypeTree)expression.getCalleeExpression().accept((KtVisitor)this, (Object)data);
            JContainer<Expression> typeParams = this.mapTypeArguments(expression.getTypeArgumentList(), data);
            return new J.ParameterizedType(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (NameTree)typeTree, typeParams, this.type((KtElement)expression));
        }
        throw new UnsupportedOperationException("ExpressionType not found: " + expression.getCalleeExpression().getText());
    }

    @Nullable
    JContainer<Expression> mapTypeArguments(@Nullable KtTypeArgumentList ktTypeArgumentList, ExecutionContext data) {
        if (ktTypeArgumentList == null) {
            return null;
        }
        List ktTypeProjections = ktTypeArgumentList.getArguments();
        ArrayList<JRightPadded<Expression>> parameters = new ArrayList<JRightPadded<Expression>>(ktTypeProjections.size());
        for (KtTypeProjection ktTypeProjection : ktTypeProjections) {
            parameters.add(this.padRight((Expression)this.convertToExpression((J)ktTypeProjection.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)ktTypeProjection)));
        }
        return JContainer.build((Space)this.prefix((PsiElement)ktTypeArgumentList), parameters, (Markers)Markers.EMPTY);
    }

    public J visitConstantExpression(KtConstantExpression expression, ExecutionContext data) {
        Serializable value;
        IStubElementType elementType = expression.getElementType();
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            value = ParseUtilsKt.parseNumericLiteral((String)expression.getText(), (IElementType)elementType);
        } else if (elementType == KtNodeTypes.BOOLEAN_CONSTANT) {
            value = Boolean.valueOf(ParseUtilsKt.parseBoolean((String)expression.getText()));
        } else if (elementType == KtNodeTypes.CHARACTER_CONSTANT) {
            value = Character.valueOf(expression.getText().charAt(0));
        } else if (elementType == KtNodeTypes.NULL) {
            value = null;
        } else {
            throw new UnsupportedOperationException("Unsupported constant expression elementType : " + elementType);
        }
        return new J.Literal(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (Object)value, expression.getText(), null, this.primitiveType((PsiElement)expression));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J visitClass(KtClass klass, ExecutionContext data) {
        this.ownerStack.push((KtElement)klass);
        try {
            J j = this.visitClass0(klass, data);
            return j;
        }
        finally {
            this.ownerStack.pop();
        }
    }

    @NotNull
    private J visitClass0(KtClass klass, ExecutionContext data) {
        J.ClassDeclaration.Kind kind;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        JContainer typeParams = null;
        JContainer implementings = null;
        Markers markers = Markers.EMPTY;
        PsiElement prefixConsumed = this.findFirstPrefixSpace(this.findFirstNotSpaceChild((PsiElement)klass));
        HashSet<PsiElement> prefixConsumedSet = new HashSet<PsiElement>();
        prefixConsumedSet.add(prefixConsumed);
        List<J.Modifier> modifiers = this.mapModifiers(klass.getModifierList(), leadingAnnotations, lastAnnotations, data);
        if (!klass.hasModifier(KtTokens.OPEN_KEYWORD)) {
            modifiers.add(this.buildFinalModifier());
        }
        if (klass.getClassKeyword() != null) {
            boolean isAnnotationClass = false;
            for (J.Modifier mod : modifiers) {
                if (!"annotation".equals(mod.getKeyword())) continue;
                isAnnotationClass = true;
                break;
            }
            J.ClassDeclaration.Kind.Type classType = isAnnotationClass ? J.ClassDeclaration.Kind.Type.Annotation : J.ClassDeclaration.Kind.Type.Class;
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(klass.getClassKeyword(), prefixConsumedSet), Markers.EMPTY, lastAnnotations, classType);
        } else if (klass.getClassOrInterfaceKeyword() != null) {
            kind = new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(klass.getClassOrInterfaceKeyword(), prefixConsumedSet), Markers.EMPTY, Collections.emptyList(), J.ClassDeclaration.Kind.Type.Interface);
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        J.Identifier name = this.createIdentifier(klass.getIdentifyingElement(), this.type((KtElement)klass));
        J.Block body = klass.getBody() != null ? (J.Block)klass.getBody().accept((KtVisitor)this, (Object)data) : new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY.add((Marker)new OmitBraces(Tree.randomId())), this.padRight(false, Space.EMPTY), Collections.emptyList(), Space.EMPTY);
        if (klass.getPrimaryConstructor() != null) {
            J.MethodDeclaration primaryConstructor = (J.MethodDeclaration)klass.getPrimaryConstructor().accept((KtVisitor)this, (Object)data);
            body = body.withStatements(ListUtils.concat((Object)primaryConstructor, (List)body.getStatements()));
            markers = markers.addIfAbsent((Marker)new PrimaryConstructor(Tree.randomId()));
        }
        if (!klass.getSuperTypeListEntries().isEmpty()) {
            ArrayList<Object> superTypes = new ArrayList<Object>(klass.getSuperTypeListEntries().size());
            for (int i = 0; i < klass.getSuperTypeListEntries().size(); ++i) {
                KtSuperTypeListEntry superTypeListEntry = (KtSuperTypeListEntry)klass.getSuperTypeListEntries().get(i);
                if (superTypeListEntry instanceof KtSuperTypeCallEntry) {
                    JContainer args;
                    KtSuperTypeCallEntry superTypeCallEntry = (KtSuperTypeCallEntry)superTypeListEntry;
                    TypeTree typeTree = (TypeTree)superTypeCallEntry.getCalleeExpression().accept((KtVisitor)this, (Object)data);
                    if (!superTypeCallEntry.getValueArguments().isEmpty()) {
                        args = this.mapFunctionCallArguments(superTypeCallEntry.getValueArgumentList(), data);
                    } else {
                        KtValueArgumentList ktArgList = superTypeCallEntry.getValueArgumentList();
                        args = JContainer.build((Space)this.prefix((PsiElement)ktArgList), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(ktArgList.getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)markers);
                    }
                    K.ConstructorInvocation delegationCall = new K.ConstructorInvocation(Tree.randomId(), this.prefix((PsiElement)klass.getSuperTypeList()), Markers.EMPTY, typeTree, args);
                    superTypes.add(this.padRight(delegationCall, this.suffix((PsiElement)superTypeCallEntry)));
                    continue;
                }
                if (superTypeListEntry instanceof KtSuperTypeEntry || superTypeListEntry instanceof KtDelegatedSuperTypeEntry) {
                    TypeTree typeTree = (TypeTree)superTypeListEntry.accept((KtVisitor)this, (Object)data);
                    if (i == 0) {
                        typeTree = (TypeTree)typeTree.withPrefix(this.prefix((PsiElement)klass.getSuperTypeList()));
                    }
                    superTypes.add(this.padRight(typeTree, this.suffix((PsiElement)superTypeListEntry)));
                    continue;
                }
                throw new UnsupportedOperationException("TODO");
            }
            implementings = JContainer.build((Space)this.prefix(klass.getColon()), superTypes, (Markers)Markers.EMPTY);
        }
        if (!klass.getTypeParameters().isEmpty()) {
            typeParams = JContainer.build((Space)this.prefix((PsiElement)klass.getTypeParameterList()), this.mapTypeParameters((KtTypeParameterListOwner)klass, data), (Markers)Markers.EMPTY);
        }
        K.TypeConstraints typeConstraints = null;
        if (klass.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)klass.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = klass.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        J.ClassDeclaration classDeclaration = new J.ClassDeclaration(Tree.randomId(), this.prefixAndInfix((PsiElement)klass), markers, leadingAnnotations, modifiers, kind, name, typeParams, null, null, implementings, null, body, (JavaType.FullyQualified)this.type((KtElement)klass));
        return typeConstraints != null ? new K.ClassDeclaration(Tree.randomId(), Markers.EMPTY, classDeclaration, typeConstraints) : classDeclaration;
    }

    public J visitClassBody(KtClassBody classBody, ExecutionContext data) {
        ArrayList<Object> list = new ArrayList<Object>();
        Space after = this.prefix(classBody.getRBrace());
        if (!classBody.getEnumEntries().isEmpty()) {
            ArrayList<JRightPadded> enumValues = new ArrayList<JRightPadded>(classBody.getEnumEntries().size());
            boolean terminatedWithSemicolon = false;
            for (int i = 0; i < classBody.getEnumEntries().size(); ++i) {
                KtEnumEntry ktEnumEntry = (KtEnumEntry)classBody.getEnumEntries().get(i);
                PsiElement comma = PsiTreeUtil.findSiblingForward((PsiElement)ktEnumEntry.getIdentifyingElement(), (IElementType)KtTokens.COMMA, null);
                PsiElement semicolon = PsiTreeUtil.findSiblingForward((PsiElement)ktEnumEntry.getIdentifyingElement(), (IElementType)KtTokens.SEMICOLON, null);
                JRightPadded rp = this.padRight((J.EnumValue)ktEnumEntry.accept((KtVisitor)this, (Object)data), Space.EMPTY);
                if (i == classBody.getEnumEntries().size() - 1) {
                    if (comma != null) {
                        rp = rp.withAfter(this.prefix(comma));
                        Space afterComma = this.suffix(comma);
                        rp = rp.withMarkers(rp.getMarkers().addIfAbsent((Marker)new TrailingComma(Tree.randomId(), afterComma)));
                    } else if (semicolon != null) {
                        rp = rp.withAfter(this.prefix(semicolon));
                    }
                    if (semicolon != null) {
                        terminatedWithSemicolon = true;
                        after = this.merge(this.suffix(semicolon), after);
                    }
                } else {
                    rp = rp.withAfter(this.prefix(comma));
                }
                enumValues.add(rp);
            }
            JRightPadded<J.EnumValueSet> enumSet = this.padRight(new J.EnumValueSet(Tree.randomId(), Space.EMPTY, Markers.EMPTY, enumValues, terminatedWithSemicolon), Space.EMPTY);
            list.add(enumSet);
        }
        for (KtDeclaration d : classBody.getDeclarations()) {
            if (d instanceof KtEnumEntry) continue;
            list.add(this.maybeSemicolon(this.convertToStatement((J)d.accept((KtVisitor)this, (Object)data)), (KtElement)d));
        }
        return new J.Block(Tree.randomId(), this.prefix((PsiElement)classBody), Markers.EMPTY, this.padRight(false, Space.EMPTY), list, after);
    }

    public J visitDestructuringDeclaration(KtDestructuringDeclaration multiDeclaration, ExecutionContext data) {
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList leadingAnnotations = new ArrayList();
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> vars = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>();
        JLeftPadded<Expression> paddedInitializer = null;
        J.Modifier modifier = new J.Modifier(Tree.randomId(), this.prefix(multiDeclaration.getValOrVarKeyword()), Markers.EMPTY, multiDeclaration.isVar() ? "var" : null, multiDeclaration.isVar() ? J.Modifier.Type.LanguageExtension : J.Modifier.Type.Final, Collections.emptyList());
        modifiers.add(modifier);
        if (multiDeclaration.getInitializer() != null) {
            paddedInitializer = this.padLeft(this.suffix(multiDeclaration.getRPar()), (Expression)this.convertToExpression((J)multiDeclaration.getInitializer().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)multiDeclaration.getInitializer())));
        }
        List entries = multiDeclaration.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            KtDestructuringDeclarationEntry entry = (KtDestructuringDeclarationEntry)entries.get(i);
            Space beforeEntry = this.prefix((PsiElement)entry);
            List<Object> annotations = new ArrayList<J.Annotation>();
            if (entry.getModifierList() != null) {
                this.mapModifiers(entry.getModifierList(), annotations, Collections.emptyList(), data);
                if (!annotations.isEmpty()) {
                    annotations = ListUtils.mapFirst(annotations, anno -> anno.withPrefix(beforeEntry));
                }
            }
            JavaType.Variable vt = this.variableType((PsiElement)entry);
            if (entry.getName() == null) {
                throw new UnsupportedOperationException();
            }
            J.Identifier nameVar = this.createIdentifier(entry.getNameIdentifier(), vt != null ? vt.getType() : null, vt);
            nameVar = !annotations.isEmpty() ? nameVar.withAnnotations(annotations) : nameVar.withPrefix(beforeEntry);
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, nameVar, Collections.emptyList(), null, vt);
            JavaType.Method methodType = this.methodInvocationType((PsiElement)entry);
            J.MethodInvocation initializer = this.buildSyntheticDestructInitializer(i + 1).withMethodType(methodType);
            namedVariable = namedVariable.getPadding().withInitializer(this.padLeft(Space.SINGLE_SPACE, initializer));
            vars.add(this.padRight(namedVariable, this.suffix((PsiElement)entry)));
        }
        J.VariableDeclarations.NamedVariable emptyWithInitializer = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), "<destruct>", (JavaType)this.variableType((PsiElement)multiDeclaration), null), Collections.emptyList(), paddedInitializer, null);
        J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, leadingAnnotations, modifiers, null, null, Collections.emptyList(), Collections.singletonList(this.padRight(emptyWithInitializer, Space.EMPTY)));
        return new K.DestructuringDeclaration(Tree.randomId(), this.prefix((PsiElement)multiDeclaration), Markers.EMPTY, variableDeclarations, (JContainer<J.VariableDeclarations.NamedVariable>)JContainer.build((Space)this.prefix(multiDeclaration.getLPar()), vars, (Markers)Markers.EMPTY));
    }

    private J.MethodInvocation buildSyntheticDestructInitializer(int id) {
        J.Identifier name = new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), "component" + id, null, null);
        return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, null, name, JContainer.empty(), null);
    }

    public J visitDotQualifiedExpression(KtDotQualifiedExpression expression, ExecutionContext data) {
        assert (expression.getSelectorExpression() != null);
        if (expression.getSelectorExpression() instanceof KtCallExpression) {
            KtCallExpression callExpression = (KtCallExpression)expression.getSelectorExpression();
            MethodCall methodInvocation = (MethodCall)callExpression.accept((KtVisitor)this, (Object)data);
            if (expression.getReceiverExpression() != null) {
                Expression receiver = (Expression)this.convertToExpression((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data));
                if (methodInvocation instanceof J.MethodInvocation) {
                    methodInvocation = ((J.MethodInvocation)methodInvocation).getPadding().withSelect(this.padRight(receiver, this.suffix((PsiElement)expression.getReceiverExpression()))).withName(((J.MethodInvocation)methodInvocation).getName().withPrefix(this.prefix((PsiElement)callExpression))).withPrefix(this.prefix((PsiElement)expression));
                } else if (methodInvocation instanceof J.NewClass) {
                    methodInvocation = ((J.NewClass)methodInvocation).getPadding().withEnclosing(this.padRight(receiver, this.suffix((PsiElement)expression.getReceiverExpression()))).withClazz((TypeTree)((J.NewClass)methodInvocation).getClazz().withPrefix(this.prefix((PsiElement)callExpression))).withPrefix(this.prefix((PsiElement)expression));
                }
            }
            return methodInvocation;
        }
        if (expression.getSelectorExpression() instanceof KtNameReferenceExpression) {
            return new J.FieldAccess(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, (Expression)((J)expression.getReceiverExpression().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY), this.padLeft(this.suffix((PsiElement)expression.getReceiverExpression()), (J.Identifier)expression.getSelectorExpression().accept((KtVisitor)this, (Object)data)), this.type((KtElement)expression.getSelectorExpression()));
        }
        throw new UnsupportedOperationException("Unsupported dot qualified selector: " + expression.getSelectorExpression().getClass());
    }

    public J visitIfExpression(KtIfExpression expression, ExecutionContext data) {
        return new J.If(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.buildIfCondition(expression), this.buildIfThenPart(expression), this.buildIfElsePart(expression));
    }

    public J visitImportDirective(KtImportDirective importDirective, ExecutionContext data) {
        Object firElement = null;
        boolean hasParentClassId = firElement instanceof FirResolvedImport && ((FirResolvedImport)firElement).getResolvedParentClassId() != null;
        JLeftPadded<Boolean> statik = this.padLeft(Space.EMPTY, hasParentClassId);
        KtImportAlias alias = importDirective.getAlias();
        String text = this.nodeRangeText(importDirective.getNode().findChildByType(KtTokens.WHITE_SPACE), importDirective.isAllUnder() ? importDirective.getNode().findChildByType((IElementType)KtTokens.MUL) : importDirective.getNode().findChildByType(KtNodeTypes.DOT_QUALIFIED_EXPRESSION));
        TypeTree reference = TypeTree.build((String)text);
        if (reference instanceof J.Identifier) {
            reference = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY), this.padLeft(Space.EMPTY, (J.Identifier)reference), null);
        }
        return new J.Import(Tree.randomId(), this.prefix((PsiElement)importDirective), Markers.EMPTY, statik, (J.FieldAccess)reference, alias != null ? this.padLeft(this.prefix((PsiElement)alias), this.createIdentifier(alias.getNameIdentifier(), null)) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public J visitNamedFunction(KtNamedFunction function, ExecutionContext data) {
        this.ownerStack.push((KtElement)function);
        try {
            J j = this.visitNamedFunction0(function, data);
            return j;
        }
        finally {
            this.ownerStack.pop();
        }
    }

    @NotNull
    private J visitNamedFunction0(KtNamedFunction function, ExecutionContext data) {
        JContainer params;
        boolean isOpen;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(function.getModifierList(), leadingAnnotations, lastAnnotations, data);
        J.TypeParameters typeParameters = null;
        TypeTree returnTypeExpression = null;
        PsiElement prefixConsumed = this.findFirstPrefixSpace(this.findFirstNotSpaceChild((PsiElement)function));
        HashSet<PsiElement> prefixConsumedSet = new HashSet<PsiElement>();
        prefixConsumedSet.add(prefixConsumed);
        if (function.getTypeParameterList() != null) {
            typeParameters = new J.TypeParameters(Tree.randomId(), this.prefix((PsiElement)function.getTypeParameterList()), Markers.EMPTY, Collections.emptyList(), this.mapTypeParameters((KtTypeParameterListOwner)function, data));
        }
        if (!(isOpen = function.hasModifier(KtTokens.OPEN_KEYWORD))) {
            modifiers.add(this.buildFinalModifier().withPrefix(Space.EMPTY));
        }
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(function.getFunKeyword(), prefixConsumedSet), Markers.EMPTY, "fun", J.Modifier.Type.LanguageExtension, Collections.emptyList()));
        J.Identifier name = null;
        JavaType.Method type = this.methodDeclarationType((PsiElement)function);
        name = function.getNameIdentifier() == null ? this.createIdentifier("", Space.EMPTY, (JavaType)type) : this.createIdentifier(function.getNameIdentifier(), (JavaType)type);
        List ktParameters = function.getValueParameters();
        if (function.getValueParameterList() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        if (ktParameters.isEmpty()) {
            params = JContainer.build((Space)this.prefix((PsiElement)function.getValueParameterList()), Collections.singletonList(this.padRight(new J.Empty(Tree.randomId(), this.prefix(function.getValueParameterList().getRightParenthesis()), Markers.EMPTY), Space.EMPTY)), (Markers)Markers.EMPTY);
        } else {
            ArrayList<JRightPadded<Statement>> rps = new ArrayList<JRightPadded<Statement>>();
            for (KtParameter param : ktParameters) {
                rps.add(this.padRight(this.convertToStatement((J)param.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)param)));
            }
            params = JContainer.build((Space)this.prefix((PsiElement)function.getValueParameterList()), rps, (Markers)Markers.EMPTY);
        }
        if (function.getReceiverTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new Extension(Tree.randomId()));
            Expression receiver = (Expression)this.convertToExpression((J)function.getReceiverTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)function.getReceiverTypeReference()));
            JRightPadded infixReceiver = JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new Extension(Tree.randomId())), this.createIdentifier("<receiverType>", Space.EMPTY, null, null), Collections.emptyList(), this.padLeft(Space.EMPTY, receiver), null)).withAfter(this.suffix((PsiElement)function.getReceiverTypeReference()));
            J.VariableDeclarations implicitParam = new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new Extension(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(infixReceiver));
            implicitParam = implicitParam.withMarkers(implicitParam.getMarkers().addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), Space.EMPTY)));
            ArrayList<JRightPadded> newStatements = new ArrayList<JRightPadded>(params.getElements().size() + 1);
            newStatements.add(JRightPadded.build((Object)implicitParam));
            newStatements.addAll(params.getPadding().getElements());
            params = params.getPadding().withElements(newStatements);
        }
        if (function.getTypeReference() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(function.getColon())));
            returnTypeExpression = (TypeTree)((J)function.getTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)function.getTypeReference()));
        }
        K.TypeConstraints typeConstraints = null;
        if (function.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)function.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = function.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        J.Block body = function.getBodyBlockExpression() != null ? (J.Block)((J)function.getBodyBlockExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)function.getBodyBlockExpression())) : (function.getBodyExpression() != null ? this.convertToBlock(function.getBodyExpression(), data).withPrefix(this.prefix(function.getEqualsToken())) : null);
        J.MethodDeclaration methodDeclaration = new J.MethodDeclaration(Tree.randomId(), this.prefixAndInfix((PsiElement)function), markers, leadingAnnotations, modifiers, typeParameters, returnTypeExpression, new J.MethodDeclaration.IdentifierWithAnnotations(name, Collections.emptyList()), params, null, body, null, type);
        return typeConstraints == null ? methodDeclaration : new K.MethodDeclaration(Tree.randomId(), Markers.EMPTY, methodDeclaration, typeConstraints);
    }

    @NotNull
    private List<JRightPadded<J.TypeParameter>> mapTypeParameters(KtTypeParameterListOwner owner, ExecutionContext data) {
        List ktTypeParameters = owner.getTypeParameters();
        ArrayList<JRightPadded<J.TypeParameter>> params = new ArrayList<JRightPadded<J.TypeParameter>>(ktTypeParameters.size());
        for (KtTypeParameter ktTypeParameter : ktTypeParameters) {
            J.TypeParameter typeParameter = (J.TypeParameter)((J)ktTypeParameter.accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)ktTypeParameter));
            params.add(this.padRight(typeParameter, this.suffix((PsiElement)ktTypeParameter)));
        }
        return params;
    }

    public J visitObjectLiteralExpression(KtObjectLiteralExpression expression, ExecutionContext data) {
        JContainer args;
        KtObjectDeclaration declaration = expression.getObjectDeclaration();
        TypeTree clazz = null;
        Markers markers = Markers.EMPTY;
        if (declaration.getSuperTypeList() == null) {
            args = JContainer.empty();
            args = args.withMarkers(Markers.build(Collections.singletonList(new OmitParentheses(Tree.randomId()))));
        } else {
            if (declaration.getSuperTypeList().getEntries().size() > 1) {
                throw new UnsupportedOperationException("TODO");
            }
            KtValueArgumentList ktArgs = (KtValueArgumentList)((KtSuperTypeListEntry)declaration.getSuperTypeList().getEntries().get(0)).getStubOrPsiChild((IStubElementType)KtStubElementTypes.VALUE_ARGUMENT_LIST);
            if (ktArgs != null) {
                args = this.mapFunctionCallArguments(ktArgs, data);
            } else {
                args = JContainer.empty();
                args = args.withMarkers(Markers.EMPTY.addIfAbsent((Marker)new OmitParentheses(Tree.randomId())));
            }
            clazz = (TypeTree)((J)declaration.getSuperTypeList().accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
        }
        J.Block body = (J.Block)declaration.getBody().accept((KtVisitor)this, (Object)data);
        if (declaration.getObjectKeyword() != null) {
            markers = markers.add((Marker)new KObject(Tree.randomId(), Space.EMPTY));
            markers = markers.add((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(declaration.getColon())));
        }
        return new J.NewClass(Tree.randomId(), this.prefix((PsiElement)declaration), markers, null, this.suffix(declaration.getColon()), clazz, args, body, null);
    }

    public J visitObjectDeclaration(KtObjectDeclaration declaration, ExecutionContext data) {
        J.Block body;
        JContainer typeParameters;
        Markers markers = Markers.EMPTY;
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList<JRightPadded<TypeTree>> superTypes = new ArrayList<JRightPadded<TypeTree>>();
        JContainer implementings = null;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        if (declaration.getModifierList() != null) {
            modifiers.addAll(this.mapModifiers(declaration.getModifierList(), leadingAnnotations, lastAnnotations, data));
        }
        modifiers.add(this.buildFinalModifier());
        JContainer jContainer = typeParameters = declaration.getTypeParameterList() == null ? null : JContainer.build((Space)this.prefix((PsiElement)declaration.getTypeParameterList()), this.mapTypeParameters((KtTypeParameterListOwner)declaration, data), (Markers)Markers.EMPTY);
        if (declaration.getSuperTypeList() != null) {
            TypeTree clazz = (TypeTree)((J)declaration.getSuperTypeList().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)declaration.getSuperTypeList()));
            superTypes.add(this.padRight(clazz, Space.EMPTY));
            implementings = JContainer.build((Space)this.prefix(declaration.getColon()), superTypes, (Markers)Markers.EMPTY);
        }
        if (declaration.getBody() == null) {
            body = new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.padRight(false, Space.EMPTY), Collections.emptyList(), Space.EMPTY);
            body = body.withMarkers(body.getMarkers().addIfAbsent((Marker)new OmitBraces(Tree.randomId())));
        } else {
            body = (J.Block)declaration.getBody().accept((KtVisitor)this, (Object)data);
        }
        if (declaration.getObjectKeyword() != null) {
            markers = markers.add((Marker)new KObject(Tree.randomId(), Space.EMPTY));
            markers = markers.add((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(declaration.getColon())));
        }
        J.Identifier name = declaration.getNameIdentifier() != null ? this.createIdentifier(declaration.getNameIdentifier(), this.type((KtElement)declaration)) : this.createIdentifier(declaration.isCompanion() ? "<companion>" : "", Space.EMPTY, this.type((KtElement)declaration)).withMarkers(Markers.EMPTY.addIfAbsent((Marker)new Implicit(Tree.randomId())));
        return new J.ClassDeclaration(Tree.randomId(), this.prefix((PsiElement)declaration), markers, leadingAnnotations, modifiers, new J.ClassDeclaration.Kind(Tree.randomId(), this.prefix(declaration.getObjectKeyword()), Markers.EMPTY, lastAnnotations, J.ClassDeclaration.Kind.Type.Class), name, typeParameters, null, null, implementings, null, body, (JavaType.FullyQualified)this.type((KtElement)declaration));
    }

    @Nullable
    public J visitPackageDirective(KtPackageDirective directive, ExecutionContext data) {
        if (directive.getPackageNameExpression() == null) {
            return null;
        }
        return new J.Package(Tree.randomId(), this.prefix((PsiElement)directive), Markers.EMPTY, (Expression)directive.getPackageNameExpression().accept((KtVisitor)this, (Object)data), Collections.emptyList());
    }

    public J visitPrefixExpression(KtPrefixExpression expression, ExecutionContext data) {
        assert (expression.getBaseExpression() != null);
        J.Unary.Type type = this.mapJUnaryType(expression.getOperationReference());
        if (type == null) {
            throw new UnsupportedOperationException("TODO");
        }
        return new J.Unary(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), type), (Expression)((J)expression.getBaseExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.suffix((PsiElement)expression.getOperationReference())), this.type((KtElement)expression));
    }

    public J visitPostfixExpression(KtPostfixExpression expression, ExecutionContext data) {
        J j = (J)expression.getBaseExpression().accept((KtVisitor)this, (Object)data);
        IElementType referencedNameElementType = expression.getOperationReference().getReferencedNameElementType();
        if (referencedNameElementType == KtTokens.EXCLEXCL) {
            j = (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new CheckNotNull(Tree.randomId(), this.prefix((PsiElement)expression.getOperationReference()))));
        } else if (referencedNameElementType == KtTokens.PLUSPLUS) {
            j = new J.Unary(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), J.Unary.Type.PostIncrement), (Expression)j, this.type((KtElement)expression));
        } else if (referencedNameElementType == KtTokens.MINUSMINUS) {
            j = new J.Unary(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, this.padLeft(this.prefix((PsiElement)expression.getOperationReference()), J.Unary.Type.PostDecrement), (Expression)j, this.type((KtElement)expression));
        } else {
            throw new UnsupportedOperationException("TODO");
        }
        return j;
    }

    public J visitProperty(KtProperty property, ExecutionContext data) {
        Markers markers = Markers.EMPTY;
        ArrayList<J.Annotation> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        List<J.Modifier> modifiers = this.mapModifiers(property.getModifierList(), leadingAnnotations, lastAnnotations, data);
        TypeTree typeExpression = null;
        ArrayList<JRightPadded> variables = new ArrayList<JRightPadded>();
        J.MethodDeclaration getter = null;
        J.MethodDeclaration setter = null;
        JRightPadded<Expression> receiver = null;
        JContainer typeParameters = property.getTypeParameterList() != null ? JContainer.build((Space)this.prefix((PsiElement)property.getTypeParameterList()), this.mapTypeParameters((KtTypeParameterListOwner)property, data), (Markers)Markers.EMPTY) : null;
        K.TypeConstraints typeConstraints = null;
        boolean isSetterFirst = false;
        PsiElement prefixConsumed = this.findFirstPrefixSpace(this.findFirstNotSpaceChild((PsiElement)property));
        HashSet<PsiElement> prefixConsumedSet = new HashSet<PsiElement>();
        prefixConsumedSet.add(prefixConsumed);
        modifiers.add(new J.Modifier(Tree.randomId(), this.prefix(property.getValOrVarKeyword(), prefixConsumedSet), Markers.EMPTY, property.isVar() ? "var" : null, property.isVar() ? J.Modifier.Type.LanguageExtension : J.Modifier.Type.Final, lastAnnotations));
        if (property.getReceiverTypeReference() != null) {
            Expression receiverExp = (Expression)this.convertToExpression(((J)property.getReceiverTypeReference().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)property.getReceiverTypeReference())));
            receiver = this.padRight(receiverExp, this.suffix((PsiElement)property.getReceiverTypeReference()));
            markers = markers.addIfAbsent((Marker)new Extension(Tree.randomId()));
        }
        JLeftPadded<Expression> initializer = null;
        if (property.getInitializer() != null) {
            initializer = this.padLeft(this.prefix(property.getEqualsToken()), (Expression)this.convertToExpression(((J)property.getInitializer().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)property.getInitializer()))));
        } else if (property.getDelegate() != null) {
            Space afterByKeyword = this.prefix((PsiElement)property.getDelegate().getExpression());
            Expression initializerExp = (Expression)this.convertToExpression((J)property.getDelegate().accept((KtVisitor)this, (Object)data)).withPrefix(afterByKeyword);
            initializer = this.padLeft(this.prefix((PsiElement)property.getDelegate()), initializerExp);
            markers = markers.addIfAbsent((Marker)new By(Tree.randomId()));
        }
        Markers rpMarker = Markers.EMPTY;
        Space maybeBeforeSemicolon = Space.EMPTY;
        if (property.getLastChild().getNode().getElementType() == KtTokens.SEMICOLON) {
            rpMarker = rpMarker.addIfAbsent((Marker)new Semicolon(Tree.randomId()));
            maybeBeforeSemicolon = this.prefix(property.getLastChild());
        }
        J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), this.prefix(property.getNameIdentifier()), Markers.EMPTY, this.createIdentifier(property.getNameIdentifier(), this.type((KtElement)property)).withPrefix(Space.EMPTY), Collections.emptyList(), initializer, this.variableType((PsiElement)property));
        variables.add(this.padRight(namedVariable, maybeBeforeSemicolon).withMarkers(rpMarker));
        if (property.getColon() != null) {
            markers = markers.addIfAbsent((Marker)new TypeReferencePrefix(Tree.randomId(), this.prefix(property.getColon())));
            typeExpression = (TypeTree)property.getTypeReference().accept((KtVisitor)this, (Object)data);
            typeExpression = (TypeTree)typeExpression.withPrefix(this.suffix(property.getColon()));
        }
        if (property.getGetter() != null) {
            getter = (J.MethodDeclaration)property.getGetter().accept((KtVisitor)this, (Object)data);
        }
        if (property.getSetter() != null) {
            setter = (J.MethodDeclaration)property.getSetter().accept((KtVisitor)this, (Object)data);
        }
        if (getter != null && setter != null) {
            isSetterFirst = property.getSetter().getTextRange().getStartOffset() < property.getGetter().getTextRange().getStartOffset();
        }
        J.VariableDeclarations variableDeclarations = new J.VariableDeclarations(Tree.randomId(), this.prefixAndInfix((PsiElement)property), markers, leadingAnnotations, modifiers, typeExpression, null, Collections.emptyList(), variables);
        if (property.getTypeConstraintList() != null) {
            typeConstraints = (K.TypeConstraints)property.getTypeConstraintList().accept((KtVisitor)this, (Object)data);
            PsiElement whereKeyword = property.getNode().findChildByType((IElementType)KtTokens.WHERE_KEYWORD).getPsi();
            typeConstraints = (K.TypeConstraints)typeConstraints.withConstraints(ListUtils.mapFirst(typeConstraints.getConstraints(), constraint -> constraint.withPrefix(this.suffix(whereKeyword)))).withPrefix(this.prefix(whereKeyword));
        }
        if (getter != null || setter != null || receiver != null || typeConstraints != null) {
            return new K.Property(Tree.randomId(), this.prefix((PsiElement)property), markers, (JContainer<J.TypeParameter>)typeParameters, variableDeclarations.withPrefix(Space.EMPTY), typeConstraints, getter, setter, isSetterFirst, receiver);
        }
        return variableDeclarations;
    }

    private List<J.Modifier> mapModifiers(@Nullable KtModifierList modifierList, @NonNull List<J.Annotation> leadingAnnotations, @NonNull List<J.Annotation> lastAnnotations, ExecutionContext data) {
        boolean isLeadingAnnotation = true;
        ArrayList<J.Modifier> modifiers = new ArrayList<J.Modifier>();
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        if (modifierList == null) {
            return modifiers;
        }
        for (PsiElement child : PsiUtilsKt.getAllChildren((PsiElement)modifierList)) {
            boolean isKeyword;
            if (this.isSpace(child.getNode())) continue;
            boolean isAnnotation = child instanceof KtAnnotationEntry;
            boolean bl = isKeyword = child instanceof LeafPsiElement && child.getNode().getElementType() instanceof KtModifierKeywordToken;
            if (isAnnotation) {
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)child;
                J.Annotation annotation = (J.Annotation)ktAnnotationEntry.accept((KtVisitor)this, (Object)data);
                if (isLeadingAnnotation) {
                    leadingAnnotations.add(annotation);
                    continue;
                }
                annotations.add(annotation);
                continue;
            }
            if (!isKeyword) continue;
            isLeadingAnnotation = false;
            modifiers.add(this.mapModifier(child, new ArrayList<J.Annotation>(annotations)));
            annotations.clear();
        }
        if (!annotations.isEmpty()) {
            lastAnnotations.addAll(annotations);
        }
        return modifiers;
    }

    public J visitPropertyDelegate(KtPropertyDelegate delegate, ExecutionContext data) {
        if (delegate.getExpression() == null) {
            throw new UnsupportedOperationException("TODO");
        }
        return ((J)delegate.getExpression().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)delegate));
    }

    public J visitSimpleNameExpression(KtSimpleNameExpression expression, ExecutionContext data) {
        return this.createIdentifier((PsiElement)expression, this.type((KtElement)expression));
    }

    public J visitStringTemplateExpression(KtStringTemplateExpression expression, ExecutionContext data) {
        KtStringTemplateEntry[] entries = expression.getEntries();
        boolean hasStringTemplateEntry = Arrays.stream(entries).anyMatch(x -> x instanceof KtBlockStringTemplateEntry || x instanceof KtSimpleNameStringTemplateEntry);
        if (hasStringTemplateEntry) {
            String delimiter = expression.getFirstChild().getText();
            ArrayList<J> values = new ArrayList<J>();
            for (KtStringTemplateEntry entry : entries) {
                values.add((J)entry.accept((KtVisitor)this, (Object)data));
            }
            return new K.KString(Tree.randomId(), this.prefix((PsiElement)expression), Markers.EMPTY, delimiter, values, this.type((KtElement)expression));
        }
        String valueSource = expression.getText();
        StringBuilder valueSb = new StringBuilder();
        Arrays.stream(entries).forEach(x -> valueSb.append(x.getText()));
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)valueSb.toString(), valueSource, null, JavaType.Primitive.String).withPrefix(this.prefix((PsiElement)expression));
    }

    public J visitStringTemplateEntry(KtStringTemplateEntry entry, ExecutionContext data) {
        PsiElement leaf = entry.getFirstChild();
        if (!(leaf instanceof LeafPsiElement)) {
            throw new UnsupportedOperationException("Unsupported KtStringTemplateEntry child");
        }
        return new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)leaf.getText(), "\"" + leaf.getText() + "\"", null, this.primitiveType((PsiElement)entry));
    }

    public J visitSuperTypeList(KtSuperTypeList list, ExecutionContext data) {
        List typeListEntries = list.getEntries();
        if (typeListEntries.size() > 1) {
            throw new UnsupportedOperationException("KtSuperTypeList size is bigger than 1, TODO");
        }
        return (J)((KtSuperTypeListEntry)typeListEntries.get(0)).accept((KtVisitor)this, (Object)data);
    }

    public J visitSuperTypeCallEntry(KtSuperTypeCallEntry call, ExecutionContext data) {
        return (J)call.getTypeReference().accept((KtVisitor)this, (Object)data);
    }

    public J visitTypeReference(KtTypeReference typeReference, ExecutionContext data) {
        J j;
        List<Object> leadingAnnotations = new ArrayList<J.Annotation>();
        ArrayList<J.Annotation> lastAnnotations = new ArrayList<J.Annotation>();
        boolean prefixConsumed = false;
        this.mapModifiers(typeReference.getModifierList(), leadingAnnotations, lastAnnotations, data);
        if (!leadingAnnotations.isEmpty()) {
            leadingAnnotations = ListUtils.mapFirst(leadingAnnotations, anno -> anno.withPrefix(this.prefix((PsiElement)typeReference)));
            prefixConsumed = true;
        }
        if ((j = ((J)typeReference.getTypeElement().accept((KtVisitor)this, (Object)data)).withPrefix(prefixConsumed ? this.prefix((PsiElement)typeReference.getTypeElement()) : this.merge(this.prefix((PsiElement)typeReference), this.prefix((PsiElement)typeReference.getTypeElement())))) instanceof K.FunctionType && typeReference.getModifierList() != null && typeReference.getModifierList().hasModifier(KtTokens.SUSPEND_KEYWORD)) {
            if (((K.FunctionType)(j = ((K.FunctionType)j).withModifiers(Collections.singletonList(this.mapModifier(typeReference.getModifierList().getModifier(KtTokens.SUSPEND_KEYWORD), Collections.emptyList()))).withLeadingAnnotations(leadingAnnotations))).getReceiver() != null) {
                j = ((K.FunctionType)j).withReceiver((JRightPadded<NameTree>)((K.FunctionType)j).getReceiver().withElement((Object)((NameTree)((NameTree)((K.FunctionType)j).getReceiver().getElement()).withPrefix(this.prefix((PsiElement)typeReference.getTypeElement())))));
            }
        } else if (j instanceof J.Identifier) {
            j = ((J.Identifier)j).withAnnotations(leadingAnnotations);
        }
        return j;
    }

    public J visitUserType(KtUserType type, ExecutionContext data) {
        J.Identifier name;
        J.Identifier nameTree = name = (J.Identifier)type.getReferenceExpression().accept((KtVisitor)this, (Object)data);
        if (type.getQualifier() != null) {
            Expression select = (Expression)this.convertToExpression((J)type.getQualifier().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)type.getQualifier()));
            nameTree = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, select, this.padLeft(this.suffix((PsiElement)type.getQualifier()), name), null);
        }
        List typeArguments = type.getTypeArguments();
        ArrayList<JRightPadded<Expression>> parameters = new ArrayList<JRightPadded<Expression>>(typeArguments.size());
        if (!typeArguments.isEmpty()) {
            for (KtTypeProjection typeProjection : typeArguments) {
                parameters.add(this.padRight((Expression)this.convertToExpression((J)typeProjection.accept((KtVisitor)this, (Object)data)), this.suffix((PsiElement)typeProjection)));
            }
            return new J.ParameterizedType(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)nameTree, JContainer.build((Space)this.prefix((PsiElement)type.getTypeArgumentList()), parameters, (Markers)Markers.EMPTY), this.type((KtElement)type));
        }
        return nameTree;
    }

    public J visitValueArgumentList(KtValueArgumentList list, ExecutionContext data) {
        throw new UnsupportedOperationException("TODO");
    }

    @Nullable
    private K.Binary.Type mapKBinaryType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == null) {
            return null;
        }
        if (elementType == KtTokens.NOT_IN) {
            return K.Binary.Type.NotContains;
        }
        if (elementType == KtTokens.RANGE) {
            return K.Binary.Type.RangeTo;
        }
        if (elementType == KtTokens.RANGE_UNTIL) {
            return K.Binary.Type.RangeUntil;
        }
        if (elementType == KtTokens.IN_KEYWORD) {
            return K.Binary.Type.Contains;
        }
        if (elementType == KtTokens.EQEQEQ) {
            return K.Binary.Type.IdentityEquals;
        }
        if (elementType == KtTokens.EXCLEQEQEQ) {
            return K.Binary.Type.IdentityNotEquals;
        }
        if (elementType == KtTokens.ELVIS) {
            return K.Binary.Type.Elvis;
        }
        if (elementType == KtTokens.EQ) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported OPERATION_REFERENCE type: " + elementType);
    }

    @Nullable
    private J.Binary.Type mapJBinaryType(KtOperationReferenceExpression operationReference) {
        KtSingleValueToken elementType = operationReference.getOperationSignTokenType();
        if (elementType == null) {
            String operator = operationReference.getText();
            if ("and".equals(operator)) {
                return J.Binary.Type.BitAnd;
            }
            if ("or".equals(operator)) {
                return J.Binary.Type.BitOr;
            }
            if ("xor".equals(operator)) {
                return J.Binary.Type.BitXor;
            }
            if ("shl".equals(operator)) {
                return J.Binary.Type.LeftShift;
            }
            if ("shr".equals(operator)) {
                return J.Binary.Type.RightShift;
            }
            if ("ushr".equals(operator)) {
                return J.Binary.Type.UnsignedRightShift;
            }
        }
        if (elementType == KtTokens.PLUS) {
            return J.Binary.Type.Addition;
        }
        if (elementType == KtTokens.MINUS) {
            return J.Binary.Type.Subtraction;
        }
        if (elementType == KtTokens.MUL) {
            return J.Binary.Type.Multiplication;
        }
        if (elementType == KtTokens.DIV) {
            return J.Binary.Type.Division;
        }
        if (elementType == KtTokens.EQEQ) {
            return J.Binary.Type.Equal;
        }
        if (elementType == KtTokens.EXCLEQ) {
            return J.Binary.Type.NotEqual;
        }
        if (elementType == KtTokens.GT) {
            return J.Binary.Type.GreaterThan;
        }
        if (elementType == KtTokens.GTEQ) {
            return J.Binary.Type.GreaterThanOrEqual;
        }
        if (elementType == KtTokens.LT) {
            return J.Binary.Type.LessThan;
        }
        if (elementType == KtTokens.LTEQ) {
            return J.Binary.Type.LessThanOrEqual;
        }
        if (elementType == KtTokens.PERC) {
            return J.Binary.Type.Modulo;
        }
        if (elementType == KtTokens.ANDAND) {
            return J.Binary.Type.And;
        }
        if (elementType == KtTokens.OROR) {
            return J.Binary.Type.Or;
        }
        return null;
    }

    @Nullable
    private J.Unary.Type mapJUnaryType(KtSimpleNameExpression operationReference) {
        IElementType elementType = operationReference.getReferencedNameElementType();
        if (elementType == KtTokens.EXCL) {
            return J.Unary.Type.Not;
        }
        if (elementType == KtTokens.MINUSMINUS) {
            return J.Unary.Type.PreDecrement;
        }
        if (elementType == KtTokens.PLUSPLUS) {
            return J.Unary.Type.PreIncrement;
        }
        if (elementType == KtTokens.MINUS) {
            return J.Unary.Type.Negative;
        }
        if (elementType == KtTokens.PLUSEQ) {
            return J.Unary.Type.Positive;
        }
        if (elementType == KtTokens.PLUS) {
            return J.Unary.Type.Positive;
        }
        return null;
    }

    private J.Modifier.Type mapModifierType(PsiElement modifier) {
        switch (modifier.getText()) {
            case "public": {
                return J.Modifier.Type.Public;
            }
            case "private": {
                return J.Modifier.Type.Private;
            }
            case "sealed": {
                return J.Modifier.Type.Sealed;
            }
            case "annotation": 
            case "data": 
            case "enum": 
            case "open": 
            case "inner": 
            case "internal": 
            case "value": {
                return J.Modifier.Type.LanguageExtension;
            }
            case "abstract": {
                return J.Modifier.Type.Abstract;
            }
        }
        throw new UnsupportedOperationException("Unsupported ModifierType : " + modifier);
    }

    private J.MethodInvocation mapFunctionCall(KtBinaryExpression expression, ExecutionContext data) {
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new Infix(Tree.randomId())).addIfAbsent((Marker)new Extension(Tree.randomId()));
        Expression selectExp = (Expression)this.convertToExpression(((J)expression.getLeft().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getLeft())));
        JRightPadded<Expression> select = this.padRight(selectExp, Space.EMPTY);
        J.Identifier name = (J.Identifier)expression.getOperationReference().accept((KtVisitor)this, (Object)data);
        JContainer typeParams = null;
        ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(1);
        Markers paramMarkers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
        Expression rightExp = (Expression)this.convertToExpression(((J)expression.getRight().accept((KtVisitor)this, (Object)data)).withPrefix(this.prefix((PsiElement)expression.getRight())));
        JRightPadded<Expression> padded = this.padRight(rightExp, this.suffix((PsiElement)expression.getRight()));
        expressions.add(padded);
        JContainer args = JContainer.build((Space)Space.EMPTY, expressions, (Markers)paramMarkers);
        JavaType.Method methodType = this.methodInvocationType((PsiElement)expression);
        return new J.MethodInvocation(Tree.randomId(), this.prefix((PsiElement)expression), markers, select, typeParams, name, args, methodType);
    }

    private J.ControlParentheses<Expression> buildIfCondition(KtIfExpression expression) {
        return new J.ControlParentheses(Tree.randomId(), this.prefix(expression.getLeftParenthesis()), Markers.EMPTY, this.padRight((Expression)this.convertToExpression((J)expression.getCondition().accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.suffix(expression.getLeftParenthesis())), this.prefix(expression.getRightParenthesis())));
    }

    private JRightPadded<Statement> buildIfThenPart(KtIfExpression expression) {
        return this.padRight((Statement)this.convertToStatement((J)expression.getThen().accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.prefix(expression.getThen().getParent())), Space.EMPTY);
    }

    @Nullable
    private J.If.Else buildIfElsePart(KtIfExpression expression) {
        if (expression.getElse() == null) {
            return null;
        }
        return new J.If.Else(Tree.randomId(), this.prefix(expression.getElseKeyword()), Markers.EMPTY, this.padRight((Statement)this.convertToStatement((J)expression.getElse().accept((KtVisitor)this, (Object)this.executionContext)).withPrefix(this.suffix(expression.getElseKeyword())), Space.EMPTY));
    }

    @Nullable
    private JavaType type(@Nullable KtElement psi) {
        if (psi == null) {
            return JavaType.Unknown.getInstance();
        }
        return this.psiElementAssociations.type((PsiElement)psi, this.owner((PsiElement)psi));
    }

    private JavaType.Primitive primitiveType(PsiElement psi) {
        FirElement firElement = this.psiElementAssociations.primary(psi);
        if (firElement instanceof FirConstExpression) {
            return this.psiElementAssociations.getTypeMapping().primitive((ConeClassLikeType)((FirResolvedTypeRef)((FirConstExpression)firElement).getTypeRef()).getType());
        }
        if (firElement instanceof FirStringConcatenationCall) {
            return JavaType.Primitive.String;
        }
        return null;
    }

    @Nullable
    private JavaType.Variable variableType(PsiElement psi) {
        FirBasedSymbol<?> basedSymbol;
        if (psi instanceof KtDeclaration && (basedSymbol = this.psiElementAssociations.symbol((KtDeclaration)psi)) instanceof FirVariableSymbol) {
            return (JavaType.Variable)this.psiElementAssociations.getTypeMapping().type(basedSymbol.getFir(), this.owner(psi));
        }
        return null;
    }

    @Nullable
    private JavaType.Method methodDeclarationType(PsiElement psi) {
        FirBasedSymbol<?> basedSymbol;
        if (psi instanceof KtDeclaration && (basedSymbol = this.psiElementAssociations.symbol((KtDeclaration)psi)) != null && basedSymbol.getFir() instanceof FirFunction) {
            return this.psiElementAssociations.getTypeMapping().methodDeclarationType((FirFunction)basedSymbol.getFir(), null, (FirBasedSymbol<?>)this.psiElementAssociations.getFile().getSymbol());
        }
        return null;
    }

    @Nullable
    private JavaType.Method methodInvocationType(PsiElement psi) {
        FirElement firElement = this.psiElementAssociations.component(psi);
        if (firElement == null) {
            firElement = this.psiElementAssociations.component(psi.getParent());
        }
        if (firElement instanceof FirFunctionCall) {
            return this.psiElementAssociations.getTypeMapping().methodInvocationType((FirFunctionCall)firElement, (FirBasedSymbol<?>)this.psiElementAssociations.getFile().getSymbol());
        }
        if (firElement instanceof FirResolvedNamedReference) {
            throw new UnsupportedOperationException("FIXME");
        }
        return null;
    }

    private J.Identifier createIdentifier(PsiElement name, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        return this.createIdentifier(name.getNode().getText(), this.prefix(name), type, fieldType);
    }

    private J.Identifier createIdentifier(PsiElement name, @Nullable JavaType type) {
        return this.createIdentifier(name.getNode().getText(), this.prefix(name), type);
    }

    private J.Identifier createIdentifier(String name, Space prefix, @Nullable JavaType type) {
        return this.createIdentifier(name, prefix, type instanceof JavaType.Variable ? ((JavaType.Variable)type).getType() : type, type instanceof JavaType.Variable ? (JavaType.Variable)type : null);
    }

    private J.Identifier createIdentifier(String name, Space prefix, @Nullable JavaType type, @Nullable JavaType.Variable fieldType) {
        return new J.Identifier(Tree.randomId(), prefix, Markers.EMPTY, Collections.emptyList(), name, (JavaType)(type instanceof JavaType.Parameterized ? ((JavaType.Parameterized)type).getType() : type), fieldType);
    }

    @Nullable
    private FirBasedSymbol<?> owner(PsiElement element) {
        KtElement owner;
        KtElement ktElement = owner = this.ownerStack.peek() == element ? (KtElement)this.ownerStack.get(this.ownerStack.size() - 2) : this.ownerStack.peek();
        if (owner instanceof KtDeclaration) {
            return this.psiElementAssociations.symbol((KtDeclaration)owner);
        }
        if (owner instanceof KtFile) {
            return ((FirFile)this.psiElementAssociations.primary((PsiElement)owner)).getSymbol();
        }
        return null;
    }

    private J.Block convertToBlock(KtExpression ktExpression, ExecutionContext data) {
        Expression returnExpr = (Expression)this.convertToExpression((J)ktExpression.accept((KtVisitor)this, (Object)data)).withPrefix(Space.EMPTY);
        K.KReturn kreturn = new K.KReturn(Tree.randomId(), new J.Return(Tree.randomId(), this.prefix((PsiElement)ktExpression), Markers.EMPTY.addIfAbsent((Marker)new ImplicitReturn(Tree.randomId())), returnExpr), null);
        return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY.addIfAbsent((Marker)new OmitBraces(Tree.randomId())).addIfAbsent((Marker)new SingleExpressionBlock(Tree.randomId())), JRightPadded.build((Object)false), Collections.singletonList(JRightPadded.build((Object)kreturn)), Space.EMPTY);
    }

    private <J2 extends J> JRightPadded<J2> maybeSemicolon(J2 j, KtElement element) {
        PsiElement maybeSemicolon = element.getLastChild();
        boolean hasSemicolon = maybeSemicolon instanceof LeafPsiElement && ((LeafPsiElement)maybeSemicolon).getElementType() == KtTokens.SEMICOLON;
        return hasSemicolon ? new JRightPadded(j, this.prefix(maybeSemicolon), Markers.EMPTY.add((Marker)new Semicolon(Tree.randomId()))) : JRightPadded.build(j);
    }

    private <T> JLeftPadded<T> padLeft(Space left, T tree) {
        return new JLeftPadded(left, tree, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right) {
        return this.padRight(tree, right, Markers.EMPTY);
    }

    private <T> JRightPadded<T> padRight(T tree, @Nullable Space right, Markers markers) {
        return new JRightPadded(tree, right == null ? Space.EMPTY : right, markers);
    }

    private <J2 extends J> J2 convertToExpression(J j) {
        if (j instanceof Statement && !(j instanceof Expression)) {
            j = new K.StatementExpression(Tree.randomId(), (Statement)j);
        }
        return (J2)j;
    }

    private Statement convertToStatement(J j) {
        if (!(j instanceof Statement) && j instanceof Expression) {
            j = new K.ExpressionStatement(Tree.randomId(), (Expression)j);
        }
        if (!(j instanceof Statement)) {
            throw new UnsupportedOperationException("TODO");
        }
        return (Statement)j;
    }

    private Space prefix(@Nullable PsiElement element) {
        return this.prefix(element, null);
    }

    @NotNull
    private Space prefix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement first = this.findFirstPrefixSpace(element);
        if (first == null) {
            return Space.EMPTY;
        }
        if (consumedSpaces != null && consumedSpaces.contains(first)) {
            return Space.EMPTY;
        }
        return this.space(first);
    }

    @Nullable
    private PsiElement findFirstPrefixSpace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement pre = element.getPrevSibling();
        if (pre == null || !this.isSpace(pre.getNode())) {
            return null;
        }
        while (pre.getPrevSibling() != null && this.isSpace(pre.getPrevSibling().getNode())) {
            pre = pre.getPrevSibling();
        }
        return pre;
    }

    private Space openPrefix(@Nullable PsiElement element) {
        PsiElement prev;
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement whitespace = this.prev(element);
        if (whitespace == null || !this.isSpace(whitespace.getNode())) {
            return Space.EMPTY;
        }
        while ((prev = this.prev(whitespace)) != null && this.isSpace(prev.getNode())) {
            whitespace = prev;
        }
        return this.space(whitespace);
    }

    private Space suffix(@Nullable PsiElement element) {
        if (element == null) {
            return Space.EMPTY;
        }
        PsiElement whitespace = element.getLastChild();
        if (whitespace == null || !this.isSpace(whitespace.getNode())) {
            whitespace = element.getNextSibling();
        } else {
            while (whitespace.getPrevSibling() != null && this.isSpace(whitespace.getPrevSibling().getNode())) {
                whitespace = whitespace.getPrevSibling();
            }
        }
        if (whitespace == null || !this.isSpace(whitespace.getNode())) {
            return Space.EMPTY;
        }
        return this.space(whitespace);
    }

    private Space infix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        for (PsiElement it : PsiUtilsKt.getAllChildren((PsiElement)element)) {
            if (this.isSpace(it.getNode())) continue;
            return this.prefix(it, consumedSpaces);
        }
        return Space.EMPTY;
    }

    private Space prefixAndInfix(@Nullable PsiElement element) {
        return this.prefixAndInfix(element, null);
    }

    private Space prefixAndInfix(@Nullable PsiElement element, @Nullable Set<PsiElement> consumedSpaces) {
        if (element == null) {
            return Space.EMPTY;
        }
        return this.merge(this.prefix(element, consumedSpaces), this.infix(element, consumedSpaces));
    }

    private boolean isSpace(ASTNode node) {
        IElementType elementType = node.getElementType();
        return elementType == KtTokens.WHITE_SPACE || elementType == KtTokens.BLOCK_COMMENT || elementType == KtTokens.EOL_COMMENT || elementType == KtTokens.DOC_COMMENT || this.isCRLF(node);
    }

    private boolean isWhiteSpace(@Nullable PsiElement node) {
        if (node == null) {
            return false;
        }
        return node instanceof PsiWhiteSpace || this.isCRLF(node.getNode());
    }

    private boolean isCRLF(ASTNode node) {
        return node instanceof PsiErrorElementImpl && node.getText().equals("\r");
    }

    private String nodeRangeText(@Nullable ASTNode first, @Nullable ASTNode last) {
        StringBuilder builder = new StringBuilder();
        while (first != null) {
            builder.append(first.getText());
            if (first == last) break;
            first = first.getTreeNext();
        }
        return builder.toString();
    }

    private List<J.Annotation> mapAnnotations(List<KtAnnotationEntry> ktAnnotationEntries, ExecutionContext data) {
        return ktAnnotationEntries.stream().map(annotation -> (J.Annotation)annotation.accept((KtVisitor)this, (Object)data)).collect(Collectors.toList());
    }

    private J.VariableDeclarations mapDestructuringDeclaration(KtDestructuringDeclaration ktDestructuringDeclaration, ExecutionContext data) {
        List entries = ktDestructuringDeclaration.getEntries();
        ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>> variables = new ArrayList<JRightPadded<J.VariableDeclarations.NamedVariable>>(entries.size());
        for (KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry : entries) {
            J.Identifier name = (J.Identifier)ktDestructuringDeclarationEntry.accept((KtVisitor)this, (Object)data);
            J.VariableDeclarations.NamedVariable namedVariable = new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), null, this.variableType((PsiElement)ktDestructuringDeclaration));
            variables.add(this.padRight(namedVariable, this.suffix((PsiElement)ktDestructuringDeclarationEntry)));
        }
        return new J.VariableDeclarations(Tree.randomId(), this.prefix((PsiElement)ktDestructuringDeclaration), Markers.EMPTY.addIfAbsent((Marker)new OmitEquals(Tree.randomId())), Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), variables);
    }

    private J.Modifier mapModifier(PsiElement modifier, List<J.Annotation> annotations) {
        J.Modifier.Type type;
        Space prefix = this.prefix(modifier);
        String keyword = null;
        switch (modifier.getText()) {
            case "public": {
                type = J.Modifier.Type.Public;
                break;
            }
            case "protected": {
                type = J.Modifier.Type.Protected;
                break;
            }
            case "private": {
                type = J.Modifier.Type.Private;
                break;
            }
            case "abstract": {
                type = J.Modifier.Type.Abstract;
                break;
            }
            case "val": {
                type = J.Modifier.Type.Final;
                break;
            }
            default: {
                type = J.Modifier.Type.LanguageExtension;
                keyword = modifier.getText();
            }
        }
        return new J.Modifier(Tree.randomId(), prefix, Markers.EMPTY, keyword, type, annotations);
    }

    private List<JRightPadded<Statement>> mapParameters(@Nullable KtParameterList list, ExecutionContext data) {
        if (list == null) {
            return Collections.emptyList();
        }
        List ktParameters = list.getParameters();
        ArrayList<JRightPadded<Statement>> statements = new ArrayList<JRightPadded<Statement>>(ktParameters.size());
        for (int i = 0; i < ktParameters.size(); ++i) {
            KtParameter ktParameter = (KtParameter)ktParameters.get(i);
            Statement statement = this.convertToStatement((J)ktParameter.accept((KtVisitor)this, (Object)data));
            statements.add(this.maybeTrailingComma((KtElement)ktParameter, this.padRight(statement, this.suffix((PsiElement)ktParameter)), i == ktParameters.size() - 1));
        }
        if (ktParameters.isEmpty()) {
            J.Empty param = new J.Empty(Tree.randomId(), this.prefix(list.getRightParenthesis()), Markers.EMPTY);
            statements.add(this.padRight(param, Space.EMPTY));
        }
        return statements;
    }

    private JContainer<Expression> mapFunctionCallArguments(@Nullable KtValueArgumentList valueArgumentList, List<KtValueArgument> ktValueArguments, ExecutionContext data) {
        ArrayList<Object> expressions = new ArrayList<Object>(ktValueArguments.size());
        Markers markers = Markers.EMPTY;
        for (int i = 0; i < ktValueArguments.size(); ++i) {
            PsiElement maybeTrailingComma;
            KtValueArgument ktValueArgument = ktValueArguments.get(i);
            Expression expr = (Expression)this.convertToExpression((J)ktValueArgument.accept((KtVisitor)this, (Object)data));
            Markers rpMarkers = Markers.EMPTY;
            if (valueArgumentList != null && i == valueArgumentList.getArguments().size() - 1 && (maybeTrailingComma = this.findTrailingComma((PsiElement)ktValueArgument)) != null) {
                rpMarkers = rpMarkers.addIfAbsent((Marker)new TrailingComma(Tree.randomId(), this.suffix(maybeTrailingComma)));
            }
            expressions.add(this.padRight(expr, this.suffix((PsiElement)ktValueArgument), rpMarkers));
        }
        if (ktValueArguments.isEmpty() && valueArgumentList != null) {
            J.Empty arg = new J.Empty(Tree.randomId(), this.prefix(valueArgumentList.getRightParenthesis()), Markers.EMPTY);
            expressions.add(this.padRight(arg, Space.EMPTY));
        }
        if (valueArgumentList == null) {
            markers = markers.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
        }
        Space prefix = valueArgumentList != null ? this.prefix((PsiElement)valueArgumentList) : Space.EMPTY;
        return JContainer.build((Space)prefix, expressions, (Markers)markers);
    }

    @Nullable
    private JContainer<Expression> mapFunctionCallArguments(@Nullable KtValueArgumentList argumentList, ExecutionContext data) {
        if (argumentList == null) {
            return null;
        }
        List ktValueArguments = argumentList.getArguments();
        ArrayList<Object> expressions = new ArrayList<Object>(ktValueArguments.size());
        for (int i = 0; i < ktValueArguments.size(); ++i) {
            KtValueArgument ktValueArgument = (KtValueArgument)ktValueArguments.get(i);
            Expression expr = (Expression)this.convertToExpression((J)ktValueArgument.accept((KtVisitor)this, (Object)data));
            expressions.add(this.maybeTrailingComma((KtElement)ktValueArgument, this.padRight(expr, this.suffix((PsiElement)ktValueArgument)), i == ktValueArguments.size() - 1));
        }
        if (ktValueArguments.isEmpty()) {
            J.Empty arg = new J.Empty(Tree.randomId(), this.prefix(argumentList.getRightParenthesis()), Markers.EMPTY);
            expressions.add(this.padRight(arg, Space.EMPTY));
        }
        return JContainer.build((Space)this.prefix((PsiElement)argumentList), expressions, (Markers)Markers.EMPTY);
    }

    private Space space(PsiElement node) {
        Space space = null;
        PsiElement preNode = null;
        while (node != null) {
            PsiElement finalNode = node;
            if (this.isWhiteSpace(node)) {
                space = space == null ? Space.build((String)node.getText(), Collections.emptyList()) : (this.isWhiteSpace(preNode) ? space.withWhitespace(space.getWhitespace() + node.getText()) : space.withComments(ListUtils.mapLast((List)space.getComments(), c -> c.withSuffix(finalNode.getText()))));
            } else {
                if (!(node instanceof PsiComment)) break;
                if (space == null) {
                    space = Space.EMPTY;
                }
                String nodeText = node.getText();
                boolean isBlockComment = ((PsiComment)node).getTokenType() == KtTokens.BLOCK_COMMENT;
                String comment = isBlockComment ? nodeText.substring(2, nodeText.length() - 2) : nodeText.substring(2);
                space = space.withComments(ListUtils.concat((List)space.getComments(), (Object)new TextComment(isBlockComment, comment, "", Markers.EMPTY)));
            }
            preNode = node;
            node = this.next(node);
        }
        return space == null ? Space.EMPTY : space;
    }

    @Nullable
    private PsiElement prev(PsiElement node) {
        return node.getPrevSibling();
    }

    @Nullable
    private PsiElement next(PsiElement node) {
        return node.getNextSibling();
    }

    private Space merge(Space s1, Space s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s1.getComments().isEmpty()) {
            return Space.build((String)(s1.getWhitespace() + s2.getWhitespace()), (List)s2.getComments());
        }
        List newComments = ListUtils.mapLast((List)s1.getComments(), c -> c.withSuffix(c.getSuffix() + s2.getWhitespace()));
        newComments.addAll(s2.getComments());
        return Space.build((String)s1.getWhitespace(), (List)newComments);
    }

    private J.Modifier buildFinalModifier() {
        return new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, J.Modifier.Type.Final, Collections.emptyList());
    }

    @Nullable
    private PsiElement findFirstNotSpaceChild(PsiElement parent) {
        for (PsiElement it : PsiUtilsKt.getAllChildren((PsiElement)parent)) {
            IElementType type = it.getNode().getElementType();
            if (type == KtTokens.EOL_COMMENT || type == KtTokens.BLOCK_COMMENT || type == KtTokens.WHITE_SPACE) continue;
            return it;
        }
        return null;
    }

    @Nullable
    private PsiElement findTrailingComma(PsiElement element) {
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getNode().getElementType() != KtTokens.COMMA) continue;
            return nextSibling;
        }
        return null;
    }
}

