/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.style.ImportLayoutStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.style.SpacesStyle;
import org.openrewrite.kotlin.style.TabsAndIndentsStyle;
import org.openrewrite.kotlin.style.WrappingAndBracesStyle;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.kotlin.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detector() {
        return new Detector();
    }

    private static long getTotalCharCount(IndentStatistic indentStatistic) {
        return indentStatistic.depthToSpaceIndentFrequencies.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).mapToLong(entry -> (long)((Integer)entry.getKey()).intValue() * (Long)entry.getValue()).sum();
    }

    private static int getBiggestGroupOfTabSize(IndentStatistic deltaSpaces) {
        Map<Integer, Integer> tabSizeToFrequencyMap = deltaSpaces.depthToSpaceIndentFrequencies.entrySet().stream().filter(entry -> ((IndentStatistic.DepthCoordinate)entry.getKey()).indentDepth != 0).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream().map(spaceCountToFrequency -> new AbstractMap.SimpleEntry<Integer, Integer>((int)Math.round((double)((Integer)spaceCountToFrequency.getKey()).intValue() / (double)((IndentStatistic.DepthCoordinate)entry.getKey()).indentDepth), ((Long)spaceCountToFrequency.getValue()).intValue()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingInt(Map.Entry::getValue)));
        return tabSizeToFrequencyMap.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(0);
    }

    private static class IndentStatistic {
        Map<DepthCoordinate, Map<Integer, Long>> depthToSpaceIndentFrequencies = new ConcurrentHashMap<DepthCoordinate, Map<Integer, Long>>();

        public void record(int indentDepth, int continuationDepth, int charCount) {
            this.record(new DepthCoordinate(indentDepth, continuationDepth), charCount);
        }

        public void record(DepthCoordinate depth, int charCount) {
            if (charCount <= 0) {
                return;
            }
            this.depthToSpaceIndentFrequencies.compute(depth, (n, map2) -> {
                if (map2 == null) {
                    map2 = new ConcurrentHashMap<Integer, Long>();
                }
                map2.compute(charCount, (m, count) -> {
                    if (count == null) {
                        count = 0L;
                    }
                    return count + 1L;
                });
                return map2;
            });
        }

        public int continuationIndent(int commonIndent) {
            Map<Integer, Long> map2 = this.depthToSpaceIndentFrequencies.entrySet().stream().flatMap(it -> {
                int depth = ((DepthCoordinate)it.getKey()).getIndentDepth();
                int continuationDepth = ((DepthCoordinate)it.getKey()).getContinuationDepth();
                return ((Map)it.getValue()).entrySet().stream().map(charsToOccurrence -> new AbstractMap.SimpleEntry<Integer, Long>(((Integer)charsToOccurrence.getKey() - depth * commonIndent) / continuationDepth, (Long)charsToOccurrence.getValue()));
            }).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, Long::sum));
            return map2.entrySet().stream().max(Comparator.comparingLong(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(commonIndent * 2);
        }

        public Map<DepthCoordinate, Map<Integer, Long>> getDepthToSpaceIndentFrequencies() {
            return this.depthToSpaceIndentFrequencies;
        }

        public void setDepthToSpaceIndentFrequencies(Map<DepthCoordinate, Map<Integer, Long>> depthToSpaceIndentFrequencies) {
            this.depthToSpaceIndentFrequencies = depthToSpaceIndentFrequencies;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndentStatistic)) {
                return false;
            }
            IndentStatistic other = (IndentStatistic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<DepthCoordinate, Map<Integer, Long>> this$depthToSpaceIndentFrequencies = this.getDepthToSpaceIndentFrequencies();
            Map<DepthCoordinate, Map<Integer, Long>> other$depthToSpaceIndentFrequencies = other.getDepthToSpaceIndentFrequencies();
            return !(this$depthToSpaceIndentFrequencies == null ? other$depthToSpaceIndentFrequencies != null : !((Object)this$depthToSpaceIndentFrequencies).equals(other$depthToSpaceIndentFrequencies));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndentStatistic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<DepthCoordinate, Map<Integer, Long>> $depthToSpaceIndentFrequencies = this.getDepthToSpaceIndentFrequencies();
            result = result * 59 + ($depthToSpaceIndentFrequencies == null ? 43 : ((Object)$depthToSpaceIndentFrequencies).hashCode());
            return result;
        }

        public String toString() {
            return "Autodetect.IndentStatistic(depthToSpaceIndentFrequencies=" + this.getDepthToSpaceIndentFrequencies() + ")";
        }

        private static final class DepthCoordinate {
            private final int indentDepth;
            private final int continuationDepth;

            public DepthCoordinate(int indentDepth, int continuationDepth) {
                this.indentDepth = indentDepth;
                this.continuationDepth = continuationDepth;
            }

            public int getIndentDepth() {
                return this.indentDepth;
            }

            public int getContinuationDepth() {
                return this.continuationDepth;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DepthCoordinate)) {
                    return false;
                }
                DepthCoordinate other = (DepthCoordinate)o;
                if (this.getIndentDepth() != other.getIndentDepth()) {
                    return false;
                }
                return this.getContinuationDepth() == other.getContinuationDepth();
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getIndentDepth();
                result = result * 59 + this.getContinuationDepth();
                return result;
            }

            public String toString() {
                return "Autodetect.IndentStatistic.DepthCoordinate(indentDepth=" + this.getIndentDepth() + ", continuationDepth=" + this.getContinuationDepth() + ")";
            }
        }
    }

    public static class Detector {
        private final IndentStatistics indentStatistics = new IndentStatistics();
        private final SpacesStatistics spacesStatistics = new SpacesStatistics();
        private final WrappingAndBracesStatistics wrappingAndBracesStatistics = new WrappingAndBracesStatistics();
        private final GeneralFormatStatistics generalFormatStatistics = new GeneralFormatStatistics();
        private final FindImportLayout findImportLayout = new FindImportLayout();
        private final FindIndentJavaVisitor findIndent = new FindIndentJavaVisitor();
        private final FindSpacesStyle findSpaces = new FindSpacesStyle();
        private final FindWrappingAndBracesStyle findWrappingAndBraces = new FindWrappingAndBracesStyle();
        private final FindLineFormatJavaVisitor findLineFormat = new FindLineFormatJavaVisitor();

        public void sample(SourceFile cu) {
            if (cu instanceof JavaSourceFile) {
                this.findImportLayout.visitNonNull((Tree)cu, 0);
                this.findIndent.visitNonNull((Tree)cu, this.indentStatistics);
                this.findSpaces.visitNonNull((Tree)cu, this.spacesStatistics);
                this.findWrappingAndBraces.visitNonNull((Tree)cu, this.wrappingAndBracesStatistics);
                this.findLineFormat.visitNonNull((Tree)cu, this.generalFormatStatistics);
            }
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.indentStatistics.getTabsAndIndentsStyle(), this.findImportLayout.getImportLayoutStyle(), this.spacesStatistics.getSpacesStyle(), this.wrappingAndBracesStatistics.getWrappingAndBracesStyle(), this.generalFormatStatistics.getFormatStyle()));
        }
    }

    private static class FindWrappingAndBracesStyle
    extends KotlinIsoVisitor<WrappingAndBracesStatistics> {
        private FindWrappingAndBracesStyle() {
        }

        @Override
        public J.If.Else visitElse(J.If.Else else_, WrappingAndBracesStatistics stats) {
            stats.elseOnNewLine += this.hasNewLine(else_.getPrefix());
            return super.visitElse(else_, stats);
        }

        private int hasNewLine(Space space) {
            return space.getWhitespace().contains("\n") ? 1 : -1;
        }
    }

    private static class WrappingAndBracesStatistics {
        int elseOnNewLine = 0;

        private WrappingAndBracesStatistics() {
        }

        public WrappingAndBracesStyle getWrappingAndBracesStyle() {
            WrappingAndBracesStyle wrappingAndBracesStyle = IntelliJ.wrappingAndBraces();
            return wrappingAndBracesStyle.withIfStatement(new WrappingAndBracesStyle.IfStatement(this.elseOnNewLine > 0, true, false));
        }
    }

    private static class FindSpacesStyle
    extends KotlinIsoVisitor<SpacesStatistics> {
        private FindSpacesStyle() {
        }

        @Nullable
        public J visit(@Nullable Tree tree, SpacesStatistics spacesStatistics) {
            try {
                super.visit(tree, (Object)spacesStatistics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (J)tree;
        }

        @Override
        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SpacesStatistics stats) {
            stats.afterTypeCast += this.hasSpace(typeCast.getExpression().getPrefix());
            return super.visitTypeCast(typeCast, stats);
        }

        @Override
        public J.Try.Catch visitCatch(J.Try.Catch _catch, SpacesStatistics stats) {
            stats.beforeCatch += this.hasSpace(_catch.getParameter().getPrefix());
            return super.visitCatch(_catch, stats);
        }

        @Override
        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(doWhileLoop.getWhileCondition().getPrefix());
            return super.visitDoWhileLoop(doWhileLoop, stats);
        }

        @Override
        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeColonInForEach += this.hasSpace(forLoop.getControl().getPadding().getVariable().getAfter());
            return super.visitForEachLoop(forLoop, stats);
        }

        @Override
        public J.ForLoop visitForLoop(J.ForLoop forLoop, SpacesStatistics stats) {
            stats.beforeFor += this.hasSpace(forLoop.getControl().getPrefix());
            stats.beforeForSemiColon += this.hasSpace(((JRightPadded)forLoop.getControl().getPadding().getInit().get(forLoop.getControl().getInit().size() - 1)).getAfter());
            stats.beforeForSemiColon += this.hasSpace(forLoop.getControl().getPadding().getCondition().getAfter());
            stats.afterForSemiColon += this.hasSpace(((Statement)forLoop.getControl().getInit().get(forLoop.getControl().getInit().size() - 1)).getPrefix());
            stats.afterForSemiColon += this.hasSpace(forLoop.getControl().getCondition().getPrefix());
            return super.visitForLoop(forLoop, stats);
        }

        @Override
        public J.If visitIf(J.If iff, SpacesStatistics stats) {
            stats.beforeIf += this.hasSpace(iff.getIfCondition().getPrefix());
            return super.visitIf(iff, stats);
        }

        @Override
        public J.Lambda visitLambda(J.Lambda lambda, SpacesStatistics stats) {
            List parameters = lambda.getParameters().getParameters();
            if (parameters.size() > 1) {
                int i;
                List paddedParameters = lambda.getParameters().getPadding().getParams();
                for (i = 0; i < paddedParameters.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(((JRightPadded)paddedParameters.get(i)).getAfter());
                }
                for (i = 1; i < parameters.size(); ++i) {
                    stats.afterComma += this.hasSpace(((J)parameters.get(i)).getPrefix());
                }
            }
            return super.visitLambda(lambda, stats);
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, SpacesStatistics stats) {
            stats.beforeMethodDeclaration += this.hasSpace(method.getPadding().getParameters().getBefore());
            List parameters = method.getParameters();
            if (parameters.size() > 1) {
                int i;
                List paddedParameters = method.getPadding().getParameters().getPadding().getElements();
                for (i = 0; i < paddedParameters.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(((JRightPadded)paddedParameters.get(i)).getAfter());
                }
                for (i = 1; i < parameters.size(); ++i) {
                    stats.afterComma += this.hasSpace(((Statement)parameters.get(i)).getPrefix());
                }
            }
            return super.visitMethodDeclaration(method, stats);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(method.getPadding().getArguments().getBefore());
            List arguments = method.getArguments();
            if (arguments.size() > 1) {
                int i;
                List paddedArguments = method.getPadding().getArguments().getPadding().getElements();
                stats.withinMethodCallParentheses += this.hasSpace(((Expression)((JRightPadded)paddedArguments.get(0)).getElement()).getPrefix());
                stats.withinMethodCallParentheses += this.hasSpace(((JRightPadded)paddedArguments.get(method.getArguments().size() - 1)).getAfter());
                for (i = 0; i < paddedArguments.size() - 1; ++i) {
                    JRightPadded elem = (JRightPadded)paddedArguments.get(i);
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (i = 1; i < arguments.size(); ++i) {
                    stats.afterComma += this.hasSpace(((Expression)arguments.get(i)).getPrefix());
                }
            }
            return super.visitMethodInvocation(method, stats);
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray newArray, SpacesStatistics stats) {
            JContainer initializer = newArray.getPadding().getInitializer();
            List elements = newArray.getInitializer();
            if (elements != null && initializer != null && elements.size() > 1) {
                int i;
                List paddedElements = initializer.getPadding().getElements();
                for (i = 0; i < paddedElements.size() - 1; ++i) {
                    stats.beforeComma += this.hasSpace(((JRightPadded)paddedElements.get(i)).getAfter());
                }
                for (i = 1; i < elements.size(); ++i) {
                    stats.afterComma += this.hasSpace(((Expression)elements.get(i)).getPrefix());
                }
            }
            return super.visitNewArray(newArray, stats);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, SpacesStatistics stats) {
            stats.beforeMethodCall += this.hasSpace(newClass.getPadding().getArguments().getBefore());
            List arguments = newClass.getArguments();
            if (arguments.size() > 1) {
                int i;
                List paddedArguments = newClass.getPadding().getArguments().getPadding().getElements();
                stats.withinMethodCallParentheses += this.hasSpace(((Expression)((JRightPadded)paddedArguments.get(0)).getElement()).getPrefix());
                stats.withinMethodCallParentheses += this.hasSpace(((JRightPadded)paddedArguments.get(newClass.getArguments().size() - 1)).getAfter());
                for (i = 0; i < paddedArguments.size() - 1; ++i) {
                    JRightPadded elem = (JRightPadded)paddedArguments.get(i);
                    stats.beforeComma += this.hasSpace(elem.getAfter());
                }
                for (i = 1; i < arguments.size(); ++i) {
                    stats.afterComma += this.hasSpace(((Expression)arguments.get(i)).getPrefix());
                }
            }
            return super.visitNewClass(newClass, stats);
        }

        @Override
        public J.Switch visitSwitch(J.Switch _switch, SpacesStatistics stats) {
            stats.beforeSwitch += this.hasSpace(_switch.getSelector().getPrefix());
            return super.visitSwitch(_switch, stats);
        }

        @Override
        public J.Synchronized visitSynchronized(J.Synchronized _sync, SpacesStatistics stats) {
            stats.beforeSynchronized += this.hasSpace(_sync.getLock().getPrefix());
            return super.visitSynchronized(_sync, stats);
        }

        @Override
        public J.Try visitTry(J.Try _try, SpacesStatistics stats) {
            if (_try.getPadding().getResources() != null) {
                stats.beforeTry += this.hasSpace(_try.getPadding().getResources().getBefore());
            }
            return super.visitTry(_try, stats);
        }

        @Override
        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SpacesStatistics stats) {
            stats.beforeWhile += this.hasSpace(whileLoop.getCondition().getPrefix());
            return super.visitWhileLoop(whileLoop, stats);
        }

        private int hasSpace(Space space) {
            return space.getWhitespace().contains(" ") ? 1 : -1;
        }
    }

    private static class SpacesStatistics {
        int beforeIf = 1;
        int beforeMethodCall = 0;
        int beforeMethodDeclaration = 0;
        int beforeFor = 1;
        int beforeWhile = 1;
        int beforeSwitch = 1;
        int beforeTry = 1;
        int beforeCatch = 1;
        int beforeSynchronized = 1;
        int beforeComma = 0;
        int afterComma = 1;
        int beforeColonInForEach = 1;
        int beforeForSemiColon = 0;
        int afterForSemiColon = 0;
        int afterTypeCast = 0;
        int withinMethodCallParentheses = 0;

        private SpacesStatistics() {
        }

        public SpacesStyle getSpacesStyle() {
            SpacesStyle spaces = IntelliJ.spaces();
            return spaces.withBeforeParentheses(new SpacesStyle.BeforeParentheses(this.beforeIf > 0, this.beforeFor > 0 || this.beforeWhile > 0, this.beforeWhile > 0 || this.beforeFor > 0, this.beforeTry > 0 || this.beforeCatch > 0, true)).withOther(new SpacesStyle.Other(this.beforeComma > 0, this.afterComma >= 1, false, true, true, true, true, true, true, true));
        }
    }

    private static class FindImportLayout
    extends KotlinIsoVisitor<Integer> {
        private final List<List<ImportAttributes>> importsBySourceFile = new ArrayList<List<ImportAttributes>>();
        private final NavigableSet<String> importedPackages = new TreeSet<String>();
        private final ImportLayoutStatistics importLayoutStatistics = new ImportLayoutStatistics();
        private static final String TYPE_ALL_OTHERS = "allOther";
        private static final String TYPE_JAVA = "java";
        private static final String TYPE_JAVAX = "javax";
        private static final String TYPE_KOTLIN = "kotlin";
        private static final String TYPE_ALL_ALIASES = "allAliases";
        private static final Double AVE_DEFAULT_WEIGHT_ALL_OTHERS = 0.5;
        private static final Double AVE_DEFAULT_WEIGHT_JAVA = 0.4;
        private static final Double AVE_DEFAULT_WEIGHT_JAVAX = 0.3;
        private static final Double AVE_DEFAULT_WEIGHT_KOTLIN = 0.2;
        private static final Double AVE_DEFAULT_WEIGHT_ALL_ALIASES = 0.1;

        private FindImportLayout() {
        }

        public ImportLayoutStyle getImportLayoutStyle() {
            return this.importsBySourceFile.stream().max(Comparator.comparing(List::size)).map(longestImports -> {
                ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
                builder.packageToFold("kotlinx.android.synthetic.*", true).packageToFold("io.ktor.*", true);
                HashMap<String, List> weightMap = new HashMap<String, List>();
                for (int i = 0; i < longestImports.size(); ++i) {
                    ImportAttributes importAttributes = (ImportAttributes)longestImports.get(i);
                    int weight = longestImports.size() - i;
                    if (importAttributes.isAlias()) {
                        weightMap.computeIfAbsent(TYPE_ALL_ALIASES, k -> new ArrayList()).add(weight);
                        continue;
                    }
                    if (importAttributes.getPackageName().startsWith("java.")) {
                        weightMap.computeIfAbsent(TYPE_JAVA, k -> new ArrayList()).add(weight);
                        continue;
                    }
                    if (importAttributes.getPackageName().startsWith("javax.")) {
                        weightMap.computeIfAbsent(TYPE_JAVAX, k -> new ArrayList()).add(weight);
                        continue;
                    }
                    if (importAttributes.getPackageName().startsWith("kotlin.")) {
                        weightMap.computeIfAbsent(TYPE_KOTLIN, k -> new ArrayList()).add(weight);
                        continue;
                    }
                    weightMap.computeIfAbsent(TYPE_ALL_OTHERS, k -> new ArrayList()).add(weight);
                }
                Map<String, Double> averageWeightMap = weightMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    List weights = (List)entry.getValue();
                    int sum = 0;
                    Iterator iterator = weights.iterator();
                    while (iterator.hasNext()) {
                        int number = (Integer)iterator.next();
                        sum += number;
                    }
                    return (double)sum / (double)weights.size();
                }));
                averageWeightMap.computeIfAbsent(TYPE_ALL_OTHERS, w -> AVE_DEFAULT_WEIGHT_ALL_OTHERS);
                averageWeightMap.computeIfAbsent(TYPE_JAVA, w -> AVE_DEFAULT_WEIGHT_JAVA);
                averageWeightMap.computeIfAbsent(TYPE_JAVAX, w -> AVE_DEFAULT_WEIGHT_JAVAX);
                averageWeightMap.computeIfAbsent(TYPE_KOTLIN, w -> AVE_DEFAULT_WEIGHT_KOTLIN);
                averageWeightMap.computeIfAbsent(TYPE_ALL_ALIASES, w -> AVE_DEFAULT_WEIGHT_ALL_ALIASES);
                List<String> sortedTypes = FindImportLayout.sortTypesByWeightDescending(averageWeightMap);
                Iterator<String> iterator = sortedTypes.iterator();
                while (iterator.hasNext()) {
                    String type;
                    switch (type = iterator.next()) {
                        case "allOther": {
                            builder.importAllOthers();
                            break;
                        }
                        case "java": {
                            builder.importPackage("java.*");
                            break;
                        }
                        case "javax": {
                            builder.importPackage("javax.*");
                            break;
                        }
                        case "kotlin": {
                            builder.importPackage("kotlin.*");
                            break;
                        }
                        case "allAliases": {
                            builder.importAllAliases();
                        }
                    }
                }
                return builder.build();
            }).orElse(IntelliJ.importLayout());
        }

        public static List<String> sortTypesByWeightDescending(Map<String, Double> averageWeightMap) {
            return averageWeightMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).map(Map.Entry::getKey).collect(Collectors.toList());
        }

        public ImportLayoutStatistics aggregate() {
            this.importLayoutStatistics.mapBlockPatterns(this.importedPackages);
            for (List<ImportAttributes> imports : this.importsBySourceFile) {
                LinkedHashSet<ImportLayoutStatistics.Block> blocks = new LinkedHashSet<ImportLayoutStatistics.Block>();
                int blockStart = 0;
                int i = 0;
                String previousPkg = "";
                int previousPkgCount = 1;
                int javaPos = Integer.MAX_VALUE;
                int javaxPos = Integer.MAX_VALUE;
                HashMap<ImportLayoutStatistics.Block, Integer> referenceCount = new HashMap<ImportLayoutStatistics.Block, Integer>();
                for (ImportAttributes anImport : imports) {
                    boolean containsNewLine;
                    previousPkgCount += previousPkg.equals(this.importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + ".")) ? 1 : 0;
                    boolean bl = containsNewLine = anImport.getPrefix().contains("\n\n") || anImport.getPrefix().contains("\r\n\r\n");
                    if (containsNewLine || i > 0 && this.importLayoutStatistics.pkgToBlockPattern.containsKey(anImport.getPackageName() + ".") && !previousPkg.equals(this.importLayoutStatistics.pkgToBlockPattern.get(anImport.getPackageName() + "."))) {
                        if (i - blockStart > 0) {
                            ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(ImportLayoutStatistics.BlockType.Import, previousPkg, containsNewLine);
                            javaPos = "java.*".equals(block.pattern) && javaPos > blockStart ? blockStart : javaPos;
                            int n = javaxPos = "javax.*".equals(block.pattern) && javaxPos > blockStart ? blockStart : javaxPos;
                            if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                                blocks.remove(block);
                            }
                            blocks.add(block);
                            referenceCount.put(block, previousPkgCount + 1);
                            previousPkgCount = 1;
                        }
                        blockStart = i;
                    }
                    ++i;
                    previousPkg = this.importLayoutStatistics.pkgToBlockPattern.getOrDefault(anImport.getPackageName() + ".", "");
                }
                if (i - blockStart > 0) {
                    ImportLayoutStatistics.Block block = new ImportLayoutStatistics.Block(ImportLayoutStatistics.BlockType.Import, previousPkg, false);
                    if (blocks.contains(block) && previousPkgCount > (Integer)referenceCount.get(block)) {
                        blocks.remove(block);
                    }
                    javaPos = "java.*".equals(block.pattern) ? blockStart : javaPos;
                    javaxPos = "javax.*".equals(block.pattern) ? blockStart : javaxPos;
                    blocks.add(block);
                }
                if (javaPos != Integer.MAX_VALUE && javaxPos != Integer.MAX_VALUE) {
                    this.importLayoutStatistics.javaBeforeJavaxCount = this.importLayoutStatistics.javaBeforeJavaxCount + (javaPos < javaxPos ? 1 : 0);
                    this.importLayoutStatistics.javaxBeforeJavaCount = this.importLayoutStatistics.javaxBeforeJavaCount + (javaxPos < javaPos ? 1 : 0);
                }
                this.importLayoutStatistics.blocksPerSourceFile.add(new ArrayList(blocks));
            }
            return this.importLayoutStatistics;
        }

        @Override
        public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, Integer integer) {
            for (J.Import anImport : cu.getImports()) {
                JavaType.FullyQualified fq;
                this.importedPackages.add(anImport.getPackageName() + ".");
                if (!anImport.getQualid().getSimpleName().equals("*")) continue;
                if (anImport.isStatic()) {
                    int count = 0;
                    for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                        fq = TypeUtils.asFullyQualified((JavaType)variable.getType());
                        if (fq == null || !anImport.getTypeName().equals(fq.getFullyQualifiedName())) continue;
                        ++count;
                    }
                    this.importLayoutStatistics.minimumFoldedStaticImports = Math.min(this.importLayoutStatistics.minimumFoldedStaticImports, count);
                    continue;
                }
                HashSet<String> fqns = new HashSet<String>();
                for (JavaType type : cu.getTypesInUse().getTypesInUse()) {
                    if (!(type instanceof JavaType.FullyQualified)) continue;
                    fq = (JavaType.FullyQualified)type;
                    if (!anImport.getPackageName().equals(fq.getPackageName())) continue;
                    fqns.add(fq.getFullyQualifiedName());
                }
                this.importLayoutStatistics.minimumFoldedImports = Math.min(this.importLayoutStatistics.minimumFoldedImports, fqns.size());
            }
            this.importsBySourceFile.add(cu.getImports().stream().map(it -> new ImportAttributes(it.getPackageName(), it.getPrefix().getWhitespace(), it.getAlias() != null)).collect(Collectors.toList()));
            return cu;
        }
    }

    private static final class ImportAttributes {
        private final String packageName;
        private final String prefix;
        private final boolean isAlias;

        public ImportAttributes(String packageName, String prefix, boolean isAlias) {
            this.packageName = packageName;
            this.prefix = prefix;
            this.isAlias = isAlias;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isAlias() {
            return this.isAlias;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportAttributes)) {
                return false;
            }
            ImportAttributes other = (ImportAttributes)o;
            if (this.isAlias() != other.isAlias()) {
                return false;
            }
            String this$packageName = this.getPackageName();
            String other$packageName = other.getPackageName();
            if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAlias() ? 79 : 97);
            String $packageName = this.getPackageName();
            result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            return result;
        }

        public String toString() {
            return "Autodetect.ImportAttributes(packageName=" + this.getPackageName() + ", prefix=" + this.getPrefix() + ", isAlias=" + this.isAlias() + ")";
        }
    }

    private static class ImportLayoutStatistics {
        List<List<Block>> blocksPerSourceFile = new ArrayList<List<Block>>();
        Map<String, String> pkgToBlockPattern = new LinkedHashMap<String, String>();
        int javaBeforeJavaxCount = 0;
        int javaxBeforeJavaCount = 0;
        int minimumFoldedImports = Integer.MAX_VALUE;
        int minimumFoldedStaticImports = Integer.MAX_VALUE;

        private ImportLayoutStatistics() {
        }

        public boolean isJavaxBeforeJava() {
            return this.javaxBeforeJavaCount >= this.javaBeforeJavaxCount;
        }

        public ImportLayoutStyle getImportLayoutStyle() {
            return this.blocksPerSourceFile.stream().max(Comparator.comparing(List::size).thenComparing(blocks -> blocks.stream().filter(b -> "all other imports".equals(((Block)b).pattern)).count())).map(longestBlocks -> {
                ImportLayoutStyle.Builder builder = ImportLayoutStyle.builder();
                boolean insertAllOthers = false;
                boolean containsJava = false;
                boolean containsJavax = false;
                int insertAllOtherAtIndex = 0;
                int nonStaticMaxCount = Integer.MIN_VALUE;
                int nonStaticCountPos = 0;
                int nonStaticPos = 0;
                ArrayList<Block> nonStaticBlocks = new ArrayList<Block>();
                ArrayList<Integer> countOfBlocksInNonStaticGroups = new ArrayList<Integer>();
                for (Block block : longestBlocks) {
                    if (!containsJava && "java.*".equals(block.pattern)) {
                        containsJava = true;
                    }
                    if (!containsJavax && "javax.*".equals(block.pattern)) {
                        containsJavax = true;
                    }
                    nonStaticBlocks.add(block);
                    countOfBlocksInNonStaticGroups.add(0);
                    countOfBlocksInNonStaticGroups.set(nonStaticCountPos, (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos) + 1);
                    if (nonStaticMaxCount < (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos)) {
                        nonStaticMaxCount = (Integer)countOfBlocksInNonStaticGroups.get(nonStaticCountPos);
                        insertAllOtherAtIndex = nonStaticCountPos;
                        insertAllOthers = true;
                    }
                    if (block.addBlankLine) {
                        nonStaticCountPos = nonStaticPos + 1;
                    }
                    ++nonStaticPos;
                }
                boolean addNewLine = false;
                addNewLine = false;
                if (!insertAllOthers) {
                    if (addNewLine) {
                        builder = builder.blankLine();
                    }
                    builder = builder.importAllOthers();
                    if (!containsJava && !containsJavax) {
                        builder = builder.blankLine();
                        if (this.isJavaxBeforeJava()) {
                            builder = builder.importPackage("javax.*");
                            builder = builder.importPackage("java.*");
                        } else {
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                        }
                    }
                    addNewLine = true;
                }
                boolean addJavaOrJavax = true;
                for (int i = 0; i < nonStaticBlocks.size(); ++i) {
                    if (insertAllOthers) {
                        if (i == insertAllOtherAtIndex) {
                            if (addNewLine) {
                                builder = builder.blankLine();
                                addNewLine = false;
                            }
                            builder = builder.importAllOthers();
                            if (containsJava || containsJavax) continue;
                            builder = builder.blankLine();
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                                continue;
                            }
                            builder = builder.importPackage("java.*");
                            builder = builder.importPackage("javax.*");
                            continue;
                        }
                        if (i > insertAllOtherAtIndex) {
                            if ((Integer)countOfBlocksInNonStaticGroups.get(i) == 0) continue;
                            insertAllOthers = false;
                            addNewLine = true;
                        }
                    }
                    Block block = (Block)nonStaticBlocks.get(i);
                    if (addJavaOrJavax && "java.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "javax.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() && "javax.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else if (addJavaOrJavax && "javax.*".equals(block.pattern)) {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        if (!(i - 1 >= 0 && "java.*".equals(((Block)nonStaticBlocks.get(i - 1)).pattern) || i + 1 < nonStaticBlocks.size() - 1 && "java.*".equals(((Block)nonStaticBlocks.get(i + 1)).pattern))) {
                            if (this.isJavaxBeforeJava()) {
                                builder = builder.importPackage("javax.*");
                                builder = builder.importPackage("java.*");
                            } else {
                                builder = builder.importPackage("java.*");
                                builder = builder.importPackage("javax.*");
                            }
                            addNewLine = true;
                            addJavaOrJavax = false;
                        } else {
                            builder = builder.importPackage(block.pattern);
                        }
                    } else {
                        if (addNewLine) {
                            builder = builder.blankLine();
                            addNewLine = false;
                        }
                        builder = builder.importPackage(block.pattern);
                    }
                    if (!block.addBlankLine || i == nonStaticBlocks.size() - 1) continue;
                    builder = builder.blankLine();
                }
                builder = builder.blankLine();
                builder = builder.importAllOthers();
                if (longestBlocks.isEmpty()) {
                    builder.importAllOthers();
                    builder.blankLine();
                    if (this.isJavaxBeforeJava()) {
                        builder = builder.importPackage("javax.*");
                        builder = builder.importPackage("java.*");
                    } else {
                        builder = builder.importPackage("java.*");
                        builder = builder.importPackage("javax.*");
                    }
                    builder.blankLine();
                    builder.importAllOthers();
                }
                builder.topLevelSymbolsToUseStarImport(Math.max(this.minimumFoldedImports, 5));
                builder.javaStaticsAndEnumsToUseStarImport(Math.max(this.minimumFoldedStaticImports, 3));
                return builder.build();
            }).orElse(IntelliJ.importLayout());
        }

        public void mapBlockPatterns(NavigableSet<String> importedPackages) {
            String longestCommonPrefix = null;
            String prevLCP = null;
            ArrayList<String> prevPackages = new ArrayList<String>();
            for (String pkg : importedPackages) {
                longestCommonPrefix = this.longestCommonPrefix(pkg, longestCommonPrefix);
                if (!prevPackages.isEmpty() && longestCommonPrefix.chars().filter(c -> c == 46).count() <= 1L && !StringUtils.isNullOrEmpty((String)prevLCP)) {
                    for (String prev : prevPackages) {
                        if (prevLCP.startsWith("java.")) {
                            prevLCP = "java.";
                        } else if (prevLCP.startsWith("javax.")) {
                            prevLCP = "javax.";
                        }
                        this.pkgToBlockPattern.put(prev, prevLCP + "*");
                    }
                    longestCommonPrefix = pkg;
                    prevPackages.clear();
                }
                prevPackages.add(pkg);
                prevLCP = longestCommonPrefix;
            }
            for (String prev : prevPackages) {
                this.pkgToBlockPattern.put(prev, prevLCP + "*");
            }
        }

        private String longestCommonPrefix(String pkg, @Nullable String lcp) {
            int i;
            if (lcp == null) {
                return pkg;
            }
            char[] p1 = pkg.toCharArray();
            char[] p2 = lcp.toCharArray();
            for (i = 0; i < p1.length && i < p2.length && p1[i] == p2[i]; ++i) {
            }
            return lcp.substring(0, i);
        }

        static class Block {
            private final BlockType type;
            private final String pattern;
            private final boolean addBlankLine;

            Block(BlockType type, String pattern, boolean addBlankLine) {
                this.type = type;
                this.pattern = pattern;
                this.addBlankLine = addBlankLine;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Block)) {
                    return false;
                }
                Block other = (Block)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.addBlankLine != other.addBlankLine) {
                    return false;
                }
                BlockType this$type = this.type;
                BlockType other$type = other.type;
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$pattern = this.pattern;
                String other$pattern = other.pattern;
                return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Block;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.addBlankLine ? 79 : 97);
                BlockType $type = this.type;
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $pattern = this.pattern;
                result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
                return result;
            }
        }

        static enum BlockType {
            Import;

        }
    }

    private static class FindIndentJavaVisitor
    extends KotlinIsoVisitor<IndentStatistics> {
        private FindIndentJavaVisitor() {
        }

        @Nullable
        public J visit(@Nullable Tree tree, IndentStatistics indentStatistics) {
            try {
                super.visit(tree, (Object)indentStatistics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (J)tree;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, IndentStatistics stats) {
            this.visitStatement((Statement)cd, stats);
            this.visit((Tree)cd.getBody(), stats);
            return cd;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, IndentStatistics stats) {
            if (method.getParameters().size() > 1) {
                int alignTo;
                if (((Statement)method.getParameters().get(0)).getPrefix().getLastWhitespace().contains("\n")) {
                    alignTo = ((Statement)method.getParameters().get(0)).getPrefix().getLastWhitespace().length() - 1;
                } else {
                    String source = method.print(this.getCursor().getParentOrThrow());
                    alignTo = source.indexOf(((Statement)method.getParameters().get(0)).print(this.getCursor())) - 1;
                }
                List parameters = method.getParameters();
                for (int i = 1; i < parameters.size(); ++i) {
                    if (!((Statement)parameters.get(i)).getPrefix().getLastWhitespace().contains("\n")) continue;
                    if (alignTo == ((Statement)parameters.get(i)).getPrefix().getLastWhitespace().length()) {
                        stats.multilineAlignedToFirstArgument++;
                        continue;
                    }
                    stats.multilineNotAlignedToFirstArgument++;
                }
            }
            this.visitStatement((Statement)method, stats);
            ListUtils.map((List)method.getLeadingAnnotations(), a -> (J.Annotation)this.visitAndCast((Tree)a, stats));
            this.visitContainer(method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, stats);
            this.visit((Tree)method.getBody(), stats);
            return method;
        }

        @Override
        public J.Block visitBlock(J.Block block, IndentStatistics stats) {
            stats.incrementDepth();
            for (Statement s : block.getStatements()) {
                if (s instanceof Expression) {
                    Set statementExpressions = (Set)this.getCursor().getMessage("STATEMENT_EXPRESSION", Collections.newSetFromMap(new IdentityHashMap(block.getStatements().size())));
                    statementExpressions.add((Expression)s);
                    this.getCursor().putMessage("STATEMENT_EXPRESSION", (Object)statementExpressions);
                }
                this.visit((Tree)s, stats);
            }
            stats.decrementDepth();
            return block;
        }

        @Override
        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, IndentStatistics indentStatistics) {
            return annotatedType;
        }

        @Override
        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, IndentStatistics stats) {
            this.visitStatement((Statement)vd, stats);
            ListUtils.map((List)vd.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.NAMED_VARIABLE, stats));
            return vd;
        }

        @Override
        public J.NewArray visitNewArray(J.NewArray na, IndentStatistics stats) {
            this.visitExpression((Expression)na, stats);
            return na;
        }

        @Override
        public Statement visitStatement(Statement statement, IndentStatistics stats) {
            boolean isInParentheses = this.getCursor().dropParentUntil(p -> p instanceof J.Block || p instanceof JContainer || p instanceof SourceFile).getValue() instanceof JContainer;
            if (isInParentheses) {
                return statement;
            }
            this.countIndents(statement.getPrefix().getWhitespace(), false, stats);
            return statement;
        }

        @Override
        public Expression visitExpression(Expression expression, IndentStatistics stats) {
            super.visitExpression(expression, stats);
            Set statementExpressions = (Set)this.getCursor().getNearestMessage("STATEMENT_EXPRESSION", Collections.emptySet());
            if (statementExpressions.contains(expression)) {
                return expression;
            }
            this.countIndents(expression.getPrefix().getWhitespace(), true, stats);
            return expression;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, IndentStatistics stats) {
            Set statementExpressions = (Set)this.getCursor().getNearestMessage("STATEMENT_EXPRESSION", Collections.emptySet());
            if (statementExpressions.contains(m)) {
                this.visitStatement((Statement)m, stats);
            } else {
                this.visitExpression((Expression)m, stats);
            }
            if (m.getPadding().getSelect() != null) {
                this.countIndents(m.getPadding().getSelect().getAfter().getWhitespace(), true, stats);
            }
            this.visitContainer(m.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, stats);
            return m;
        }

        public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, IndentStatistics indentStatistics) {
            return super.visitRightPadded(right, loc, (Object)indentStatistics);
        }

        private void countIndents(String space, boolean isContinuation, IndentStatistics stats) {
            int ni = space.lastIndexOf(10);
            int depth = stats.getDepth();
            if (ni >= 0 && depth > 0) {
                char[] chars;
                int spaceIndent = 0;
                int tabIndent = 0;
                boolean mixed = false;
                for (char c : chars = space.substring(ni).toCharArray()) {
                    if (c == ' ') {
                        if (tabIndent > 0) {
                            mixed = true;
                        }
                        ++spaceIndent;
                        continue;
                    }
                    if (c != '\t') continue;
                    if (spaceIndent > 0) {
                        mixed = true;
                    }
                    ++tabIndent;
                }
                if (spaceIndent > 0 || tabIndent > 0) {
                    if (!isContinuation) {
                        stats.spaceIndentFrequencies.record(depth, 0, spaceIndent);
                        stats.tabIndentFrequencies.record(depth, 0, tabIndent);
                        stats.deltaSpaceIndentFrequencies.record(depth - tabIndent, 0, spaceIndent);
                        stats.accumulateDepthCount += depth;
                    } else if (!mixed) {
                        stats.spaceContinuationIndentFrequencies.record(depth, stats.getContinuationDepth(), spaceIndent);
                        stats.tabContinuationIndentFrequencies.record(depth, stats.getContinuationDepth(), tabIndent);
                    }
                }
            }
        }
    }

    private static class FindLineFormatJavaVisitor
    extends KotlinIsoVisitor<GeneralFormatStatistics> {
        private FindLineFormatJavaVisitor() {
        }

        @Nullable
        public J visit(@Nullable Tree tree, GeneralFormatStatistics generalFormatStatistics) {
            try {
                super.visit(tree, (Object)generalFormatStatistics);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (J)tree;
        }

        public Space visitSpace(Space space, Space.Location loc, GeneralFormatStatistics stats) {
            String prefix = space.getWhitespace();
            char[] chars = prefix.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c != '\n') continue;
                if (i == 0 || chars[i - 1] != '\r') {
                    stats.linesWithLFNewLines++;
                    continue;
                }
                stats.linesWithCRLFNewLines++;
            }
            return space;
        }
    }

    private static class IndentStatistics {
        private final IndentStatistic spaceIndentFrequencies = new IndentStatistic();
        private final IndentStatistic spaceContinuationIndentFrequencies = new IndentStatistic();
        private final IndentStatistic tabIndentFrequencies = new IndentStatistic();
        private final IndentStatistic tabContinuationIndentFrequencies = new IndentStatistic();
        private final IndentStatistic deltaSpaceIndentFrequencies = new IndentStatistic();
        private long accumulateDepthCount = 0L;
        private int multilineAlignedToFirstArgument = 0;
        private int multilineNotAlignedToFirstArgument = 0;
        private int depth = 0;
        private int continuationDepth = 1;

        private IndentStatistics() {
        }

        public int getDepth() {
            return this.depth;
        }

        public int getContinuationDepth() {
            return this.continuationDepth;
        }

        public void incrementDepth() {
            ++this.depth;
        }

        public void decrementDepth() {
            --this.depth;
        }

        public void incrementContinuationDepth() {
            ++this.continuationDepth;
        }

        public void decrementContinuationDepth() {
            --this.continuationDepth;
        }

        public TabsAndIndentsStyle getTabsAndIndentsStyle() {
            if (this.accumulateDepthCount == 0L) {
                return IntelliJ.tabsAndIndents();
            }
            long d = this.accumulateDepthCount;
            long nt = Autodetect.getTotalCharCount(this.tabIndentFrequencies);
            double pt = (double)nt / (double)d;
            boolean useTabs = pt >= 0.5;
            int moreFrequentTabSize = Autodetect.getBiggestGroupOfTabSize(this.deltaSpaceIndentFrequencies);
            int tabSize = moreFrequentTabSize == 0 ? 4 : moreFrequentTabSize;
            IndentStatistic continuationFrequencies = useTabs ? this.tabContinuationIndentFrequencies : this.spaceContinuationIndentFrequencies;
            int continuationIndent = continuationFrequencies.continuationIndent(useTabs ? 1 : tabSize) * (useTabs ? tabSize : 1);
            return new TabsAndIndentsStyle(useTabs, tabSize, tabSize, continuationIndent, false, new TabsAndIndentsStyle.FunctionDeclarationParameters(this.multilineAlignedToFirstArgument >= this.multilineNotAlignedToFirstArgument));
        }
    }

    private static class GeneralFormatStatistics {
        private int linesWithCRLFNewLines = 0;
        private int linesWithLFNewLines = 0;

        private GeneralFormatStatistics() {
        }

        public boolean isIndentedWithLFNewLines() {
            return this.linesWithLFNewLines >= this.linesWithCRLFNewLines;
        }

        public GeneralFormatStyle getFormatStyle() {
            boolean useCRLF = !this.isIndentedWithLFNewLines();
            return new GeneralFormatStyle(useCRLF);
        }
    }
}

