/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;

public final class RenameTypeAlias
extends Recipe {
    @Option(displayName="Old alias name", description="Name of the alias type.", example="OldAlias")
    private final String aliasName;
    @Option(displayName="New alias name", description="Name of the alias type.", example="NewAlias")
    private final String newName;
    @Option(displayName="Target fully qualified type", description="Fully-qualified class name of the aliased type.", example="org.junit.Assume")
    private final String fullyQualifiedAliasedType;

    public String getDisplayName() {
        return "Rename type alias";
    }

    public String getDescription() {
        return "Change the name of a given type alias.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinIsoVisitor<ExecutionContext>(){

            @Override
            public J.Identifier visitIdentifier(J.Identifier i, ExecutionContext executionContext) {
                if (!i.getSimpleName().equals(RenameTypeAlias.this.aliasName) || !TypeUtils.isOfClassType((JavaType)i.getType(), (String)RenameTypeAlias.this.fullyQualifiedAliasedType)) {
                    return i;
                }
                if (!RenameTypeAlias.this.isVariableName(this.getCursor().getParentTreeCursor(), i)) {
                    i = i.withSimpleName(RenameTypeAlias.this.newName);
                }
                return i;
            }
        };
    }

    private boolean isVariableName(Cursor cursor, J.Identifier ident) {
        Object value = cursor.getValue();
        if (value instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)value;
            return m.getName() != ident;
        }
        if (value instanceof J.NewClass) {
            J.NewClass m = (J.NewClass)value;
            return m.getClazz() != ident;
        }
        if (value instanceof J.NewArray) {
            J.NewArray a = (J.NewArray)value;
            return a.getTypeExpression() != ident;
        }
        if (value instanceof J.VariableDeclarations) {
            J.VariableDeclarations v = (J.VariableDeclarations)value;
            return ident != v.getTypeExpression();
        }
        if (value instanceof J.VariableDeclarations.NamedVariable) {
            J.VariableDeclarations vd;
            Object maybeVd = cursor.getParentTreeCursor().getValue();
            return !(maybeVd instanceof J.VariableDeclarations) || !(vd = (J.VariableDeclarations)maybeVd).getLeadingAnnotations().stream().anyMatch(it -> "typealias".equals(it.getSimpleName()));
        }
        return !(value instanceof J.ParameterizedType);
    }

    public RenameTypeAlias(String aliasName, String newName, String fullyQualifiedAliasedType) {
        this.aliasName = aliasName;
        this.newName = newName;
        this.fullyQualifiedAliasedType = fullyQualifiedAliasedType;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getNewName() {
        return this.newName;
    }

    public String getFullyQualifiedAliasedType() {
        return this.fullyQualifiedAliasedType;
    }

    public String toString() {
        return "RenameTypeAlias(aliasName=" + this.getAliasName() + ", newName=" + this.getNewName() + ", fullyQualifiedAliasedType=" + this.getFullyQualifiedAliasedType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameTypeAlias)) {
            return false;
        }
        RenameTypeAlias other = (RenameTypeAlias)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$aliasName = this.getAliasName();
        String other$aliasName = other.getAliasName();
        if (this$aliasName == null ? other$aliasName != null : !this$aliasName.equals(other$aliasName)) {
            return false;
        }
        String this$newName = this.getNewName();
        String other$newName = other.getNewName();
        if (this$newName == null ? other$newName != null : !this$newName.equals(other$newName)) {
            return false;
        }
        String this$fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        String other$fullyQualifiedAliasedType = other.getFullyQualifiedAliasedType();
        return !(this$fullyQualifiedAliasedType == null ? other$fullyQualifiedAliasedType != null : !this$fullyQualifiedAliasedType.equals(other$fullyQualifiedAliasedType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RenameTypeAlias;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $aliasName = this.getAliasName();
        result = result * 59 + ($aliasName == null ? 43 : $aliasName.hashCode());
        String $newName = this.getNewName();
        result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
        String $fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        result = result * 59 + ($fullyQualifiedAliasedType == null ? 43 : $fullyQualifiedAliasedType.hashCode());
        return result;
    }
}

