/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.List;
import java.util.Optional;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.style.WrappingAndBracesStyle;

public class WrappingAndBracesVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final WrappingAndBracesStyle style;

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style) {
        this(style, null);
    }

    public WrappingAndBracesVisitor(WrappingAndBracesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        Statement j = super.visitStatement(statement, p);
        J parentTree = (J)this.getCursor().getParentTreeCursor().getValue();
        if (parentTree instanceof J.Block && !(j instanceof J.EnumValueSet)) {
            J.MethodDeclaration m;
            J.Block parentBlock = (J.Block)parentTree;
            if (parentBlock.getMarkers().findFirst(OmitBraces.class).isPresent()) {
                return j;
            }
            if (j instanceof J.MethodDeclaration && "<constructor>".equals(Optional.ofNullable((m = (J.MethodDeclaration)j).getMethodType()).map(JavaType.Method::getName).orElse(""))) {
                return j;
            }
            if (!j.getPrefix().getWhitespace().contains("\n")) {
                j = (Statement)j.withPrefix(this.withNewline(j.getPrefix()));
            }
        }
        return j;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, p);
        if (this.getCursor().getParent() != null && this.getCursor().getParent().firstEnclosing(J.class) instanceof J.Block && !(variableDeclarations = variableDeclarations.withLeadingAnnotations(this.withNewlines(variableDeclarations.getLeadingAnnotations()))).getLeadingAnnotations().isEmpty()) {
            if (!variableDeclarations.getModifiers().isEmpty()) {
                variableDeclarations = variableDeclarations.withModifiers(this.withNewline(variableDeclarations.getModifiers()));
            } else if (variableDeclarations.getTypeExpression() != null && !variableDeclarations.getTypeExpression().getPrefix().getWhitespace().contains("\n")) {
                variableDeclarations = variableDeclarations.withTypeExpression((TypeTree)variableDeclarations.getTypeExpression().withPrefix(this.withNewline(variableDeclarations.getTypeExpression().getPrefix())));
            }
        }
        return variableDeclarations;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = super.visitMethodDeclaration(method, p);
        m = m.withLeadingAnnotations(this.withNewlines(m.getLeadingAnnotations()));
        List modifiers = method.getModifiers();
        if (!(m = m.withModifiers(modifiers = ListUtils.map((List)modifiers, mod -> {
            if (mod.getType() == J.Modifier.Type.LanguageExtension && !mod.getAnnotations().isEmpty() && !(mod = mod.withAnnotations(ListUtils.map((List)mod.getAnnotations(), (index, anno) -> {
                if (index > 0 && !anno.getPrefix().getWhitespace().contains("\n")) {
                    return anno.withPrefix(this.withNewline(anno.getPrefix()));
                }
                return anno;
            }))).getPrefix().getWhitespace().contains("\n")) {
                mod = mod.withPrefix(this.withNewline(mod.getPrefix()));
            }
            return mod;
        }))).getLeadingAnnotations().isEmpty()) {
            modifiers = method.getModifiers();
            int firstModifierIndex = -1;
            for (int i = 0; i < method.getModifiers().size(); ++i) {
                if (((J.Modifier)method.getModifiers().get(i)).getType() == J.Modifier.Type.Final) continue;
                if (((J.Modifier)method.getModifiers().get(i)).getPrefix().getWhitespace().contains("\n")) break;
                firstModifierIndex = i;
                break;
            }
            if (firstModifierIndex >= 0) {
                int finalIndex = firstModifierIndex;
                m = m.withModifiers(ListUtils.map((List)modifiers, (index, mod) -> {
                    if (finalIndex == index) {
                        return mod.withPrefix(this.withNewline(mod.getPrefix()));
                    }
                    return mod;
                }));
            }
        }
        return m;
    }

    @Override
    public J.If.Else visitElse(J.If.Else else_, P p) {
        boolean hasBody;
        J.If.Else e = super.visitElse(else_, p);
        boolean bl = hasBody = e.getBody() instanceof J.Block || e.getBody() instanceof J.If;
        if (hasBody) {
            if (this.style.getIfStatement().getElseOnNewLine().booleanValue() && !e.getPrefix().getWhitespace().contains("\n")) {
                e = e.withPrefix(e.getPrefix().withWhitespace("\n" + e.getPrefix().getWhitespace()));
            } else if (!this.style.getIfStatement().getElseOnNewLine().booleanValue() && e.getPrefix().getWhitespace().contains("\n")) {
                e = e.withPrefix(Space.EMPTY);
            }
        }
        return e;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration c = super.visitClassDeclaration(classDecl, p);
        J.ClassDeclaration.Kind k = (c = c.withLeadingAnnotations(this.withNewlines(c.getLeadingAnnotations()))).getAnnotations().getKind();
        List leadingAnnotations = k.getAnnotations();
        if (!leadingAnnotations.isEmpty()) {
            if (!(k = k.withAnnotations(leadingAnnotations = ListUtils.map((List)leadingAnnotations, (index, anno) -> {
                if (index > 0 && !anno.getPrefix().getWhitespace().contains("\n")) {
                    return anno.withPrefix(this.withNewline(anno.getPrefix()));
                }
                return anno;
            }))).getPrefix().getWhitespace().contains("\n")) {
                k = k.withPrefix(this.withNewline(k.getPrefix()));
            }
            c = c.getAnnotations().withKind(k);
        }
        if (!c.getLeadingAnnotations().isEmpty()) {
            boolean hasModifier = false;
            for (J.Modifier mod : c.getModifiers()) {
                if (mod.getType() == J.Modifier.Type.Final) continue;
                hasModifier = true;
                break;
            }
            if (hasModifier) {
                c = c.withModifiers(this.withNewline(c.getModifiers()));
            } else {
                J.ClassDeclaration.Kind kind = c.getAnnotations().getKind();
                if (!kind.getPrefix().getWhitespace().contains("\n")) {
                    c = c.getAnnotations().withKind(kind.withPrefix(kind.getPrefix().withWhitespace("\n" + kind.getPrefix().getWhitespace())));
                }
            }
        }
        return c;
    }

    private List<J.Annotation> withNewlines(List<J.Annotation> annotations) {
        if (annotations.isEmpty()) {
            return annotations;
        }
        return ListUtils.map(annotations, (index, a) -> {
            if (index != 0 && !a.getPrefix().getWhitespace().contains("\n")) {
                a = a.withPrefix(this.withNewline(a.getPrefix()));
            }
            return a;
        });
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J.Block b = super.visitBlock(block, p);
        if (!b.getMarkers().findFirst(OmitBraces.class).isPresent() && !b.getEnd().getWhitespace().contains("\n")) {
            b = b.withEnd(this.withNewline(b.getEnd()));
        }
        return b;
    }

    private Space withNewline(Space space) {
        if (space.getComments().isEmpty()) {
            space = space.withWhitespace("\n" + space.getWhitespace());
        } else if (((Comment)space.getComments().get(space.getComments().size() - 1)).isMultiline()) {
            space = space.withComments(ListUtils.mapLast((List)space.getComments(), c -> c.withSuffix("\n")));
        }
        return space;
    }

    private List<J.Modifier> withNewline(List<J.Modifier> modifiers) {
        J.Modifier firstModifier = modifiers.iterator().next();
        if (firstModifier.getType() == J.Modifier.Type.Final) {
            return modifiers;
        }
        if (!firstModifier.getPrefix().getWhitespace().contains("\n")) {
            return ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(this.withNewline(mod.getPrefix())));
        }
        return modifiers;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }
}

