/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.style;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.kotlin.KotlinStyle;
import org.openrewrite.kotlin.style.Deserializer;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.style.Serializer;

@JsonDeserialize(using=Deserializer.class)
@JsonSerialize(using=Serializer.class)
public class ImportLayoutStyle
implements KotlinStyle {
    private final int topLevelSymbolsToUseStarImport;
    private final int javaStaticsAndEnumsToUseStarImport;
    private final List<Block> layout;
    private final List<Block> packagesToFold;
    private final List<Block> blocksNoCatchalls;
    private final List<Block> blocksOnlyCatchalls;

    public ImportLayoutStyle(int topLevelSymbolsToUseStarImport, int javaStaticsAndEnumsToUseStarImport, List<Block> layout, List<Block> packagesToFold) {
        this.topLevelSymbolsToUseStarImport = topLevelSymbolsToUseStarImport;
        this.javaStaticsAndEnumsToUseStarImport = javaStaticsAndEnumsToUseStarImport;
        this.layout = layout.isEmpty() ? IntelliJ.importLayout().getLayout() : layout;
        this.packagesToFold = packagesToFold;
        Map<Boolean, List<Block>> blockGroups = layout.stream().collect(Collectors.partitioningBy(block -> block instanceof Block.AllOthers));
        this.blocksNoCatchalls = blockGroups.get(false);
        this.blocksOnlyCatchalls = blockGroups.get(true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("topLevelSymbols=").append(this.topLevelSymbolsToUseStarImport).append(", javaStaticAndEnums=").append(this.javaStaticsAndEnumsToUseStarImport).append('\n');
        for (Block block : this.layout) {
            s.append(block).append("\n");
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImportLayoutStyle)) {
            return false;
        }
        ImportLayoutStyle other = (ImportLayoutStyle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTopLevelSymbolsToUseStarImport() != other.getTopLevelSymbolsToUseStarImport()) {
            return false;
        }
        if (this.getJavaStaticsAndEnumsToUseStarImport() != other.getJavaStaticsAndEnumsToUseStarImport()) {
            return false;
        }
        List<Block> this$layout = this.getLayout();
        List<Block> other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !((Object)this$layout).equals(other$layout)) {
            return false;
        }
        List<Block> this$packagesToFold = this.getPackagesToFold();
        List<Block> other$packagesToFold = other.getPackagesToFold();
        return !(this$packagesToFold == null ? other$packagesToFold != null : !((Object)this$packagesToFold).equals(other$packagesToFold));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImportLayoutStyle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTopLevelSymbolsToUseStarImport();
        result = result * 59 + this.getJavaStaticsAndEnumsToUseStarImport();
        List<Block> $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : ((Object)$layout).hashCode());
        List<Block> $packagesToFold = this.getPackagesToFold();
        result = result * 59 + ($packagesToFold == null ? 43 : ((Object)$packagesToFold).hashCode());
        return result;
    }

    public int getTopLevelSymbolsToUseStarImport() {
        return this.topLevelSymbolsToUseStarImport;
    }

    public int getJavaStaticsAndEnumsToUseStarImport() {
        return this.javaStaticsAndEnumsToUseStarImport;
    }

    public List<Block> getLayout() {
        return this.layout;
    }

    public List<Block> getPackagesToFold() {
        return this.packagesToFold;
    }

    public List<Block> getBlocksNoCatchalls() {
        return this.blocksNoCatchalls;
    }

    public List<Block> getBlocksOnlyCatchalls() {
        return this.blocksOnlyCatchalls;
    }

    public static class Builder {
        private final List<Block> blocks = new ArrayList<Block>();
        private final List<Block> packagesToFold = new ArrayList<Block>();
        private int topLevelSymbolsToUseStarImport = 5;
        private int javaStaticsAndEnumsToUseStarImport = 3;

        public Builder importAllOthers() {
            this.blocks.add(new Block.AllOthers());
            return this;
        }

        public Builder importAllAliases() {
            this.blocks.add(new Block.AllAliases());
            return this;
        }

        public Builder blankLine() {
            if (!this.blocks.isEmpty() && this.blocks.get(this.blocks.size() - 1) instanceof Block.BlankLines) {
                ((Block.BlankLines)this.blocks.get(this.blocks.size() - 1)).count++;
            } else {
                this.blocks.add(new Block.BlankLines());
            }
            return this;
        }

        public Builder importPackage(String packageWildcard, Boolean withSubpackages) {
            this.blocks.add(new Block.ImportPackage(packageWildcard, withSubpackages));
            return this;
        }

        public Builder importPackage(String packageWildcard) {
            return this.importPackage(packageWildcard, true);
        }

        public Builder packageToFold(String packageWildcard, Boolean withSubpackages) {
            this.packagesToFold.add(new Block.ImportPackage(packageWildcard, withSubpackages));
            return this;
        }

        public Builder packageToFold(String packageWildcard) {
            return this.packageToFold(packageWildcard, true);
        }

        public Builder topLevelSymbolsToUseStarImport(int topLevelSymbolsToUseStarImport) {
            this.topLevelSymbolsToUseStarImport = topLevelSymbolsToUseStarImport;
            return this;
        }

        public Builder javaStaticsAndEnumsToUseStarImport(int javaStaticsAndEnumsToUseStarImport) {
            this.javaStaticsAndEnumsToUseStarImport = javaStaticsAndEnumsToUseStarImport;
            return this;
        }

        public ImportLayoutStyle build() {
            for (Block block : this.blocks) {
                if (!(block instanceof Block.AllOthers)) continue;
                ((Block.AllOthers)block).setPackageImports(this.blocks.stream().filter(b -> b.getClass().equals(Block.ImportPackage.class)).map(Block.ImportPackage.class::cast).collect(Collectors.toList()));
            }
            return new ImportLayoutStyle(this.topLevelSymbolsToUseStarImport, this.javaStaticsAndEnumsToUseStarImport, this.blocks, this.packagesToFold);
        }
    }

    public static interface Block {
        public boolean accept(JRightPadded<J.Import> var1);

        public static class AllAliases
        extends ImportPackage {
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllAliases() {
                super("*", true);
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toString() {
                return "import all alias imports";
            }
        }

        public static class AllOthers
        extends ImportPackage {
            private Collection<ImportPackage> packageImports = Collections.emptyList();

            public AllOthers() {
                super("*", true);
            }

            public void setPackageImports(Collection<ImportPackage> packageImports) {
                this.packageImports = packageImports;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                for (ImportPackage pi : this.packageImports) {
                    if (!pi.accept(anImport)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String toString() {
                return "import all other imports";
            }
        }

        public static class ImportPackage
        implements Block {
            static final Comparator<JRightPadded<J.Import>> IMPORT_SORTING = (i1, i2) -> {
                String[] import1 = ((J.Import)i1.getElement()).getQualid().printTrimmed().split("\\.");
                String[] import2 = ((J.Import)i2.getElement()).getQualid().printTrimmed().split("\\.");
                for (int i = 0; i < Math.min(import1.length, import2.length); ++i) {
                    int diff = import1[i].compareTo(import2[i]);
                    if (diff == 0) continue;
                    return diff;
                }
                if (import1.length == import2.length) {
                    return 0;
                }
                return import1.length > import2.length ? 1 : -1;
            };
            private final Pattern packageWildcard;

            public ImportPackage(String packageWildcard, boolean withSubpackages) {
                this.packageWildcard = Pattern.compile(packageWildcard.replace(".", "\\.").replace("*", withSubpackages ? ".+" : "[^.]+"));
            }

            public Pattern getPackageWildcard() {
                return this.packageWildcard;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return this.packageWildcard.matcher(((J.Import)anImport.getElement()).getQualid().printTrimmed()).matches();
            }

            public String toString() {
                return "import " + this.packageWildcard;
            }
        }

        public static class BlankLines
        implements Block {
            private int count = 1;

            private int getCount() {
                return this.count;
            }

            @Override
            public boolean accept(JRightPadded<J.Import> anImport) {
                return false;
            }

            public String toString() {
                return "<blank line>" + (this.count > 1 ? " (x" + this.count + ")" : "");
            }
        }
    }

    private static class LayoutState {
        Map<Block, List<JRightPadded<J.Import>>> imports = new HashMap<Block, List<JRightPadded<J.Import>>>();

        private LayoutState() {
        }

        public void claimImport(Block block, JRightPadded<J.Import> import_) {
            this.imports.computeIfAbsent(block, b -> new ArrayList()).add(import_);
        }

        public List<JRightPadded<J.Import>> getImports(Block block) {
            return this.imports.getOrDefault(block, Collections.emptyList());
        }
    }
}

