/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.annotation.AnnotationTarget;
import kotlin.jvm.functions.Function2;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompilerKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.CompilerPipelineKt;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.pipeline.ModuleCompilerInput;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporterFactory;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.session.environment.AbstractProjectEnvironment;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.utils.PathUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.kotlin.CompiledKotlinSource;
import org.openrewrite.kotlin.internal.KotlinParserVisitor;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class KotlinParser
implements Parser<K.CompilationUnit> {
    @Nullable
    private final Collection<Path> classpath;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final String moduleName;

    public List<K.CompilationUnit> parse(String ... sources) {
        Pattern packagePattern = Pattern.compile("^package\\s+([^;]+);");
        Pattern classPattern = Pattern.compile("(class|interface|enum)\\s*(<[^>]*>)?\\s+(\\w+)");
        Function<String, String> simpleName = sourceStr -> {
            Matcher classMatcher = classPattern.matcher((CharSequence)sourceStr);
            return classMatcher.find() ? classMatcher.group(3) : null;
        };
        return this.parseInputs(Arrays.stream(sources).map(sourceFile -> {
            Matcher packageMatcher = packagePattern.matcher((CharSequence)sourceFile);
            String pkg = packageMatcher.find() ? packageMatcher.group(1).replace('.', '/') + "/" : "";
            String className = Optional.ofNullable((String)simpleName.apply((String)sourceFile)).orElse(Long.toString(System.nanoTime())) + ".kt";
            Path path = Paths.get(pkg + className, new String[0]);
            return new Parser.Input(path, null, () -> new ByteArrayInputStream(sourceFile.getBytes(StandardCharsets.UTF_8)), true);
        }).collect(Collectors.toList()), null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public List<K.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        Map<FirSession, List<CompiledKotlinSource>> firSessionToCus = this.parseInputsToCompilerAst(sources, relativeTo, pctx);
        FirSession firSession = (FirSession)firSessionToCus.keySet().toArray()[0];
        List<CompiledKotlinSource> compilerCus = firSessionToCus.get(firSession);
        ArrayList<K.CompilationUnit> cus = new ArrayList<K.CompilationUnit>(firSessionToCus.get(firSession).size());
        for (CompiledKotlinSource compiled : compilerCus) {
            try {
                KotlinParserVisitor mappingVisitor = new KotlinParserVisitor(compiled.getInput().getRelativePath(relativeTo), compiled.getInput().getFileAttributes(), compiled.getInput().getSource(ctx), this.typeCache, firSession, ctx);
                K.CompilationUnit kcu = (K.CompilationUnit)mappingVisitor.visitFile(compiled.getFirFile(), (ExecutionContext)new InMemoryExecutionContext());
                cus.add(kcu);
                parsingListener.parsed(compiled.getInput(), (SourceFile)kcu);
            }
            catch (Throwable t) {
                pctx.parseFailure(compiled.getInput(), compiled.getInput().getRelativePath(relativeTo), (Parser)KotlinParser.builder().build(), t);
                ctx.getOnError().accept(t);
            }
        }
        return cus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<FirSession, List<CompiledKotlinSource>> parseInputsToCompilerAst(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ParsingExecutionContextView ctx) {
        CompilerConfiguration compilerConfiguration = this.compilerConfiguration();
        File buildFile = null;
        K2JVMCompilerArguments arguments = new K2JVMCompilerArguments();
        ModuleChunk moduleChunk = K2JVMCompilerKt.configureModuleChunk((CompilerConfiguration)compilerConfiguration, (K2JVMCompilerArguments)arguments, buildFile);
        List chunk = moduleChunk.getModules();
        if (this.classpath != null) {
            for (Path path : this.classpath) {
                File file;
                try {
                    file = path.toFile();
                }
                catch (UnsupportedOperationException ex) {
                    continue;
                }
                JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)file);
            }
        }
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)compilerConfiguration, (File)PathUtil.getResourcePathForClass(AnnotationTarget.class));
        KotlinToJVMBytecodeCompilerKt.configureSourceRoots((CompilerConfiguration)compilerConfiguration, (List)chunk, buildFile);
        JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)compilerConfiguration);
        Disposable disposable = Disposer.newDisposable();
        HashMap<FirSession, List<CompiledKotlinSource>> sessionToCus = new HashMap<FirSession, List<CompiledKotlinSource>>();
        try {
            KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction((Disposable)disposable, (CompilerConfiguration)compilerConfiguration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
            Project project = environment.getProject();
            VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem("file");
            GlobalSearchScope globalScope = GlobalSearchScope.allScope((Project)project);
            JvmPackagePartProvider packagePartProvider = environment.createPackagePartProvider(globalScope);
            Function<GlobalSearchScope, JvmPackagePartProvider> packagePartProviderFunction = globalSearchScope -> packagePartProvider;
            VfsBasedProjectEnvironment projectEnvironment = new VfsBasedProjectEnvironment(project, fileSystem, packagePartProviderFunction::apply);
            if (chunk.size() > 1) {
                throw new IllegalStateException("Implement me. Expects chunk size of 1, but was " + chunk.size());
            }
            Module module = (Module)chunk.get(0);
            CompilerConfiguration moduleConfiguration = CoreEnvironmentUtilsKt.applyModuleProperties((CompilerConfiguration)compilerConfiguration, (Module)module, buildFile);
            moduleConfiguration.put(JVMConfigurationKeys.FRIEND_PATHS, (Object)module.getFriendPaths());
            LinkedHashSet<KtVirtualFileSourceFile> platformSources = new LinkedHashSet<KtVirtualFileSourceFile>();
            LinkedHashSet commonSources = new LinkedHashSet();
            List contentRoots = (List)compilerConfiguration.get(CLIConfigurationKeys.CONTENT_ROOTS);
            List roots = contentRoots == null ? Collections.emptyList() : contentRoots.stream().filter(it -> it instanceof KotlinSourceRoot).map(it -> (KotlinSourceRoot)it).collect(Collectors.toList());
            Function2 sortFiles = (virtualFile, isCommon) -> {
                KtVirtualFileSourceFile file = new KtVirtualFileSourceFile(virtualFile);
                if (isCommon.booleanValue()) {
                    commonSources.add(file);
                } else {
                    platformSources.add(file);
                }
                return Unit.INSTANCE;
            };
            CoreEnvironmentUtilsKt.forAllFiles(roots, (CompilerConfiguration)compilerConfiguration, (Project)project, null, (Function2)sortFiles);
            int i = 0;
            for (Parser.Input source : sources) {
                String fileName = "openRewriteFile.kt".equals(source.getPath().toString()) ? "openRewriteFile.kt" + i : source.getPath().toString();
                LightVirtualFile vFile = new LightVirtualFile(fileName, (FileType)KotlinFileType.INSTANCE, (CharSequence)source.getSource((ExecutionContext)ctx).readFully());
                platformSources.add(new KtVirtualFileSourceFile((VirtualFile)vFile));
            }
            BaseDiagnosticsCollector diagnosticsReporter = DiagnosticReporterFactory.INSTANCE.createReporter(false);
            ModuleCompilerInput compilerInput = new ModuleCompilerInput(new TargetId(module.getModuleName(), module.getModuleType()), CommonPlatforms.INSTANCE.getDefaultCommonPlatform(), commonSources, JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform(), platformSources, moduleConfiguration, Collections.emptyList());
            ModuleCompilerEnvironment compilerEnvironment = new ModuleCompilerEnvironment((AbstractProjectEnvironment)projectEnvironment, diagnosticsReporter);
            CommonCompilerPerformanceManager performanceManager = (CommonCompilerPerformanceManager)compilerConfiguration.get(CLIConfigurationKeys.PERF_MANAGER);
            ModuleCompilerAnalyzedOutput output = CompilerPipelineKt.compileModuleToAnalyzedFir((ModuleCompilerInput)compilerInput, (ModuleCompilerEnvironment)compilerEnvironment, Collections.emptyList(), null, (DiagnosticReporter)diagnosticsReporter, (CommonCompilerPerformanceManager)performanceManager);
            CompilerPipelineKt.convertAnalyzedFirToIr((ModuleCompilerInput)compilerInput, (ModuleCompilerAnalyzedOutput)output, (ModuleCompilerEnvironment)compilerEnvironment);
            List firFiles = output.getFir();
            ArrayList inputs = new ArrayList(firFiles.size());
            sources.iterator().forEachRemaining(inputs::add);
            assert (firFiles.size() == inputs.size());
            ArrayList<CompiledKotlinSource> cus = new ArrayList<CompiledKotlinSource>();
            for (int j = 0; j < inputs.size(); ++j) {
                Parser.Input input = (Parser.Input)inputs.get(j);
                FirFile firFile = (FirFile)firFiles.get(j);
                cus.add(new CompiledKotlinSource(input, firFile));
            }
            sessionToCus.put(output.getSession(), cus);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
        return sessionToCus;
    }

    private CompilerConfiguration compilerConfiguration() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.put(CommonConfigurationKeys.MODULE_NAME, (Object)this.moduleName);
        compilerConfiguration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, this.logCompilationWarningsAndErrors ? new PrintingMessageCollector(System.err, MessageRenderer.PLAIN_FULL_PATHS, true) : MessageCollector.Companion.getNONE());
        compilerConfiguration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)new LanguageVersionSettingsImpl(LanguageVersion.KOTLIN_1_7, ApiVersion.KOTLIN_1_7));
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)true);
        compilerConfiguration.put(JVMConfigurationKeys.DO_NOT_CLEAR_BINDING_CONTEXT, (Object)false);
        compilerConfiguration.put(CommonConfigurationKeys.ALLOW_ANY_SCRIPTS_IN_SOURCE_ROOTS, (Object)true);
        compilerConfiguration.put(CommonConfigurationKeys.INCREMENTAL_COMPILATION, (Object)true);
        JvmContentRootsKt.addJvmSdkRoots((CompilerConfiguration)compilerConfiguration, (List)PathUtil.getJdkClassesRootsFromCurrentJre());
        return compilerConfiguration;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".kt");
    }

    public KotlinParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("openRewriteFile.kt");
    }

    public static Builder builder() {
        return new Builder();
    }

    private KotlinParser(Collection<Path> classpath, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, String moduleName) {
        this.classpath = classpath;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.moduleName = moduleName;
    }

    public static class Builder
    extends Parser.Builder {
        @Nullable
        private Collection<Path> classpath = JavaParser.runtimeClasspath();
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors = false;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();
        private String moduleName = "main";

        public Builder() {
            super(K.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder classpath(Collection<Path> classpath) {
            this.classpath = classpath;
            return this;
        }

        public Builder classpath(String ... classpath) {
            this.classpath = JavaParser.dependenciesFromClasspath((String[])classpath);
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.moduleName = moduleName;
            return this;
        }

        public KotlinParser build() {
            return new KotlinParser(this.classpath, this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.moduleName);
        }

        public String getDslName() {
            return "kotlin";
        }
    }
}

