/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.logging.JavetStandardConsoleInterceptor;
import com.caoccao.javet.interop.JavetBridge;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.IV8Value;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiConsumer;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.DebugOnly;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.javascript.internal.JavetUtils;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;

public class TSCRuntime
implements AutoCloseable {
    private static final boolean USE_WRAPPED_V8_RUNTIME = false;
    public final V8Runtime v8Runtime;
    public @Nullable V8ValueFunction tsParseV8 = null;
    private final V8ValueObject parseOptionsV8;
    private final JavetStandardConsoleInterceptor javetStandardConsoleInterceptor;

    public static TSCRuntime init() {
        return TSCRuntime.init(false);
    }

    public static TSCRuntime init(boolean forceWrappedV8Runtime) {
        try {
            V8Runtime v8Runtime = forceWrappedV8Runtime ? JavetBridge.makeWrappedV8Runtime() : V8Host.getV8Instance().createV8Runtime();
            JavetStandardConsoleInterceptor javetStandardConsoleInterceptor = new JavetStandardConsoleInterceptor(v8Runtime);
            javetStandardConsoleInterceptor.register(new IV8ValueObject[]{v8Runtime.getGlobalObject()});
            return new TSCRuntime(v8Runtime, javetStandardConsoleInterceptor);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public TSCRuntime setCompilerOptionOverride(String key, Object value) {
        try {
            this.close();
            TSCRuntime runtime = TSCRuntime.init(false);
            V8Value compilerOptions = runtime.parseOptionsV8.get((Object)"compilerOptions");
            if (compilerOptions.isNullOrUndefined()) {
                compilerOptions = runtime.v8Runtime.createV8ValueObject();
                runtime.parseOptionsV8.set((Object)"compilerOptions", (Object)compilerOptions);
            }
            ((V8ValueObject)compilerOptions).setWeak();
            ((V8ValueObject)compilerOptions).set((Object)key, value);
            return runtime;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public TSCRuntime enableVirtualFileSystemTracing() {
        try {
            this.parseOptionsV8.set((Object)"traceVirtualFileSystem", (Object)true);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public TSCRuntime(V8Runtime v8Runtime, JavetStandardConsoleInterceptor javetStandardConsoleInterceptor) {
        this.v8Runtime = v8Runtime;
        this.javetStandardConsoleInterceptor = javetStandardConsoleInterceptor;
        try {
            this.parseOptionsV8 = v8Runtime.createV8ValueObject();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getJSEntryProgramText() {
        String string;
        block9: {
            InputStream is = TSCRuntime.class.getResourceAsStream("/tsc/index.js");
            try {
                if (is == null) {
                    throw new IllegalStateException("entry JS resource does not exist");
                }
                string = StringUtils.readFully((InputStream)is, (Charset)StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public void importTS() {
        if (this.tsParseV8 != null) {
            return;
        }
        try {
            this.v8Runtime.getExecutor("const require = () => undefined;").executeVoid();
            this.v8Runtime.getExecutor("const module = {exports: {}};").executeVoid();
            this.v8Runtime.getExecutor(TSCRuntime.getJSEntryProgramText()).executeVoid();
            this.tsParseV8 = (V8ValueFunction)this.v8Runtime.getExecutor("module.exports.default").execute();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @DebugOnly
    public void parseSingleSource(@Language(value="typescript") String sourceText, BiConsumer<TSCNode, TSCSourceFileContext> callback) {
        this.parseSingleSource(sourceText, "file.ts", callback);
    }

    public void parseSingleSource(@Language(value="typescript") String sourceText, String filename, BiConsumer<TSCNode, TSCSourceFileContext> callback) {
        this.parseSourceTexts(Collections.singletonMap(Paths.get(filename, new String[0]), sourceText), callback);
    }

    public void parseSourceTexts(Map<Path, String> sourceTexts, BiConsumer<TSCNode, TSCSourceFileContext> callback) {
        this.importTS();
        assert (this.tsParseV8 != null);
        try (V8ValueMap sourceTextsV8 = this.v8Runtime.createV8ValueMap();){
            for (Map.Entry<Path, String> entry : sourceTexts.entrySet()) {
                sourceTextsV8.set((Object)entry.getKey().toString(), (Object)entry.getValue());
            }
            try (V8ValueObject parseResultV8 = (V8ValueObject)this.tsParseV8.call(null, new V8Value[]{sourceTextsV8, this.parseOptionsV8});
                 TSCProgramContext programContext = TSCProgramContext.fromJS(parseResultV8);
                 V8ValueMap sourceFilesByPathV8 = (V8ValueMap)parseResultV8.get((Object)"sourceFiles");){
                sourceFilesByPathV8.forEach((filePathV8, maybeSourceFileV8) -> {
                    if (maybeSourceFileV8.isNullOrUndefined()) {
                        System.err.println("**** missing source file: " + (String)filePathV8.getValue());
                        return;
                    }
                    V8ValueObject sourceFileV8 = (V8ValueObject)maybeSourceFileV8;
                    String sourceText = sourceFileV8.getPropertyString((Object)"text");
                    Path filePath = Paths.get((String)filePathV8.getValue(), new String[0]);
                    try (TSCSourceFileContext sourceFileContext = new TSCSourceFileContext(programContext, sourceText, filePath);){
                        TSCNode node = programContext.tscNode(sourceFileV8);
                        callback.accept(node, sourceFileContext);
                    }
                });
            }
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        JavetUtils.close((IV8Value)this.tsParseV8);
        JavetUtils.close((IV8Value)this.parseOptionsV8);
        if (!this.v8Runtime.isClosed()) {
            this.v8Runtime.await();
            this.v8Runtime.lowMemoryNotification();
            try {
                this.javetStandardConsoleInterceptor.unregister(new IV8ValueObject[]{this.v8Runtime.getGlobalObject()});
            }
            catch (JavetException javetException) {
                // empty catch block
            }
            this.v8Runtime.await();
            this.v8Runtime.lowMemoryNotification();
        }
        try {
            this.v8Runtime.close();
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }
}

