/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.interop.options.V8RuntimeOptions;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueReference;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.javascript.internal.tsc.generated.TSCSyntaxKind;

public final class JavetBridge {
    private JavetBridge() {
    }

    public static Map<Long, IV8ValueReference> getReferenceMapSnapshot(V8Runtime runtime) {
        return new HashMap<Long, IV8ValueReference>(runtime.referenceMap);
    }

    public static V8Runtime makeWrappedV8Runtime() {
        final V8Host host = V8Host.getV8Instance();
        V8RuntimeOptions runtimeOptions = (V8RuntimeOptions)host.getJSRuntimeType().getRuntimeOptions();
        if (!host.isLibraryLoaded()) {
            throw new IllegalStateException("native v8 library is not loaded");
        }
        long handle = host.getV8Native().createV8Runtime((Object)runtimeOptions);
        V8Runtime v8Runtime = new V8Runtime(host, handle, false, host.getV8Native(), (RuntimeOptions)runtimeOptions){
            private final Map<Long, String> remainingReferences;
            {
                super(v8Host, handle, pooled, v8Native, runtimeOptions);
                this.remainingReferences = new HashMap<Long, String>();
            }

            void addReference(IV8ValueReference iV8ValueReference) {
                super.addReference(iV8ValueReference);
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    sb.append("\t").append(element.toString()).append("\n");
                }
                this.remainingReferences.put(iV8ValueReference.getHandle(), sb.toString());
            }

            void removeReference(IV8ValueReference iV8ValueReference) throws JavetException {
                super.removeReference(iV8ValueReference);
            }

            public void close(boolean forceClose) throws JavetException {
                if (!this.isClosed() && forceClose) {
                    this.debugOpenReferences();
                    this.removeAllReferences();
                    host.getV8Native().closeV8Runtime(this.handle);
                }
            }

            private void debugOpenReferences() {
                Map<Long, IV8ValueReference> referenceMap = JavetBridge.getReferenceMapSnapshot(this);
                boolean hasOpen = false;
                for (IV8ValueReference valueV8 : referenceMap.values()) {
                    if (valueV8.isClosed()) continue;
                    hasOpen = true;
                    System.err.print("** still open: ");
                    if (valueV8 instanceof V8ValueFunction) {
                        System.err.print(valueV8);
                    } else if (valueV8 instanceof V8ValueObject) {
                        try (V8Value constructor = ((V8ValueObject)valueV8).get((Object)"constructor");){
                            if (constructor instanceof V8ValueObject) {
                                String name = (String)((V8ValueObject)constructor).getPrimitive((Object)"name");
                                if (name.equals("NodeObject")) {
                                    System.err.print("[" + name + ":" + (Object)((Object)TSCSyntaxKind.fromCode(((V8ValueObject)valueV8).getInteger((Object)"kind"))) + "]");
                                } else {
                                    System.err.print("[" + name + "]");
                                }
                            } else {
                                System.err.print("[object without a constructor]");
                            }
                        }
                        catch (JavetException e) {
                            System.err.print("[error while trying to display a JS object]");
                        }
                    } else {
                        System.err.print(valueV8);
                    }
                    try {
                        if (valueV8.isWeak()) {
                            System.err.print(" (weak)");
                        }
                    }
                    catch (JavetException e) {
                        throw new RuntimeException(e);
                    }
                    System.err.println();
                    String caller = this.remainingReferences.get(valueV8.getHandle());
                    System.err.println("\tfrom " + caller);
                }
                if (hasOpen) {
                    throw new IllegalStateException("runtime contains un-recycled V8 references");
                }
            }
        };
        host.getV8Native().registerV8Runtime(handle, (Object)v8Runtime);
        return v8Runtime;
    }
}

