/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.generated.TSCSymbolFlag;

public class TSCSymbol
implements TSCV8Backed {
    private final TSCProgramContext programContext;
    public final V8ValueObject symbolV8;

    public TSCSymbol(TSCProgramContext programContext, V8ValueObject symbolV8) {
        this.programContext = programContext;
        this.symbolV8 = symbolV8;
    }

    @Override
    public TSCProgramContext getProgramContext() {
        return this.programContext;
    }

    public String toString() {
        return "Symbol(" + this.getTypeChecker().symbolToString(this) + ")";
    }

    public @Nullable TSCNode getValueDeclaration() {
        return this.getOptionalNodeProperty("valueDeclaration");
    }

    public @Nullable List<TSCNode> getDeclarations() {
        return this.getOptionalNodeListProperty("declarations");
    }

    public int getSymbolFlags() {
        try {
            return this.symbolV8.getInteger((Object)"flags");
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasSymbolFlag(TSCSymbolFlag flag) {
        return flag.matches(this.getSymbolFlags());
    }

    public List<TSCSymbolFlag> listMatchingSymbolFlags() {
        int symbolFlags = this.getSymbolFlags();
        ArrayList<TSCSymbolFlag> result = new ArrayList<TSCSymbolFlag>();
        for (TSCSymbolFlag flag : TSCSymbolFlag.values()) {
            if (!flag.matches(symbolFlags)) continue;
            result.add(flag);
        }
        return result;
    }

    public String getEscapedName() {
        return this.getStringProperty("escapedName");
    }

    @Override
    public DebugInfo getDebugInfo() {
        return new DebugInfo(this.listMatchingSymbolFlags(), this.getAllPropertiesForDebugging());
    }

    @Override
    public V8ValueObject getBackingV8Object() {
        return this.symbolV8;
    }

    public static final class DebugInfo {
        private final List<TSCSymbolFlag> symbolFlags;
        private final Map<String, Object> properties;

        @Generated
        public DebugInfo(List<TSCSymbolFlag> symbolFlags, Map<String, Object> properties) {
            this.symbolFlags = symbolFlags;
            this.properties = properties;
        }

        @Generated
        public List<TSCSymbolFlag> getSymbolFlags() {
            return this.symbolFlags;
        }

        @Generated
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebugInfo)) {
                return false;
            }
            DebugInfo other = (DebugInfo)o;
            List<TSCSymbolFlag> this$symbolFlags = this.getSymbolFlags();
            List<TSCSymbolFlag> other$symbolFlags = other.getSymbolFlags();
            if (this$symbolFlags == null ? other$symbolFlags != null : !((Object)this$symbolFlags).equals(other$symbolFlags)) {
                return false;
            }
            Map<String, Object> this$properties = this.getProperties();
            Map<String, Object> other$properties = other.getProperties();
            return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<TSCSymbolFlag> $symbolFlags = this.getSymbolFlags();
            result = result * 59 + ($symbolFlags == null ? 43 : ((Object)$symbolFlags).hashCode());
            Map<String, Object> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TSCSymbol.DebugInfo(symbolFlags=" + this.getSymbolFlags() + ", properties=" + this.getProperties() + ")";
        }
    }
}

