/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;
import org.openrewrite.javascript.internal.tsc.TSCV8Backed;
import org.openrewrite.javascript.internal.tsc.TSCV8ValueHolder;

public abstract class TSCObjectCache<T extends TSCV8Backed>
extends TSCV8ValueHolder {
    public static <T extends TSCV8Backed> TSCObjectCache<T> usingInternalKey(InstanceConstructor<T> makeInstance) {
        return new Impl<Long, T>(TSCProgramContext::getInternalObjectId, makeInstance);
    }

    public static <T extends TSCV8Backed> TSCObjectCache<T> usingPropertyAsKey(String propertyName, InstanceConstructor<T> makeInstance) {
        return new Impl<Object, T>((context, objectV8) -> objectV8.getPrimitive((Object)propertyName), makeInstance);
    }

    public abstract T getOrCreate(TSCProgramContext var1, V8ValueObject var2);

    private static class Impl<TKey, T extends TSCV8Backed>
    extends TSCObjectCache<T> {
        private final Map<TKey, T> cache = new HashMap<TKey, T>();
        private final KeyProvider<TKey> getKey;
        private final InstanceConstructor<T> makeInstance;

        public Impl(KeyProvider<TKey> getKey, InstanceConstructor<T> makeInstance) {
            this.getKey = getKey;
            this.makeInstance = makeInstance;
        }

        @Override
        public T getOrCreate(TSCProgramContext programContext, V8ValueObject objectV8) {
            try {
                TKey key = this.getKey.getKey(programContext, objectV8);
                return (T)this.cache.computeIfAbsent(key, _key -> {
                    V8ValueObject clone = this.lifecycleLinked(objectV8);
                    try {
                        return this.makeInstance.makeInstance(programContext, clone);
                    }
                    catch (JavetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (JavetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface KeyProvider<TKey> {
        public TKey getKey(TSCProgramContext var1, V8ValueObject var2) throws JavetException;
    }

    public static interface InstanceConstructor<T extends TSCV8Backed> {
        public T makeInstance(TSCProgramContext var1, V8ValueObject var2) throws JavetException;
    }
}

