/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.values.V8Value;
import org.jspecify.annotations.Nullable;
import org.openrewrite.javascript.internal.tsc.TSCProgramContext;

public interface TSCConversion<T> {
    public T convertUnsafe(TSCProgramContext var1, V8Value var2) throws JavetException;

    default public @Nullable T convertNullable(TSCProgramContext context, V8Value value) {
        try {
            if (value.isNullOrUndefined()) {
                return null;
            }
            return this.convertUnsafe(context, value);
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }

    default public T convertNonNull(TSCProgramContext context, V8Value value) {
        @Nullable T converted = this.convertNullable(context, value);
        if (converted == null) {
            throw new IllegalArgumentException("value converted to null, but was required to be non-null");
        }
        return converted;
    }
}

