/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.openrewrite.yaml.tree.YamlKey;

public final class UpdateMovedRecipeYaml
extends Recipe {
    @Option(displayName="The fully qualified className of recipe moved from", description="The fully qualified className of recipe moved from a old package.", example="org.openrewrite.java.cleanup.UnnecessaryCatch")
    private final String oldRecipeFullyQualifiedClassName;
    @Option(displayName="The fully qualified className of recipe moved to", description="The fully qualified className of recipe moved to a new package.", example="org.openrewrite.staticanalysis.UnnecessaryCatch")
    private final String newRecipeFullyQualifiedClassName;

    public String getDisplayName() {
        return "Update moved package recipe in yaml file";
    }

    public String getDescription() {
        return "Update moved package recipe in yaml file.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Scalar visitScalar(Yaml.Scalar scalar, ExecutionContext executionContext) {
                List keys = this.getCursor().getPathAsStream().filter(Yaml.Mapping.Entry.class::isInstance).map(Yaml.Mapping.Entry.class::cast).map(Yaml.Mapping.Entry::getKey).map(YamlKey::getValue).collect(Collectors.toList());
                Collections.reverse(keys);
                String prop = String.join((CharSequence)".", keys);
                if (prop.equals("recipeList") && scalar.getValue().equals(UpdateMovedRecipeYaml.this.oldRecipeFullyQualifiedClassName)) {
                    return scalar.withValue(UpdateMovedRecipeYaml.this.newRecipeFullyQualifiedClassName);
                }
                return super.visitScalar(scalar, (Object)executionContext);
            }
        };
    }

    public UpdateMovedRecipeYaml(String oldRecipeFullyQualifiedClassName, String newRecipeFullyQualifiedClassName) {
        this.oldRecipeFullyQualifiedClassName = oldRecipeFullyQualifiedClassName;
        this.newRecipeFullyQualifiedClassName = newRecipeFullyQualifiedClassName;
    }

    public String getOldRecipeFullyQualifiedClassName() {
        return this.oldRecipeFullyQualifiedClassName;
    }

    public String getNewRecipeFullyQualifiedClassName() {
        return this.newRecipeFullyQualifiedClassName;
    }

    @NonNull
    public String toString() {
        return "UpdateMovedRecipeYaml(oldRecipeFullyQualifiedClassName=" + this.getOldRecipeFullyQualifiedClassName() + ", newRecipeFullyQualifiedClassName=" + this.getNewRecipeFullyQualifiedClassName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMovedRecipeYaml)) {
            return false;
        }
        UpdateMovedRecipeYaml other = (UpdateMovedRecipeYaml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        String other$oldRecipeFullyQualifiedClassName = other.getOldRecipeFullyQualifiedClassName();
        if (this$oldRecipeFullyQualifiedClassName == null ? other$oldRecipeFullyQualifiedClassName != null : !this$oldRecipeFullyQualifiedClassName.equals(other$oldRecipeFullyQualifiedClassName)) {
            return false;
        }
        String this$newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        String other$newRecipeFullyQualifiedClassName = other.getNewRecipeFullyQualifiedClassName();
        return !(this$newRecipeFullyQualifiedClassName == null ? other$newRecipeFullyQualifiedClassName != null : !this$newRecipeFullyQualifiedClassName.equals(other$newRecipeFullyQualifiedClassName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMovedRecipeYaml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        result = result * 59 + ($oldRecipeFullyQualifiedClassName == null ? 43 : $oldRecipeFullyQualifiedClassName.hashCode());
        String $newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        result = result * 59 + ($newRecipeFullyQualifiedClassName == null ? 43 : $newRecipeFullyQualifiedClassName.hashCode());
        return result;
    }
}

