/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public class AutoFormatVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final List<NamedStyles> styles;

    public AutoFormatVisitor() {
        this(null, new NamedStyles[0]);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter, NamedStyles ... style) {
        this.stopAfter = stopAfter;
        this.styles = Arrays.stream(style).collect(Collectors.toList());
    }

    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof J.CompilationUnit;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu;
        JavaSourceFile javaSourceFile = cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        if (tree == null) {
            tree = (Tree)cursor.getValue();
        }
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visitNonNull(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(AutoFormatVisitor.getStyle(BlankLinesStyle.class, this.styles, cu, IntelliJ::blankLines), this.stopAfter).visitNonNull(t, p, cursor.fork());
        WrappingAndBracesStyle wrappingAndBracesStyle = AutoFormatVisitor.getStyle(WrappingAndBracesStyle.class, this.styles, cu, IntelliJ::wrappingAndBraces);
        SpacesStyle spacesStyle = AutoFormatVisitor.getStyle(SpacesStyle.class, this.styles, cu, IntelliJ::spaces);
        TabsAndIndentsStyle tabsAndIndentsStyle = AutoFormatVisitor.getStyle(TabsAndIndentsStyle.class, this.styles, cu, IntelliJ::tabsAndIndents);
        t = (J)new WrappingAndBracesVisitor(wrappingAndBracesStyle, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new SpacesVisitor(spacesStyle, AutoFormatVisitor.getStyle(EmptyForInitializerPadStyle.class, this.styles, cu), AutoFormatVisitor.getStyle(EmptyForIteratorPadStyle.class, this.styles, cu), this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(tabsAndIndentsStyle, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new TabsAndIndentsVisitor(tabsAndIndentsStyle, spacesStyle, wrappingAndBracesStyle, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(AutoFormatVisitor.getStyle(GeneralFormatStyle.class, this.styles, cu, () -> AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu)), this.stopAfter).visitNonNull(t, p, cursor.fork());
        if ((t = (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork())) instanceof J.CompilationUnit) {
            return AutoFormatVisitor.addStyleMarker((JavaSourceFile)t, this.styles);
        }
        return t;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof J.CompilationUnit)) {
                return cu;
            }
            JavaSourceFile t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(cu, p);
            t = (JavaSourceFile)new BlankLinesVisitor(AutoFormatVisitor.getStyle(BlankLinesStyle.class, this.styles, cu, IntelliJ::blankLines), this.stopAfter).visitNonNull(t, p);
            WrappingAndBracesStyle wrappingAndBracesStyle = AutoFormatVisitor.getStyle(WrappingAndBracesStyle.class, this.styles, cu, IntelliJ::wrappingAndBraces);
            SpacesStyle spacesStyle = AutoFormatVisitor.getStyle(SpacesStyle.class, this.styles, cu, IntelliJ::spaces);
            TabsAndIndentsStyle tabsAndIndentsStyle = AutoFormatVisitor.getStyle(TabsAndIndentsStyle.class, this.styles, cu, IntelliJ::tabsAndIndents);
            t = (JavaSourceFile)new SpacesVisitor(spacesStyle, AutoFormatVisitor.getStyle(EmptyForInitializerPadStyle.class, this.styles, cu), AutoFormatVisitor.getStyle(EmptyForIteratorPadStyle.class, this.styles, cu), this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor(wrappingAndBracesStyle, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor(tabsAndIndentsStyle, this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new TabsAndIndentsVisitor(tabsAndIndentsStyle, spacesStyle, wrappingAndBracesStyle, this.stopAfter).visitNonNull(t, p);
            return AutoFormatVisitor.addStyleMarker(t, this.styles);
        }
        return (J)tree;
    }

    private static <T extends SourceFile> T addStyleMarker(T t, List<NamedStyles> styles) {
        if (!styles.isEmpty()) {
            HashSet<NamedStyles> newNamedStyles = new HashSet<NamedStyles>(styles);
            boolean styleAlreadyPresent = false;
            for (NamedStyles namedStyle : t.getMarkers().findAll(NamedStyles.class)) {
                styleAlreadyPresent = !newNamedStyles.add(namedStyle) || styleAlreadyPresent;
            }
            if (!styleAlreadyPresent) {
                Markers markers = t.getMarkers().removeByType(NamedStyles.class);
                for (NamedStyles namedStyle : newNamedStyles) {
                    markers = markers.add((Marker)namedStyle);
                }
                return (T)((SourceFile)t.withMarkers(markers));
            }
        }
        return t;
    }

    private static <S extends Style, T extends SourceFile> @Nullable S getStyle(Class<S> styleClass, List<NamedStyles> styles, T sourceFile) {
        Style projectStyle = Style.from(styleClass, sourceFile);
        Style style = NamedStyles.merge(styleClass, styles);
        if (projectStyle == null) {
            return (S)style;
        }
        if (style != null) {
            return (S)((Style)StyleHelper.merge((Object)projectStyle, (Object)style));
        }
        return (S)projectStyle;
    }

    private static <S extends Style, T extends SourceFile> S getStyle(Class<S> styleClass, List<NamedStyles> styles, T sourceFile, Supplier<S> defaultStyle) {
        Style projectStyle = Style.from(styleClass, sourceFile, defaultStyle);
        Style style = NamedStyles.merge(styleClass, styles);
        if (style != null) {
            return (S)((Style)StyleHelper.merge((Object)projectStyle, (Object)style));
        }
        return (S)projectStyle;
    }
}

