/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.rpc;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.rpc.JavaTypeReceiver;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.marker.Markers;
import org.openrewrite.rpc.RpcReceiveQueue;

public class JavaReceiver
extends JavaVisitor<RpcReceiveQueue> {
    private static final JavaTypeReceiver javaTypeReceiver = new JavaTypeReceiver();

    public J preVisit(J j, RpcReceiveQueue q) {
        J j2 = (J)j.withId((UUID)q.receiveAndGet((Object)j.getId(), UUID::fromString));
        j2 = j2.withPrefix((Space)q.receive((Object)j.getPrefix(), space -> this.visitSpace((Space)space, q)));
        return (J)j2.withMarkers((Markers)q.receive((Object)j.getMarkers()));
    }

    @Override
    public J visitAnnotatedType(J.AnnotatedType annotatedType, RpcReceiveQueue q) {
        return annotatedType.withAnnotations(q.receiveList(annotatedType.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withTypeExpression((TypeTree)q.receive((Object)annotatedType.getTypeExpression(), t -> (TypeTree)this.visitNonNull((Tree)t, q)));
    }

    @Override
    public J visitAnnotation(J.Annotation annotation, RpcReceiveQueue q) {
        return annotation.withAnnotationType((NameTree)q.receive((Object)annotation.getAnnotationType(), n -> (NameTree)this.visitNonNull((Tree)n, q))).getPadding().withArguments((JContainer)q.receive(annotation.getPadding().getArguments(), args -> this.visitContainer((JContainer)args, q)));
    }

    @Override
    public J visitArrayAccess(J.ArrayAccess arrayAccess, RpcReceiveQueue q) {
        return arrayAccess.withIndexed((Expression)q.receive((Object)arrayAccess.getIndexed(), i -> (Expression)this.visitNonNull((Tree)i, q))).withDimension((J.ArrayDimension)q.receive((Object)arrayAccess.getDimension(), d -> (J.ArrayDimension)this.visitNonNull((Tree)d, q)));
    }

    @Override
    public J visitArrayDimension(J.ArrayDimension arrayDimension, RpcReceiveQueue q) {
        return arrayDimension.getPadding().withIndex((JRightPadded)q.receive(arrayDimension.getPadding().getIndex(), idx -> this.visitRightPadded((JRightPadded)idx, q)));
    }

    @Override
    public J visitArrayType(J.ArrayType arrayType, RpcReceiveQueue q) {
        return arrayType.withElementType((TypeTree)q.receive((Object)arrayType.getElementType(), t -> (TypeTree)this.visitNonNull((Tree)t, q))).withAnnotations(q.receiveList(arrayType.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withDimension((JLeftPadded)q.receive(arrayType.getDimension(), d -> this.visitLeftPadded((JLeftPadded)d, q))).withType((JavaType)q.receive((Object)arrayType.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitAssert(J.Assert assertStmt, RpcReceiveQueue q) {
        return assertStmt.withCondition((Expression)q.receive((Object)assertStmt.getCondition(), c -> (Expression)this.visitNonNull((Tree)c, q))).withDetail((JLeftPadded)q.receive(assertStmt.getDetail(), d -> this.visitLeftPadded((JLeftPadded)d, q)));
    }

    @Override
    public J visitAssignment(J.Assignment assignment, RpcReceiveQueue q) {
        return assignment.withVariable((Expression)q.receive((Object)assignment.getVariable(), v -> (Expression)this.visitNonNull((Tree)v, q))).getPadding().withAssignment((JLeftPadded)q.receive(assignment.getPadding().getAssignment(), a -> this.visitLeftPadded((JLeftPadded)a, q))).withType((JavaType)q.receive((Object)assignment.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitAssignmentOperation(J.AssignmentOperation assignOp, RpcReceiveQueue q) {
        return assignOp.withVariable((Expression)q.receive((Object)assignOp.getVariable(), v -> (Expression)this.visitNonNull((Tree)v, q))).getPadding().withOperator((JLeftPadded)q.receive(assignOp.getPadding().getOperator(), o -> this.visitLeftPadded((JLeftPadded)o, q, RpcReceiveQueue.toEnum(J.AssignmentOperation.Type.class)))).withAssignment((Expression)q.receive((Object)assignOp.getAssignment(), a -> (Expression)this.visitNonNull((Tree)a, q))).withType((JavaType)q.receive((Object)assignOp.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitBinary(J.Binary binary, RpcReceiveQueue q) {
        return binary.withLeft((Expression)q.receive((Object)binary.getLeft(), l -> (Expression)this.visitNonNull((Tree)l, q))).getPadding().withOperator((JLeftPadded)q.receive(binary.getPadding().getOperator(), o -> this.visitLeftPadded((JLeftPadded)o, q, RpcReceiveQueue.toEnum(J.Binary.Type.class)))).withRight((Expression)q.receive((Object)binary.getRight(), r -> (Expression)this.visitNonNull((Tree)r, q))).withType((JavaType)q.receive((Object)binary.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitBlock(J.Block block, RpcReceiveQueue q) {
        J.Block block1 = block.getPadding().withStatic((JRightPadded)q.receive(block.getPadding().getStatic(), s -> this.visitRightPadded((JRightPadded)s, q)));
        return block1.getPadding().withStatements(q.receiveList(block.getPadding().getStatements(), s -> this.visitRightPadded((JRightPadded)s, q))).withEnd((Space)q.receive((Object)block.getEnd(), e -> this.visitSpace((Space)e, q)));
    }

    @Override
    public J visitBreak(J.Break breakStmt, RpcReceiveQueue q) {
        return breakStmt.withLabel((J.Identifier)q.receive((Object)breakStmt.getLabel(), l -> (J.Identifier)this.visitNonNull((Tree)l, q)));
    }

    @Override
    public J visitCase(J.Case caseStmt, RpcReceiveQueue q) {
        return caseStmt.withType((J.Case.Type)((Object)q.receiveAndGet((Object)caseStmt.getType(), RpcReceiveQueue.toEnum(J.Case.Type.class)))).getPadding().withCaseLabels((JContainer)q.receive(caseStmt.getPadding().getCaseLabels(), l -> this.visitContainer((JContainer)l, q))).getPadding().withStatements((JContainer)q.receive(caseStmt.getPadding().getStatements(), s -> this.visitContainer((JContainer)s, q))).getPadding().withBody((JRightPadded)q.receive(caseStmt.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q))).withGuard((Expression)q.receive((Object)caseStmt.getGuard(), g -> (Expression)this.visitNonNull((Tree)g, q)));
    }

    @Override
    public J visitClassDeclaration(J.ClassDeclaration classDecl, RpcReceiveQueue q) {
        return classDecl.withLeadingAnnotations(q.receiveList(classDecl.getLeadingAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withModifiers(q.receiveList(classDecl.getModifiers(), m -> (J.Modifier)this.visitNonNull((Tree)m, q))).getPadding().withKind((J.ClassDeclaration.Kind)q.receive((Object)classDecl.getPadding().getKind(), k -> this.visitClassDeclarationKind((J.ClassDeclaration.Kind)k, q))).withName((J.Identifier)q.receive((Object)classDecl.getName(), n -> (J.Identifier)this.visitNonNull((Tree)n, q))).getPadding().withTypeParameters((JContainer)q.receive(classDecl.getPadding().getTypeParameters(), tp -> this.visitContainer((JContainer)tp, q))).getPadding().withPrimaryConstructor((JContainer)q.receive(classDecl.getPadding().getPrimaryConstructor(), pc -> this.visitContainer((JContainer)pc, q))).getPadding().withExtends((JLeftPadded)q.receive(classDecl.getPadding().getExtends(), e -> this.visitLeftPadded((JLeftPadded)e, q))).getPadding().withImplements((JContainer)q.receive(classDecl.getPadding().getImplements(), i -> this.visitContainer((JContainer)i, q))).getPadding().withPermits((JContainer)q.receive(classDecl.getPadding().getPermits(), p -> this.visitContainer((JContainer)p, q))).withBody((J.Block)q.receive((Object)classDecl.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q)));
    }

    private J.ClassDeclaration.Kind visitClassDeclarationKind(J.ClassDeclaration.Kind kind, RpcReceiveQueue q) {
        J.ClassDeclaration.Kind k = (J.ClassDeclaration.Kind)this.preVisit(kind, q);
        return k.withAnnotations(q.receiveList(kind.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withType((J.ClassDeclaration.Kind.Type)((Object)q.receiveAndGet((Object)kind.getType(), RpcReceiveQueue.toEnum(J.ClassDeclaration.Kind.Type.class))));
    }

    @Override
    public J visitCompilationUnit(J.CompilationUnit cu, RpcReceiveQueue q) {
        return ((J.CompilationUnit)((J.CompilationUnit)((J.CompilationUnit)cu.withSourcePath((Path)q.receiveAndGet((Object)cu.getSourcePath(), x$0 -> Paths.get(x$0, new String[0]))).withCharset((Charset)q.receiveAndGet((Object)cu.getCharset(), Charset::forName)).withCharsetBomMarked(((Boolean)q.receive((Object)cu.isCharsetBomMarked())).booleanValue()).withChecksum((Checksum)q.receive((Object)cu.getChecksum())).withFileAttributes((FileAttributes)q.receive((Object)cu.getFileAttributes()))).getPadding().withPackageDeclaration((JRightPadded)q.receive(cu.getPadding().getPackageDeclaration(), p -> this.visitRightPadded((JRightPadded)p, q))).getPadding().withImports(q.receiveList(cu.getPadding().getImports(), i -> this.visitRightPadded((JRightPadded)i, q)))).withClasses(q.receiveList(cu.getClasses(), c -> (J.ClassDeclaration)this.visitNonNull((Tree)c, q)))).withEof((Space)q.receive((Object)cu.getEof(), e -> this.visitSpace((Space)e, q)));
    }

    @Override
    public J visitContinue(J.Continue continueStmt, RpcReceiveQueue q) {
        return continueStmt.withLabel((J.Identifier)q.receive((Object)continueStmt.getLabel(), l -> (J.Identifier)this.visitNonNull((Tree)l, q)));
    }

    @Override
    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, RpcReceiveQueue q) {
        return controlParens.getPadding().withTree((JRightPadded)q.receive(controlParens.getPadding().getTree(), t -> this.visitRightPadded((JRightPadded)t, q)));
    }

    @Override
    public J visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, RpcReceiveQueue q) {
        return deconstructionPattern.withDeconstructor((Expression)q.receive((Object)deconstructionPattern.getDeconstructor(), d -> (Expression)this.visitNonNull((Tree)d, q))).getPadding().withNested((JContainer)q.receive(deconstructionPattern.getPadding().getNested(), n -> this.visitContainer((JContainer)n, q))).withType((JavaType)q.receive((Object)deconstructionPattern.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitDoWhileLoop(J.DoWhileLoop doWhileLoop, RpcReceiveQueue q) {
        return doWhileLoop.getPadding().withBody((JRightPadded)q.receive(doWhileLoop.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q))).getPadding().withWhileCondition((JLeftPadded)q.receive(doWhileLoop.getPadding().getWhileCondition(), c -> this.visitLeftPadded((JLeftPadded)c, q)));
    }

    @Override
    public J visitEmpty(J.Empty empty, RpcReceiveQueue q) {
        return empty;
    }

    @Override
    public J visitEnumValue(J.EnumValue enumValue, RpcReceiveQueue q) {
        return enumValue.withAnnotations(q.receiveList(enumValue.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withName((J.Identifier)q.receive((Object)enumValue.getName(), n -> (J.Identifier)this.visitNonNull((Tree)n, q))).withInitializer((J.NewClass)q.receive((Object)enumValue.getInitializer(), i -> (J.NewClass)this.visitNonNull((Tree)i, q)));
    }

    @Override
    public J visitEnumValueSet(J.EnumValueSet enumValueSet, RpcReceiveQueue q) {
        return enumValueSet.getPadding().withEnums(q.receiveList(enumValueSet.getPadding().getEnums(), e -> this.visitRightPadded((JRightPadded)e, q))).withTerminatedWithSemicolon((Boolean)q.receive((Object)enumValueSet.isTerminatedWithSemicolon()));
    }

    @Override
    public J visitErroneous(J.Erroneous erroneous, RpcReceiveQueue q) {
        return erroneous.withText((String)q.receive((Object)erroneous.getText()));
    }

    @Override
    public J visitFieldAccess(J.FieldAccess fieldAccess, RpcReceiveQueue q) {
        return fieldAccess.withTarget((Expression)q.receive((Object)fieldAccess.getTarget(), t -> (Expression)this.visitNonNull((Tree)t, q))).getPadding().withName((JLeftPadded)q.receive(fieldAccess.getPadding().getName(), n -> this.visitLeftPadded((JLeftPadded)n, q))).withType((JavaType)q.receive((Object)fieldAccess.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitForEachControl(J.ForEachLoop.Control control, RpcReceiveQueue q) {
        return control.getPadding().withVariable((JRightPadded)q.receive(control.getPadding().getVariable(), v -> this.visitRightPadded((JRightPadded)v, q))).getPadding().withIterable((JRightPadded)q.receive(control.getPadding().getIterable(), i -> this.visitRightPadded((JRightPadded)i, q)));
    }

    @Override
    public J visitForEachLoop(J.ForEachLoop forEachLoop, RpcReceiveQueue q) {
        return forEachLoop.withControl((J.ForEachLoop.Control)q.receive((Object)forEachLoop.getControl(), c -> (J.ForEachLoop.Control)this.visitNonNull((Tree)c, q))).getPadding().withBody((JRightPadded)q.receive(forEachLoop.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q)));
    }

    @Override
    public J visitForControl(J.ForLoop.Control control, RpcReceiveQueue q) {
        return control.getPadding().withInit(q.receiveList(control.getPadding().getInit(), i -> this.visitRightPadded((JRightPadded)i, q))).getPadding().withCondition((JRightPadded)q.receive(control.getPadding().getCondition(), c -> this.visitRightPadded((JRightPadded)c, q))).getPadding().withUpdate(q.receiveList(control.getPadding().getUpdate(), u -> this.visitRightPadded((JRightPadded)u, q)));
    }

    @Override
    public J visitForLoop(J.ForLoop forLoop, RpcReceiveQueue q) {
        return forLoop.withControl((J.ForLoop.Control)q.receive((Object)forLoop.getControl(), c -> (J.ForLoop.Control)this.visitNonNull((Tree)c, q))).getPadding().withBody((JRightPadded)q.receive(forLoop.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q)));
    }

    @Override
    public J visitIdentifier(J.Identifier identifier, RpcReceiveQueue q) {
        return identifier.withAnnotations(q.receiveList(identifier.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withSimpleName((String)q.receive((Object)identifier.getSimpleName())).withType((JavaType)q.receive((Object)identifier.getType(), t -> this.visitType((JavaType)t, q))).withFieldType((JavaType.Variable)q.receive((Object)identifier.getFieldType(), t -> (JavaType.Variable)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitIf(J.If iff, RpcReceiveQueue q) {
        return iff.withIfCondition((J.ControlParentheses)q.receive(iff.getIfCondition(), c -> (J.ControlParentheses)this.visitNonNull((Tree)c, q))).getPadding().withThenPart((JRightPadded)q.receive(iff.getPadding().getThenPart(), t -> this.visitRightPadded((JRightPadded)t, q))).withElsePart((J.If.Else)q.receive((Object)iff.getElsePart(), e -> (J.If.Else)this.visitNonNull((Tree)e, q)));
    }

    @Override
    public J visitElse(J.If.Else anElse, RpcReceiveQueue q) {
        return anElse.getPadding().withBody((JRightPadded)q.receive(anElse.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q)));
    }

    @Override
    public J visitImport(J.Import importStmt, RpcReceiveQueue q) {
        return importStmt.getPadding().withStatic((JLeftPadded)q.receive(importStmt.getPadding().getStatic(), s -> this.visitLeftPadded((JLeftPadded)s, q))).withQualid((J.FieldAccess)q.receive((Object)importStmt.getQualid(), q2 -> (J.FieldAccess)this.visitNonNull((Tree)q2, q))).getPadding().withAlias((JLeftPadded)q.receive(importStmt.getPadding().getAlias(), a -> this.visitLeftPadded((JLeftPadded)a, q)));
    }

    @Override
    public J visitInstanceOf(J.InstanceOf instanceOf, RpcReceiveQueue q) {
        return instanceOf.getPadding().withExpression((JRightPadded)q.receive(instanceOf.getPadding().getExpression(), e -> this.visitRightPadded((JRightPadded)e, q))).withClazz((J)q.receive((Object)instanceOf.getClazz(), c -> (J)this.visitNonNull((Tree)c, q))).withPattern((J)q.receive((Object)instanceOf.getPattern(), p -> (J)this.visitNonNull((Tree)p, q))).withType((JavaType)q.receive((Object)instanceOf.getType(), t -> this.visitType((JavaType)t, q))).withModifier((J.Modifier)q.receive((Object)instanceOf.getModifier(), m -> (J.Modifier)this.visitNonNull((Tree)m, q)));
    }

    @Override
    public J visitIntersectionType(J.IntersectionType intersectionType, RpcReceiveQueue q) {
        return intersectionType.getPadding().withBounds((JContainer)q.receive(intersectionType.getPadding().getBounds(), b -> this.visitContainer((JContainer)b, q)));
    }

    @Override
    public J visitLabel(J.Label label, RpcReceiveQueue q) {
        return label.getPadding().withLabel((JRightPadded)q.receive(label.getPadding().getLabel(), l -> this.visitRightPadded((JRightPadded)l, q))).withStatement((Statement)q.receive((Object)label.getStatement(), s -> (Statement)this.visitNonNull((Tree)s, q)));
    }

    @Override
    public J visitLambda(J.Lambda lambda, RpcReceiveQueue q) {
        return lambda.withParameters((J.Lambda.Parameters)q.receive((Object)lambda.getParameters(), p -> (J.Lambda.Parameters)this.visitNonNull((Tree)p, q))).withArrow((Space)q.receive((Object)lambda.getArrow(), a -> this.visitSpace((Space)a, q))).withBody((J)q.receive((Object)lambda.getBody(), b -> (J)this.visitNonNull((Tree)b, q))).withType((JavaType)q.receive((Object)lambda.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitLambdaParameters(J.Lambda.Parameters parameters, RpcReceiveQueue q) {
        return parameters.withParenthesized((Boolean)q.receive((Object)parameters.isParenthesized())).getPadding().withParameters(q.receiveList(parameters.getPadding().getParameters(), p -> this.visitRightPadded((JRightPadded)p, q)));
    }

    @Override
    public J visitLiteral(J.Literal literal, RpcReceiveQueue q) {
        return literal.withValue(q.receive(literal.getValue())).withValueSource((String)q.receive((Object)literal.getValueSource())).withUnicodeEscapes(q.receiveList(literal.getUnicodeEscapes(), s -> s)).withType((JavaType)q.receive((Object)literal.getType(), t -> (JavaType.Primitive)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitMemberReference(J.MemberReference memberRef, RpcReceiveQueue q) {
        return memberRef.getPadding().withContaining((JRightPadded)q.receive(memberRef.getPadding().getContaining(), c -> this.visitRightPadded((JRightPadded)c, q))).getPadding().withTypeParameters((JContainer)q.receive(memberRef.getPadding().getTypeParameters(), tp -> this.visitContainer((JContainer)tp, q))).getPadding().withReference((JLeftPadded)q.receive(memberRef.getPadding().getReference(), r -> this.visitLeftPadded((JLeftPadded)r, q))).withType((JavaType)q.receive((Object)memberRef.getType(), t -> this.visitType((JavaType)t, q))).withMethodType((JavaType.Method)q.receive((Object)memberRef.getMethodType(), t -> (JavaType.Method)this.visitType((JavaType)t, q))).withVariableType((JavaType.Variable)q.receive((Object)memberRef.getVariableType(), t -> (JavaType.Variable)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitMethodDeclaration(J.MethodDeclaration method, RpcReceiveQueue q) {
        if (method.getAnnotations().getName() == null) {
            method = method.getAnnotations().withName(new J.MethodDeclaration.IdentifierWithAnnotations(null, null));
        }
        return method.withLeadingAnnotations(q.receiveList(method.getLeadingAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withModifiers(q.receiveList(method.getModifiers(), m -> (J.Modifier)this.visitNonNull((Tree)m, q))).getPadding().withTypeParameters((J.TypeParameters)q.receive((Object)method.getPadding().getTypeParameters(), tp -> (J.TypeParameters)this.visitNonNull((Tree)tp, q))).withReturnTypeExpression((TypeTree)q.receive((Object)method.getReturnTypeExpression(), rt -> (TypeTree)this.visitNonNull((Tree)rt, q))).getAnnotations().withName(method.getAnnotations().getName().withAnnotations(q.receiveList(method.getAnnotations().getName().getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q)))).withName((J.Identifier)q.receive((Object)method.getName(), n -> (J.Identifier)this.visitNonNull((Tree)n, q))).getPadding().withParameters((JContainer)q.receive(method.getPadding().getParameters(), p -> this.visitContainer((JContainer)p, q))).getPadding().withThrows((JContainer)q.receive(method.getPadding().getThrows(), t -> this.visitContainer((JContainer)t, q))).withBody((J.Block)q.receive((Object)method.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q))).getPadding().withDefaultValue((JLeftPadded)q.receive(method.getPadding().getDefaultValue(), d -> this.visitLeftPadded((JLeftPadded)d, q))).withMethodType((JavaType.Method)q.receive((Object)method.getMethodType(), t -> (JavaType.Method)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, RpcReceiveQueue q) {
        return method.getPadding().withSelect((JRightPadded)q.receive(method.getPadding().getSelect(), s -> this.visitRightPadded((JRightPadded)s, q))).getPadding().withTypeParameters((JContainer)q.receive(method.getPadding().getTypeParameters(), tp -> this.visitContainer((JContainer)tp, q))).withName((J.Identifier)q.receive((Object)method.getName(), n -> (J.Identifier)this.visitNonNull((Tree)n, q))).getPadding().withArguments((JContainer)q.receive(method.getPadding().getArguments(), a -> this.visitContainer((JContainer)a, q))).withMethodType((JavaType.Method)q.receive((Object)method.getMethodType(), t -> (JavaType.Method)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitModifier(J.Modifier modifier, RpcReceiveQueue q) {
        return modifier.withKeyword((String)q.receive((Object)modifier.getKeyword())).withType((J.Modifier.Type)((Object)q.receiveAndGet((Object)modifier.getType(), RpcReceiveQueue.toEnum(J.Modifier.Type.class)))).withAnnotations(q.receiveList(modifier.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q)));
    }

    @Override
    public J visitMultiCatch(J.MultiCatch multiCatch, RpcReceiveQueue q) {
        return multiCatch.getPadding().withAlternatives(q.receiveList(multiCatch.getPadding().getAlternatives(), a -> this.visitRightPadded((JRightPadded)a, q)));
    }

    @Override
    public J visitNewArray(J.NewArray newArray, RpcReceiveQueue q) {
        return newArray.withTypeExpression((TypeTree)q.receive((Object)newArray.getTypeExpression(), t -> (TypeTree)this.visitNonNull((Tree)t, q))).withDimensions(q.receiveList(newArray.getDimensions(), d -> (J.ArrayDimension)this.visitNonNull((Tree)d, q))).getPadding().withInitializer((JContainer)q.receive(newArray.getPadding().getInitializer(), i -> this.visitContainer((JContainer)i, q))).withType((JavaType)q.receive((Object)newArray.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitNewClass(J.NewClass newClass, RpcReceiveQueue q) {
        return newClass.getPadding().withEnclosing((JRightPadded)q.receive(newClass.getPadding().getEnclosing(), e -> this.visitRightPadded((JRightPadded)e, q))).withNew((Space)q.receive((Object)newClass.getNew(), n -> this.visitSpace((Space)n, q))).withClazz((TypeTree)q.receive((Object)newClass.getClazz(), c -> (TypeTree)this.visitNonNull((Tree)c, q))).getPadding().withArguments((JContainer)q.receive(newClass.getPadding().getArguments(), a -> this.visitContainer((JContainer)a, q))).withBody((J.Block)q.receive((Object)newClass.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q))).withConstructorType((JavaType.Method)q.receive((Object)newClass.getConstructorType(), t -> (JavaType.Method)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitNullableType(J.NullableType nullableType, RpcReceiveQueue q) {
        return nullableType.withAnnotations(q.receiveList(nullableType.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withTypeTree((JRightPadded)q.receive(nullableType.getPadding().getTypeTree(), t -> this.visitRightPadded((JRightPadded)t, q)));
    }

    @Override
    public J visitPackage(J.Package pkg, RpcReceiveQueue q) {
        return pkg.withExpression((Expression)q.receive((Object)pkg.getExpression(), e -> (Expression)this.visitNonNull((Tree)e, q))).withAnnotations(q.receiveList(pkg.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q)));
    }

    @Override
    public J visitParameterizedType(J.ParameterizedType type, RpcReceiveQueue q) {
        return type.withClazz((NameTree)q.receive((Object)type.getClazz(), t -> (NameTree)this.visitNonNull((Tree)t, q))).getPadding().withTypeParameters((JContainer)q.receive(type.getPadding().getTypeParameters(), c -> this.visitContainer((JContainer)c, q))).withType((JavaType)q.receive((Object)type.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public <T extends J> J visitParentheses(J.Parentheses<T> parens, RpcReceiveQueue q) {
        return parens.getPadding().withTree((JRightPadded)q.receive(parens.getPadding().getTree(), t -> this.visitRightPadded((JRightPadded)t, q)));
    }

    @Override
    public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedType, RpcReceiveQueue q) {
        return parenthesizedType.withAnnotations(q.receiveList(parenthesizedType.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withParenthesizedType((J.Parentheses)q.receive(parenthesizedType.getParenthesizedType(), t -> (J.Parentheses)this.visitNonNull((Tree)t, q)));
    }

    @Override
    public J visitPrimitive(J.Primitive primitive, RpcReceiveQueue q) {
        return primitive.withType((JavaType)q.receive((Object)primitive.getType()));
    }

    @Override
    public J visitReturn(J.Return retrn, RpcReceiveQueue q) {
        return retrn.withExpression((Expression)q.receive((Object)retrn.getExpression(), e -> (Expression)this.visitNonNull((Tree)e, q)));
    }

    @Override
    public J visitSwitch(J.Switch switzh, RpcReceiveQueue q) {
        return switzh.withSelector((J.ControlParentheses)q.receive(switzh.getSelector(), s -> (J.ControlParentheses)this.visitNonNull((Tree)s, q))).withCases((J.Block)q.receive((Object)switzh.getCases(), c -> (J.Block)this.visitNonNull((Tree)c, q)));
    }

    @Override
    public J visitSwitchExpression(J.SwitchExpression switchExpression, RpcReceiveQueue q) {
        return switchExpression.withSelector((J.ControlParentheses)q.receive(switchExpression.getSelector(), s -> (J.ControlParentheses)this.visitNonNull((Tree)s, q))).withCases((J.Block)q.receive((Object)switchExpression.getCases(), c -> (J.Block)this.visitNonNull((Tree)c, q))).withType((JavaType)q.receive((Object)switchExpression.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitSynchronized(J.Synchronized synch, RpcReceiveQueue q) {
        return synch.withLock((J.ControlParentheses)q.receive(synch.getLock(), l -> (J.ControlParentheses)this.visitNonNull((Tree)l, q))).withBody((J.Block)q.receive((Object)synch.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q)));
    }

    @Override
    public J visitTernary(J.Ternary ternary, RpcReceiveQueue q) {
        return ternary.withCondition((Expression)q.receive((Object)ternary.getCondition(), c -> (Expression)this.visitNonNull((Tree)c, q))).getPadding().withTruePart((JLeftPadded)q.receive(ternary.getPadding().getTruePart(), t -> this.visitLeftPadded((JLeftPadded)t, q))).getPadding().withFalsePart((JLeftPadded)q.receive(ternary.getPadding().getFalsePart(), f -> this.visitLeftPadded((JLeftPadded)f, q))).withType((JavaType)q.receive((Object)ternary.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitThrow(J.Throw throwStmt, RpcReceiveQueue q) {
        return throwStmt.withException((Expression)q.receive((Object)throwStmt.getException(), e -> (Expression)this.visitNonNull((Tree)e, q)));
    }

    @Override
    public J visitTry(J.Try tryStmt, RpcReceiveQueue q) {
        return tryStmt.getPadding().withResources((JContainer)q.receive(tryStmt.getPadding().getResources(), r -> this.visitContainer((JContainer)r, q))).withBody((J.Block)q.receive((Object)tryStmt.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q))).withCatches(q.receiveList(tryStmt.getCatches(), c -> (J.Try.Catch)this.visitNonNull((Tree)c, q))).getPadding().withFinally((JLeftPadded)q.receive(tryStmt.getPadding().getFinally(), f -> this.visitLeftPadded((JLeftPadded)f, q)));
    }

    @Override
    public J visitCatch(J.Try.Catch tryCatch, RpcReceiveQueue q) {
        return tryCatch.withParameter((J.ControlParentheses)q.receive(tryCatch.getParameter(), p -> (J.ControlParentheses)this.visitNonNull((Tree)p, q))).withBody((J.Block)q.receive((Object)tryCatch.getBody(), b -> (J.Block)this.visitNonNull((Tree)b, q)));
    }

    @Override
    public J visitTryResource(J.Try.Resource tryResource, RpcReceiveQueue q) {
        return tryResource.withVariableDeclarations((TypedTree)q.receive((Object)tryResource.getVariableDeclarations(), v -> (TypedTree)this.visitNonNull((Tree)v, q))).withTerminatedWithSemicolon((Boolean)q.receive((Object)tryResource.isTerminatedWithSemicolon()));
    }

    @Override
    public J visitTypeParameter(J.TypeParameter typeParam, RpcReceiveQueue q) {
        return typeParam.withAnnotations(q.receiveList(typeParam.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withModifiers(q.receiveList(typeParam.getModifiers(), a -> (J.Modifier)this.visitNonNull((Tree)a, q))).withName((Expression)q.receive((Object)typeParam.getName(), n -> (Expression)this.visitNonNull((Tree)n, q))).getPadding().withBounds((JContainer)q.receive(typeParam.getPadding().getBounds(), b -> this.visitContainer((JContainer)b, q)));
    }

    public J.TypeParameters visitTypeParameters(J.TypeParameters typeParameters, RpcReceiveQueue q) {
        return typeParameters.withAnnotations(q.receiveList(typeParameters.getAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).getPadding().withTypeParameters(q.receiveList(typeParameters.getPadding().getTypeParameters(), p -> this.visitRightPadded((JRightPadded)p, q)));
    }

    @Override
    public J visitTypeCast(J.TypeCast typeCast, RpcReceiveQueue q) {
        return typeCast.withClazz((J.ControlParentheses)q.receive(typeCast.getClazz(), c -> (J.ControlParentheses)this.visitNonNull((Tree)c, q))).withExpression((Expression)q.receive((Object)typeCast.getExpression(), e -> (Expression)this.visitNonNull((Tree)e, q)));
    }

    @Override
    public J visitUnary(J.Unary unary, RpcReceiveQueue q) {
        return unary.getPadding().withOperator((JLeftPadded)q.receive(unary.getPadding().getOperator(), op -> this.visitLeftPadded((JLeftPadded)op, q, RpcReceiveQueue.toEnum(J.Unary.Type.class)))).withExpression((Expression)q.receive((Object)unary.getExpression(), e -> (Expression)this.visitNonNull((Tree)e, q))).withType((JavaType)q.receive((Object)unary.getType(), t -> this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitVariable(J.VariableDeclarations.NamedVariable variable, RpcReceiveQueue q) {
        return variable.withDeclarator((VariableDeclarator)q.receive((Object)variable.getDeclarator(), decl -> (VariableDeclarator)this.visitNonNull((Tree)decl, q))).withDimensionsAfterName(q.receiveList(variable.getDimensionsAfterName(), d -> this.visitLeftPadded((JLeftPadded)d, q))).getPadding().withInitializer((JLeftPadded)q.receive(variable.getPadding().getInitializer(), i -> this.visitLeftPadded((JLeftPadded)i, q))).withVariableType((JavaType.Variable)q.receive((Object)variable.getVariableType(), t -> (JavaType.Variable)this.visitType((JavaType)t, q)));
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations variableDecls, RpcReceiveQueue q) {
        return variableDecls.withLeadingAnnotations(q.receiveList(variableDecls.getLeadingAnnotations(), a -> (J.Annotation)this.visitNonNull((Tree)a, q))).withModifiers(q.receiveList(variableDecls.getModifiers(), m -> (J.Modifier)this.visitNonNull((Tree)m, q))).withTypeExpression((TypeTree)q.receive((Object)variableDecls.getTypeExpression(), t -> (TypeTree)this.visitNonNull((Tree)t, q))).withVarargs((Space)q.receive((Object)variableDecls.getVarargs(), v -> this.visitSpace((Space)v, q))).getPadding().withVariables(q.receiveList(variableDecls.getPadding().getVariables(), v -> this.visitRightPadded((JRightPadded)v, q)));
    }

    @Override
    public J visitWhileLoop(J.WhileLoop whileLoop, RpcReceiveQueue q) {
        return whileLoop.withCondition((J.ControlParentheses)q.receive(whileLoop.getCondition(), c -> (J.ControlParentheses)this.visitNonNull((Tree)c, q))).getPadding().withBody((JRightPadded)q.receive(whileLoop.getPadding().getBody(), b -> this.visitRightPadded((JRightPadded)b, q)));
    }

    @Override
    public J visitWildcard(J.Wildcard wildcard, RpcReceiveQueue q) {
        return wildcard.getPadding().withBound((JLeftPadded)q.receive(wildcard.getPadding().getBound(), o -> this.visitLeftPadded((JLeftPadded)o, q, RpcReceiveQueue.toEnum(J.Wildcard.Bound.class)))).withBoundedType((NameTree)q.receive((Object)wildcard.getBoundedType(), b -> (TypeTree)this.visitNonNull((Tree)b, q)));
    }

    @Override
    public J visitYield(J.Yield yieldStmt, RpcReceiveQueue q) {
        return yieldStmt.withImplicit((Boolean)q.receive((Object)yieldStmt.isImplicit())).withValue((Expression)q.receive((Object)yieldStmt.getValue(), v -> (Expression)this.visitNonNull((Tree)v, q)));
    }

    public Space visitSpace(Space space, RpcReceiveQueue q) {
        return space.withComments(q.receiveList(space.getComments(), c -> {
            if (c instanceof TextComment) {
                return ((TextComment)c).withMultiline((Boolean)q.receive((Object)c.isMultiline())).withText((String)q.receive((Object)((TextComment)c).getText())).withSuffix((String)q.receive((Object)c.getSuffix())).withMarkers((Markers)q.receive((Object)c.getMarkers()));
            }
            return c;
        })).withWhitespace((String)q.receive((Object)space.getWhitespace()));
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, RpcReceiveQueue q) {
        return container.withBefore((Space)q.receive((Object)container.getBefore(), space -> this.visitSpace((Space)space, q))).getPadding().withElements(q.receiveList(container.getPadding().getElements(), e -> this.visitRightPadded((JRightPadded)e, q))).withMarkers((Markers)q.receive((Object)container.getMarkers()));
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, RpcReceiveQueue q) {
        return left.withBefore((Space)q.receive((Object)left.getBefore(), s -> this.visitSpace((Space)s, q))).withElement(q.receive(left.getElement(), t -> {
            if (t instanceof J) {
                return this.visitNonNull((J)t, q);
            }
            if (t instanceof Space) {
                return this.visitSpace((Space)t, q);
            }
            return t;
        })).withMarkers((Markers)q.receive((Object)left.getMarkers()));
    }

    public <T> JLeftPadded<T> visitLeftPadded(JLeftPadded<T> left, RpcReceiveQueue q, Function<Object, T> elementMapping) {
        return left.withBefore((Space)q.receive((Object)left.getBefore(), s -> this.visitSpace((Space)s, q))).withElement(Objects.requireNonNull(q.receiveAndGet(left.getElement(), elementMapping))).withMarkers((Markers)q.receive((Object)left.getMarkers()));
    }

    public <T> JRightPadded<T> visitRightPadded(JRightPadded<T> right, RpcReceiveQueue q) {
        return right.withElement(q.receive(right.getElement(), t -> {
            if (t instanceof J) {
                return this.visitNonNull((J)t, q);
            }
            if (t instanceof Space) {
                return this.visitSpace((Space)t, q);
            }
            return t;
        })).withAfter((Space)q.receive((Object)right.getAfter(), s -> this.visitSpace((Space)s, q))).withMarkers((Markers)q.receive((Object)right.getMarkers()));
    }

    @Override
    public @Nullable JavaType visitType(@Nullable JavaType javaType, RpcReceiveQueue q) {
        if (javaType == null) {
            return null;
        }
        if (javaType instanceof JavaType.Unknown) {
            return JavaType.Unknown.getInstance();
        }
        return javaTypeReceiver.visit(javaType, q);
    }
}

