/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class WrappingAndBraces
extends Recipe {
    public String getDisplayName() {
        return "Wrapping and braces";
    }

    public String getDescription() {
        return "Format line wraps and braces in Java code.";
    }

    public Set<String> getTags() {
        return new LinkedHashSet<String>(Arrays.asList("RSPEC-S121", "RSPEC-S2681", "RSPEC-S3972", "RSPEC-S3973"));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(10L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new WrappingAndBracesCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatWrappingAndBraces(J j, Cursor cursor) {
        SourceFile sourceFile = (SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class);
        WrappingAndBracesStyle style = (WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)sourceFile);
        return (J2)((J)new WrappingAndBracesVisitor(style == null ? IntelliJ.wrappingAndBraces() : style).visitNonNull(j, 0, cursor));
    }

    private static class WrappingAndBracesCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private WrappingAndBracesCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                WrappingAndBracesStyle style = (WrappingAndBracesStyle)Style.from(WrappingAndBracesStyle.class, (SourceFile)cu, IntelliJ::wrappingAndBraces);
                return new WrappingAndBracesVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

