/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class FindInheritedFields {
    private FindInheritedFields() {
    }

    public static Set<JavaType.Variable> find(J j, String clazz) {
        HashSet<JavaType.Variable> fields = new HashSet<JavaType.Variable>();
        new FindInheritedFieldsVisitor(clazz).visit(j, fields);
        return fields;
    }

    private static boolean hasElementTypeAssignable(@Nullable JavaType type, String fullyQualifiedName) {
        if (type instanceof JavaType.Array) {
            return FindInheritedFields.hasElementTypeAssignable(((JavaType.Array)type).getElemType(), fullyQualifiedName);
        }
        if (type instanceof JavaType.Class) {
            return TypeUtils.isAssignableTo(JavaType.ShallowClass.build(fullyQualifiedName), type);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)type;
            for (JavaType bound : generic.getBounds()) {
                if (!FindInheritedFields.hasElementTypeAssignable(bound, fullyQualifiedName)) continue;
                return true;
            }
        } else if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            return FindInheritedFields.hasElementTypeAssignable(parameterized.getType(), fullyQualifiedName);
        }
        return false;
    }

    private static class FindInheritedFieldsVisitor
    extends JavaIsoVisitor<Set<JavaType.Variable>> {
        private final String fullyQualifiedName;

        public FindInheritedFieldsVisitor(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        private Set<JavaType.Variable> superFields(@Nullable JavaType.FullyQualified type) {
            if (type == null || type.getSupertype() == null) {
                return Collections.emptySet();
            }
            HashSet<JavaType.Variable> types = new HashSet<JavaType.Variable>();
            for (JavaType.Variable m : type.getMembers()) {
                if (m.hasFlags(Flag.Private) || !FindInheritedFields.hasElementTypeAssignable(m.getType(), this.fullyQualifiedName)) continue;
                types.add(m);
            }
            types.addAll(this.superFields(type.getSupertype()));
            return types;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Set<JavaType.Variable> ctx) {
            ctx.addAll(this.superFields(classDecl.getType() == null ? null : classDecl.getType().getSupertype()));
            return super.visitClassDeclaration(classDecl, ctx);
        }
    }
}

