/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.indentation;

import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentLevel;
import org.openrewrite.tools.checkstyle.checks.indentation.IndentationCheck;
import org.openrewrite.tools.checkstyle.checks.indentation.MethodCallHandler;
import org.openrewrite.tools.checkstyle.checks.indentation.NewHandler;

public class LambdaHandler
extends AbstractExpressionHandler {
    private boolean isLambdaCorrectlyIndented = true;

    public LambdaHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "lambda", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        IndentLevel childIndent = this.getIndent();
        if (this.isLambdaCorrectlyIndented) {
            childIndent = IndentLevel.addAcceptable(childIndent, this.getLineStart(this.getMainAst()), this.getLineStart(this.getMainAst().getFirstChild()));
        }
        return childIndent;
    }

    @Override
    protected IndentLevel getIndentImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            return this.getParent().getSuggestedChildIndent(this);
        }
        DetailAST parent = this.getMainAst().getParent();
        if (this.getParent() instanceof NewHandler) {
            parent = parent.getParent();
        }
        IndentLevel level = new IndentLevel(this.getLineStart(parent));
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild)) {
            level = new IndentLevel(level, this.getIndentCheck().getLineWrappingIndentation());
        }
        return level;
    }

    @Override
    public void checkIndentation() {
        int mainAstColumnNo;
        boolean isLineWrappedLambda;
        IndentLevel level;
        int firstChildColumnNo;
        boolean isSwitchRuleLambda;
        DetailAST mainAst = this.getMainAst();
        DetailAST firstChild = mainAst.getFirstChild();
        boolean bl = isSwitchRuleLambda = firstChild == null;
        if (!isSwitchRuleLambda && this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild) && this.isNonAcceptableIndent(firstChildColumnNo = this.expandedTabsColumnNo(firstChild), level = this.getIndent())) {
            this.isLambdaCorrectlyIndented = false;
            this.logError(firstChild, "arguments", firstChildColumnNo, level);
        }
        boolean bl2 = isLineWrappedLambda = (mainAstColumnNo = this.expandedTabsColumnNo(mainAst)) == this.getLineStart(mainAst);
        if (isLineWrappedLambda) {
            this.checkLineWrappedLambda(isSwitchRuleLambda, mainAstColumnNo);
        }
    }

    private boolean isNonAcceptableIndent(int astColumnNo, IndentLevel level) {
        return astColumnNo < level.getFirstIndentLevel() || this.getIndentCheck().isForceStrictCondition() && !level.isAcceptable(astColumnNo);
    }

    private void checkLineWrappedLambda(boolean isSwitchRuleLambda, int mainAstColumnNo) {
        IndentLevel level;
        DetailAST mainAst = this.getMainAst();
        if (isSwitchRuleLambda) {
            DetailAST previousSibling = mainAst.getPreviousSibling();
            int previousLineStart = this.getLineStart(previousSibling);
            level = new IndentLevel(new IndentLevel(previousLineStart), this.getIndentCheck().getLineWrappingIndentation());
        } else {
            level = new IndentLevel(this.getIndent(), this.getIndentCheck().getLineWrappingIndentation());
        }
        if (this.isNonAcceptableIndent(mainAstColumnNo, level)) {
            this.isLambdaCorrectlyIndented = false;
            this.logError(mainAst, "", mainAstColumnNo, level);
        }
    }
}

