/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class TypeMappings
extends DataTable<Row> {
    public TypeMappings(Recipe recipe) {
        super(recipe, "Type mapping", "The types mapped to `J` trees.");
    }

    public static final class Row {
        @Column(displayName="Compilation unit class name", description="The root compilation unit class name containing the mapping.")
        private final String compilationUnitName;
        @Column(displayName="Tree class name", description="The simple class name of the `J` element.")
        private final String treeName;
        @Column(displayName="Java type class name", description="The simple class name of the `JavaType`.")
        private final String typeName;
        @Column(displayName="Count", description="The number of times this tree and type pair occurred in a repository.")
        private final Integer count;
        @Column(displayName="Nearest non-null tree class name", description="The simple class name of the nearest non-null `J` element when `typeName` is null.")
        private final String nearestNonNullTreeName;

        @Generated
        public Row(String compilationUnitName, String treeName, String typeName, Integer count, String nearestNonNullTreeName) {
            this.compilationUnitName = compilationUnitName;
            this.treeName = treeName;
            this.typeName = typeName;
            this.count = count;
            this.nearestNonNullTreeName = nearestNonNullTreeName;
        }

        @Generated
        public String getCompilationUnitName() {
            return this.compilationUnitName;
        }

        @Generated
        public String getTreeName() {
            return this.treeName;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public Integer getCount() {
            return this.count;
        }

        @Generated
        public String getNearestNonNullTreeName() {
            return this.nearestNonNullTreeName;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$count = this.getCount();
            Integer other$count = other.getCount();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            String this$compilationUnitName = this.getCompilationUnitName();
            String other$compilationUnitName = other.getCompilationUnitName();
            if (this$compilationUnitName == null ? other$compilationUnitName != null : !this$compilationUnitName.equals(other$compilationUnitName)) {
                return false;
            }
            String this$treeName = this.getTreeName();
            String other$treeName = other.getTreeName();
            if (this$treeName == null ? other$treeName != null : !this$treeName.equals(other$treeName)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            String this$nearestNonNullTreeName = this.getNearestNonNullTreeName();
            String other$nearestNonNullTreeName = other.getNearestNonNullTreeName();
            return !(this$nearestNonNullTreeName == null ? other$nearestNonNullTreeName != null : !this$nearestNonNullTreeName.equals(other$nearestNonNullTreeName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            String $compilationUnitName = this.getCompilationUnitName();
            result = result * 59 + ($compilationUnitName == null ? 43 : $compilationUnitName.hashCode());
            String $treeName = this.getTreeName();
            result = result * 59 + ($treeName == null ? 43 : $treeName.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            String $nearestNonNullTreeName = this.getNearestNonNullTreeName();
            result = result * 59 + ($nearestNonNullTreeName == null ? 43 : $nearestNonNullTreeName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeMappings.Row(compilationUnitName=" + this.getCompilationUnitName() + ", treeName=" + this.getTreeName() + ", typeName=" + this.getTypeName() + ", count=" + this.getCount() + ", nearestNonNullTreeName=" + this.getNearestNonNullTreeName() + ")";
        }
    }
}

