/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.internal.grammar.TemplateParameterLexer;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.grammar.TemplateParameterParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;

public class TypeParameter {
    private static final JavaType.Class TYPE_OBJECT = JavaType.ShallowClass.build("java.lang.Object");

    public static TemplateParameterParser parser(String value) {
        TemplateParameterLexer lexer = new TemplateParameterLexer((CharStream)CharStreams.fromString((String)value));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
        TemplateParameterParser parser = new TemplateParameterParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ThrowingErrorListener());
        return parser;
    }

    public static JavaType toJavaType(@Nullable TemplateParameterParser.TypeContext type, final Map<String, JavaType.GenericTypeVariable> genericTypes) {
        if (type == null) {
            return TYPE_OBJECT;
        }
        return type.accept(new TemplateParameterParserBaseVisitor<JavaType>(){

            @Override
            public JavaType visitType(TemplateParameterParser.TypeContext ctx) {
                JavaType type1 = ctx.typeName().accept(this);
                if (!ctx.typeParameter().isEmpty()) {
                    ArrayList<JavaType> typeParameters = new ArrayList<JavaType>();
                    for (TemplateParameterParser.TypeParameterContext param : ctx.typeParameter()) {
                        typeParameters.add(param.accept(this));
                    }
                    type1 = new JavaType.Parameterized(null, (JavaType.FullyQualified)type1, typeParameters);
                }
                for (TemplateParameterParser.TypeArrayContext unused : ctx.typeArray()) {
                    type1 = new JavaType.Array(null, type1, null);
                }
                return type1;
            }

            @Override
            public JavaType visitTypeName(TemplateParameterParser.TypeNameContext ctx) {
                JavaType type;
                String fqn;
                String string = fqn = ctx.FullyQualifiedName() != null ? ctx.FullyQualifiedName().getText() : ctx.Identifier().getText();
                if (fqn.contains(".")) {
                    type = JavaType.ShallowClass.build(fqn);
                } else if (genericTypes.containsKey(fqn)) {
                    type = (JavaType)genericTypes.get(fqn);
                } else if (fqn.equals("String")) {
                    type = JavaType.ShallowClass.build("java.lang.String");
                } else if (fqn.equals("Object")) {
                    type = TYPE_OBJECT;
                } else {
                    type = JavaType.Primitive.fromKeyword(fqn);
                    if (type == null) {
                        throw new IllegalArgumentException("Unknown type " + fqn + ". Make sure all types are fully qualified.");
                    }
                }
                return type;
            }

            @Override
            public JavaType visitTypeParameter(TemplateParameterParser.TypeParameterContext ctx) {
                JavaType type1 = (JavaType)super.visitTypeParameter(ctx);
                if (ctx.variance() != null) {
                    JavaType.GenericTypeVariable.Variance variance = ctx.variance().Extends() != null ? JavaType.GenericTypeVariable.Variance.COVARIANT : JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
                    type1 = new JavaType.GenericTypeVariable(null, ctx.variance().WILDCARD().getText(), variance, Collections.singletonList(type1));
                } else if (ctx.WILDCARD() != null) {
                    type1 = new JavaType.GenericTypeVariable(null, ctx.WILDCARD().getText(), JavaType.GenericTypeVariable.Variance.INVARIANT, Collections.emptyList());
                }
                return type1;
            }
        });
    }

    public static Map<String, JavaType.GenericTypeVariable> parseGenericTypes(Set<String> genericTypes) {
        Map<String, List<TemplateParameterParser.GenericPatternContext>> contexts = genericTypes.stream().map(e -> TypeParameter.parser(e).genericPattern()).collect(Collectors.groupingBy(e -> e.genericName().getText()));
        if (contexts.values().stream().anyMatch(e -> e.size() > 1)) {
            throw new IllegalArgumentException("Found duplicated generic type.");
        }
        Map<String, JavaType.GenericTypeVariable> genericTypesMap = contexts.keySet().stream().collect(Collectors.toMap(e -> e, e -> new JavaType.GenericTypeVariable(null, (String)e, JavaType.GenericTypeVariable.Variance.INVARIANT, Collections.emptyList())));
        for (String name : genericTypesMap.keySet()) {
            JavaType.GenericTypeVariable genericType = genericTypesMap.get(name);
            TemplateParameterParser.GenericPatternContext context = contexts.get(name).get(0);
            List<JavaType> bounds = context.type().stream().map(e -> TypeParameter.toJavaType(e, genericTypesMap)).collect(Collectors.toList());
            if (bounds.isEmpty()) continue;
            genericType.unsafeSet(name, JavaType.GenericTypeVariable.Variance.COVARIANT, bounds);
        }
        return genericTypesMap;
    }

    private static class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new IllegalArgumentException(String.format("Syntax error at line %d:%d %s.", line, charPositionInLine, msg), e);
        }
    }
}

