/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.CheckUtil;
import org.openrewrite.tools.checkstyle.utils.TokenUtil;

@StatelessCheck
public class MultipleVariableDeclarationsCheck
extends AbstractCheck {
    public static final String MSG_MULTIPLE = "multiple.variable.declarations";
    public static final String MSG_MULTIPLE_COMMA = "multiple.variable.declarations.comma";

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nextNode = ast.getNextSibling();
        if (nextNode != null) {
            boolean isCommaSeparated;
            boolean bl = isCommaSeparated = nextNode.getType() == 74;
            if (isCommaSeparated || nextNode.getType() == 45) {
                nextNode = nextNode.getNextSibling();
            }
            if (nextNode != null && nextNode.getType() == 10) {
                DetailAST firstNode = CheckUtil.getFirstNode(ast);
                if (isCommaSeparated) {
                    if (ast.getParent().getType() != 35) {
                        this.log(firstNode, MSG_MULTIPLE_COMMA, new Object[0]);
                    }
                } else {
                    DetailAST lastNode = MultipleVariableDeclarationsCheck.getLastNode(ast);
                    DetailAST firstNextNode = CheckUtil.getFirstNode(nextNode);
                    if (TokenUtil.areOnSameLine(firstNextNode, lastNode)) {
                        this.log(firstNode, MSG_MULTIPLE, new Object[0]);
                    }
                }
            }
        }
    }

    private static DetailAST getLastNode(DetailAST node) {
        DetailAST currentNode = node;
        DetailAST child = node.getLastChild();
        if (child != null) {
            currentNode = MultipleVariableDeclarationsCheck.getLastNode(child);
        }
        return currentNode;
    }
}

