/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Locale;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.HasSourceSet;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

@Incubating(since="7.36.0")
public class IsLikelyTest
extends Recipe {
    public String getDisplayName() {
        return "Find sources that are likely tests";
    }

    public String getDescription() {
        return "Sources that contain indicators of being, or being exclusively for the use in tests. This recipe is not exhaustive, but is intended to be a good starting point for finding test sources. Looks at the source set name, and types in use; for example looks for uses of JUnit & TestNG annotations/assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.or((TreeVisitor[])new TreeVisitor[]{new HasSourceSet("test").getVisitor(), new HasSourceSetNameContainingTestVisitor(), new UsesType("org.junit..*", true), new UsesType("org.testng..*", true), new UsesType("org.hamcrest..*", true), new UsesType("org.mockito..*", true), new UsesType("org.powermock..*", true), new UsesType("org.assertj..*", true), new UsesType("spock.lang..*", true)});
    }

    private static class HasSourceSetNameContainingTestVisitor<P>
    extends JavaIsoVisitor<P> {
        private HasSourceSetNameContainingTestVisitor() {
        }

        public J visit(@Nullable Tree tree, P p) {
            JavaSourceFile cu;
            if (tree instanceof JavaSourceFile && (cu = (JavaSourceFile)Objects.requireNonNull(tree)).getMarkers().findFirst(JavaSourceSet.class).filter(s -> s.getName().toLowerCase(Locale.ROOT).contains("test")).isPresent()) {
                return (J)SearchResult.found((Tree)cu);
            }
            return (J)tree;
        }
    }
}

