/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import java.util.ArrayList;
import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.grammar.TemplateParameterParserBaseVisitor;
import org.openrewrite.java.tree.JavaType;

public class TypeParameter {
    private static final JavaType.Class TYPE_OBJECT = JavaType.ShallowClass.build("java.lang.Object");

    public static JavaType toFullyQualifiedName( @Nullable TemplateParameterParser.TypeContext type) {
        if (type == null) {
            return TYPE_OBJECT;
        }
        return type.accept(new TemplateParameterParserBaseVisitor<JavaType>(){

            @Override
            public JavaType visitType(TemplateParameterParser.TypeContext ctx) {
                JavaType type1 = ctx.typeName().accept(this);
                if (!ctx.typeParameter().isEmpty()) {
                    ArrayList<JavaType> typeParameters = new ArrayList<JavaType>();
                    for (TemplateParameterParser.TypeParameterContext param : ctx.typeParameter()) {
                        typeParameters.add(param.accept(this));
                    }
                    type1 = new JavaType.Parameterized(null, (JavaType.FullyQualified)type1, typeParameters);
                }
                for (TemplateParameterParser.TypeArrayContext unused : ctx.typeArray()) {
                    type1 = new JavaType.Array(null, type1, null);
                }
                return type1;
            }

            @Override
            public JavaType visitTypeName(TemplateParameterParser.TypeNameContext ctx) {
                JavaType type;
                String fqn;
                String string = fqn = ctx.FullyQualifiedName() != null ? ctx.FullyQualifiedName().getText() : ctx.Identifier().getText();
                if (fqn.contains(".")) {
                    type = JavaType.ShallowClass.build(fqn);
                } else if (fqn.equals("String")) {
                    type = JavaType.ShallowClass.build("java.lang.String");
                } else if (fqn.equals("Object")) {
                    type = TYPE_OBJECT;
                } else {
                    type = JavaType.Primitive.fromKeyword(fqn);
                    if (type == null) {
                        type = JavaType.Unknown.getInstance();
                    }
                }
                return type;
            }

            @Override
            public JavaType visitTypeParameter(TemplateParameterParser.TypeParameterContext ctx) {
                JavaType type1 = (JavaType)super.visitTypeParameter(ctx);
                if (ctx.variance() != null) {
                    JavaType.GenericTypeVariable.Variance variance = ctx.variance().Variance().getSymbol().getText().equals("extends") ? JavaType.GenericTypeVariable.Variance.COVARIANT : JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
                    type1 = new JavaType.GenericTypeVariable(null, ctx.variance().WILDCARD().getText(), variance, Collections.singletonList(type1));
                } else if (ctx.WILDCARD() != null) {
                    type1 = new JavaType.GenericTypeVariable(null, ctx.WILDCARD().getText(), JavaType.GenericTypeVariable.Variance.INVARIANT, Collections.emptyList());
                }
                return type1;
            }
        });
    }
}

