/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.javadoc;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.DetailNode;
import org.openrewrite.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;
import org.openrewrite.tools.checkstyle.utils.JavadocUtil;

@StatelessCheck
public class NonEmptyAtclauseDescriptionCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "non.empty.atclause";

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10, 11, 17, 9, 8};
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (NonEmptyAtclauseDescriptionCheck.isEmptyTag(ast.getParent())) {
            this.log(ast.getLineNumber(), MSG_KEY, ast.getText());
        }
    }

    private static boolean isEmptyTag(DetailNode tagNode) {
        DetailNode tagDescription = JavadocUtil.findFirstToken(tagNode, 10068);
        return tagDescription == null || NonEmptyAtclauseDescriptionCheck.hasOnlyEmptyText(tagDescription);
    }

    private static boolean hasOnlyEmptyText(DetailNode description) {
        boolean result = true;
        for (DetailNode child : description.getChildren()) {
            if (child.getType() == 10074 && CommonUtil.isBlank(child.getText())) continue;
            result = false;
            break;
        }
        return result;
    }
}

