/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.PatternVariables;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class BlockStatementTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE__";
    private static final String STOP_COMMENT = "__TEMPLATE_STOP__";
    protected static final String TEMPLATE_INTERNAL_IMPORTS = "import org.openrewrite.java.internal.template.__M__;\nimport org.openrewrite.java.internal.template.__P__;\n";
    protected final Set<String> imports;
    private final boolean contextSensitive;

    public String template(Cursor cursor, String template, Space.Location location, JavaCoordinates.Mode mode) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            if (cursor.getValue() instanceof J.MethodDeclaration && location == Space.Location.BLOCK_PREFIX) {
                J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
                J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
                before.insert(0, m.printTrimmed(cursor.getParentOrThrow()).trim() + '{');
                after.append('}');
            }
            if (this.contextSensitive) {
                this.contextTemplate(this.next(cursor), (J)cursor.getValue(), before, after, (J)cursor.getValue(), mode);
            } else {
                this.contextFreeTemplate(this.next(cursor), (J)cursor.getValue(), before, after);
            }
            return before.toString().trim() + "\n/*" + TEMPLATE_COMMENT + "*/" + template + "/*" + STOP_COMMENT + "*/\n" + after.toString().trim();
        });
    }

    public <J2 extends J> List<J2> listTemplatedTrees(JavaSourceFile cu, final Class<J2> expected) {
        final ArrayList js = new ArrayList();
        new JavaIsoVisitor<Integer>(){
            boolean done = false;
            @Nullable J.Block blockEnclosingTemplateComment;

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, Integer integer) {
                if (this.getCursor().getParentTreeCursor().getValue() instanceof SourceFile && (classDecl.getSimpleName().equals("__P__") || classDecl.getSimpleName().equals("__M__"))) {
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, integer);
            }

            @Override
            public J.Block visitBlock(J.Block block, Integer p) {
                J b = super.visitBlock(block, p);
                if (b == this.blockEnclosingTemplateComment) {
                    this.done = true;
                }
                return b;
            }

            @Override
            public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, Integer integer) {
                if ((right = super.visitRightPadded(right, loc, integer)) != null) {
                    for (Comment comment : right.getAfter().getComments()) {
                        if (!this.isTemplateStopComment(comment)) continue;
                        this.done = true;
                        break;
                    }
                }
                return right;
            }

            @Override
            public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, JLeftPadded.Location loc, Integer integer) {
                if ((left = super.visitLeftPadded(left, loc, integer)) != null) {
                    for (Comment comment : left.getBefore().getComments()) {
                        if (!this.isTemplateStopComment(comment)) continue;
                        this.done = true;
                        break;
                    }
                }
                return left;
            }

            public @Nullable J visit(@Nullable Tree tree, Integer p) {
                J trimmed;
                if (this.done) {
                    return (J)tree;
                }
                if (expected.isInstance(tree)) {
                    J t = (J)tree;
                    if (this.blockEnclosingTemplateComment != null) {
                        J trimmed2;
                        for (Comment comment : t.getComments()) {
                            if (!this.isTemplateStopComment(comment)) continue;
                            this.done = true;
                            break;
                        }
                        J j = trimmed2 = this.done ? null : TemplatedTreeTrimmer.trimTree(t);
                        if (trimmed2 != null) {
                            js.add(trimmed2);
                        }
                        return t;
                    }
                    List<Comment> comments = t.getPrefix().getComments();
                    for (int i = 0; i < comments.size(); ++i) {
                        Comment comment = comments.get(i);
                        if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.TEMPLATE_COMMENT)) continue;
                        this.blockEnclosingTemplateComment = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
                        J trimmed3 = TemplatedTreeTrimmer.trimTree(t);
                        if (t != trimmed3) {
                            this.done = true;
                        }
                        if (trimmed3 != null) {
                            js.add(trimmed3.withPrefix(trimmed3.getPrefix().withComments(comments.subList(i + 1, comments.size()))));
                        }
                        return t;
                    }
                } else if (tree != null && !js.isEmpty() && (trimmed = TemplatedTreeTrimmer.trimTree((J)tree)) != tree) {
                    this.done = true;
                }
                return (J)super.visit(tree, (Object)p);
            }

            private boolean isTemplateStopComment(Comment comment) {
                return comment instanceof TextComment && ((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.STOP_COMMENT);
            }
        }.visit(cu, 0);
        return js;
    }

    protected void contextFreeTemplate(Cursor cursor, J j, StringBuilder before, StringBuilder after) {
        if (j instanceof J.Lambda) {
            throw new IllegalArgumentException("Templating a lambda requires a cursor so that it can be properly parsed and type-attributed. Mark this template as context-sensitive by calling JavaTemplate.Builder#contextSensitive().");
        }
        if (j instanceof J.MemberReference) {
            throw new IllegalArgumentException("Templating a method reference requires a cursor so that it can be properly parsed and type-attributed. Mark this template as context-sensitive by calling JavaTemplate.Builder#contextSensitive().");
        }
        if (j instanceof J.MethodInvocation) {
            before.insert(0, "class Template {{\n");
            JavaType.Method methodType = ((J.MethodInvocation)j).getMethodType();
            if (methodType == null || methodType.getReturnType() != JavaType.Primitive.Void) {
                before.append("Object o = ");
            }
            after.append(";\n}}");
        } else if (j instanceof Expression && !(j instanceof J.Assignment)) {
            before.insert(0, "class Template {\n");
            before.append("Object o = ");
            after.append(";\n}");
        } else if ((j instanceof J.MethodDeclaration || j instanceof J.VariableDeclarations || j instanceof J.Block || j instanceof J.ClassDeclaration) && cursor.getValue() instanceof J.Block && (cursor.getParent().getValue() instanceof J.ClassDeclaration || cursor.getParent().getValue() instanceof J.NewClass)) {
            before.insert(0, "class Template {\n");
            after.append("\n}");
        } else {
            if (j instanceof J.ClassDeclaration) {
                throw new IllegalArgumentException("Templating a class declaration requires context from which package declaration and imports may be reached. Mark this template as context-sensitive by calling JavaTemplate.Builder#contextSensitive().");
            }
            if (j instanceof Statement && !(j instanceof J.Import) && !(j instanceof J.Package)) {
                before.insert(0, "class Template {{\n");
                after.append("\n}}");
            }
        }
        before.insert(0, TEMPLATE_INTERNAL_IMPORTS);
        for (String anImport : this.imports) {
            before.insert(0, anImport);
        }
    }

    private void contextTemplate(Cursor cursor, J prior, StringBuilder before, StringBuilder after, J insertionPoint, JavaCoordinates.Mode mode) {
        J j = (J)cursor.getValue();
        if (j instanceof JavaSourceFile) {
            before.insert(0, TEMPLATE_INTERNAL_IMPORTS);
            JavaSourceFile cu = (JavaSourceFile)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                J.ClassDeclaration c = (J.ClassDeclaration)parent;
                this.classDeclaration(prior, c, before, after, cursor, mode);
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                this.addLeadingVariableDeclarations(cursor, prior, m.getBody(), before, insertionPoint);
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    before.insert(0, "if(true) {");
                    after.append("}\nreturn ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + '{');
            } else {
                J.Block b = (J.Block)j;
                this.addLeadingVariableDeclarations(cursor, prior, b, before, insertionPoint);
                before.insert(0, "{\n");
            }
            if (prior == insertionPoint && prior instanceof Expression) {
                after.append(';');
            }
            after.append('}');
        } else if (j instanceof J.Annotation) {
            J.Annotation annotation = (J.Annotation)j;
            Optional<Expression> arg2 = annotation.getArguments().stream().filter(a -> a == prior).findFirst();
            if (arg2.isPresent()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('@').append(((JavaType.Class)annotation.getType()).getFullyQualifiedName()).append('(');
                before.insert(0, stringBuilder);
                after.append(')').append('\n');
                J parent = (J)this.next(cursor).getValue();
                if (parent instanceof J.ClassDeclaration) {
                    J.ClassDeclaration cd = (J.ClassDeclaration)parent;
                    after.append(cd.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY).printTrimmed(cursor).trim()).append("{}");
                } else if (parent instanceof J.MethodDeclaration) {
                    J.MethodDeclaration md = (J.MethodDeclaration)parent;
                    after.append(md.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed(cursor).trim()).append("{}");
                }
            }
        } else if (j instanceof J.DoWhileLoop) {
            J.DoWhileLoop dw = (J.DoWhileLoop)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, dw.getWhileCondition())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                after.append(";");
            }
        } else if (j instanceof J.Assert) {
            before.insert(0, "assert ");
            after.append(';');
        } else if (j instanceof J.NewArray) {
            J.NewArray n = (J.NewArray)j;
            if (n.getInitializer() != null && n.getInitializer().stream().anyMatch(arg -> BlockStatementTemplateGenerator.referToSameElement(prior, arg))) {
                before.insert(0, n.withInitializer(null).printTrimmed(cursor) + "{\n");
                after.append("\n}");
            } else {
                before.insert(0, "__M__.any(");
                after.append(");");
            }
        } else if (j instanceof J.NewClass) {
            String newClassString;
            boolean isEnum;
            J.NewClass n = (J.NewClass)j;
            JavaType.Class clazz = n.getConstructorType() != null ? TypeUtils.asClass(n.getConstructorType().getReturnType()) : null;
            boolean bl = isEnum = clazz != null && JavaType.FullyQualified.Kind.Enum == clazz.getKind();
            if (n.getClazz() != null) {
                newClassString = "new " + n.getClazz().printTrimmed(cursor);
            } else if (clazz != null) {
                newClassString = isEnum ? "" : "new " + clazz.getFullyQualifiedName();
            } else {
                throw new IllegalStateException("Unable to template a J.NewClass instance having a null clazz and constructor type.");
            }
            if (n.getArguments().stream().anyMatch(arg -> BlockStatementTemplateGenerator.referToSameElement(prior, arg))) {
                StringBuilder beforeSegments = new StringBuilder();
                StringBuilder afterSegments = new StringBuilder();
                beforeSegments.append(newClassString).append("(");
                boolean priorFound = false;
                for (Expression arg3 : n.getArguments()) {
                    if (!priorFound) {
                        if (BlockStatementTemplateGenerator.referToSameElement(prior, arg3)) {
                            priorFound = true;
                            continue;
                        }
                        beforeSegments.append(this.valueOfType(arg3.getType())).append(",");
                        continue;
                    }
                    afterSegments.append(",/*__TEMPLATE_STOP__*/").append(this.valueOfType(arg3.getType()));
                }
                afterSegments.append(")");
                if (priorFound && !afterSegments.toString().contains(STOP_COMMENT)) {
                    if (isEnum) {
                        afterSegments.append(";");
                    }
                    afterSegments.append("/*__TEMPLATE_STOP__*/");
                }
                before.insert(0, beforeSegments);
                after.append((CharSequence)afterSegments);
                if (this.next(cursor).getValue() instanceof J.Block) {
                    after.append(";");
                }
            } else {
                n = n.withBody(null).withPrefix(Space.EMPTY);
                before.insert(0, n.printTrimmed(cursor.getParentOrThrow()).trim());
                if (!(this.next(cursor).getValue() instanceof MethodCall)) {
                    after.append(';');
                }
            }
        } else if (j instanceof J.ForLoop.Control) {
            J.ForLoop.Control c = (J.ForLoop.Control)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, c.getCondition())) {
                before.insert(0, "for (" + c.getInit().get(0).printTrimmed(cursor).trim() + ";");
                after.append(";) {}");
            }
        } else if (j instanceof J.ForLoop) {
            J.ForLoop f = (J.ForLoop)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, f.getBody())) {
                this.insertControlWithBlock(f.getBody(), before, after, () -> before.insert(0, f.withBody(null).withPrefix(Space.EMPTY).withControl(f.getControl().withCondition(null).withUpdate(Collections.emptyList())).printTrimmed(cursor).trim()));
            }
        } else if (j instanceof J.ForEachLoop.Control) {
            J.ForEachLoop.Control c = (J.ForEachLoop.Control)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, c.getVariable())) {
                after.append(" = /*__TEMPLATE_STOP__*/").append(c.getIterable().printTrimmed(cursor));
            } else if (BlockStatementTemplateGenerator.referToSameElement(prior, c.getIterable())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                after.append(";");
            }
        } else if (j instanceof J.ForEachLoop) {
            J.ForEachLoop f = (J.ForEachLoop)j;
            if (!BlockStatementTemplateGenerator.referToSameElement(prior, f.getControl())) {
                this.insertControlWithBlock(f.getBody(), before, after, () -> before.insert(0, f.withBody(null).withPrefix(Space.EMPTY).printTrimmed(cursor).trim()));
            }
        } else if (j instanceof J.Try) {
            J.Try t = (J.Try)j;
            if (t.getResources() != null && BlockStatementTemplateGenerator.referToSameElement(prior, t.getBody())) {
                StringJoiner joiner = new StringJoiner("; ", "try (", ")");
                for (J.Try.Resource resource : t.getResources()) {
                    joiner.add(resource.withPrefix(Space.EMPTY).printTrimmed(cursor).trim());
                }
                before.insert(0, joiner);
            }
        } else if (j instanceof J.Lambda) {
            J.Lambda l = (J.Lambda)j;
            if (l.getBody() instanceof Expression) {
                before.insert(0, "return ");
                after.append(";");
            }
            before.insert(0, l.withBody(null).withPrefix(Space.EMPTY).printTrimmed(cursor.getParentOrThrow()).trim() + "{ if(true) {");
            after.append("}\n");
            JavaType.Method mt = BlockStatementTemplateGenerator.findSingleAbstractMethod(l.getType());
            if (mt == null) {
                after.append("return null;\n");
            } else if (mt.getReturnType() != JavaType.Primitive.Void) {
                after.append("return ").append(this.valueOfType(mt.getReturnType())).append(";\n");
            }
            after.append("}");
            if (this.next(cursor).getValue() instanceof J.Block) {
                after.append(";");
            }
        } else if (j instanceof J.VariableDeclarations) {
            if (prior instanceof J.Annotation) {
                after.append(this.variable((J.VariableDeclarations)j, false, cursor)).append('=').append(this.valueOfType(((J.VariableDeclarations)j).getType()));
            } else {
                before.insert(0, this.variable((J.VariableDeclarations)j, false, cursor) + '=');
            }
            after.append(";");
        } else if (j instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)j;
            J firstEnclosing = (J)cursor.getParentOrThrow().firstEnclosing(J.class);
            if (m.getArguments().stream().anyMatch(arg -> BlockStatementTemplateGenerator.referToSameElement(prior, arg))) {
                before.insert(0, "__M__.any(");
                if (firstEnclosing instanceof J.Block || firstEnclosing instanceof J.Case || firstEnclosing instanceof J.If || firstEnclosing instanceof J.If.Else) {
                    after.append(");");
                } else {
                    after.append(")");
                }
            } else if (m.getTypeParameters() != null && m.getTypeParameters().stream().anyMatch(tp -> BlockStatementTemplateGenerator.referToSameElement(prior, tp))) {
                before.insert(0, "__M__.anyT<");
                if (firstEnclosing instanceof J.Block || firstEnclosing instanceof J.Case) {
                    after.append(">();");
                } else {
                    after.append(">()");
                }
            } else if (m.getSelect() == prior) {
                ArrayList<Comment> arrayList = new ArrayList<Comment>(1);
                arrayList.add(new TextComment(true, STOP_COMMENT, "", Markers.EMPTY));
                after.append(".").append(m.withSelect(null).withComments(arrayList).printTrimmed(cursor.getParentOrThrow()));
                if (firstEnclosing instanceof J.Block || firstEnclosing instanceof J.Case) {
                    after.append(";");
                }
            }
        } else if (j instanceof J.Return) {
            before.insert(0, "return ");
            after.append(";");
        } else if (j instanceof J.Throw) {
            before.insert(0, "throw ");
            after.append(";");
        } else if (j instanceof J.Parentheses) {
            before.insert(0, '(');
            after.append(')');
        } else if (j instanceof J.If) {
            J.If iff = (J.If)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, iff.getIfCondition())) {
                int n;
                String condition = PatternVariables.simplifiedPatternVariableCondition(iff.getIfCondition().getTree(), insertionPoint);
                if (condition != null && (n = condition.indexOf(167)) != -1) {
                    before.insert(0, "if (" + condition.substring(0, n) + '(');
                    after.append(')').append(condition.substring(n + 1)).append(") {}");
                } else {
                    before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                    after.append(";");
                }
            } else {
                String condition = PatternVariables.simplifiedPatternVariableCondition(iff.getIfCondition().getTree(), insertionPoint);
                if (condition != null) {
                    if (BlockStatementTemplateGenerator.referToSameElement(prior, iff.getThenPart())) {
                        this.insertControlWithBlock(iff.getThenPart(), before, after, () -> before.insert(0, "if (" + condition + ") "));
                    } else if (BlockStatementTemplateGenerator.referToSameElement(prior, iff.getElsePart())) {
                        this.insertControlWithBlock(iff.getElsePart().getBody(), before, after, () -> before.insert(0, "if (" + condition + ") {} else "));
                    }
                }
            }
        } else if (j instanceof J.Ternary) {
            J.Ternary ternary = (J.Ternary)j;
            String condition = PatternVariables.simplifiedPatternVariableCondition(ternary.getCondition(), insertionPoint);
            if (condition != null) {
                if (BlockStatementTemplateGenerator.referToSameElement(prior, ternary.getCondition())) {
                    int n = condition.indexOf(167);
                    before.insert(0, condition.substring(0, n) + '(');
                    after.append(')').append(condition.substring(n + 1)).append(" ? ").append(ternary.getTruePart().printTrimmed(cursor).trim()).append(" : ").append(ternary.getFalsePart().printTrimmed(cursor).trim());
                } else if (BlockStatementTemplateGenerator.referToSameElement(prior, ternary.getTruePart())) {
                    before.insert(0, (condition == null ? "true" : condition) + " ? ");
                    after.append(" : ").append(ternary.getFalsePart().printTrimmed(cursor).trim());
                } else if (BlockStatementTemplateGenerator.referToSameElement(prior, ternary.getFalsePart())) {
                    before.insert(0, (condition == null ? "true" : condition) + " ? " + ternary.getTruePart().printTrimmed(cursor).trim() + " : ");
                }
            }
        } else if (j instanceof J.WhileLoop) {
            J.WhileLoop wl = (J.WhileLoop)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, wl.getCondition())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ =");
                after.append(";");
            }
        } else if (j instanceof J.Assignment) {
            J.Assignment as = (J.Assignment)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, as.getAssignment())) {
                before.insert(0, as.getVariable() + " = ");
                J parent = (J)this.next(cursor).getValue();
                if (!(parent instanceof J.Annotation)) {
                    after.append(";");
                }
            }
        } else if (j instanceof J.AssignmentOperation) {
            J.AssignmentOperation as = (J.AssignmentOperation)j;
            if (BlockStatementTemplateGenerator.referToSameElement(prior, as.getAssignment())) {
                before.insert(0, "Object __b" + cursor.getPathAsStream().count() + "__ = ");
                after.append(";");
            }
        } else if (j instanceof J.EnumValue) {
            J.EnumValue ev = (J.EnumValue)j;
            before.insert(0, ev.getName());
        } else if (j instanceof J.EnumValueSet) {
            after.append(";");
        } else if (j instanceof J.Case) {
            after.append(";");
        }
        this.contextTemplate(this.next(cursor), j, before, after, insertionPoint, JavaCoordinates.Mode.REPLACEMENT);
    }

    private void addLeadingVariableDeclarations(Cursor cursor, J current, J.Block containingBlock, StringBuilder before, J insertionPoint) {
        for (Statement statement : containingBlock.getStatements()) {
            boolean elseNeverCompletesNormally;
            J.If iff;
            String condition;
            if (BlockStatementTemplateGenerator.referToSameElement(current, statement)) break;
            if (statement instanceof J.Label) {
                statement = ((J.Label)statement).getStatement();
            }
            if (statement instanceof J.VariableDeclarations) {
                before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true, cursor) + ";\n");
                continue;
            }
            if (!(statement instanceof J.If) || (condition = PatternVariables.simplifiedPatternVariableCondition((iff = (J.If)statement).getIfCondition().getTree(), insertionPoint)) == null) continue;
            boolean thenNeverCompletesNormally = PatternVariables.neverCompletesNormally(iff.getThenPart());
            boolean bl = elseNeverCompletesNormally = iff.getElsePart() != null && PatternVariables.neverCompletesNormally(iff.getElsePart().getBody());
            if (!thenNeverCompletesNormally && !elseNeverCompletesNormally) continue;
            StringBuilder ifStatement = new StringBuilder("if (").append(condition).append(") {");
            ifStatement.append(thenNeverCompletesNormally ? " throw new RuntimeException(); }" : " }");
            ifStatement.append(elseNeverCompletesNormally ? " else { throw new RuntimeException(); }" : " else { }");
            before.insert(0, ifStatement);
        }
    }

    private void insertControlWithBlock(J body, StringBuilder before, StringBuilder after, Runnable insertion) {
        if (!(body instanceof J.Block)) {
            before.insert(0, "{");
        }
        insertion.run();
        if (!(body instanceof J.Block)) {
            after.append("}");
        }
    }

    private void classDeclaration(@Nullable J prior, J.ClassDeclaration cd, StringBuilder before, StringBuilder after, Cursor cursor, JavaCoordinates.Mode mode) {
        StringBuilder beforeBuffer = prior == null ? null : new StringBuilder();
        StringBuilder appendBuffer = prior == null ? after : beforeBuffer;
        appendBuffer.append(cd.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY).printTrimmed(cursor).trim()).append('{');
        List<Statement> statements = cd.getBody().getStatements();
        for (Statement statement : statements) {
            if (BlockStatementTemplateGenerator.referToSameElement(statement, prior) && mode != JavaCoordinates.Mode.AFTER) {
                appendBuffer = after;
                if (mode == JavaCoordinates.Mode.REPLACEMENT) continue;
            }
            if (statement instanceof J.EnumValueSet) {
                J.EnumValueSet enumValues = (J.EnumValueSet)statements.get(0);
                StringJoiner enumStr = new StringJoiner(",");
                for (J.EnumValue anEnum : enumValues.getEnums()) {
                    String en = anEnum.getName().getSimpleName();
                    enumStr.add(en);
                }
                appendBuffer.append(enumStr).append(";\n");
                continue;
            }
            if (statement instanceof J.VariableDeclarations) {
                String variable = this.variable((J.VariableDeclarations)statement, false, cursor);
                appendBuffer.append(variable).append(";\n");
                continue;
            }
            if (statement instanceof J.MethodDeclaration) {
                String m = this.method((J.MethodDeclaration)statement, cursor);
                appendBuffer.append(m);
                continue;
            }
            if (!(statement instanceof J.ClassDeclaration)) continue;
            this.classDeclaration(null, (J.ClassDeclaration)statement, before, appendBuffer, cursor, JavaCoordinates.Mode.REPLACEMENT);
            appendBuffer.append('}');
        }
        if (beforeBuffer != null) {
            before.insert(0, beforeBuffer);
        }
    }

    private String method(J.MethodDeclaration method, Cursor cursor) {
        if (method.isAbstract()) {
            return "\n" + method.withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + ";\n";
        }
        StringBuilder methodBuilder = new StringBuilder("\n");
        J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
        methodBuilder.append(m.printTrimmed(cursor).trim()).append('{');
        if (method.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(method.getReturnTypeExpression().getType())) {
            methodBuilder.append("\nreturn ").append(this.valueOfType(method.getReturnTypeExpression().getType())).append(";\n");
        }
        methodBuilder.append("}\n");
        return methodBuilder.toString();
    }

    private String variable(J.VariableDeclarations variable, boolean initializer, Cursor cursor) {
        StringBuilder varBuilder = new StringBuilder();
        for (J.Modifier modifier : variable.getModifiers()) {
            varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            if (i == 0) {
                if (variable.getTypeExpression() != null) {
                    varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed(cursor));
                }
                if (nv.getType() instanceof JavaType.Array) {
                    if (nv.getInitializer() instanceof J.NewArray && !((J.NewArray)nv.getInitializer()).getDimensions().isEmpty()) {
                        J.NewArray na = (J.NewArray)nv.getInitializer();
                        na.getDimensions().forEach(d -> varBuilder.append("[]"));
                    } else {
                        varBuilder.append("[]");
                    }
                }
                varBuilder.append(" ");
            }
            varBuilder.append(nv.getSimpleName());
            JavaType type = nv.getType();
            if (initializer && type != null) {
                varBuilder.append('=').append(this.valueOfType(type));
            }
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.getParentTreeCursor();
    }

    private static boolean referToSameElement(@Nullable Tree t1, @Nullable Tree t2) {
        return t1 == t2 || t1 != null && t2 != null && t1.getId().equals(t2.getId());
    }

    private static @Nullable JavaType.Method findSingleAbstractMethod(@Nullable JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        JavaType.FullyQualified fq = TypeUtils.asFullyQualified(javaType);
        if (fq == null) {
            return null;
        }
        return fq.getMethods().stream().filter(method -> method.hasFlags(Flag.Abstract)).findAny().orElse(null);
    }

    @Generated
    public BlockStatementTemplateGenerator(Set<String> imports, boolean contextSensitive) {
        this.imports = imports;
        this.contextSensitive = contextSensitive;
    }

    private static class TemplatedTreeTrimmer {
        private TemplatedTreeTrimmer() {
        }

        static @Nullable J trimTree(J j) {
            J trimmed = new TemplatedTreeTrimmerVisitor().visit((Tree)j, 0);
            if (trimmed == null || trimmed.getMarkers().findFirst(RemoveTreeMarker.class).isPresent()) {
                return null;
            }
            return trimmed;
        }

        private static class TemplatedTreeTrimmerVisitor
        extends JavaVisitor<Integer> {
            private TemplatedTreeTrimmerVisitor() {
            }

            private boolean stopCommentExists(@Nullable J j) {
                return j != null && TemplatedTreeTrimmerVisitor.stopCommentExists(j.getComments());
            }

            private static boolean stopCommentExists(List<Comment> comments) {
                for (Comment comment : comments) {
                    if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.STOP_COMMENT)) continue;
                    return true;
                }
                return false;
            }

            public @Nullable J visit(@Nullable Tree tree, Integer integer) {
                Cursor parent;
                J j = (J)super.visit(tree, (Object)integer);
                if (this.stopCommentExists(j) && ((parent = this.getCursor().getParent()) == null || !(parent.getValue() instanceof J.MethodInvocation))) {
                    return (J)j.withMarkers(j.getMarkers().addIfAbsent((Marker)new RemoveTreeMarker(Tree.randomId())));
                }
                return j;
            }

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, Integer integer) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, integer);
                if (this.stopCommentExists(mi.getName())) {
                    return mi.getSelect();
                }
                if (method.getTypeParameters() != null && TemplatedTreeTrimmerVisitor.stopCommentExists(mi.getPadding().getTypeParameters().getBefore().getComments())) {
                    return mi.getSelect();
                }
                return mi;
            }

            @Override
            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, Integer integer) {
                List<J.VariableDeclarations.NamedVariable> variables = multiVariable.getVariables();
                for (J.VariableDeclarations.NamedVariable variable : variables) {
                    J.VariableDeclarations.NamedVariable.Padding padding = variable.getPadding();
                    if (padding.getInitializer() == null || !TemplatedTreeTrimmerVisitor.stopCommentExists(padding.getInitializer().getBefore().getComments())) continue;
                    List<J.VariableDeclarations.NamedVariable> vars = variables.subList(0, variables.indexOf(variable) + 1);
                    return multiVariable.withVariables(ListUtils.mapLast(vars, v -> v.withInitializer(null)));
                }
                return super.visitVariableDeclarations(multiVariable, integer);
            }
        }

        private static final class RemoveTreeMarker
        implements Marker {
            private final UUID id;

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RemoveTreeMarker)) {
                    return false;
                }
                RemoveTreeMarker other = (RemoveTreeMarker)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "BlockStatementTemplateGenerator.TemplatedTreeTrimmer.RemoveTreeMarker(id=" + this.getId() + ")";
            }

            @Generated
            public RemoveTreeMarker(UUID id) {
                this.id = id;
            }

            @NonNull
            @Generated
            public RemoveTreeMarker withId(UUID id) {
                return this.id == id ? this : new RemoveTreeMarker(id);
            }
        }
    }
}

