/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public final class AddOrUpdateAnnotationAttribute
extends Recipe {
    @Option(displayName="Annotation type", description="The fully qualified name of the annotation.", example="org.junit.Test")
    private final String annotationType;
    @Option(displayName="Attribute name", description="The name of attribute to change. If omitted defaults to 'value'.", required=false, example="timeout")
    private final @Nullable String attributeName;
    @Option(displayName="Attribute value", description="The value to set the attribute to. Set to `null` to remove the attribute.", example="500")
    private final @Nullable String attributeValue;
    @Option(displayName="Add only", description="When set to `true` will not change existing annotation attribute values.")
    private final @Nullable Boolean addOnly;
    @Option(displayName="Append array", description="If the attribute is an array, setting this option to `true` will append the value(s). In conjunction with `addOnly`, it is possible to control duplicates: `addOnly=true`, always append. `addOnly=false`, only append if the value is not already present.")
    private final @Nullable Boolean appendArray;

    public String getDisplayName() {
        return "Add or update annotation attribute";
    }

    public String getDescription() {
        return "Some annotations accept arguments. This recipe sets an existing argument to the specified value, or adds the argument if it is not already set.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesType(this.annotationType, false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation a, ExecutionContext ctx) {
                J original = super.visitAnnotation(a, ctx);
                if (!TypeUtils.isOfClassType(a.getType(), AddOrUpdateAnnotationAttribute.this.annotationType)) {
                    return a;
                }
                String newAttributeValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, AddOrUpdateAnnotationAttribute.this.attributeValue, a);
                List<Expression> currentArgs = a.getArguments();
                if (currentArgs == null || currentArgs.isEmpty() || currentArgs.get(0) instanceof J.Empty) {
                    if (newAttributeValue == null) {
                        return a;
                    }
                    if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                        return (J.Annotation)JavaTemplate.builder("#{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), newAttributeValue);
                    }
                    String newAttributeValueResult = newAttributeValue;
                    if (((JavaType.FullyQualified)Objects.requireNonNull(a.getAnnotationType().getType())).getMethods().stream().anyMatch(method -> method.getReturnType().toString().equals("java.lang.String[]"))) {
                        String[] stringArray;
                        String attributeValueCleanedUp = AddOrUpdateAnnotationAttribute.this.attributeValue.replaceAll("\\s+", "").replaceAll("[\\s+{}\"]", "");
                        if (attributeValueCleanedUp.contains(",")) {
                            stringArray = attributeValueCleanedUp.split(",");
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = attributeValueCleanedUp;
                        }
                        List<String> attributeList = Arrays.asList(stringArray);
                        newAttributeValueResult = attributeList.stream().map(String::valueOf).collect(Collectors.joining("\", \"", "{\"", "\"}"));
                    }
                    return (J.Annotation)JavaTemplate.builder("#{} = #{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), AddOrUpdateAnnotationAttribute.this.attributeName, newAttributeValueResult);
                }
                AtomicBoolean foundOrSetAttributeWithDesiredValue = new AtomicBoolean(false);
                J.Annotation finalA = a;
                List newArgs = ListUtils.map(currentArgs, it -> {
                    if (it instanceof J.Assignment) {
                        J.Assignment as = (J.Assignment)it;
                        J.Identifier var = (J.Identifier)as.getVariable();
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || !AddOrUpdateAnnotationAttribute.this.attributeName.equals(var.getSimpleName())) {
                            return it;
                        }
                        foundOrSetAttributeWithDesiredValue.set(true);
                        if (newAttributeValue == null) {
                            return null;
                        }
                        if (as.getAssignment() instanceof J.NewArray) {
                            String newAttributeListValue;
                            String[] stringArray;
                            List<Expression> jLiteralList = ((J.NewArray)as.getAssignment()).getInitializer();
                            String attributeValueCleanedUp = AddOrUpdateAnnotationAttribute.this.attributeValue.replaceAll("\\s+", "").replaceAll("[\\s+{}\"]", "");
                            if (attributeValueCleanedUp.contains(",")) {
                                stringArray = attributeValueCleanedUp.split(",");
                            } else {
                                String[] stringArray2 = new String[1];
                                stringArray = stringArray2;
                                stringArray2[0] = attributeValueCleanedUp;
                            }
                            List<String> attributeList = Arrays.asList(stringArray);
                            if (as.getMarkers().findFirst(AlreadyAppended.class).filter(ap -> ap.getValues().equals(newAttributeValue)).isPresent()) {
                                return as;
                            }
                            if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.appendArray)) {
                                boolean changed = false;
                                for (String attrListValues : attributeList) {
                                    String newAttributeListValue2 = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, attrListValues, finalA);
                                    if (Boolean.FALSE.equals(AddOrUpdateAnnotationAttribute.this.addOnly) && AddOrUpdateAnnotationAttribute.attributeValIsAlreadyPresent(jLiteralList, newAttributeListValue2)) continue;
                                    changed = true;
                                    jLiteralList.add(new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, newAttributeListValue2, newAttributeListValue2, null, JavaType.Primitive.String));
                                }
                                return changed ? as.withAssignment(((J.NewArray)as.getAssignment()).withInitializer(jLiteralList)).withMarkers(as.getMarkers().add((Marker)new AlreadyAppended(Tree.randomId(), newAttributeValue))) : as;
                            }
                            int m = 0;
                            for (int i = 0; i < Objects.requireNonNull(jLiteralList).size(); ++i) {
                                if (i >= attributeList.size()) {
                                    jLiteralList.remove(i);
                                    --i;
                                    continue;
                                }
                                newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, attributeList.get(i), finalA);
                                if (jLiteralList.size() == i + 1) {
                                    m = i + 1;
                                }
                                if (newAttributeListValue != null && newAttributeListValue.equals(((J.Literal)jLiteralList.get(i)).getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) continue;
                                jLiteralList.set(i, ((J.Literal)jLiteralList.get(i)).withValue(newAttributeListValue).withValueSource(newAttributeListValue).withPrefix(jLiteralList.get(i).getPrefix()));
                            }
                            if (jLiteralList.size() < attributeList.size() || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                if (Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                    m = 0;
                                }
                                for (int j = m; j < attributeList.size(); ++j) {
                                    newAttributeListValue = AddOrUpdateAnnotationAttribute.maybeQuoteStringArgument(AddOrUpdateAnnotationAttribute.this.attributeName, attributeList.get(j), finalA);
                                    jLiteralList.add(j, new J.Literal(Tree.randomId(), jLiteralList.get(j - 1).getPrefix(), Markers.EMPTY, newAttributeListValue, newAttributeListValue, null, JavaType.Primitive.String));
                                }
                            }
                            return as.withAssignment(((J.NewArray)as.getAssignment()).withInitializer(jLiteralList));
                        }
                        J.Literal value = (J.Literal)as.getAssignment();
                        if (newAttributeValue.equals(value.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                            return it;
                        }
                        return as.withAssignment(value.withValue(newAttributeValue).withValueSource(newAttributeValue));
                    }
                    if (it instanceof J.Literal) {
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                            foundOrSetAttributeWithDesiredValue.set(true);
                            if (newAttributeValue == null) {
                                return null;
                            }
                            J.Literal value = (J.Literal)it;
                            if (newAttributeValue.equals(value.getValueSource()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                return it;
                            }
                            return ((J.Literal)it).withValue(newAttributeValue).withValueSource(newAttributeValue);
                        }
                        return ((J.Annotation)JavaTemplate.builder("value = #{}").contextSensitive().build().apply(this.getCursor(), finalA.getCoordinates().replaceArguments(), it)).getArguments().get(0);
                    }
                    if (it instanceof J.FieldAccess) {
                        if (AddOrUpdateAnnotationAttribute.this.attributeName == null || "value".equals(AddOrUpdateAnnotationAttribute.this.attributeName)) {
                            foundOrSetAttributeWithDesiredValue.set(true);
                            if (newAttributeValue == null) {
                                return null;
                            }
                            J.FieldAccess value = (J.FieldAccess)it;
                            if (newAttributeValue.equals(value.toString()) || Boolean.TRUE.equals(AddOrUpdateAnnotationAttribute.this.addOnly)) {
                                return it;
                            }
                            return ((J.Annotation)JavaTemplate.apply(newAttributeValue, this.getCursor(), finalA.getCoordinates().replaceArguments(), new Object[0])).getArguments().get(0);
                        }
                        return ((J.Annotation)JavaTemplate.builder("value = #{any()}").contextSensitive().build().apply(this.getCursor(), finalA.getCoordinates().replaceArguments(), it)).getArguments().get(0);
                    }
                    return it;
                });
                if (newArgs != currentArgs) {
                    a = a.withArguments(newArgs);
                }
                if (foundOrSetAttributeWithDesiredValue.get()) {
                    a = this.maybeAutoFormat(original, a, ctx);
                    return a;
                }
                String effectiveName = AddOrUpdateAnnotationAttribute.this.attributeName == null ? "value" : AddOrUpdateAnnotationAttribute.this.attributeName;
                J.Assignment as = (J.Assignment)((J.Annotation)JavaTemplate.builder("#{} = #{}").contextSensitive().build().apply(this.getCursor(), a.getCoordinates().replaceArguments(), effectiveName, newAttributeValue)).getArguments().get(0);
                a = a.withArguments(ListUtils.concat((Object)as, a.getArguments()));
                a = this.maybeAutoFormat(original, a, ctx);
                return a;
            }
        });
    }

    private static @Nullable String maybeQuoteStringArgument(@Nullable String attributeName, @Nullable String attributeValue, J.Annotation annotation) {
        if (attributeValue != null && AddOrUpdateAnnotationAttribute.attributeIsString(attributeName, annotation)) {
            return "\"" + attributeValue + "\"";
        }
        return attributeValue;
    }

    private static boolean attributeIsString(@Nullable String attributeName, J.Annotation annotation) {
        String actualAttributeName = attributeName == null ? "value" : attributeName;
        JavaType.Class annotationType = (JavaType.Class)annotation.getType();
        if (annotationType != null) {
            for (JavaType.Method m : annotationType.getMethods()) {
                if (!m.getName().equals(actualAttributeName)) continue;
                return TypeUtils.isOfClassType(m.getReturnType(), "java.lang.String");
            }
        }
        return false;
    }

    private static boolean attributeValIsAlreadyPresent(List<Expression> expression, @Nullable String attributeValue) {
        for (Expression e : expression) {
            J.Literal literal;
            if (!(e instanceof J.Literal) || (literal = (J.Literal)e).getValueSource() == null || !literal.getValueSource().equals(attributeValue)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public AddOrUpdateAnnotationAttribute(String annotationType, @Nullable String attributeName, @Nullable String attributeValue, @Nullable Boolean addOnly, @Nullable Boolean appendArray) {
        this.annotationType = annotationType;
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.addOnly = addOnly;
        this.appendArray = appendArray;
    }

    @Generated
    public String getAnnotationType() {
        return this.annotationType;
    }

    @Generated
    public @Nullable String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public @Nullable String getAttributeValue() {
        return this.attributeValue;
    }

    @Generated
    public @Nullable Boolean getAddOnly() {
        return this.addOnly;
    }

    @Generated
    public @Nullable Boolean getAppendArray() {
        return this.appendArray;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddOrUpdateAnnotationAttribute(annotationType=" + this.getAnnotationType() + ", attributeName=" + this.getAttributeName() + ", attributeValue=" + this.getAttributeValue() + ", addOnly=" + this.getAddOnly() + ", appendArray=" + this.getAppendArray() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrUpdateAnnotationAttribute)) {
            return false;
        }
        AddOrUpdateAnnotationAttribute other = (AddOrUpdateAnnotationAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addOnly = this.getAddOnly();
        Boolean other$addOnly = other.getAddOnly();
        if (this$addOnly == null ? other$addOnly != null : !((Object)this$addOnly).equals(other$addOnly)) {
            return false;
        }
        Boolean this$appendArray = this.getAppendArray();
        Boolean other$appendArray = other.getAppendArray();
        if (this$appendArray == null ? other$appendArray != null : !((Object)this$appendArray).equals(other$appendArray)) {
            return false;
        }
        String this$annotationType = this.getAnnotationType();
        String other$annotationType = other.getAnnotationType();
        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$attributeValue = this.getAttributeValue();
        String other$attributeValue = other.getAttributeValue();
        return !(this$attributeValue == null ? other$attributeValue != null : !this$attributeValue.equals(other$attributeValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddOrUpdateAnnotationAttribute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addOnly = this.getAddOnly();
        result = result * 59 + ($addOnly == null ? 43 : ((Object)$addOnly).hashCode());
        Boolean $appendArray = this.getAppendArray();
        result = result * 59 + ($appendArray == null ? 43 : ((Object)$appendArray).hashCode());
        String $annotationType = this.getAnnotationType();
        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $attributeValue = this.getAttributeValue();
        result = result * 59 + ($attributeValue == null ? 43 : $attributeValue.hashCode());
        return result;
    }

    private static final class AlreadyAppended
    implements Marker {
        private final UUID id;
        private final String values;

        @Generated
        public AlreadyAppended(UUID id, String values) {
            this.id = id;
            this.values = values;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getValues() {
            return this.values;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlreadyAppended)) {
                return false;
            }
            AlreadyAppended other = (AlreadyAppended)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$values = this.getValues();
            String other$values = other.getValues();
            return !(this$values == null ? other$values != null : !this$values.equals(other$values));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : $values.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddOrUpdateAnnotationAttribute.AlreadyAppended(id=" + this.getId() + ", values=" + this.getValues() + ")";
        }

        @NonNull
        @Generated
        public AlreadyAppended withId(UUID id) {
            return this.id == id ? this : new AlreadyAppended(id, this.values);
        }

        @NonNull
        @Generated
        public AlreadyAppended withValues(String values) {
            return this.values == values ? this : new AlreadyAppended(this.id, values);
        }
    }
}

