/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.util.Collections;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.format.AutoFormatVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;

public class SimplifyBooleanExpressionVisitor
extends JavaVisitor<ExecutionContext> {
    private static final String MAYBE_AUTO_FORMAT_ME = "MAYBE_AUTO_FORMAT_ME";
    private final MethodMatcher isEmpty = new MethodMatcher("java.lang.String isEmpty()");

    public J visit(@Nullable Tree tree, ExecutionContext ctx) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull((J)super.visit(tree, (Object)ctx));
            if (tree != cu) {
                cu = (JavaSourceFile)this.visitNonNull(cu, ctx);
            }
            return cu;
        }
        return (J)super.visit(tree, (Object)ctx);
    }

    @Override
    public J visitBinary(J.Binary binary, ExecutionContext ctx) {
        J j = super.visitBinary(binary, ctx);
        J.Binary asBinary = (J.Binary)j;
        if (asBinary.getOperator() == J.Binary.Type.And) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralTrue(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (this.removeAllSpace(asBinary.getLeft()).printTrimmed(this.getCursor()).equals(this.removeAllSpace(asBinary.getRight()).printTrimmed(this.getCursor()))) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Or) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
            } else if (this.isLiteralFalse(asBinary.getLeft())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getRight();
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(""));
            } else if (this.removeAllSpace(asBinary.getLeft()).printTrimmed(this.getCursor()).equals(this.removeAllSpace(asBinary.getRight()).printTrimmed(this.getCursor()))) {
                this.maybeUnwrapParentheses();
                j = asBinary.getLeft();
            }
        } else if (asBinary.getOperator() == J.Binary.Type.Equal) {
            if (this.isLiteralTrue(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    this.maybeUnwrapParentheses();
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralTrue(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    this.maybeUnwrapParentheses();
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else {
                j = this.maybeReplaceCompareWithNull(asBinary, true);
            }
        } else if (asBinary.getOperator() == J.Binary.Type.NotEqual) {
            if (this.isLiteralFalse(asBinary.getLeft())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getRight())) {
                    this.maybeUnwrapParentheses();
                    j = asBinary.getRight().withPrefix(asBinary.getRight().getPrefix().withWhitespace(""));
                }
            } else if (this.isLiteralFalse(asBinary.getRight())) {
                if (this.shouldSimplifyEqualsOn(asBinary.getLeft())) {
                    this.maybeUnwrapParentheses();
                    j = asBinary.getLeft().withPrefix(asBinary.getLeft().getPrefix().withWhitespace(" "));
                }
            } else {
                j = this.maybeReplaceCompareWithNull(asBinary, false);
            }
        }
        if (asBinary != j) {
            this.getCursor().getParentTreeCursor().putMessage(MAYBE_AUTO_FORMAT_ME, (Object)"");
        }
        return j;
    }

    public J postVisit(J tree, ExecutionContext ctx) {
        J j = (J)super.postVisit((Tree)tree, (Object)ctx);
        if (this.getCursor().pollMessage(MAYBE_AUTO_FORMAT_ME) != null) {
            j = new AutoFormatVisitor().visit((Tree)j, ctx, this.getCursor().getParentOrThrow());
        }
        return j;
    }

    @Override
    public J visitUnary(J.Unary unary, ExecutionContext ctx) {
        J j = super.visitUnary(unary, ctx);
        J.Unary asUnary = (J.Unary)j;
        if (asUnary.getOperator() == J.Unary.Type.Not) {
            if (this.isLiteralTrue(asUnary.getExpression())) {
                this.maybeUnwrapParentheses();
                j = ((J.Literal)asUnary.getExpression()).withValue(false).withValueSource("false");
            } else if (this.isLiteralFalse(asUnary.getExpression())) {
                this.maybeUnwrapParentheses();
                j = ((J.Literal)asUnary.getExpression()).withValue(true).withValueSource("true");
            } else if (asUnary.getExpression() instanceof J.Unary && ((J.Unary)asUnary.getExpression()).getOperator() == J.Unary.Type.Not) {
                this.maybeUnwrapParentheses();
                j = ((J.Unary)asUnary.getExpression()).getExpression();
            }
        }
        if (asUnary != j) {
            this.getCursor().getParentTreeCursor().putMessage(MAYBE_AUTO_FORMAT_ME, (Object)"");
        }
        return j;
    }

    @Override
    public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
        J j = super.visitMethodInvocation(method, executionContext);
        J.MethodInvocation asMethod = (J.MethodInvocation)j;
        Expression select = asMethod.getSelect();
        if (this.isEmpty.matches(asMethod) && select instanceof J.Literal && select.getType() == JavaType.Primitive.String) {
            this.maybeUnwrapParentheses();
            return this.booleanLiteral(method, J.Literal.isLiteralValue(select, ""));
        }
        return j;
    }

    private void maybeUnwrapParentheses() {
        Cursor c = this.getCursor().getParentOrThrow().getParentTreeCursor();
        if (c.getValue() instanceof J.Parentheses) {
            this.doAfterVisit(new UnwrapParentheses((J.Parentheses)c.getValue()));
        }
    }

    private boolean isLiteralTrue(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(true);
    }

    private boolean isLiteralFalse(@Nullable Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getValue() == Boolean.valueOf(false);
    }

    private boolean isNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.Null;
    }

    private boolean isNonNullLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() != JavaType.Primitive.Null;
    }

    private J maybeReplaceCompareWithNull(J.Binary asBinary, boolean valueIfEqual) {
        Expression left = asBinary.getLeft();
        Expression right = asBinary.getRight();
        boolean leftIsNull = this.isNullLiteral(left);
        boolean rightIsNull = this.isNullLiteral(right);
        if (leftIsNull && rightIsNull) {
            this.maybeUnwrapParentheses();
            return this.booleanLiteral(asBinary, valueIfEqual);
        }
        boolean leftIsNonNullLiteral = this.isNonNullLiteral(left);
        boolean rightIsNonNullLiteral = this.isNonNullLiteral(right);
        if (leftIsNull && rightIsNonNullLiteral || rightIsNull && leftIsNonNullLiteral) {
            this.maybeUnwrapParentheses();
            return this.booleanLiteral(asBinary, !valueIfEqual);
        }
        return asBinary;
    }

    private J.Literal booleanLiteral(J j, boolean value) {
        return new J.Literal(Tree.randomId(), j.getPrefix(), j.getMarkers(), value, String.valueOf(value), Collections.emptyList(), JavaType.Primitive.Boolean);
    }

    private J removeAllSpace(J j) {
        return (J)new JavaIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                return Space.EMPTY;
            }
        }.visit(j, 0);
    }

    protected boolean shouldSimplifyEqualsOn(J j) {
        return true;
    }
}

