/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class UpdateMovedRecipeXml
extends Recipe {
    @Option(displayName="The fully qualified className of recipe moved from", description="The fully qualified className of recipe moved from a old package.", example="org.openrewrite.java.cleanup.UnnecessaryCatch")
    private final String oldRecipeFullyQualifiedClassName;
    @Option(displayName="The fully qualified className of recipe moved to", description="The fully qualified className of recipe moved to a new package.", example="org.openrewrite.staticanalysis.UnnecessaryCatch")
    private final String newRecipeFullyQualifiedClassName;

    public String getDisplayName() {
        return "Update moved package recipe in pom.xml";
    }

    public String getDescription() {
        return "Update moved package recipe in pom.xml.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                return super.visitDocument(document, (Object)ctx);
            }

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                tag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                XPathMatcher matcher = new XPathMatcher("/project/build/plugins/plugin/configuration/activeRecipes/recipe");
                if (matcher.matches(this.getCursor()) && tag.getValue().map(s -> s.equals(UpdateMovedRecipeXml.this.oldRecipeFullyQualifiedClassName)).orElse(false).booleanValue()) {
                    return tag.withValue(UpdateMovedRecipeXml.this.newRecipeFullyQualifiedClassName);
                }
                return tag;
            }
        };
    }

    public UpdateMovedRecipeXml(String oldRecipeFullyQualifiedClassName, String newRecipeFullyQualifiedClassName) {
        this.oldRecipeFullyQualifiedClassName = oldRecipeFullyQualifiedClassName;
        this.newRecipeFullyQualifiedClassName = newRecipeFullyQualifiedClassName;
    }

    public String getOldRecipeFullyQualifiedClassName() {
        return this.oldRecipeFullyQualifiedClassName;
    }

    public String getNewRecipeFullyQualifiedClassName() {
        return this.newRecipeFullyQualifiedClassName;
    }

    @NonNull
    public String toString() {
        return "UpdateMovedRecipeXml(oldRecipeFullyQualifiedClassName=" + this.getOldRecipeFullyQualifiedClassName() + ", newRecipeFullyQualifiedClassName=" + this.getNewRecipeFullyQualifiedClassName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMovedRecipeXml)) {
            return false;
        }
        UpdateMovedRecipeXml other = (UpdateMovedRecipeXml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        String other$oldRecipeFullyQualifiedClassName = other.getOldRecipeFullyQualifiedClassName();
        if (this$oldRecipeFullyQualifiedClassName == null ? other$oldRecipeFullyQualifiedClassName != null : !this$oldRecipeFullyQualifiedClassName.equals(other$oldRecipeFullyQualifiedClassName)) {
            return false;
        }
        String this$newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        String other$newRecipeFullyQualifiedClassName = other.getNewRecipeFullyQualifiedClassName();
        return !(this$newRecipeFullyQualifiedClassName == null ? other$newRecipeFullyQualifiedClassName != null : !this$newRecipeFullyQualifiedClassName.equals(other$newRecipeFullyQualifiedClassName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMovedRecipeXml;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldRecipeFullyQualifiedClassName = this.getOldRecipeFullyQualifiedClassName();
        result = result * 59 + ($oldRecipeFullyQualifiedClassName == null ? 43 : $oldRecipeFullyQualifiedClassName.hashCode());
        String $newRecipeFullyQualifiedClassName = this.getNewRecipeFullyQualifiedClassName();
        result = result * 59 + ($newRecipeFullyQualifiedClassName == null ? 43 : $newRecipeFullyQualifiedClassName.hashCode());
        return result;
    }
}

