/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.imports;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.openrewrite.tools.checkstyle.checks.imports.AbstractImportControl;
import org.openrewrite.tools.checkstyle.checks.imports.MismatchStrategy;

class PkgImportControl
extends AbstractImportControl {
    private static final String DOT = ".";
    private static final String DOT_REGEX = "\\.";
    private static final Pattern DOT_REGEX_PATTERN = Pattern.compile("\\.");
    private static final String DOT_ESCAPED_REGEX = "\\\\.";
    private final List<AbstractImportControl> children = new ArrayList<AbstractImportControl>();
    private final String fullPackageName;
    private final Pattern patternForPartialMatch;
    private final Pattern patternForExactMatch;
    private final boolean regex;

    PkgImportControl(String packageName, boolean regex, MismatchStrategy strategyOnMismatch) {
        super(null, strategyOnMismatch);
        this.regex = regex;
        if (regex) {
            this.fullPackageName = PkgImportControl.encloseInGroup(packageName);
            this.patternForPartialMatch = PkgImportControl.createPatternForPartialMatch(this.fullPackageName);
            this.patternForExactMatch = PkgImportControl.createPatternForExactMatch(this.fullPackageName);
        } else {
            this.fullPackageName = packageName;
            this.patternForPartialMatch = null;
            this.patternForExactMatch = null;
        }
    }

    PkgImportControl(PkgImportControl parent, String subPackageName, boolean regex, MismatchStrategy strategyOnMismatch) {
        super(parent, strategyOnMismatch);
        if (regex || parent.regex) {
            String parentRegex = PkgImportControl.ensureSelfContainedRegex(parent.fullPackageName, parent.regex);
            String thisRegex = PkgImportControl.ensureSelfContainedRegex(subPackageName, regex);
            this.fullPackageName = parentRegex + DOT_REGEX + thisRegex;
            this.patternForPartialMatch = PkgImportControl.createPatternForPartialMatch(this.fullPackageName);
            this.patternForExactMatch = PkgImportControl.createPatternForExactMatch(this.fullPackageName);
            this.regex = true;
        } else {
            this.fullPackageName = parent.fullPackageName + DOT + subPackageName;
            this.patternForPartialMatch = null;
            this.patternForExactMatch = null;
            this.regex = false;
        }
    }

    private static String ensureSelfContainedRegex(String input, boolean alreadyRegex) {
        String result = alreadyRegex ? PkgImportControl.encloseInGroup(input) : PkgImportControl.toRegex(input);
        return result;
    }

    private static String encloseInGroup(String expression) {
        return "(?:" + expression + ")";
    }

    private static String toRegex(String input) {
        return DOT_REGEX_PATTERN.matcher(input).replaceAll(DOT_ESCAPED_REGEX);
    }

    private static Pattern createPatternForPartialMatch(String expression) {
        return Pattern.compile(expression + "(?:\\..*)?");
    }

    private static Pattern createPatternForExactMatch(String expression) {
        return Pattern.compile(expression);
    }

    @Override
    public AbstractImportControl locateFinest(String forPkg, String forFileName) {
        AbstractImportControl finestMatch = null;
        if (this.matchesAtFront(forPkg)) {
            finestMatch = this;
            for (AbstractImportControl child : this.children) {
                AbstractImportControl match = child.locateFinest(forPkg, forFileName);
                if (match == null) continue;
                finestMatch = match;
                break;
            }
        }
        return finestMatch;
    }

    public void addChild(AbstractImportControl importControl) {
        this.children.add(importControl);
    }

    private boolean matchesAtFront(String pkg) {
        boolean result = this.regex ? this.patternForPartialMatch.matcher(pkg).matches() : this.matchesAtFrontNoRegex(pkg);
        return result;
    }

    private boolean matchesAtFrontNoRegex(String pkg) {
        return pkg.startsWith(this.fullPackageName) && (pkg.length() == this.fullPackageName.length() || pkg.charAt(this.fullPackageName.length()) == '.');
    }

    @Override
    protected boolean matchesExactly(String pkg, String fileName) {
        boolean result = this.regex ? this.patternForExactMatch.matcher(pkg).matches() : this.fullPackageName.equals(pkg);
        return result;
    }
}

