/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Javadoc;

@Incubating(since="7.33.0")
public class RenameJavaDocParamNameVisitor<P>
extends JavaIsoVisitor<P> {
    private final MethodMatcher methodMatcher;
    private final String oldName;
    private final String newName;

    public RenameJavaDocParamNameVisitor(J.MethodDeclaration targetScope, String oldName, String newName) {
        String methodPattern = MethodMatcher.methodPattern(targetScope);
        this.methodMatcher = new MethodMatcher(methodPattern);
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J md = super.visitMethodDeclaration(method, (Object)p);
        if (this.methodMatcher.matches(((J.MethodDeclaration)md).getMethodType()) && md.getComments().stream().anyMatch(it -> it instanceof Javadoc.DocComment)) {
            md = (J.MethodDeclaration)md.withComments(ListUtils.map(md.getComments(), it -> {
                if (it instanceof Javadoc.DocComment) {
                    Javadoc.DocComment docComment = (Javadoc.DocComment)it;
                    return (Comment)((Object)new RenameParamVisitor<Object>(this.oldName, this.newName).visitDocComment(docComment, p));
                }
                return it;
            }));
        }
        return md;
    }

    private static class RenameParamVisitor<P>
    extends JavadocVisitor<P> {
        private final String oldName;
        private final String newName;

        public RenameParamVisitor(String oldName, String newName) {
            super(new JavaVisitor());
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public Javadoc visitParameter(Javadoc.Parameter parameter, P p) {
            Javadoc.Parameter pp = (Javadoc.Parameter)super.visitParameter(parameter, p);
            if (pp.getNameReference() != null && pp.getNameReference().getTree() instanceof J.Identifier && this.oldName.equals(((J.Identifier)pp.getNameReference().getTree()).getSimpleName())) {
                J.Identifier id = ((J.Identifier)pp.getNameReference().getTree()).withSimpleName(this.newName);
                pp = pp.withNameReference(pp.getNameReference().withTree(id));
            }
            return pp;
        }
    }
}

