/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ReplaceConstant
extends Recipe {
    @Option(displayName="Owning type of the constant", description="The target type in which the constant to be replaced is defined.", example="com.google.common.base.Charsets")
    private final String owningType;
    @Option(displayName="Constant name", description="The name of the constant field to replace.", example="UTF_8")
    private final String constantName;
    @Option(displayName="Literal value", description="The literal value to replace.", example="UTF_8")
    private final String literalValue;

    public String getDisplayName() {
        return "Replace constant with literal value";
    }

    public String getDescription() {
        return "Replace a named constant with a literal value when you wish to remove the old constant. A `String` literal must include escaped quotes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            @Nullable J.Literal literal;

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (this.isConstant(fieldAccess.getName().getFieldType())) {
                    this.maybeRemoveImport(ReplaceConstant.this.owningType);
                    return this.buildLiteral().withPrefix(fieldAccess.getPrefix());
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }

            @Override
            public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
                if (this.isConstant(ident.getFieldType()) && !this.isVariableDeclaration()) {
                    this.maybeRemoveImport(ReplaceConstant.this.owningType);
                    return this.buildLiteral().withPrefix(ident.getPrefix());
                }
                return super.visitIdentifier(ident, ctx);
            }

            private boolean isConstant( @Nullable JavaType.Variable varType) {
                return varType != null && TypeUtils.isOfClassType(varType.getOwner(), ReplaceConstant.this.owningType) && varType.getName().equals(ReplaceConstant.this.constantName);
            }

            private boolean isVariableDeclaration() {
                Cursor maybeVariable = this.getCursor().dropParentUntil(is -> is instanceof J.VariableDeclarations || is instanceof J.CompilationUnit);
                if (!(maybeVariable.getValue() instanceof J.VariableDeclarations)) {
                    return false;
                }
                JavaType.Variable variableType = ((J.VariableDeclarations)maybeVariable.getValue()).getVariables().get(0).getVariableType();
                if (variableType == null) {
                    return true;
                }
                JavaType.FullyQualified ownerFqn = TypeUtils.asFullyQualified(variableType.getOwner());
                if (ownerFqn == null) {
                    return true;
                }
                return ReplaceConstant.this.constantName.equals(((J.VariableDeclarations)maybeVariable.getValue()).getVariables().get(0).getSimpleName()) && ReplaceConstant.this.owningType.equals(ownerFqn.getFullyQualifiedName());
            }

            private J.Literal buildLiteral() {
                if (this.literal == null) {
                    Parser parser = JavaParser.fromJavaVersion().build();
                    J.CompilationUnit result = parser.parse("class $ { Object o = " + ReplaceConstant.this.literalValue + "; }").findFirst().map(J.CompilationUnit.class::cast).orElseThrow(() -> new IllegalStateException("Expected to have one parsed compilation unit."));
                    Expression j = ((J.VariableDeclarations)result.getClasses().get(0).getBody().getStatements().get(0)).getVariables().get(0).getInitializer();
                    if (!(j instanceof J.Literal)) {
                        throw new IllegalArgumentException("Unknown literal type for literal value: " + ReplaceConstant.this.literalValue);
                    }
                    J.Literal parsedLiteral = (J.Literal)j;
                    this.literal = parsedLiteral.withId(Tree.randomId());
                }
                return this.literal;
            }
        };
    }

    @Generated
    public ReplaceConstant(String owningType, String constantName, String literalValue) {
        this.owningType = owningType;
        this.constantName = constantName;
        this.literalValue = literalValue;
    }

    @Generated
    public String getOwningType() {
        return this.owningType;
    }

    @Generated
    public String getConstantName() {
        return this.constantName;
    }

    @Generated
    public String getLiteralValue() {
        return this.literalValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceConstant(owningType=" + this.getOwningType() + ", constantName=" + this.getConstantName() + ", literalValue=" + this.getLiteralValue() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceConstant)) {
            return false;
        }
        ReplaceConstant other = (ReplaceConstant)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$owningType = this.getOwningType();
        String other$owningType = other.getOwningType();
        if (this$owningType == null ? other$owningType != null : !this$owningType.equals(other$owningType)) {
            return false;
        }
        String this$constantName = this.getConstantName();
        String other$constantName = other.getConstantName();
        if (this$constantName == null ? other$constantName != null : !this$constantName.equals(other$constantName)) {
            return false;
        }
        String this$literalValue = this.getLiteralValue();
        String other$literalValue = other.getLiteralValue();
        return !(this$literalValue == null ? other$literalValue != null : !this$literalValue.equals(other$literalValue));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ReplaceConstant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owningType = this.getOwningType();
        result = result * 59 + ($owningType == null ? 43 : $owningType.hashCode());
        String $constantName = this.getConstantName();
        result = result * 59 + ($constantName == null ? 43 : $constantName.hashCode());
        String $literalValue = this.getLiteralValue();
        result = result * 59 + ($literalValue == null ? 43 : $literalValue.hashCode());
        return result;
    }
}

