/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;

public final class FindImports
extends Recipe {
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching field uses.", example="org.springframework..*", required=false)
    private final @Nullable String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    private final @Nullable Boolean matchInherited;

    public String getDisplayName() {
        return "Find source files with imports";
    }

    public String getInstanceNameSuffix() {
        if (this.typePattern != null) {
            return "matching `" + this.typePattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    public String getDescription() {
        return "Locates source files that have imports matching the given type pattern, regardless of whether that import is used in the code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = new TypeMatcher(this.typePattern, Boolean.TRUE.equals(this.matchInherited));
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Import visitImport(J.Import anImport, ExecutionContext ctx) {
                if (typeMatcher.matchesPackage(anImport.getTypeName())) {
                    return (J.Import)SearchResult.found((Tree)anImport);
                }
                return super.visitImport(anImport, ctx);
            }
        };
    }

    @Generated
    public FindImports(@Nullable String typePattern, @Nullable Boolean matchInherited) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
    }

    @Generated
    public @Nullable String getTypePattern() {
        return this.typePattern;
    }

    @Generated
    public @Nullable Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindImports(typePattern=" + this.getTypePattern() + ", matchInherited=" + this.getMatchInherited() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImports)) {
            return false;
        }
        FindImports other = (FindImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        return !(this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindImports;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        return result;
    }
}

