/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.NoMissingTypes;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public final class RemoveUnusedImports
extends Recipe {
    public String getDisplayName() {
        return "Remove unused imports";
    }

    public String getDescription() {
        return "Remove imports for types that are not referenced. As a precaution against incorrect changes no imports will be removed from any source where unknown types are referenced. The most common cause of unknown types is the use of annotation processors not supported by OpenRewrite, such as lombok.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S1128");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new NoMissingTypes(), (TreeVisitor)new RemoveUnusedImportsVisitor());
    }

    @Generated
    public RemoveUnusedImports() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveUnusedImports()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveUnusedImports)) {
            return false;
        }
        RemoveUnusedImports other = (RemoveUnusedImports)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveUnusedImports;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RemoveUnusedImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final Set<String> JAVA_LANG_CLASS_NAMES = new HashSet<String>(Arrays.asList("AbstractMethodError", "Appendable", "ArithmeticException", "ArrayIndexOutOfBoundsException", "ArrayStoreException", "AssertionError", "AutoCloseable", "Boolean", "BootstrapMethodError", "Byte", "Character", "CharSequence", "Class", "ClassCastException", "ClassCircularityError", "ClassFormatError", "ClassLoader", "ClassNotFoundException", "ClassValue", "Cloneable", "CloneNotSupportedException", "Comparable", "Deprecated", "Double", "Enum", "EnumConstantNotPresentException", "Error", "Exception", "ExceptionInInitializerError", "Float", "FunctionalInterface", "IllegalAccessError", "IllegalAccessException", "IllegalArgumentException", "IllegalCallerException", "IllegalMonitorStateException", "IllegalStateException", "IllegalThreadStateException", "IncompatibleClassChangeError", "IndexOutOfBoundsException", "InheritableThreadLocal", "InstantiationError", "InstantiationException", "Integer", "InternalError", "InterruptedException", "Iterable", "LayerInstantiationException", "LinkageError", "Long", "MatchException", "Math", "Module", "ModuleLayer", "NegativeArraySizeException", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchFieldException", "NoSuchMethodError", "NoSuchMethodException", "NullPointerException", "Number", "NumberFormatException", "Object", "OutOfMemoryError", "Override", "Package", "Process", "ProcessBuilder", "ProcessHandle", "Readable", "Record", "ReflectiveOperationException", "Runnable", "Runtime", "RuntimeException", "RuntimePermission", "SafeVarargs", "ScopedValue", "SecurityException", "SecurityManager", "Short", "StackOverflowError", "StackTraceElement", "StackWalker", "StrictMath", "String", "StringBuffer", "StringBuilder", "StringIndexOutOfBoundsException", "StringTemplate", "SuppressWarnings", "System", "Thread", "ThreadDeath", "ThreadGroup", "ThreadLocal", "Throwable", "TypeNotPresentException", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "UnsupportedOperationException", "VerifyError", "VirtualMachineError", "Void", "WrongThreadException"));

        private RemoveUnusedImportsVisitor() {
        }

        @Override
        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            Object fq;
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            String sourcePackage = ((J.CompilationUnit)cu).getPackageDeclaration() == null ? "" : ((J.CompilationUnit)cu).getPackageDeclaration().getExpression().printTrimmed(this.getCursor()).replaceAll("\\s", "");
            HashMap<String, TreeSet> methodsAndFieldsByTypeName = new HashMap<String, TreeSet>();
            HashMap<String, Set<Object>> typesByPackage = new HashMap<String, Set<Object>>();
            for (JavaType.Method method : ((J.CompilationUnit)cu).getTypesInUse().getUsedMethods()) {
                if (!method.hasFlags(Flag.Static)) continue;
                methodsAndFieldsByTypeName.computeIfAbsent(method.getDeclaringType().getFullyQualifiedName(), t -> new TreeSet()).add(method.getName());
            }
            for (JavaType.Variable variable : ((J.CompilationUnit)cu).getTypesInUse().getVariables()) {
                fq = TypeUtils.asFullyQualified(variable.getOwner());
                if (fq == null) continue;
                methodsAndFieldsByTypeName.computeIfAbsent(((JavaType.FullyQualified)fq).getFullyQualifiedName(), f -> new TreeSet()).add(variable.getName());
            }
            for (JavaType javaType : ((J.CompilationUnit)cu).getTypesInUse().getTypesInUse()) {
                if (javaType instanceof JavaType.Parameterized) {
                    JavaType.Parameterized parameterized = (JavaType.Parameterized)javaType;
                    typesByPackage.computeIfAbsent(parameterized.getType().getPackageName(), f -> new HashSet()).add(parameterized.getType());
                    for (JavaType typeParameter : parameterized.getTypeParameters()) {
                        JavaType.FullyQualified fq2 = TypeUtils.asFullyQualified(typeParameter);
                        if (fq2 == null) continue;
                        typesByPackage.computeIfAbsent(fq2.getPackageName(), f -> new HashSet()).add(fq2);
                    }
                    continue;
                }
                if (!(javaType instanceof JavaType.FullyQualified)) continue;
                fq = (JavaType.FullyQualified)javaType;
                typesByPackage.computeIfAbsent(((JavaType.FullyQualified)fq).getPackageName(), f -> new HashSet()).add(fq);
            }
            boolean changed = false;
            ArrayList<ImportUsage> importUsage = new ArrayList<ImportUsage>(((J.CompilationUnit)cu).getPadding().getImports().size());
            for (JRightPadded jRightPadded : ((J.CompilationUnit)cu).getPadding().getImports()) {
                ImportUsage singleUsage = new ImportUsage();
                singleUsage.imports.add(jRightPadded);
                importUsage.add(singleUsage);
            }
            HashSet<String> checkedImports = new HashSet<String>();
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> usedStaticWildcardImports = new HashSet<String>();
            for (ImportUsage importUsage2 : importUsage) {
                J.Import elem = importUsage2.imports.get(0).getElement();
                J.FieldAccess qualid = elem.getQualid();
                J.Identifier name = qualid.getName();
                if (checkedImports.contains(elem.toString())) {
                    importUsage2.used = false;
                    changed = true;
                } else if (elem.isStatic()) {
                    String outerType = elem.getTypeName();
                    SortedSet methodsAndFields = (SortedSet)methodsAndFieldsByTypeName.get(outerType);
                    String target = qualid.getTarget().toString();
                    String modifiedTarget = methodsAndFieldsByTypeName.keySet().stream().filter(fqn -> TypeUtils.fullyQualifiedNamesAreEqual(target, fqn)).findFirst().orElse(target);
                    SortedSet targetMethodsAndFields = (SortedSet)methodsAndFieldsByTypeName.get(modifiedTarget);
                    HashSet<JavaType.FullyQualified> staticClasses = null;
                    for (JavaType.FullyQualified maybeStatic : typesByPackage.getOrDefault(elem.getPackageName(), Collections.emptySet())) {
                        if (maybeStatic.getOwningClass() == null || !outerType.startsWith(maybeStatic.getOwningClass().getFullyQualifiedName())) continue;
                        if (staticClasses == null) {
                            staticClasses = new HashSet<JavaType.FullyQualified>();
                        }
                        staticClasses.add(maybeStatic);
                    }
                    if (methodsAndFields == null && targetMethodsAndFields == null && staticClasses == null) {
                        importUsage2.used = false;
                        changed = true;
                    } else if ("*".equals(qualid.getSimpleName())) {
                        if (ImportLayoutStyle.isPackageAlwaysFolded(layoutStyle.getPackagesToFold(), elem)) {
                            importUsage2.used = true;
                            usedStaticWildcardImports.add(elem.getTypeName());
                        } else if ((methodsAndFields == null ? 0 : methodsAndFields.size()) + (staticClasses == null ? 0 : staticClasses.size()) < layoutStyle.getNameCountToUseStarImport()) {
                            importUsage2.imports.clear();
                            if (methodsAndFields != null) {
                                for (String method : methodsAndFields) {
                                    importUsage2.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName(method))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY));
                                }
                            }
                            if (staticClasses != null) {
                                for (JavaType.FullyQualified fqn2 : staticClasses) {
                                    importUsage2.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName(fqn2.getClassName().contains(".") ? fqn2.getClassName().substring(fqn2.getClassName().lastIndexOf(".") + 1) : fqn2.getClassName()))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY));
                                }
                            }
                            importUsage2.imports.set(0, importUsage2.imports.get(0).withElement(importUsage2.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                            changed = true;
                        } else {
                            usedStaticWildcardImports.add(elem.getTypeName());
                        }
                    } else if (staticClasses != null && staticClasses.stream().anyMatch(c -> elem.getTypeName().equals(c.getFullyQualifiedName())) || methodsAndFields != null && methodsAndFields.contains(qualid.getSimpleName()) || targetMethodsAndFields != null && targetMethodsAndFields.contains(qualid.getSimpleName())) {
                        importUsage2.used = true;
                    } else {
                        importUsage2.used = false;
                        changed = true;
                    }
                } else {
                    Set types = typesByPackage.getOrDefault(elem.getPackageName(), new HashSet());
                    Set typesByFullyQualifiedClassPath = typesByPackage.getOrDefault(TypeUtils.toFullyQualifiedName(elem.getPackageName()), new HashSet());
                    Set combinedTypes = Stream.concat(types.stream(), typesByFullyQualifiedClassPath.stream()).collect(Collectors.toSet());
                    JavaType.FullyQualified qualidType = TypeUtils.asFullyQualified(elem.getQualid().getType());
                    if (combinedTypes.isEmpty() || sourcePackage.equals(elem.getPackageName()) && qualidType != null && !qualidType.getFullyQualifiedName().contains("$")) {
                        importUsage2.used = false;
                        changed = true;
                    } else if ("*".equals(elem.getQualid().getSimpleName())) {
                        if (ImportLayoutStyle.isPackageAlwaysFolded(layoutStyle.getPackagesToFold(), elem)) {
                            importUsage2.used = true;
                            hashSet.add(elem.getPackageName());
                        } else if (combinedTypes.size() < layoutStyle.getClassCountToUseStarImport()) {
                            importUsage2.imports.clear();
                            combinedTypes.stream().map(JavaType.FullyQualified::getClassName).sorted().distinct().forEach(type -> anImport.imports.add(new JRightPadded<J.Import>(elem.withQualid(qualid.withName(name.withSimpleName(type.substring(type.lastIndexOf(46) + 1)))).withPrefix(Space.format("\n")), Space.EMPTY, Markers.EMPTY)));
                            importUsage2.imports.set(0, importUsage2.imports.get(0).withElement(importUsage2.imports.get(0).getElement().withPrefix(elem.getPrefix())));
                            changed = true;
                        } else {
                            hashSet.add(elem.getQualid().getTarget().toString());
                        }
                    } else if (combinedTypes.stream().noneMatch(c -> {
                        if ("*".equals(elem.getQualid().getSimpleName())) {
                            return elem.getPackageName().equals(c.getPackageName());
                        }
                        return TypeUtils.fullyQualifiedNamesAreEqual(c.getFullyQualifiedName(), elem.getTypeName());
                    })) {
                        importUsage2.used = false;
                        changed = true;
                    }
                }
                checkedImports.add(elem.toString());
            }
            Set<String> ambiguousStaticImportNames = RemoveUnusedImportsVisitor.getAmbiguousStaticImportNames((J.CompilationUnit)cu);
            for (ImportUsage anImport : importUsage) {
                J.Import elem = anImport.imports.get(0).getElement();
                if ("*".equals(elem.getQualid().getSimpleName())) continue;
                if (elem.isStatic()) {
                    if (!usedStaticWildcardImports.contains(elem.getTypeName()) || ambiguousStaticImportNames.contains(elem.getQualid().getSimpleName())) continue;
                    anImport.used = false;
                    changed = true;
                    continue;
                }
                if (hashSet.size() != 1 || !hashSet.contains(elem.getPackageName()) || elem.getTypeName().contains("$") || RemoveUnusedImportsVisitor.conflictsWithJavaLang(elem)) continue;
                anImport.used = false;
                changed = true;
            }
            if (changed) {
                ArrayList<JRightPadded<J.Import>> arrayList = new ArrayList<JRightPadded<J.Import>>();
                Space lastUnusedImportSpace = null;
                for (ImportUsage anImportGroup : importUsage) {
                    if (anImportGroup.used) {
                        List<JRightPadded<J.Import>> importGroup = anImportGroup.imports;
                        for (int i = 0; i < importGroup.size(); ++i) {
                            JRightPadded<J.Import> anImport = importGroup.get(i);
                            if (i == 0 && lastUnusedImportSpace != null && anImport.getElement().getPrefix().getLastWhitespace().chars().filter(c -> c == 10).count() <= 1L) {
                                anImport = anImport.withElement(anImport.getElement().withPrefix(lastUnusedImportSpace));
                            }
                            arrayList.add(anImport);
                        }
                        lastUnusedImportSpace = null;
                        continue;
                    }
                    if (lastUnusedImportSpace != null) continue;
                    lastUnusedImportSpace = anImportGroup.imports.get(0).getElement().getPrefix();
                }
                if (((J.CompilationUnit)(cu = ((J.CompilationUnit)cu).getPadding().withImports(arrayList))).getImports().isEmpty() && !((J.CompilationUnit)cu).getClasses().isEmpty()) {
                    cu = (J.CompilationUnit)this.autoFormat(cu, ((J.CompilationUnit)cu).getClasses().get(0).getName(), ctx, this.getCursor().getParentOrThrow());
                }
            }
            return cu;
        }

        private static Set<String> getAmbiguousStaticImportNames(J.CompilationUnit cu) {
            HashSet<String> typesWithWildcardImport = new HashSet<String>();
            for (J.Import import_ : cu.getImports()) {
                if (!"*".equals(import_.getQualid().getSimpleName())) continue;
                typesWithWildcardImport.add(import_.getTypeName());
            }
            HashSet<JavaType.FullyQualified> qualifiedTypes = new HashSet<JavaType.FullyQualified>();
            for (JavaType.Variable variable : cu.getTypesInUse().getVariables()) {
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified(variable.getOwner());
                if (fq == null || !typesWithWildcardImport.contains(fq.getFullyQualifiedName())) continue;
                qualifiedTypes.add(fq);
            }
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> ambiguous = new HashSet<String>();
            for (JavaType.FullyQualified fq : qualifiedTypes) {
                for (JavaType.Variable member : fq.getMembers()) {
                    if (hashSet.add(member.getName())) continue;
                    ambiguous.add(member.getName());
                }
            }
            return ambiguous;
        }

        private static boolean conflictsWithJavaLang(J.Import elem) {
            return JAVA_LANG_CLASS_NAMES.contains(elem.getClassName());
        }
    }

    private static class ImportUsage {
        final List<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>();
        boolean used = true;

        private ImportUsage() {
        }
    }
}

