/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public final class HasSourceSet
extends Recipe {
    @Option(displayName="Source set", description="The source set to search for.", example="main")
    private final String sourceSet;

    public String getDisplayName() {
        return "Find files in a source set";
    }

    public String getDescription() {
        return "Source sets are a way to organize your source code into logical groups. For example, Java projects commonly have a `main` source set for application code and a `test` source set for test code. This recipe will find all files in a given source set.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                JavaSourceFile cu;
                if (tree instanceof JavaSourceFile && (cu = (JavaSourceFile)Objects.requireNonNull(tree)).getMarkers().findFirst(JavaSourceSet.class).filter(s -> s.getName().equals(HasSourceSet.this.sourceSet)).isPresent()) {
                    return (J)SearchResult.found((Tree)cu);
                }
                return (J)tree;
            }
        };
    }

    @Generated
    public HasSourceSet(String sourceSet) {
        this.sourceSet = sourceSet;
    }

    @Generated
    public String getSourceSet() {
        return this.sourceSet;
    }

    @NonNull
    @Generated
    public String toString() {
        return "HasSourceSet(sourceSet=" + this.getSourceSet() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HasSourceSet)) {
            return false;
        }
        HasSourceSet other = (HasSourceSet)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$sourceSet = this.getSourceSet();
        String other$sourceSet = other.getSourceSet();
        return !(this$sourceSet == null ? other$sourceSet != null : !this$sourceSet.equals(other$sourceSet));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof HasSourceSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceSet = this.getSourceSet();
        result = result * 59 + ($sourceSet == null ? 43 : $sourceSet.hashCode());
        return result;
    }
}

